/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.service;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.algo.olap.LeafFeature;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.rule.ruleFunction.RuleFunction;
import kd.epm.eb.common.utils.pkgversioncheck.PkgVersionCheckService;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import kd.epm.eb.olap.service.enums.CheckResult;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class CheckRuleSimpleUtils {
    public static CheckResult check(IModelCacheHelper modelCache, RuleDto ruleDto) {
        Map<String, Map<String, Set<String>>> rightMembers = ruleDto.getRightMembers();
        List<RuleFunction> functions = ruleDto.getFunctions();
        String formulaString = ruleDto.getFormulaString();
        if (ruleDto.getLeafFeature() == LeafFeature.NOTLEAF) {
            return CheckResult.AlgoCalc;
        }
        if (CollectionUtils.isNotEmpty(functions)) {
            return CheckResult.AlgoCalc;
        }
        if (StringUtils.containsAny((CharSequence)formulaString, (CharSequence[])new CharSequence[]{"Max(", "Min(", "Year(", "Month(", "Date(", "PeriodShift(", "DateDif("})) {
            return CheckResult.AlgoCalc;
        }
        String s = formulaString.toUpperCase();
        if (s.contains("IF")) {
            return CheckResult.AlgoCalc;
        }
        if (!PkgVersionCheckService.getInstance().checkPkgVersionOverOrDefault("kd.bos.olap.dataSources.MetadataCommandInfo", "2.7.2", false) && CheckRuleSimpleUtils.checkRightAccountMemberNotInBizModel(modelCache, ruleDto.getDataSetId(), rightMembers)) {
            return CheckResult.AlgoCalc;
        }
        return CheckResult.OlapCalc;
    }

    private static boolean checkRightAccountMemberNotInBizModel(IModelCacheHelper modelCache, Long bizModelId, Map<String, Map<String, Set<String>>> rightMembers) {
        for (Map.Entry<String, Map<String, Set<String>>> entry : rightMembers.entrySet()) {
            Member member;
            Map<String, Set<String>> value = entry.getValue();
            Set<String> rightAccountMembers = value.get(SysDimensionEnum.Account.getNumber());
            if (!CollectionUtils.isNotEmpty(rightAccountMembers) || (member = modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, rightAccountMembers.iterator().next())) == null || bizModelId.equals(member.getDatasetId())) continue;
            return true;
        }
        return false;
    }
}

