/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.olap.service.AlgoCalcUtils;
import kd.epm.eb.olap.service.DiffAnalyzeParam;
import kd.epm.eb.olap.service.DiffAnalyzeUtils;
import kd.epm.eb.olap.service.OlapCommService;
import kd.epm.eb.olap.service.request.DrillQueryRequest;
import kd.epm.eb.olap.service.request.QueryRequest;
import org.jetbrains.annotations.NotNull;

public class DiffAnalyzeService {
    private static final Log log = LogFactory.getLog(DiffAnalyzeService.class);

    public static DiffAnalyzeService getInstance() {
        return InnerClass.instance;
    }

    public Map<MembersKey, Object[]> drill(@NotNull DrillQueryRequest request) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)request.getModelId());
        DiffAnalyzeParam param = DiffAnalyzeUtils.getQueryRequest(request);
        ArrayList<BGCell> bgCellList = new ArrayList<BGCell>(16);
        for (QueryRequest queryRequest : param.getQueryRequestList()) {
            List<BGCell> bgCells;
            if ((queryRequest = AlgoCalcUtils.filterPermRead(queryRequest, modelCache)) == null || (bgCells = OlapCommService.getInstance().queryList(queryRequest)) == null || bgCells.isEmpty()) continue;
            bgCells = AlgoCalcUtils.filterPermRead(bgCells, request.getDatasetId(), request.getViewMap(), modelCache);
            bgCellList.addAll(bgCells);
        }
        return DiffAnalyzeUtils.calcNew(request, bgCellList, param.getLeads(), param.getCacheMap());
    }

    private static class InnerClass {
        private static DiffAnalyzeService instance = new DiffAnalyzeService();

        private InnerClass() {
        }
    }
}

