/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.service;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.FormulaException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.MapUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.period.PeriodLeadUtils;
import kd.epm.eb.olap.api.metadata.IDataRow;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.enums.DataRowEnum;
import kd.epm.eb.olap.impl.ext.expr.face.IAnalyseExpr;
import kd.epm.eb.olap.service.AlgoCalcUtils;
import kd.epm.eb.olap.service.DiffAnalyzeParam;
import kd.epm.eb.olap.service.request.DrillQueryRequest;
import kd.epm.eb.olap.service.request.QueryRequest;

public class DiffAnalyzeUtils {
    private static final Log log = LogFactory.getLog(DiffAnalyzeUtils.class);
    private static final String DEF_DIFF_EXPR = "=%s-%s";
    private static final String DEF_RATIO_EXPR = "=(%s-%s)/%s";

    public static DiffAnalyzeParam getQueryRequest(DrillQueryRequest request) {
        Long modelId = request.getModelId();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List dimensionList = modelCache.getDimensionList(request.getDatasetId());
        Map dimensionMap = modelCache.getDimensionMap(request.getDatasetId());
        Map baseViewMap = request.getViewMap() == null ? modelCache.getViewsByDataSet(request.getDatasetId()) : request.getViewMap();
        Map<String, Set<String>> memberInfo = DiffAnalyzeUtils.getMemberInfo(request.getRowDims(), request.getColDims(), request.getCommDims());
        HashMap newMemberInfo = Maps.newHashMapWithExpectedSize((int)dimensionList.size());
        List<kd.epm.eb.common.model.Dimension> colDims = request.getColDims();
        List<kd.epm.eb.common.model.Dimension> commDims = request.getCommDims();
        Set commDimNums = commDims.stream().map(kd.epm.eb.common.model.Dimension::getNumber).collect(Collectors.toSet());
        HashMap commMemberMap = Maps.newHashMapWithExpectedSize((int)commDims.size());
        List<IDataRow> dataRows = request.getDataRows();
        Set dataRowDims = dataRows.stream().filter(dataRow -> DataRowEnum.DATA == dataRow.getDataRowType()).map(dataRow -> dataRow.getMetas().keySet()).flatMap(Collection::stream).collect(Collectors.toSet());
        for (Dimension dimension : dimensionList) {
            Set<String> memSet = memberInfo.get(dimension.getNumber());
            String dimNumber = dimension.getNumber();
            if (commDimNums.contains(dimNumber)) {
                if (dataRowDims.contains(dimNumber)) continue;
                newMemberInfo.put(dimNumber, memSet);
                commMemberMap.put(dimNumber, memSet.isEmpty() ? null : memSet.iterator().next());
                continue;
            }
            if (dataRowDims.contains(dimNumber)) {
                memSet = dataRows.stream().filter(dataRow -> DataRowEnum.DATA == dataRow.getDataRowType()).map(dataRow -> dataRow.getMetas().get(dimNumber)).collect(Collectors.toSet());
            }
            newMemberInfo.put(dimNumber, memSet);
        }
        Map<String, IDataRow> dataRowMap = dataRows.stream().collect(Collectors.toMap(IDataRow::getIndex, v -> v));
        for (kd.epm.eb.common.model.Dimension dim : colDims) {
            int in = dim.getMembers().size();
            for (int i = 0; i < in; ++i) {
                int mod = i % dataRows.size();
                dataRows.get(mod).addCalcMetas(dim.getNumber(), ((Member)dim.getMembers().get(i)).getNumber());
            }
        }
        for (IDataRow calcRow : dataRows) {
            IDataRow dataRow2;
            if (DataRowEnum.CUSTOM != calcRow.getDataRowType() || calcRow.getRefIndex() == null || (dataRow2 = dataRowMap.get(calcRow.getRefIndex().trim())) == null) continue;
            for (Map.Entry<String, String> entry : dataRow2.getMetas().entrySet()) {
                if (calcRow.getCalcMetas().containsKey(entry.getKey())) continue;
                calcRow.addCalcMetas(entry.getKey(), entry.getValue());
            }
        }
        int in = dataRows.size();
        for (int i = 0; i < in; ++i) {
            Long dataRowViewId;
            Long baseViewId;
            IDataRow dataRow3 = dataRows.get(i);
            for (Map.Entry<String, String> entry : dataRow3.getMetas().entrySet()) {
                baseViewId = baseViewMap != null ? IDUtils.toLong(baseViewMap.get(entry.getKey())) : 0L;
                if (!IDUtils.equals((Object)baseViewId, (Object)(dataRowViewId = Long.valueOf(dataRow3.getDimensionViews() != null ? IDUtils.toLong((Object)dataRow3.getDimensionViews().get(entry.getKey())) : 0L))) && dataRowViewId != 0L || !dimensionMap.containsKey(entry.getKey())) continue;
                newMemberInfo.computeIfAbsent(entry.getKey(), v -> new HashSet(16)).add(entry.getValue());
            }
            Map<String, Set<String>> extMetas = dataRow3.getExtMetas(modelCache, dataRowMap, commMemberMap);
            if (extMetas == null || extMetas.isEmpty()) continue;
            for (Map.Entry<String, Object> entry : extMetas.entrySet()) {
                baseViewId = baseViewMap != null ? IDUtils.toLong(baseViewMap.get(entry.getKey())) : 0L;
                if (!IDUtils.equals((Object)baseViewId, (Object)(dataRowViewId = Long.valueOf(dataRow3.getDimensionViews() != null ? IDUtils.toLong((Object)dataRow3.getDimensionViews().get(entry.getKey())) : 0L))) && dataRowViewId != 0L || !dimensionMap.containsKey(entry.getKey())) continue;
                newMemberInfo.computeIfAbsent(entry.getKey(), v -> new HashSet(16)).addAll((Collection)entry.getValue());
            }
        }
        ArrayList<QueryRequest> queryRequests = new ArrayList<QueryRequest>(16);
        QueryRequest baseQueryRequest = new QueryRequest(modelId, request.getDatasetId(), newMemberInfo);
        baseQueryRequest.setViewMap(request.getViewMap());
        queryRequests.add(baseQueryRequest);
        for (IDataRow dataRow4 : dataRows) {
            if (dataRow4.getDataRowType() != DataRowEnum.DATA || dataRow4.getDimensionViews() == null || dataRow4.getDimensionViews().isEmpty() || dataRow4.getMetas().isEmpty()) continue;
            HashMap hashMap = Maps.newHashMapWithExpectedSize((int)newMemberInfo.size());
            newMemberInfo.forEach((k, v) -> _newMemberInfo.put(k, Sets.newHashSet((Iterable)v)));
            HashMap viewMap = Maps.newHashMapWithExpectedSize((int)baseViewMap.size());
            baseViewMap.forEach(viewMap::put);
            viewMap.putAll(dataRow4.getDimensionViews());
            for (Map.Entry<String, Long> entry : dataRow4.getDimensionViews().entrySet()) {
                if (entry.getValue() == null || entry.getValue() == 0L) continue;
                viewMap.put(entry.getKey(), entry.getValue());
            }
            for (Dimension dimension : dimensionList) {
                String memberNumber = dataRow4.getMetas().get(dimension.getNumber());
                if (!StringUtils.isNotEmpty((String)memberNumber)) continue;
                hashMap.put(dimension.getNumber(), Sets.newHashSet((Object[])new String[]{memberNumber}));
            }
            QueryRequest queryRequest = new QueryRequest(modelId, request.getDatasetId(), hashMap);
            queryRequest.setViewMap(viewMap);
            queryRequests.add(queryRequest);
        }
        PeriodLeadUtils.PeriodLead lead = null;
        HashMap leads = Maps.newHashMapWithExpectedSize((int)32);
        for (IDataRow row : dataRows) {
            if (!StringUtils.isNotEmpty((String)row.getLead())) continue;
            lead = PeriodLeadUtils.parse((String)row.getLead());
            if (lead != null) {
                leads.put(row.getLead(), lead);
                continue;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u671f\u95f4\u504f\u79fb\u201d\u8868\u8fbe\u5f0f\u9519\u8bef\u3002", (String)"DrillUtils_0", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        if (!leads.isEmpty()) {
            for (QueryRequest queryRequest : queryRequests) {
                Set<String> periodNumbers = queryRequest.getMemberInfo().get(SysDimensionEnum.BudgetPeriod.getNumber());
                LinkedHashSet<String> newPeriodNumbers = new LinkedHashSet<String>();
                for (PeriodLeadUtils.PeriodLead _lead : leads.values()) {
                    for (String number : periodNumbers) {
                        String periodNumber = PeriodLeadUtils.get((String)number, (PeriodLeadUtils.PeriodLead)_lead, linkedHashMap);
                        if (periodNumber == null) continue;
                        newPeriodNumbers.add(periodNumber);
                    }
                }
                QFBuilder builder = new QFBuilder();
                builder.add(new QFilter("model", "=", (Object)modelId));
                builder.add(new QFilter("number", "in", newPeriodNumbers));
                Map periods = BusinessDataServiceHelper.loadFromCache((String)SysDimensionEnum.BudgetPeriod.getMemberTreemodel(), (String)"id, number", (QFilter[])builder.toArray());
                if (periods == null) continue;
                periodNumbers.clear();
                for (DynamicObject period : periods.values()) {
                    periodNumbers.add(period.getString("number"));
                }
            }
        }
        if (baseQueryRequest.getMemberInfo().size() < dimensionList.size()) {
            queryRequests.remove(0);
        }
        return new DiffAnalyzeParam(leads, linkedHashMap, queryRequests);
    }

    private static Map<String, Set<String>> getMemberInfo(List<kd.epm.eb.common.model.Dimension> rowDims, List<kd.epm.eb.common.model.Dimension> colDims, List<kd.epm.eb.common.model.Dimension> commDims) {
        HashMap<String, Set<String>> memberInfo = new HashMap<String, Set<String>>(16);
        for (kd.epm.eb.common.model.Dimension commDim : commDims) {
            memberInfo.put(commDim.getNumber(), commDim.getMembers().stream().map(Member::getNumber).collect(Collectors.toSet()));
        }
        for (kd.epm.eb.common.model.Dimension rowDim : rowDims) {
            memberInfo.put(rowDim.getNumber(), rowDim.getMembers().stream().map(Member::getNumber).collect(Collectors.toSet()));
        }
        for (kd.epm.eb.common.model.Dimension colDim : colDims) {
            memberInfo.put(colDim.getNumber(), colDim.getMembers().stream().map(Member::getNumber).collect(Collectors.toSet()));
        }
        return memberInfo;
    }

    public static Map<MembersKey, Object[]> calcNew(DrillQueryRequest request, List<BGCell> bgCells, Map<String, PeriodLeadUtils.PeriodLead> leads, Map<String, String> cacheMap) {
        String periodNumber;
        PeriodLeadUtils.PeriodLead lead;
        if (request == null || bgCells == null || bgCells.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap result = Maps.newLinkedHashMapWithExpectedSize((int)bgCells.size());
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)request.getModelId());
        List dimensionList = modelCache.getDimensionList(request.getDatasetId());
        Map dimIndexMap = modelCache.getDimIndexMap(request.getDatasetId(), false);
        LinkedList<kd.epm.eb.common.model.Dimension> rowColDims = new LinkedList<kd.epm.eb.common.model.Dimension>();
        rowColDims.addAll(request.getRowDims());
        rowColDims.addAll(request.getColDims());
        HashMap membersKeys = Maps.newHashMapWithExpectedSize((int)bgCells.size());
        for (BGCell bGCell : bgCells) {
            membersKeys.put(new MembersKey(bGCell.getMemberKey(dimensionList)), AlgoCalcUtils.toKDCell(bGCell));
        }
        HashMap commKeys = Maps.newHashMapWithExpectedSize((int)request.getCommDims().size());
        for (kd.epm.eb.common.model.Dimension commDim : request.getCommDims()) {
            if (!"BudgetPeriod".equals(commDim.getNumber())) continue;
            commKeys.put(commDim.getNumber(), ((Member)commDim.getMembers().get(0)).getNumber());
        }
        for (IDataRow row : request.getDataRows()) {
            row.getMetas().entrySet().forEach(e -> {
                String cfr_ignored_0 = (String)commKeys.remove(e.getKey());
            });
        }
        Map<String, String> map = DiffAnalyzeUtils.getExpression(request);
        LinkedHashMap expressionMap = Maps.newLinkedHashMap();
        HashMap valuesMap = Maps.newHashMapWithExpectedSize((int)request.getDataRows().size());
        int memberKeyLength = dimensionList.size() + 1;
        int periodIndex = (Integer)dimIndexMap.get(SysDimensionEnum.BudgetPeriod.getNumber());
        LinkedHashSet leadSet = Sets.newLinkedHashSet();
        for (IDataRow row : request.getDataRows()) {
            if (!StringUtils.isNotEmpty((String)row.getLead()) || "0".equals(row.getLead())) continue;
            try {
                leadSet.add(String.valueOf(Integer.parseInt(row.getLead()) * -1));
            }
            catch (Exception ex) {
                log.error("parse-lead-error:" + row.getLead());
            }
        }
        LinkedList<BGCell> newBgCells = new LinkedList<BGCell>(bgCells);
        if (!leadSet.isEmpty()) {
            for (BGCell _bgCell : bgCells) {
                for (String _lead : leadSet) {
                    lead = leads.computeIfAbsent(_lead, f -> PeriodLeadUtils.parse((String)_lead));
                    if (lead == null) continue;
                    periodNumber = PeriodLeadUtils.get((String)((String)_bgCell.getMemberMap().get("BudgetPeriod")), (PeriodLeadUtils.PeriodLead)lead, cacheMap);
                    BGCell _tmpCell = new BGCell();
                    _tmpCell.setMemberMap(new HashMap());
                    _tmpCell.getMemberMap().putAll(_bgCell.getMemberMap());
                    _tmpCell.getMemberMap().put("BudgetPeriod", periodNumber);
                    if (membersKeys.containsKey(new MembersKey(_tmpCell.getMemberKey(dimensionList)))) continue;
                    newBgCells.add(_tmpCell);
                }
            }
        }
        for (BGCell _bgCell : newBgCells) {
            int i;
            Object value;
            valuesMap.clear();
            if (!CollectionUtils.includeByIgn((Map)_bgCell.getMemberMap(), (Map)commKeys)) continue;
            for (IDataRow row : request.getDataRows()) {
                MembersKey membersKey;
                IAnalyseExpr analyseExpr;
                Object[] memberKey;
                if (DataRowEnum.DATA.getIndex() == row.getDataRowType().getIndex()) {
                    IKDCell cell;
                    boolean hasNotLead;
                    boolean bl = hasNotLead = StringUtils.isEmpty((String)row.getLead()) || "0".equals(row.getLead());
                    if (MapUtils.contains(row.getMetas(), (Map)_bgCell.getMemberMap()) && hasNotLead) {
                        if (_bgCell.getValue() instanceof Number) {
                            valuesMap.put(row.getIndex(), ConvertUtils.toDecimal((Object)_bgCell.getValue()));
                            continue;
                        }
                        valuesMap.put(row.getIndex(), _bgCell.getValue());
                        continue;
                    }
                    memberKey = DiffAnalyzeUtils.getMemberKey(_bgCell, row, dimensionList, memberKeyLength);
                    if (!hasNotLead && (lead = leads.get(row.getLead())) != null && (periodNumber = PeriodLeadUtils.get((String)((String)memberKey[periodIndex + 1]), (PeriodLeadUtils.PeriodLead)lead, cacheMap)) != null) {
                        memberKey[periodIndex + 1] = periodNumber;
                    }
                    if ((cell = (IKDCell)membersKeys.get(new MembersKey(memberKey))) == null || !cell.getValue().isDecimal()) continue;
                    valuesMap.put(row.getIndex(), cell.getValue().getDecimal());
                    continue;
                }
                if (DataRowEnum.CUSTOM.getIndex() != row.getDataRowType().getIndex() || (analyseExpr = row.getExpr(membersKey = new MembersKey(memberKey = DiffAnalyzeUtils.getMemberKey(_bgCell, row, dimensionList, memberKeyLength)), dimIndexMap)) == null || (value = analyseExpr.calc(membersKey, membersKeys, dimIndexMap)) == null) continue;
                valuesMap.put(row.getIndex(), value);
            }
            if (valuesMap.isEmpty()) continue;
            Object[] rowColKey = new Object[rowColDims.size() + 1];
            int in = rowColDims.size();
            for (int i2 = 0; i2 < in; ++i2) {
                rowColKey[i2 + 1] = _bgCell.getMemberMap().get(((kd.epm.eb.common.model.Dimension)rowColDims.get(i2)).getNumber());
            }
            Object[] values = new Object[request.getDataRows().size()];
            int in2 = request.getDataRows().size();
            for (i = 0; i < in2; ++i) {
                Expr expr;
                String script;
                IDataRow _row = request.getDataRows().get(i);
                values[i] = valuesMap.get(_row.getIndex());
                if (DataRowEnum.DIFF.getIndex() != _row.getDataRowType().getIndex() && DataRowEnum.RATIO.getIndex() != _row.getDataRowType().getIndex() && DataRowEnum.CUSTOM.getIndex() != _row.getDataRowType().getIndex() || !StringUtils.isNotEmpty((String)(script = map.get(_row.getIndex()))) || (expr = expressionMap.computeIfAbsent(script, f -> FormulaEngine.parseFormula((String)script))) == null) continue;
                try {
                    value = FormulaEngine.execExcelFormula((Expr)expr, (Map)valuesMap);
                }
                catch (Throwable ex) {
                    log.error("drill-calc-error:", ex);
                    log.error("drill-calc-exp:" + _row.getExpression());
                    if (ex instanceof ArithmeticException) {
                        value = null;
                    }
                    if (ex instanceof FormulaException) {
                        value = null;
                    }
                    throw new KDBizException(ex.getMessage());
                }
                if (value == null) continue;
                values[i] = value;
            }
            Object[] _tmpValues = result.computeIfAbsent(new MembersKey(rowColKey), f -> values);
            if (_tmpValues == values) continue;
            int in3 = _tmpValues.length;
            for (i = 0; i < in3; ++i) {
                if (_tmpValues[i] != null || values[i] == null) continue;
                _tmpValues[i] = values[i];
            }
        }
        return result;
    }

    private static Object[] getMemberKey(BGCell cell, IDataRow row, List<Dimension> dimensions, int memberKeyLength) {
        Object[] memberKey = new Object[memberKeyLength];
        System.arraycopy(cell.getMemberKey(dimensions), 1, memberKey, 1, memberKey.length - 1);
        int in = dimensions.size();
        for (int i = 0; i < in; ++i) {
            String dimNumber = row.getMetas().get(dimensions.get(i).getNumber());
            if (dimNumber == null) continue;
            memberKey[i + 1] = dimNumber;
        }
        return memberKey;
    }

    private static Map<String, String> getExpression(DrillQueryRequest request) {
        int dataRowSize = 0;
        IDataRow one = null;
        IDataRow two = null;
        HashMap expressions = Maps.newHashMapWithExpectedSize((int)request.getDataRows().size());
        for (IDataRow row : request.getDataRows()) {
            if (DataRowEnum.DATA.getIndex() != row.getDataRowType().getIndex()) continue;
            ++dataRowSize;
            if (one == null) {
                one = row;
                continue;
            }
            if (two != null) continue;
            two = row;
        }
        for (IDataRow row : request.getDataRows()) {
            if (DataRowEnum.DATA.getIndex() == row.getDataRowType().getIndex()) continue;
            if (StringUtils.isEmpty((String)row.getExpression()) && dataRowSize == 2 && one != null && two != null) {
                if (DataRowEnum.DIFF.getIndex() == row.getDataRowType().getIndex()) {
                    row.setExpression(String.format(DEF_DIFF_EXPR, one.getIndex(), two.getIndex()));
                } else if (DataRowEnum.RATIO.getIndex() == row.getDataRowType().getIndex()) {
                    row.setExpression(String.format(DEF_RATIO_EXPR, one.getIndex(), two.getIndex(), two.getIndex()));
                }
            }
            if (!StringUtils.isNotEmpty((String)row.getExpression()) || !row.getExpressions().isEmpty()) continue;
            expressions.put(row.getIndex(), row.getExpression());
        }
        return expressions;
    }
}

