/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.epm.eb.algo.olap.Connection;
import kd.epm.eb.algo.olap.MdxResult;
import kd.epm.eb.algo.olap.Member;
import kd.epm.eb.algo.olap.MemberScope;
import kd.epm.eb.algo.olap.MetadataAPI;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.impl.DimensionImpl;
import kd.epm.eb.algo.olap.impl.MetadataAPIImpl;
import kd.epm.eb.algo.olap.impl.ScopeBuilderImpl;
import kd.epm.eb.algo.olap.mdx.FunDef;
import kd.epm.eb.algo.olap.mdx.FunDefBase;
import kd.epm.eb.common.bgmddatalock.BgmdDataLockService;
import kd.epm.eb.common.bgmddatalock.IBgmdDataLockCache;
import kd.epm.eb.common.bgmddatalock.v2.DataLockService;
import kd.epm.eb.common.bgmddatalock.v2.IDataLockChecker;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.FunctionItemEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.RuleFunctionEnum;
import kd.epm.eb.common.f7.FormulaCondition;
import kd.epm.eb.common.f7.MemberCondition;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.olapdao.BGCells;
import kd.epm.eb.common.olapdao.BgmdOlapReader;
import kd.epm.eb.common.olapdao.BgmdOlapWriter;
import kd.epm.eb.common.olapdao.BgmdShrekDao;
import kd.epm.eb.common.olapdao.FixMember;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.olapdao.OlapReadOption;
import kd.epm.eb.common.olapdao.OlapWriteOption;
import kd.epm.eb.common.rule.ruleFunction.RuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionFactory;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.MemberServiceHelper;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.common.utils.base.StrUtils;
import kd.epm.eb.olap.impl.bizrule.RuleCacheService;
import kd.epm.eb.olap.impl.bizrule.entity.FormulaMemberDto;
import kd.epm.eb.olap.impl.bizrule.entity.RuleCalcContext;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import kd.epm.eb.olap.impl.bizrule.entity.RuleRightItemDto;
import kd.epm.eb.olap.impl.calc.AlgoConnection;
import kd.epm.eb.olap.impl.calc.AlgoMdxEngine;
import kd.epm.eb.olap.impl.execute.impl.Environment;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.BinaryExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.MdxMemberExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.parse.Parse2RPN;
import kd.epm.eb.olap.impl.func.func.AncestorExcludeNullFunDef;
import kd.epm.eb.olap.impl.func.func.ChildrenMemParFunDef;
import kd.epm.eb.olap.impl.func.func.ChildrenSetParFunDef;
import kd.epm.eb.olap.impl.func.func.FirstMemberSetParFunDef;
import kd.epm.eb.olap.impl.func.func.GetNameFunDef;
import kd.epm.eb.olap.impl.func.func.GetNumberFunDef;
import kd.epm.eb.olap.impl.func.func.IsAttributeFunDef;
import kd.epm.eb.olap.impl.func.func.MemberOfShowNumberStrParFunDef;
import kd.epm.eb.olap.impl.func.func.MemberOfShowNumberValParFunDef;
import kd.epm.eb.olap.impl.func.func.MemberPropertiesFilterFunDef;
import kd.epm.eb.olap.impl.func.func.ToNumberFunDef;
import kd.epm.eb.olap.impl.utils.OlapUtils;
import kd.epm.eb.olap.service.AlgoCalcUtils;
import kd.epm.eb.olap.service.LeafFeature;
import kd.epm.eb.olap.service.request.AlgoCalcRequest;
import kd.epm.eb.olap.service.request.Options;
import kd.epm.eb.olap.service.request.QueryRequest;
import kd.epm.eb.olap.service.request.SaveRequest;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class OlapManager {
    private static final Log log = LogFactory.getLog(OlapManager.class);
    private static final List<FunDefBase> USER_DEFINED_FUN_LIST = Lists.newArrayList((Object[])new FunDefBase[]{MemberPropertiesFilterFunDef.instance, ToNumberFunDef.instance, ChildrenMemParFunDef.instance, ChildrenSetParFunDef.instance, AncestorExcludeNullFunDef.instance, IsAttributeFunDef.instance, FirstMemberSetParFunDef.instance, GetNumberFunDef.instance, GetNameFunDef.instance, MemberOfShowNumberStrParFunDef.instance, MemberOfShowNumberValParFunDef.instance});
    private static final Set<String> NEED_ADD_ALGO_USER_DEFINE_FUN = Sets.newHashSet((Object[])new String[]{"MemberPropertiesFilter", "ToNumber", "Children", "AncestorExcludeNull", "IsAttribute", "FirstMember", "GetNumber", "GetName", "MemberOfShowNumber"});

    public static OlapManager getInstance() {
        return InnerClass.instance;
    }

    private OlapManager() {
    }

    public void createSandbox(long modelId, long datasetId, String sandboxName) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        String cubeNumber = AlgoCalcUtils.getCubeNumber(datasetId);
        if (this.existSandbox(modelId, datasetId, sandboxName)) {
            return;
        }
        log.info("createSandbox modelId:{} datasetId:{} sandboxName:{}", new Object[]{modelId, datasetId, sandboxName});
        BgmdShrekDao.getInstance().createSandbox(modelCache.getModelobj(), cubeNumber, sandboxName);
    }

    public void dropSandbox(long modelId, long datasetId, String sandboxName) {
        log.info("dropSandbox modelId:{} datasetId:{} sandboxName:{}", new Object[]{modelId, datasetId, sandboxName});
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        String cubeNumber = AlgoCalcUtils.getCubeNumber(datasetId);
        BgmdShrekDao.getInstance().dropSandbox(modelCache.getModelobj(), cubeNumber, sandboxName);
    }

    public boolean existSandbox(long modelId, long datasetId, String sandboxName) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        String cubeNumber = AlgoCalcUtils.getCubeNumber(datasetId);
        return BgmdShrekDao.getInstance().existSandbox(modelCache.getModelobj(), cubeNumber, sandboxName);
    }

    public List<BGCell> queryList(QueryRequest request) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)request.getModelId());
        List<String> selectDims = this.getSelectDims(request, modelCache);
        ArrayList datas = Lists.newArrayListWithExpectedSize((int)1024);
        try (BgmdOlapReader reader = this.queryReader(request);){
            while (reader.hasNext()) {
                Object[] row = reader.next();
                if (row[0] == null) continue;
                datas.add(BGCells.of((Object[])row, selectDims));
            }
        }
        return datas;
    }

    public List<BGCell> queryLeafList(QueryRequest request) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)request.getModelId());
        List<String> selectDims = this.getSelectDims(request, modelCache);
        ArrayList datas = Lists.newArrayList();
        OlapReadOption olapReadOption = new OlapReadOption();
        olapReadOption.setExcludeDynamicCalcResult(true);
        try (BgmdOlapReader reader = this.queryReader(request, olapReadOption);){
            while (reader.hasNext()) {
                Object[] row = reader.next();
                if (row[0] == null) continue;
                datas.add(BGCells.of((Object[])row, selectDims));
            }
        }
        return datas;
    }

    public BgmdOlapReader queryReader(QueryRequest request) {
        return this.queryReader(request, new OlapReadOption());
    }

    public BgmdOlapReader queryReader(QueryRequest request, OlapReadOption readOption) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)request.getModelId());
        this.checkDimension(request.getMemberInfo(), (List<Dimension>)modelCache.getDimensionList(request.getDatasetId()));
        String cubeNumber = AlgoCalcUtils.getCubeNumber(request.getDatasetId());
        List<String> selectDims = this.getSelectDims(request, modelCache);
        return BgmdShrekDao.getInstance().read(modelCache.getModelobj(), cubeNumber, request.getMemberInfo(), selectDims, readOption);
    }

    public List<BGCell> singleCalc(AlgoCalcRequest srcRequest) {
        ArrayList closeableList = Lists.newArrayListWithExpectedSize((int)16);
        Connection mainConn = null;
        AlgoCalcRequest request = new AlgoCalcRequest(srcRequest.getModelId(), srcRequest.getDatasetId(), srcRequest.getViewMap(), srcRequest.getMemberInfo(), srcRequest.getRules(), srcRequest.getOptions());
        RuleDto ruleDto = request.getRules().get(0);
        try {
            this.checkRuleViewNeedUpgrade(request);
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)request.getModelId());
            OlapManager.getInstance().filterRulesRangeMember(request, modelCache);
            log.info(StrUtils.format((String)"singleCalc-rule: {}", (Object[])new Object[]{ruleDto.getNumber()}));
            Dataset dataSet = DatasetServiceHelper.getInstance().getDataSet(request.getDatasetId());
            if (request.getViewMap() == null) {
                request.setViewMap(modelCache.getViewsByDataSet(dataSet.getId()));
            }
            List datasetDimList = modelCache.getDimensionList(request.getDatasetId());
            List bizModelDimList = modelCache.getDimensionListByBusModel(modelCache.getBusModelByDataSet(request.getDatasetId()));
            Map<String, Set<String>> cubeIncludeMemberMap = bizModelDimList.stream().collect(Collectors.toMap(BaseCache::getNumber, v -> new HashSet()));
            ArrayList<QueryRequest> rightRefMemberMap = new ArrayList<QueryRequest>();
            List<String> needAllQueryDimension = this.getFunRefDim(request.getRules());
            this.analyzeConnectionMember(request, ruleDto, cubeIncludeMemberMap, rightRefMemberMap, modelCache, request.getOptions());
            cubeIncludeMemberMap = cubeIncludeMemberMap.entrySet().stream().filter(entry -> entry.getValue() != null && !((Set)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            String calcDimNumber = AlgoCalcUtils.genCalcDimNumber(modelCache, request.getRules());
            Map<String, Set<String>> refPropMap = this.getRefProp(request.getRules());
            List<FixMember> fixMemberList = AlgoCalcUtils.genFixMembers(calcDimNumber, cubeIncludeMemberMap, refPropMap, needAllQueryDimension);
            Set<String> fixDimSet = fixMemberList.stream().map(FixMember::getDimNumber).collect(Collectors.toSet());
            cubeIncludeMemberMap = cubeIncludeMemberMap.entrySet().stream().filter(entry -> !fixDimSet.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            List<String> bizModelSelectDim = bizModelDimList.stream().map(BaseCache::getNumber).filter(cubeIncludeMemberMap::containsKey).collect(Collectors.toList());
            HashMap<Long, Map<String, kd.epm.eb.common.cache.impl.Member>> fillInDefaultMap = new HashMap<Long, Map<String, kd.epm.eb.common.cache.impl.Member>>();
            fillInDefaultMap.computeIfAbsent(dataSet.getId(), this.getDefaultFillIn(modelCache, dataSet.getId(), bizModelSelectDim));
            rightRefMemberMap.forEach(right -> fillInDefaultMap.computeIfAbsent(right.getDatasetId(), this.getDefaultFillIn(modelCache, right.getDatasetId(), bizModelSelectDim)));
            Environment env = new Environment();
            List<RuleCalcContext> convertRules = this.convertRule(request, calcDimNumber, fixDimSet, new HashMap<Long, Set<String>>(16), modelCache, fillInDefaultMap, false, env);
            AlgoConnection mainAlgoConn = AlgoMdxEngine.getInstance().singleOpenConnection(modelCache, dataSet, request.getViewMap(), cubeIncludeMemberMap, rightRefMemberMap, fixMemberList, refPropMap, bizModelSelectDim, needAllQueryDimension, request.getOptions(), env.getFunctionVirtualMap(), closeableList, convertRules, ruleDto.getViewMap());
            mainConn = mainAlgoConn.getConnection();
            Set<String> datasetContainsDim = datasetDimList.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
            boolean fixMemberHasNotLeaf = AlgoCalcUtils.fixMemberHasNotLeaf(fixMemberList, datasetContainsDim, request.getViewMap(), modelCache);
            MetadataAPI api = mainConn.getMetadataAPI();
            this.addUserDefineFun(convertRules, api);
            for (RuleCalcContext rule : convertRules) {
                MemberScope memberScope = this.getMemberScope(modelCache, fixDimSet, request.getMemberInfo(), calcDimNumber, rule, request.getOptions());
                if (memberScope == null) continue;
                kd.epm.eb.algo.olap.LeafFeature leafFeature = rule.getRuleDto().getLeafFeature();
                if (rule.getRuleDto().getNewLeafFeature() == LeafFeature.NOTLEAF && fixMemberHasNotLeaf) {
                    leafFeature = kd.epm.eb.algo.olap.LeafFeature.ALL;
                }
                if (CollectionUtils.isEmpty((Collection)memberScope.getMemberExpressions())) {
                    MemberScope defaultMemberScope = this.genDefaultMemberScope(modelCache, request.getMemberInfo(), fixDimSet, calcDimNumber);
                    api.addMemberSope(defaultMemberScope);
                    api.addScopedMemberExpression(rule.getMdxLeft(), defaultMemberScope.getName(), rule.getMdxRight(), leafFeature);
                    continue;
                }
                api.addMemberSope(memberScope);
                api.addScopedMemberExpression(rule.getMdxLeft(), memberScope.getName(), rule.getMdxRight(), leafFeature);
            }
            if (!fixMemberHasNotLeaf) {
                this.putInDataLock(request, modelCache, mainConn, fixMemberList);
            }
            String mdxSql = AlgoCalcUtils.genMdxQuerySql(modelCache, dataSet.getNumber(), request.getMemberInfo(), fixMemberList, bizModelSelectDim);
            MdxResult mdxResult = AlgoMdxEngine.getInstance().executeMdxQuery(mainConn, mdxSql, null);
            List cells = BGCells.of((MdxResult)mdxResult, fixMemberList, (List)datasetDimList);
            if (!fixMemberHasNotLeaf) {
                this.putInOldCellByDataLock(request, modelCache, cells);
            }
            List list = cells;
            return list;
        }
        catch (StackOverflowError error) {
            log.error((Throwable)error);
            throw new KDBizException(new ErrorCode("EB040100", ResManager.loadResFormat((String)"\u4e1a\u52a1\u89c4\u5219\u6267\u884c\u5b58\u5728\u8fed\u4ee3\u4f9d\u8d56\u5bfc\u81f4\u6267\u884c\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u62a5\u8868\u5173\u8054\u7684\u4e1a\u52a1\u89c4\u5219,%s", (String)"KDDataQueryThread_2", (String)"epm-eb-olap", (Object[])new Object[]{ruleDto.getNumber()})), new Object[0]);
        }
        catch (KDBizException exception) {
            throw exception;
        }
        catch (Throwable error) {
            log.error(error);
            throw new KDBizException(ResManager.loadResFormat((String)"\u4e1a\u52a1\u89c4\u5219%1\u6267\u884c\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%2", (String)"KDDataQueryThread_4", (String)"epm-eb-olap", (Object[])new Object[]{ruleDto.getNumber(), error.getMessage()}));
        }
        finally {
            try {
                if (mainConn != null) {
                    mainConn.close();
                }
            }
            catch (OlapException ex) {
                log.error("budget-olap-log : ", (Throwable)ex);
            }
            for (Closeable closeable1 : closeableList) {
                try {
                    if (closeable1 == null) continue;
                    closeable1.close();
                }
                catch (IOException e) {
                    log.error("budget-olap-log : ", (Throwable)e);
                }
            }
        }
    }

    private void addUserDefineFun(List<RuleCalcContext> convertRules, MetadataAPI api) {
        if (CollectionUtils.isEmpty(convertRules) || api == null) {
            return;
        }
        boolean isUserDefineFun = false;
        for (String userDefineFun : NEED_ADD_ALGO_USER_DEFINE_FUN) {
            isUserDefineFun = convertRules.stream().anyMatch(e -> e.getMdxRight().contains(userDefineFun));
            if (!isUserDefineFun) continue;
            break;
        }
        if (!isUserDefineFun) {
            return;
        }
        try {
            Class<?> aClass = api.getClass();
            Method addFunDef = aClass.getDeclaredMethod("addFunDef", FunDef.class);
            for (FunDefBase funDefBase : USER_DEFINED_FUN_LIST) {
                addFunDef.invoke((Object)api, funDefBase);
            }
        }
        catch (Exception e2) {
            log.error("addFunDef_error:", (Throwable)e2);
            throw new KDBizException(ResManager.loadKDString((String)"\u5e73\u53f0\u8ba1\u7b97\u5305\u7248\u672c\u8fc7\u4f4e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5347\u7ea7\u3002", (String)"AbstractOlapServiceCaller_17", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
    }

    private Function<Long, Map<String, kd.epm.eb.common.cache.impl.Member>> getDefaultFillIn(IModelCacheHelper modelCache, Long datasetId, List<String> bizModelSelectDim) {
        return v -> {
            HashMap<String, kd.epm.eb.common.cache.impl.Member> res = new HashMap<String, kd.epm.eb.common.cache.impl.Member>();
            Set datasetAllDims = modelCache.getDimensionMap(datasetId).keySet();
            Long busModelByDataSet = modelCache.getBusModelByDataSet(datasetId);
            for (String dimNumber : bizModelSelectDim) {
                if (datasetAllDims.contains(dimNumber)) continue;
                Dimension dimension = modelCache.getDimension(dimNumber);
                res.put(dimNumber, modelCache.getMemberByAnyView(busModelByDataSet, dimNumber, dimension.getNoneNumber()));
            }
            return res;
        };
    }

    private void analyzeConnectionMember(AlgoCalcRequest request, RuleDto rule, Map<String, Set<String>> cubeIncludeMemberMap, List<QueryRequest> rightQueryRequest, IModelCacheHelper modelCache, Options options) {
        Map<String, Set<String>> queryInfo = request.getMemberInfo();
        queryInfo.forEach((k, v) -> ((Set)cubeIncludeMemberMap.get(k)).addAll(v));
        Map<String, Map<String, Set<String>>> rightPageMembers = rule.getRightPageMembers();
        List<RuleRightItemDto> ruleRightItemDtoList = rule.getRuleRightItemDto();
        boolean periodShift = rule.getRuleRightItemDto().stream().anyMatch(x -> x.isPeriodshift());
        if (MapUtils.isNotEmpty(rightPageMembers)) {
            Map<String, Set<String>> calcRefMember;
            for (Map.Entry<String, Map<String, Set<String>>> entry : rightPageMembers.entrySet()) {
                String[] dimensionNums;
                Map<String, Set<String>> rightItem = entry.getValue();
                rightItem.forEach((k, v) -> ((Set)cubeIncludeMemberMap.get(k)).addAll(v));
                RuleRightItemDto ruleRightItemDto = ruleRightItemDtoList.stream().filter(item -> ((String)entry.getKey()).equals(item.getMemberKey())).findFirst().get();
                QueryRequest queryRequest2 = new QueryRequest();
                rightQueryRequest.add(queryRequest2);
                String memberKey = entry.getKey();
                Set<String> acc = rightItem.get(SysDimensionEnum.Account.getNumber());
                Long rDataset = CollectionUtils.isEmpty(acc) ? request.getDatasetId() : modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, acc.iterator().next()).getDatasetId();
                queryRequest2.setDatasetId(rDataset);
                HashMap<String, Set<String>> memberInfo = new HashMap<String, Set<String>>();
                queryRequest2.setMemberInfo(memberInfo);
                for (String dimensionNum : dimensionNums = modelCache.getDimensionNums(rDataset)) {
                    if (rightItem.containsKey(dimensionNum)) {
                        if (periodShift && SysDimensionEnum.BudgetPeriod.getNumber().equals(dimensionNum)) {
                            Integer min = -120;
                            Integer max = 120;
                            Set<String> bpSet = AlgoCalcUtils.calcBp(modelCache, rightItem.get(dimensionNum), min, max);
                            memberInfo.put(dimensionNum, bpSet);
                            continue;
                        }
                        memberInfo.put(dimensionNum, rightItem.get(dimensionNum));
                        continue;
                    }
                    if (queryInfo.containsKey(dimensionNum)) {
                        Integer max;
                        Integer min;
                        if (periodShift && SysDimensionEnum.BudgetPeriod.getNumber().equals(dimensionNum)) {
                            Set<String> bpSet;
                            if (rule.getOffsetMap().containsKey(memberKey)) {
                                Integer offset = rule.getOffsetMap().get(memberKey);
                                Integer min2 = Math.min(offset, 0);
                                Integer max2 = Math.max(offset, 0);
                                bpSet = AlgoCalcUtils.calcBp(modelCache, queryInfo.get(SysDimensionEnum.BudgetPeriod.getNumber()), min2, max2);
                                min2 = -120;
                                max2 = 120;
                                bpSet = AlgoCalcUtils.calcBp(modelCache, bpSet, min2, max2);
                            } else {
                                min = -120;
                                max = 120;
                                bpSet = AlgoCalcUtils.calcBp(modelCache, queryInfo.get(SysDimensionEnum.BudgetPeriod.getNumber()), min, max);
                            }
                            memberInfo.put(dimensionNum, bpSet);
                            continue;
                        }
                        if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimensionNum) && rule.getOffsetMap().containsKey(memberKey)) {
                            Integer offset = rule.getOffsetMap().get(memberKey);
                            min = Math.min(offset, 0);
                            max = Math.max(offset, 0);
                            Set<String> bpSet = AlgoCalcUtils.calcBp(modelCache, queryInfo.get(SysDimensionEnum.BudgetPeriod.getNumber()), min, max);
                            memberInfo.put(dimensionNum, bpSet);
                            continue;
                        }
                        memberInfo.put(dimensionNum, queryInfo.get(dimensionNum));
                        continue;
                    }
                    memberInfo.put(dimensionNum, Sets.newHashSet((Object[])new String[]{modelCache.getDimension(dimensionNum).getNoneNumber()}));
                }
            }
            if (this.haveFinanceFun(rule)) {
                Set<String> bpSet = AlgoCalcUtils.calcBp(modelCache, queryInfo.get(SysDimensionEnum.BudgetPeriod.getNumber()), -24, 0);
                cubeIncludeMemberMap.get(SysDimensionEnum.BudgetPeriod.getNumber()).addAll(bpSet);
                rightQueryRequest.forEach(queryRequest -> {
                    Set<String> reqBpSet = queryRequest.getMemberInfo().get(SysDimensionEnum.BudgetPeriod.getNumber());
                    queryRequest.getMemberInfo().put(SysDimensionEnum.BudgetPeriod.getNumber(), (Set<String>)Sets.union(reqBpSet, (Set)bpSet));
                });
            }
            if (MapUtils.isNotEmpty(calcRefMember = rule.getCalcRefMember())) {
                calcRefMember.forEach((k, v) -> ((Set)cubeIncludeMemberMap.get(k)).addAll(v));
            }
        }
    }

    private void putInDataLock(AlgoCalcRequest request, IModelCacheHelper modelCache, Connection olapConn, List<FixMember> fixMembers) {
        IBgmdDataLockCache dataLockCache = BgmdDataLockService.getInstance().getDataLockCache(modelCache, request.getDatasetId());
        if (dataLockCache.isEmpty()) {
            return;
        }
        Map<String, FixMember> fixMemberMap = fixMembers.stream().collect(Collectors.toMap(FixMember::getDimNumber, v -> v));
        ArrayList disableCalcDimMembers = Lists.newArrayList((Object[])new String[]{SysDimensionEnum.BudgetPeriod.getShortNumber(), SysDimensionEnum.Version.getShortNumber(), SysDimensionEnum.DataType.getShortNumber(), SysDimensionEnum.AuditTrail.getShortNumber(), SysDimensionEnum.Entity.getShortNumber()});
        ArrayList<String> realDisableCalcDimMembers = new ArrayList<String>(16);
        HashMap<String, Integer> dimNumberToIndex = new HashMap<String, Integer>();
        HashMap checkDataLockMap = new HashMap(16);
        for (int i = 0; i < disableCalcDimMembers.size(); ++i) {
            String dimShortNumber = (String)disableCalcDimMembers.get(i);
            SysDimensionEnum dimensionEnum = SysDimensionEnum.getEnumByShortNumber((String)dimShortNumber);
            if (dimensionEnum == null) {
                return;
            }
            LinkedHashSet<String> memberNumbers = new LinkedHashSet<String>();
            if (fixMemberMap.containsKey(dimensionEnum.getNumber())) {
                FixMember fixMember = fixMemberMap.get(dimensionEnum.getNumber());
                memberNumbers.add(fixMember.getMemberNumber());
            } else {
                realDisableCalcDimMembers.add(dimShortNumber);
                dimNumberToIndex.put(dimShortNumber, i);
                DimensionImpl dimension = (DimensionImpl)olapConn.getSchemaReader().getCube().getDimension(dimShortNumber);
                Iterator iterator = dimension.leafMemberIterator();
                while (iterator.hasNext()) {
                    Member member = (Member)iterator.next();
                    String memberNumber = member.getName();
                    memberNumbers.add(memberNumber);
                }
            }
            checkDataLockMap.put(dimShortNumber, memberNumbers);
        }
        LinkedList<String[]> disableCalcMembers = new LinkedList<String[]>();
        String[] members = new String[5];
        if (MapUtils.isNotEmpty(checkDataLockMap)) {
            String bpShortNumber = SysDimensionEnum.BudgetPeriod.getShortNumber();
            String versionShortNumber = SysDimensionEnum.Version.getShortNumber();
            String dtShortNumber = SysDimensionEnum.DataType.getShortNumber();
            String atShortNumber = SysDimensionEnum.AuditTrail.getShortNumber();
            String entityShortNumber = SysDimensionEnum.Entity.getShortNumber();
            Set bpNumbers = (Set)checkDataLockMap.get(bpShortNumber);
            Set versionNumbers = (Set)checkDataLockMap.get(versionShortNumber);
            Set dataTypeNumbers = (Set)checkDataLockMap.get(dtShortNumber);
            Set auditTrailNumbers = (Set)checkDataLockMap.get(atShortNumber);
            Set entityNumbers = (Set)checkDataLockMap.get(entityShortNumber);
            Iterator iterator = bpNumbers.iterator();
            while (iterator.hasNext()) {
                String bpNumber;
                members[0] = bpNumber = (String)iterator.next();
                Iterator iterator2 = versionNumbers.iterator();
                while (iterator2.hasNext()) {
                    String versionNumber;
                    members[1] = versionNumber = (String)iterator2.next();
                    Iterator iterator3 = dataTypeNumbers.iterator();
                    while (iterator3.hasNext()) {
                        String dtNumber;
                        members[2] = dtNumber = (String)iterator3.next();
                        Iterator iterator4 = auditTrailNumbers.iterator();
                        while (iterator4.hasNext()) {
                            String atNumber;
                            members[3] = atNumber = (String)iterator4.next();
                            Iterator iterator5 = entityNumbers.iterator();
                            while (iterator5.hasNext()) {
                                String entityNumber;
                                members[4] = entityNumber = (String)iterator5.next();
                                if (!dataLockCache.isDataLock(members)) continue;
                                String[] _members = new String[realDisableCalcDimMembers.size()];
                                for (int i = 0; i < realDisableCalcDimMembers.size(); ++i) {
                                    String dimNumber = (String)realDisableCalcDimMembers.get(i);
                                    Integer index = (Integer)dimNumberToIndex.get(dimNumber);
                                    _members[i] = members[index];
                                }
                                disableCalcMembers.add(_members);
                            }
                        }
                    }
                }
            }
        }
        MetadataAPIImpl metadataAPI = (MetadataAPIImpl)olapConn.getMetadataAPI();
        metadataAPI.setDisableCalcDimMembers(realDisableCalcDimMembers);
        metadataAPI.setDisableCalcMembers(disableCalcMembers);
    }

    private void putInOldCellByDataLock(AlgoCalcRequest request, IModelCacheHelper modelCache, List<BGCell> cells) {
        Long datasetId = request.getDatasetId();
        IDataLockChecker checker = DataLockService.getInstance().getChecker(request.getModelId(), datasetId);
        QueryRequest oldReq = new QueryRequest(request.getModelId(), datasetId, request.getMemberInfo());
        List<BGCell> oldCells = OlapManager.getInstance().queryList(oldReq);
        List dimensionList = modelCache.getDimensionList(datasetId);
        Map<String, BGCell> oldCellMap = oldCells.stream().collect(Collectors.toMap(cell -> cell.getKey2(dimensionList), v -> v, (v1, v2) -> v1));
        Long busModelByDataSet = modelCache.getBusModelByDataSet(datasetId);
        for (BGCell cell2 : cells) {
            if (!this.isLeaf(modelCache, busModelByDataSet, cell2) || !checker.isDataLock(cell2.getMemberMap())) continue;
            String key = cell2.getKey2(dimensionList);
            BGCell oldCell = oldCellMap.get(key);
            if (oldCell == null) {
                cell2.setValue(null);
                continue;
            }
            cell2.setValue(oldCell.getValue());
        }
    }

    private Map<String, Set<String>> getRefProp(List<RuleDto> convertRules) {
        HashMap allDimRefProp = Maps.newHashMapWithExpectedSize((int)1);
        for (RuleDto rule : convertRules) {
            Map<String, Set<String>> dimRefProp = rule.getDimRefProp();
            if (!MapUtils.isNotEmpty(dimRefProp)) continue;
            for (Map.Entry<String, Set<String>> entry : dimRefProp.entrySet()) {
                allDimRefProp.computeIfAbsent(entry.getKey(), v -> new HashSet(1)).addAll((Collection)entry.getValue());
            }
        }
        return allDimRefProp;
    }

    private List<String> getFunRefDim(List<RuleDto> rules) {
        ArrayList funRefDimList = Lists.newArrayListWithExpectedSize((int)1);
        for (RuleDto convertRule : rules) {
            for (RuleRightItemDto ruleRightItemDto : convertRule.getRuleRightItemDto()) {
                List<String> skipDimList = ruleRightItemDto.getFunctionRefDimList();
                if (!CollectionUtils.isNotEmpty(skipDimList)) continue;
                funRefDimList.addAll(skipDimList);
            }
            Map<String, Set<String>> calcRefMember = convertRule.getCalcRefMember();
            if (!MapUtils.isNotEmpty(calcRefMember)) continue;
            Set<String> refDimSet = calcRefMember.keySet();
            for (String refDim : refDimSet) {
                if (funRefDimList.contains(refDim)) continue;
                funRefDimList.add(refDim);
            }
        }
        return funRefDimList;
    }

    private MemberScope genDefaultMemberScope(IModelCacheHelper modelCache, Map<String, Set<String>> memberInfo, Set<String> fixDimension, String calcDimNumber) {
        ScopeBuilderImpl scopeBuilder = new ScopeBuilderImpl();
        List collect = memberInfo.entrySet().stream().sorted(Comparator.comparingInt(c -> ((Set)c.getValue()).size())).collect(Collectors.toList());
        for (Map.Entry entry : collect) {
            String dimNumber = (String)entry.getKey();
            if (calcDimNumber.equals(dimNumber) || fixDimension.contains(dimNumber)) continue;
            Dimension dimension = modelCache.getDimension(dimNumber);
            String memberScope = this.genMemberScope((Set)entry.getValue(), dimension);
            scopeBuilder.addExpression(dimension.getShortNumber(), memberScope);
            break;
        }
        scopeBuilder.setName("defaultMemberScope");
        return scopeBuilder.build();
    }

    public boolean haveFinanceFun(RuleDto rule) {
        if (rule.getFunctions() == null || rule.getFunctions().isEmpty()) {
            return false;
        }
        for (RuleFunction function : rule.getFunctions()) {
            if (!"RecognitionP".equals(function.getFunctionName()) && !"RecognitionPC".equals(function.getFunctionName()) && !"RecognitionSP".equals(function.getFunctionName())) continue;
            return true;
        }
        return false;
    }

    private List<RuleCalcContext> convertRule(AlgoCalcRequest request, String calcDimNumber, Set<String> fixDimension, Map<Long, Set<String>> otherCubeFixDimension, IModelCacheHelper modelCache, Map<Long, Map<String, kd.epm.eb.common.cache.impl.Member>> fillInDefaultMap, boolean needLink, Environment env) {
        Set<String> calcMemberSet = request.getMemberInfo().get(calcDimNumber);
        env.setBizModelId(request.getDatasetId());
        env.setCalcDimNumber(calcDimNumber);
        env.setModelCache(modelCache);
        env.setFixDimension(fixDimension);
        env.setAnalyzeViewMap(request.getViewMap());
        env.setOtherCubeFixDimension(otherCubeFixDimension);
        env.setFillInDefaultMap(fillInDefaultMap);
        env.setNeedLink(needLink);
        ArrayList ruleList = Lists.newArrayListWithExpectedSize((int)request.getRules().size());
        for (RuleDto ruleDto : request.getRules()) {
            env.setRuleDto(ruleDto);
            Long mainDimensionId = ruleDto.getMainDimensionId();
            String mainDimNumber = modelCache.getDimension(mainDimensionId).getNumber();
            env.setMainDimNumber(mainDimNumber);
            env.setLeftMembers(ruleDto.getLeftMembers());
            List<RuleRightItemDto> ruleRightItemDto = ruleDto.getRuleRightItemDto();
            Map<String, RuleRightItemDto> ruleRightItemDtoMap = ruleRightItemDto.stream().collect(Collectors.toMap(RuleRightItemDto::getMemberKey, v -> v));
            env.setRuleRightItemDtoMap(ruleRightItemDtoMap);
            List<RuleFunction> functions = ruleDto.getFunctions();
            Map<String, RuleFunction> functionMap = functions.stream().collect(Collectors.toMap(RuleFunction::getFunctionKey, v -> v));
            HashMap newFunctionMap = Maps.newHashMap(functionMap);
            for (Map.Entry<String, RuleFunction> entry : functionMap.entrySet()) {
                RuleFunction value = entry.getValue();
                RuleFunctionUtils.putInChildFun((Map)newFunctionMap, (RuleFunction)value);
            }
            env.setFunctionMap(newFunctionMap);
            Parse2RPN parse2RPN = new Parse2RPN(ruleDto.getFormulaString());
            parse2RPN.parse();
            BinaryExpr binaryExpr = (BinaryExpr)parse2RPN.getExpr();
            String leftMdx = ((MdxMemberExpr)binaryExpr.getLeft()).toLeftMdx(env);
            env.setHasVirMember(false);
            String rightMdx = binaryExpr.getRight().toMdx(env);
            boolean rightHasNumber = binaryExpr.getRight().checkRightHasNumber();
            boolean rightHasCalcFuncValue = binaryExpr.getRight().checkRightHasCalcFuncValue();
            if (SysDimensionEnum.Account.getNumber().equals(calcDimNumber) && !mainDimNumber.equals(calcDimNumber)) {
                Set<String> ruleCalcMembers = ruleDto.getLeftMembers().get(calcDimNumber);
                Set tempSet = calcMemberSet.stream().filter(ruleCalcMembers::contains).collect(Collectors.toSet());
                int index = 0;
                String conPre = "cvt";
                for (String tempMember : tempSet) {
                    String mdxString = this.getMdxString(modelCache, calcDimNumber, null, tempMember);
                    RuleDto obj = new RuleDto();
                    try {
                        BeanUtils.copyProperties((Object)obj, (Object)ruleDto);
                    }
                    catch (Exception e) {
                        log.error("\u5bf9\u8c61\u590d\u5236\u5f02\u5e38", (Throwable)e);
                    }
                    String number = obj.getNumber() + conPre + index++;
                    String mdxLeft = StringUtils.replace((String)leftMdx, (String)"${account}", (String)mdxString);
                    String mdxRight = StringUtils.replace((String)rightMdx, (String)"${account}", (String)mdxString);
                    RuleCalcContext ruleCalcContext = new RuleCalcContext(ruleDto, number, mdxLeft, mdxRight, rightHasNumber, rightHasCalcFuncValue);
                    ruleCalcContext.setHasVirMember(env.isHasVirMember());
                    ruleList.add(ruleCalcContext);
                }
                continue;
            }
            RuleCalcContext ruleCalcContext = new RuleCalcContext(ruleDto, ruleDto.getNumber(), leftMdx, rightMdx, rightHasNumber, rightHasCalcFuncValue);
            ruleCalcContext.setHasVirMember(env.isHasVirMember());
            ruleList.add(ruleCalcContext);
        }
        return ruleList;
    }

    private String getMdxString(IModelCacheHelper modelCache, String calcDimNumber, Long viewId, String calcMember) {
        Dimension dimension = modelCache.getDimension(calcDimNumber);
        String dimHeadStr = OlapUtils.handlerDimShortNum(dimension.getShortNumber());
        kd.epm.eb.common.cache.impl.Member member = modelCache.getMember(calcDimNumber, viewId, calcMember);
        String mdxLongNumber = MemberServiceHelper.getMdx((String)member.getLongNumber());
        return dimHeadStr + '.' + mdxLongNumber;
    }

    public List<BGCell> saveList(SaveRequest request) {
        return this.saveList(request, new OlapWriteOption());
    }

    public List<BGCell> saveList(SaveRequest request, OlapWriteOption writeOption) {
        try {
            List<BGCell> datas = request.getDatas();
            if (CollectionUtils.isEmpty(datas)) {
                log.warn("\u4fdd\u5b58\u7684\u6570\u636e\u4e3a\u7a7a");
                List<BGCell> list = datas;
                return list;
            }
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)request.getModelId());
            Long datasetId = request.getDatasetId();
            Long busModelByDataSet = modelCache.getBusModelByDataSet(datasetId);
            BGCell luckyCell = datas.get(0);
            List dimensionList = modelCache.getDimensionList(datasetId);
            this.checkDimension(luckyCell.getMemberMap().keySet(), (List<Dimension>)dimensionList);
            datas = this.excludeAggUnLeaf(request, modelCache);
            if (CollectionUtils.isEmpty(datas)) {
                log.warn("\u4fdd\u5b58\u7684\u6570\u636e\u4e3a\u7a7a");
                List<BGCell> list = datas;
                return list;
            }
            List writeDims = dimensionList.stream().map(BaseCache::getNumber).collect(Collectors.toList());
            ArrayList saveList = Lists.newArrayListWithExpectedSize((int)datas.size());
            int batchSize = 20000;
            ArrayList batchList = Lists.newArrayListWithExpectedSize((int)batchSize);
            for (int i = 0; i < datas.size(); ++i) {
                batchList.add(datas.get(i));
                if ((i + 1) % batchSize != 0) continue;
                BgmdOlapWriter writer = BgmdShrekDao.getInstance().save(modelCache, AlgoCalcUtils.getCubeNumber(datasetId), writeDims, request.getFixMemberList(), writeOption);
                Object object = null;
                try {
                    for (BGCell cell : batchList) {
                        boolean saveSuccess = writer.addValue(cell, busModelByDataSet);
                        if (!saveSuccess) continue;
                        saveList.add(cell);
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (writer != null) {
                        if (object != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            writer.close();
                        }
                    }
                }
                batchList.clear();
            }
            if (!batchList.isEmpty()) {
                try (BgmdOlapWriter writer = BgmdShrekDao.getInstance().save(modelCache, AlgoCalcUtils.getCubeNumber(datasetId), writeDims, request.getFixMemberList(), writeOption);){
                    for (BGCell cell : batchList) {
                        boolean saveSuccess = writer.addValue(cell, busModelByDataSet);
                        if (!saveSuccess) continue;
                        saveList.add(cell);
                    }
                }
                batchList.clear();
            }
            ArrayList arrayList = saveList;
            return arrayList;
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
        finally {
            OlapContext.clearSaveDataContext();
        }
    }

    public BgmdOlapWriter saveWriter(SaveRequest request) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)request.getModelId());
        List dimensionList = modelCache.getDimensionList(request.getDatasetId());
        List writeDims = dimensionList.stream().map(BaseCache::getNumber).collect(Collectors.toList());
        return BgmdShrekDao.getInstance().save(modelCache, AlgoCalcUtils.getCubeNumber(request.getDatasetId()), writeDims, request.getFixMemberList());
    }

    public void checkDimension(Map<String, Set<String>> dimMemberMap, List<Dimension> dimensions) {
        ArrayList<String> errorDimNames = new ArrayList<String>(16);
        for (Dimension dim : dimensions) {
            String dimNumber = dim.getNumber();
            Set<String> members = dimMemberMap.get(dimNumber);
            if (members == null) {
                errorDimNames.add(dim.getName());
                continue;
            }
            try {
                members.removeIf(StringUtils::isEmpty);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            if (!CollectionUtils.isEmpty(members)) continue;
            errorDimNames.add(dim.getName());
        }
        if (CollectionUtils.isNotEmpty(errorDimNames)) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u7528\u6237\u65e0\u201c%1\u201d\u7ef4\u5ea6\u6210\u5458\u7684\u6743\u9650\u6216\u8005\u88ab\u7ef4\u5ea6\u6210\u5458\u5173\u7cfb\u9650\u5236\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbstractOlapServiceCaller_14", (String)"epm-eb-olap", (Object[])new Object[]{String.join((CharSequence)"\u3001", errorDimNames)}));
        }
    }

    public boolean checkDimensionNoError(List<Dimension> dimensions, Map<String, Set<String>> dimMemberMap) {
        for (Dimension dim : dimensions) {
            String dimNumber = dim.getNumber();
            Set<String> members = dimMemberMap.get(dimNumber);
            if (members == null) {
                return true;
            }
            try {
                members.removeIf(StringUtils::isEmpty);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            if (!CollectionUtils.isEmpty(members)) continue;
            return true;
        }
        return false;
    }

    private void checkDimension(Collection<String> dimList, List<Dimension> dimensions) {
        for (Dimension dim : dimensions) {
            String dimNumber = dim.getNumber();
            boolean contains = dimList.contains(dimNumber);
            if (contains) continue;
            throw new KDBizException(ResManager.loadResFormat((String)"\u6570\u636e\u67e5\u8be2\u9519\u8bef\uff0c\u53c2\u6570\u7f3a\u5c11\u201c%1\u201d\u7ef4\u5ea6\u3002", (String)"AbstractOlapServiceCaller_10", (String)"epm-eb-olap", (Object[])new Object[]{dim.getName(), dim.getNumber()}));
        }
    }

    private MemberScope getMemberScope(IModelCacheHelper modelCache, Set<String> fixDimension, Map<String, Set<String>> queryInfo, String calcDimNumber, RuleCalcContext ruleCalcContext, Options options) {
        ScopeBuilderImpl scopeBuilder = new ScopeBuilderImpl();
        Map<String, Set<String>> leftMembers = ruleCalcContext.getRuleDto().getLeftMembers();
        Map<String, Set<String>> unionRightMembers = ruleCalcContext.getRuleDto().getUnionPageRightMembers();
        boolean hasOffset = MapUtils.isNotEmpty(ruleCalcContext.getRuleDto().getOffsetMap()) || ruleCalcContext.getRuleDto().getFormulaString().contains("PeriodShift");
        for (Map.Entry<String, Set<String>> entry : queryInfo.entrySet()) {
            Set<String> filteredMember;
            String dimNumber = entry.getKey();
            if (calcDimNumber.equals(dimNumber) || fixDimension.contains(dimNumber)) continue;
            Set<String> leftMember = leftMembers.get(dimNumber);
            Set<String> rightMember = unionRightMembers.get(dimNumber);
            Set<String> queryMember = entry.getValue();
            if (ruleCalcContext.isRightHasNumber() || ruleCalcContext.isRightHasCalcFuncValue() || CollectionUtils.isNotEmpty(rightMember) || SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber) && hasOffset) {
                filteredMember = CollectionUtils.isEmpty(leftMember) ? queryMember : leftMember.stream().filter(queryMember::contains).collect(Collectors.toSet());
            } else {
                if (options.getOnlyCalc() || CollectionUtils.isEmpty(leftMember)) continue;
                filteredMember = leftMember.stream().filter(queryMember::contains).collect(Collectors.toSet());
            }
            if (CollectionUtils.isEmpty(filteredMember)) {
                return null;
            }
            Dimension dimension = modelCache.getDimension(dimNumber);
            String memberScope = this.genMemberScope(filteredMember, dimension);
            scopeBuilder.addExpression(dimension.getShortNumber(), memberScope);
        }
        scopeBuilder.setName(ruleCalcContext.getNumber());
        return scopeBuilder.build();
    }

    private String genMemberScope(Set<String> filteredMember, Dimension dimension) {
        StringBuilder mdxStr = new StringBuilder();
        mdxStr.append('{');
        for (String number : filteredMember) {
            mdxStr.append("`").append(dimension.getShortNumber()).append("`").append("->").append("`").append(number).append("`").append(',');
        }
        mdxStr.setCharAt(mdxStr.length() - 1, '}');
        return mdxStr.toString();
    }

    public List<BGCell> excludeAggUnLeaf(SaveRequest request, IModelCacheHelper modelCache) {
        Long datasetId = request.getDatasetId();
        List<BGCell> datas = request.getDatas();
        ArrayList cells = Lists.newArrayListWithExpectedSize((int)datas.size());
        Long busModelByDataSet = modelCache.getBusModelByDataSet(datasetId);
        for (BGCell cell : datas) {
            String metMemberNumber = (String)cell.getMemberMap().get(SysDimensionEnum.Metric.getNumber());
            kd.epm.eb.common.cache.impl.Member metMember = modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, metMemberNumber);
            if (metMember.hasAgg()) {
                boolean isLeaf = this.isLeaf(modelCache, busModelByDataSet, cell);
                if (!isLeaf) continue;
                cells.add(cell);
                continue;
            }
            cells.add(cell);
        }
        return cells;
    }

    public List<BGCell> filterUnLeaf(SaveRequest request, IModelCacheHelper modelCache, Map<String, Long> viewMap) {
        Long datasetId = request.getDatasetId();
        if (viewMap == null || viewMap.isEmpty()) {
            viewMap = modelCache.getViewsByDataSet(datasetId);
        }
        List<BGCell> datas = request.getDatas();
        ArrayList cells = Lists.newArrayListWithExpectedSize((int)datas.size());
        Long busModelByDataSet = modelCache.getBusModelByDataSet(datasetId);
        for (BGCell cell : datas) {
            boolean isLeaf = this.isLeaf(modelCache, busModelByDataSet, cell);
            if (isLeaf) continue;
            cells.add(cell);
        }
        return cells;
    }

    private boolean isLeaf(IModelCacheHelper modelCache, Long busModelByDataSet, BGCell cell) {
        boolean isLeaf = true;
        for (Map.Entry entry : cell.getMemberMap().entrySet()) {
            String dimNumber = (String)entry.getKey();
            kd.epm.eb.common.cache.impl.Member member = modelCache.getMemberByAnyView(busModelByDataSet, dimNumber, (String)entry.getValue());
            if (member == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u6210\u5458\u4e0d\u5b58\u5728[%1]:", (String)"CalcBizTemplate_5", (String)"epm-eb-olap", (Object[])new Object[]{entry.getValue()}));
            }
            if (member.isLeaf()) continue;
            isLeaf = false;
            break;
        }
        return isLeaf;
    }

    private List<String> getSelectDims(QueryRequest request, IModelCacheHelper modelCache) {
        if (CollectionUtils.isEmpty(request.getSelectDims())) {
            return Arrays.asList(modelCache.getDimensionNums(request.getDatasetId()));
        }
        return request.getSelectDims();
    }

    public void checkRuleViewNeedUpgrade(AlgoCalcRequest request) {
        if (request == null) {
            return;
        }
        Long modelId = request.getModelId();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        HashMap<String, Set> allRuleViewMap = new HashMap<String, Set>(16);
        List<RuleDto> rules = request.getRules();
        if (CollectionUtils.isEmpty(rules)) {
            return;
        }
        boolean needUpdateRule = false;
        for (RuleDto ruleDto : rules) {
            List<RuleFunction> functions;
            List<RuleRightItemDto> ruleRightItemDto;
            Object memberList;
            String useScope;
            if (ruleDto.isLeftMainMemContainCtControl()) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u89c4\u5219[%1]\u7684\u4e3b\u7ef4\u5ea6\u6210\u5458\u662f\u53d8\u52a8\u7c7b\u578b\u7684\u5360\u7528\u3001\u6267\u884c\u6210\u5458\uff0c\u8bf7\u4fee\u6539\u5bf9\u5e94\u89c4\u5219\u3002", (String)"CalcBizTemplate_3", (String)"epm-eb-olap", (Object[])new Object[]{ruleDto.getNumber()}));
            }
            if (needUpdateRule) break;
            Long mainDimensionId = ruleDto.getMainDimensionId();
            Dimension mainDimension = modelCacheHelper.getDimension(mainDimensionId);
            Long mainDimensionViewId = ruleDto.getMainDimensionViewId();
            String ruleView = ruleDto.getRuleView();
            if (!ruleDto.getViewMap().isEmpty() && ruleView == null) {
                needUpdateRule = true;
            }
            if (!View.NoViewDimNums.contains(mainDimension.getNumber()) && IDUtils.isEmptyLong((Long)mainDimensionViewId).booleanValue()) {
                needUpdateRule = true;
            }
            if (StringUtils.isNotBlank((CharSequence)(useScope = ruleDto.getUseScope()))) {
                List useScopeList = JSON.parseArray((String)useScope, FormulaCondition.class);
                for (FormulaCondition formulaCondition : useScopeList) {
                    Long viewIdLong;
                    String dimensionNumber = formulaCondition.getDimensionNumber();
                    if (View.NoViewDimNums.contains(dimensionNumber) || CollectionUtils.isEmpty((Collection)(memberList = formulaCondition.getMemberList())) || !IDUtils.isEmptyLong((Long)(viewIdLong = ((MemberCondition)memberList.get(0)).getViewIdLong())).booleanValue()) continue;
                    needUpdateRule = true;
                }
                Set hasViewDimSet = modelCacheHelper.getDimensionList(ruleDto.getDataSetId()).stream().map(BaseCache::getNumber).filter(number -> !View.NoViewDimNums.contains(number)).collect(Collectors.toSet());
                Set set = useScopeList.stream().map(FormulaCondition::getDimensionNumber).collect(Collectors.toSet());
                hasViewDimSet.remove(mainDimension.getNumber());
                hasViewDimSet.removeAll(set);
                if (CollectionUtils.isNotEmpty((Collection)hasViewDimSet)) {
                    needUpdateRule = true;
                }
            }
            if (CollectionUtils.isNotEmpty(ruleRightItemDto = ruleDto.getRuleRightItemDto())) {
                block2: for (RuleRightItemDto ruleRightItemDto2 : ruleRightItemDto) {
                    List<FormulaMemberDto> formulaMemberList = ruleRightItemDto2.getFormulaMemberList();
                    if (CollectionUtils.isEmpty(formulaMemberList)) continue;
                    memberList = formulaMemberList.iterator();
                    while (memberList.hasNext()) {
                        FormulaMemberDto formulaMemberDto = (FormulaMemberDto)memberList.next();
                        if (View.NoViewDimNums.contains(formulaMemberDto.getDimNumber()) || !IDUtils.isEmptyLong((Long)formulaMemberDto.getViewId()).booleanValue()) continue;
                        needUpdateRule = true;
                        continue block2;
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(functions = ruleDto.getFunctions())) {
                for (RuleFunction function : functions) {
                    needUpdateRule = this.checkRuleFunctionViewNeedUpgrade(function, needUpdateRule);
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)ruleView)) continue;
            Map map = (Map)JsonUtils.readValue((String)ruleView, Map.class);
            for (Map.Entry entry : map.entrySet()) {
                String dimNum = (String)entry.getKey();
                String viewNum = (String)entry.getValue();
                Set viewNumSet = allRuleViewMap.computeIfAbsent(dimNum, k -> Sets.newHashSetWithExpectedSize((int)16));
                viewNumSet.add(viewNum);
            }
        }
        if (needUpdateRule) {
            DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"UpdateOldRuleService", (String)"autoUpdateOldRule", (Object[])new Object[]{modelId, true});
            Long bizCtrlRangeId = rules.get(0).getBizCtrlRangeId();
            Map<Long, RuleDto> map = RuleCacheService.getInstance().listRuleFromLocalCache(bizCtrlRangeId).getRuleDtoList().stream().collect(Collectors.toMap(RuleDto::getId, v -> v, (v1, v2) -> v1));
            ArrayList<RuleDto> newRules = new ArrayList<RuleDto>(16);
            for (RuleDto rule : rules) {
                if (!map.containsKey(rule.getId())) continue;
                newRules.add(map.get(rule.getId()));
            }
            request.setRules(newRules);
        }
        for (Map.Entry entry : allRuleViewMap.entrySet()) {
            String dimNum = (String)entry.getKey();
            Set _viewNumSet = (Set)entry.getValue();
            if (!CollectionUtils.isNotEmpty((Collection)_viewNumSet) || _viewNumSet.size() <= 1) continue;
            Dimension dimension = modelCacheHelper.getDimension(dimNum);
            Set ruleNumSet = rules.stream().map(RuleDto::getNumber).collect(Collectors.toSet());
            throw new KDBizException(ResManager.loadResFormat((String)"\u89c4\u5219%1\u7684%2\u7ef4\u5ea6\u5b58\u5728\u4e0d\u540c\u89c6\u56fe\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CalcBizTemplate_2", (String)"epm-eb-olap", (Object[])new Object[]{dimension.getNumber(), StringUtils.join(ruleNumSet, (String)",")}));
        }
    }

    private boolean checkRuleFunctionViewNeedUpgrade(RuleFunction function, boolean needUpdateRule) {
        String functionName = function.getFunctionName();
        if (RuleFunctionEnum.CurrMBR.getName().equals(functionName)) {
            return needUpdateRule;
        }
        Map allValues = function.getAllValues();
        if (allValues.containsKey("childIsFun")) {
            if (allValues.containsKey(FunctionItemEnum.DIMEMBER.getKey())) {
                String dimMemberStr = (String)allValues.get(FunctionItemEnum.DIMEMBER.getKey());
                RuleFunction childFunction = RuleFunctionFactory.fromJsonString((String)dimMemberStr);
                needUpdateRule = this.checkRuleFunctionViewNeedUpgrade(childFunction, needUpdateRule);
            } else if (allValues.containsKey(FunctionItemEnum.DIMEMBERRANGE.getKey())) {
                String dimMemberRangeStr = (String)allValues.get(FunctionItemEnum.DIMEMBERRANGE.getKey());
                RuleFunction childFunction = RuleFunctionFactory.fromJsonString((String)dimMemberRangeStr);
                needUpdateRule = this.checkRuleFunctionViewNeedUpgrade(childFunction, needUpdateRule);
            }
        } else {
            String dimNumber = (String)allValues.get(FunctionItemEnum.DIMENSIONLIST.getKey());
            if (StringUtils.isBlank((CharSequence)dimNumber) || View.NoViewDimNums.contains(dimNumber)) {
                return needUpdateRule;
            }
            if (!allValues.containsKey(FunctionItemEnum.DIMEMBER.getKey()) && !allValues.containsKey(FunctionItemEnum.DIMEMBERRANGE.getKey())) {
                return needUpdateRule;
            }
            String viewIdStr = (String)allValues.get("allvals_view_id");
            Long viewId = IDUtils.toLong((Object)viewIdStr);
            if (IDUtils.isEmptyLong((Long)viewId).booleanValue()) {
                needUpdateRule = true;
            }
        }
        return needUpdateRule;
    }

    public boolean filterRulesRangeMember(AlgoCalcRequest request, IModelCacheHelper modelCache) {
        List<RuleDto> rules = request.getRules();
        Map<String, Set<String>> memberInfo = request.getMemberInfo();
        boolean change = false;
        HashMap<String, Set<String>> resultMemberInfo = new HashMap<String, Set<String>>(16);
        if (CollectionUtils.isNotEmpty(rules) && memberInfo != null) {
            HashMap<String, Set> ruleLeftMembers = new HashMap<String, Set>(16);
            Set<String> execDims = memberInfo.keySet();
            for (String string : execDims) {
                if (View.NoViewDimNums.contains(string)) continue;
                for (RuleDto rule : rules) {
                    Map<String, Set<String>> leftMembers = rule.getLeftMembers();
                    Set<String> rangeMemberSet = leftMembers.get(string);
                    if (CollectionUtils.isEmpty(rangeMemberSet)) {
                        Dimension dimension = modelCache.getDimension(string);
                        View view = dimension.getView(rule.getViewMap().getOrDefault(string, 0L));
                        rangeMemberSet = view != null ? view.getAllMembers().stream().map(BaseCache::getNumber).collect(Collectors.toSet()) : dimension.getAllMembers().stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                    }
                    Set memberSet = ruleLeftMembers.computeIfAbsent(string, f -> Sets.newHashSetWithExpectedSize((int)16));
                    memberSet.addAll(rangeMemberSet);
                }
            }
            for (Map.Entry entry : memberInfo.entrySet()) {
                String dim = (String)entry.getKey();
                Set members = (Set)entry.getValue();
                if (View.NoViewDimNums.contains(dim)) {
                    resultMemberInfo.put(dim, members);
                    continue;
                }
                Set ruleRanges = (Set)ruleLeftMembers.get(dim);
                if (CollectionUtils.isNotEmpty((Collection)members) && CollectionUtils.isNotEmpty((Collection)ruleRanges)) {
                    Sets.SetView intersection = Sets.intersection((Set)members, (Set)ruleRanges);
                    if (intersection.size() != members.size()) {
                        change = true;
                    }
                    resultMemberInfo.put(dim, new HashSet(intersection));
                    continue;
                }
                resultMemberInfo.put(dim, members);
            }
            request.setMemberInfo(resultMemberInfo);
        }
        return change;
    }

    private static class InnerClass {
        private static OlapManager instance = new OlapManager();

        private InnerClass() {
        }
    }
}

