/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.log.Stats;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.olapdao.FloatRows;
import kd.epm.eb.common.olapdao.OlapWriteOption;
import kd.epm.eb.common.params.ParamEnum;
import kd.epm.eb.common.params.ParamQueryServiceHelper;
import kd.epm.eb.common.params.ParamServiceHelper;
import kd.epm.eb.common.rule.execute.RuleExecuteTypeEnum;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.base.StrUtils;
import kd.epm.eb.common.utils.cache.Cache;
import kd.epm.eb.olap.impl.bizrule.RuleCacheService;
import kd.epm.eb.olap.impl.bizrule.RuleService;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import kd.epm.eb.olap.impl.bizrule.entity.RuleTemplateInfo;
import kd.epm.eb.olap.impl.execute.impl.Evaluator;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.BinaryExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.parse.Parse2RPN;
import kd.epm.eb.olap.service.AlgoCalcUtils;
import kd.epm.eb.olap.service.LeafFeature;
import kd.epm.eb.olap.service.OlapCommService;
import kd.epm.eb.olap.service.OlapManager;
import kd.epm.eb.olap.service.RuleRetryService;
import kd.epm.eb.olap.service.biztemplate.CalcBizTemplate;
import kd.epm.eb.olap.service.biztemplate.SaveBizTemplate;
import kd.epm.eb.olap.service.request.AlgoCalcRequest;
import kd.epm.eb.olap.service.request.FloatQueryRequest;
import kd.epm.eb.olap.service.request.Options;
import kd.epm.eb.olap.service.request.QueryRequest;
import kd.epm.eb.olap.service.request.SaveRequest;
import kd.epm.eb.olap.utils.PageUtil;
import kd.epm.eb.olap.utils.TemplateParamUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class OlapReportService {
    private static final Log log = LogFactory.getLog(OlapReportService.class);

    public static OlapReportService getInstance() {
        return InnerClass.instance;
    }

    public List<FloatRows> getFloatMember(long reportId, List<FloatQueryRequest> requests, String floatCalculate) {
        if (requests == null || requests.isEmpty()) {
            log.info(StrUtils.format((String)"getFloatMember requests is empty.", (Object[])new Object[0]));
            return new ArrayList<FloatRows>(16);
        }
        Stats stats = new Stats("getFloatMember");
        stats.appendMessage(StrUtils.format((String)"reportId: {},request size: {}", (Object[])new Object[]{reportId, requests.size()}));
        ArrayList floatRowsList = Lists.newArrayListWithExpectedSize((int)requests.size());
        Set<Long> templateRuleIds = RuleService.getInstance().getDirectRuleByTempId(reportId);
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)requests.get(0).getModelId());
        List<RuleDto> rules = this.queryRuleList(modelCache, templateRuleIds, requests.get(0).getDatasetId());
        Options options = new Options();
        for (FloatQueryRequest request : requests) {
            Stats.StatItem statItem = stats.createStatItem(StrUtils.format((String)"do Float: float number{}", (Object[])new Object[]{request.getNumber()}));
            Long datasetId = request.getDatasetId();
            List dimensionList = modelCache.getDimensionList(datasetId);
            try {
                OlapManager.getInstance().checkDimension(request.getMemberInfo(), (List<Dimension>)dimensionList);
            }
            catch (KDBizException e) {
                log.error((Throwable)e);
                continue;
            }
            if (CollectionUtils.isEmpty(request.getFloatDims())) continue;
            Map viewMap = request.getViewMap();
            if (viewMap == null || viewMap.isEmpty()) {
                viewMap = modelCache.getViewsByDataSet(request.getDatasetId());
            }
            FloatRows floatRows = new FloatRows(request.getNumber(), request.getSeq(), request.getFloatDims());
            floatRows.setRangeType(request.getRangeType());
            FloatQueryRequest.FixedDim fixedDim = request.getFixedDim();
            HashSet sections = Sets.newHashSetWithExpectedSize((int)fixedDim.getMemberNumbers().size());
            for (List<String> memberNumber : fixedDim.getMemberNumbers()) {
                String join = StringUtils.join(memberNumber, (String)"!");
                sections.add(join);
            }
            LinkedHashMap query = Maps.newLinkedHashMap();
            request.getMemberInfo().forEach((dim, mem) -> query.computeIfAbsent(dim, v -> Sets.newLinkedHashSet()).addAll(mem));
            QueryRequest req = new QueryRequest(request.getModelId(), request.getDatasetId(), query);
            req.setViewMap(viewMap);
            Stats.StatItem filterPermStat = stats.createStatItem(StrUtils.format((String)"filterPermRead", (Object[])new Object[0]));
            req = AlgoCalcUtils.filterPermRead(req, modelCache);
            filterPermStat.close();
            if (req == null || OlapManager.getInstance().checkDimensionNoError(dimensionList, req.getMemberInfo())) {
                statItem.close();
                floatRows.setFloatRows(Collections.emptyList());
                floatRowsList.add(floatRows);
                continue;
            }
            if (request.getRangeType() == 1 && request.isFilterTopItems() && !ModelServiceHelper.isUserHasRootPermByModel((long)UserUtils.getUserId(), (Long)request.getModelId())) {
                this.filterTopItems(modelCache, request.getFloatDims(), req.getMemberInfo(), req.getViewMap());
            }
            if (!MapUtils.isEmpty((Map)viewMap)) {
                options.setAnalysisView(true);
            }
            List<RuleDto> ruleDtos = AlgoCalcUtils.filterRuleByScope(request.getMemberInfo(), rules, LeafFeature.NOTLEAF);
            if ("1".equals(floatCalculate) && !ruleDtos.isEmpty() && request.getRangeType() == 1) {
                MutableGraph<Long> graph = this.buildDagGraph(ruleDtos);
                while (!graph.nodes().isEmpty()) {
                    Set zeroNodes = graph.nodes().stream().filter(node -> graph.inDegree(node) == 0).collect(Collectors.toSet());
                    if (!CollectionUtils.isNotEmpty(zeroNodes)) continue;
                    List zeroRules = ruleDtos.stream().filter(ruleDto -> zeroNodes.contains(ruleDto.getId())).collect(Collectors.toList());
                    for (RuleDto ruleDto2 : zeroRules) {
                        this.calcRule(ruleDto2, req.getMemberInfo(), viewMap, req.getDatasetId(), options, modelCache);
                        graph.removeNode((Object)ruleDto2.getId());
                    }
                }
            }
            List<BGCell> cells = OlapCommService.getInstance().queryList(req);
            statItem.append((Object)("cell Size:" + cells.size()));
            ArrayList rows = Lists.newArrayListWithExpectedSize((int)cells.size());
            StringBuilder fixedDimSb = new StringBuilder();
            StringBuilder floatDimSb = new StringBuilder();
            LinkedHashSet contains = Sets.newLinkedHashSet();
            List<String> floatDims = request.getFloatDims();
            List<BGCell> permCells = AlgoCalcUtils.filterPermRead(cells, request.getDatasetId(), request.getViewMap(), modelCache);
            for (BGCell cell : permCells) {
                Object value = cell.getValue();
                if (value == null || (value instanceof String ? StringUtils.isBlank((CharSequence)((String)value)) : value instanceof Number && ConvertUtils.equalValue((Object)BigDecimal.ZERO, (Object)value))) continue;
                Map memberMap = cell.getMemberMap();
                fixedDimSb.setLength(0);
                for (String dimNumber : fixedDim.getDimNumbers()) {
                    fixedDimSb.append((String)memberMap.get(dimNumber)).append('!');
                }
                fixedDimSb.setLength(fixedDimSb.length() - 1);
                if (!sections.contains(fixedDimSb.toString())) continue;
                floatDimSb.setLength(0);
                for (String dimNumber : floatDims) {
                    floatDimSb.append((String)memberMap.get(dimNumber)).append('!');
                }
                floatDimSb.setLength(floatDimSb.length() - 1);
                String uniqueKey = floatDimSb.toString();
                if (!contains.add(uniqueKey)) continue;
                FloatRows.FloatRow floatRow = new FloatRows.FloatRow();
                ArrayList items = Lists.newArrayListWithExpectedSize((int)floatDims.size());
                for (String floatDim : floatDims) {
                    items.add(memberMap.get(floatDim));
                }
                floatRow.setColItems((List)items);
                rows.add(floatRow);
            }
            floatRows.setFloatRows((List)rows);
            floatRowsList.add(floatRows);
            statItem.close();
        }
        stats.close();
        log.info(stats.toString("budget-olap-query:"));
        return floatRowsList;
    }

    private void filterTopItems(IModelCacheHelper modelCacheHelper, List<String> floatDims, Map<String, Set<String>> memberInfo, Map<String, Long> viewMap) {
        if (modelCacheHelper != null && floatDims != null && memberInfo != null) {
            Set<String> memNumbers = null;
            Object memLongNumbers = null;
            ArrayList<Member> members = null;
            for (String dimNumber : floatDims) {
                Long ViewId = IDUtils.toLong((Object)viewMap.get(dimNumber));
                memNumbers = memberInfo.get(dimNumber);
                if (memNumbers == null || memNumbers.size() <= 1) continue;
                HashSet<String> topMemNumbers = new HashSet<String>(16);
                members = new ArrayList<Member>(modelCacheHelper.getMembers(dimNumber, ViewId, memNumbers));
                members.sort(Comparator.comparing(Member::getLongNumber));
                String prevLongNum = "";
                for (Member member : members) {
                    if (member.getLongNumber().startsWith(prevLongNum + "!")) continue;
                    topMemNumbers.add(member.getNumber());
                    prevLongNum = member.getLongNumber();
                }
                memberInfo.put(dimNumber, topMemNumbers);
            }
        }
    }

    public List<BGCell> reportQuery(Set<Long> bizruleIds, List<QueryRequest> requests) {
        log.info(StrUtils.format((String)"reportQuery,bizruleIds: {},requests: {}", (Object[])new Object[]{bizruleIds, requests.toString()}));
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)requests.get(0).getModelId());
        List<RuleDto> rules = this.queryRuleList(modelCache, bizruleIds, requests.get(0).getDatasetId());
        return this.reportQuery(null, rules, requests);
    }

    private List<RuleDto> queryRuleList(IModelCacheHelper modelCache, Set<Long> ruleIds, Long datasetId) {
        if (CollectionUtils.isEmpty(ruleIds)) {
            return Collections.emptyList();
        }
        Long bizModelId = modelCache.getBusModelByDataSet(datasetId);
        List<RuleDto> allRuleList = RuleCacheService.getInstance().listRuleFromLocalCache(bizModelId).getRuleDtoList();
        return allRuleList.stream().filter(RuleDto::getStatus).filter(rule -> ruleIds.contains(rule.getId())).collect(Collectors.toList());
    }

    public List<BGCell> reportQuery(long reportId, List<QueryRequest> requests) {
        log.info(StrUtils.format((String)"reportQuery,reportId: {},requests: {}", (Object[])new Object[]{reportId, requests.toString()}));
        Set<Long> templateRuleIds = RuleService.getInstance().getDirectRuleByTempId(reportId);
        Long modelId = requests.get(0).getModelId();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List<RuleDto> rules = this.queryRuleList(modelCache, templateRuleIds, requests.get(0).getDatasetId());
        RuleTemplateInfo ruleTemplateInfo = new RuleTemplateInfo(modelId, reportId);
        return this.reportQuery(ruleTemplateInfo, rules, requests);
    }

    public List<BGCell> export(long reportId, List<QueryRequest> requests) {
        log.info(StrUtils.format((String)"export,reportId: {},requests size: {}", (Object[])new Object[]{reportId, requests.size()}));
        Long modelId = requests.get(0).getModelId();
        RuleTemplateInfo ruleTemplateInfo = new RuleTemplateInfo(modelId, reportId);
        ruleTemplateInfo.setCheckBindRuleToTemplate(false);
        return this.reportQuery(ruleTemplateInfo, Collections.emptyList(), requests);
    }

    public List<BGCell> reportQuery(RuleTemplateInfo ruleTemplateInfo, List<RuleDto> rules, List<QueryRequest> requests) {
        boolean checkBindRuleToTemplate;
        boolean runRuleBoolean = TemplateParamUtils.getRunRuleBoolean(ruleTemplateInfo == null ? null : ruleTemplateInfo.getTemplateId());
        if (!runRuleBoolean) {
            rules = Collections.emptyList();
        }
        Long modelId = requests.get(0).getModelId();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        boolean bl = checkBindRuleToTemplate = ruleTemplateInfo == null || ruleTemplateInfo.isCheckBindRuleToTemplate();
        if (checkBindRuleToTemplate && runRuleBoolean) {
            Long bizModelId = modelCache.getBusModelByDataSet(requests.get(0).getDatasetId());
            this.checkBindRuleToTemplate(bizModelId);
        }
        Stats stats = new Stats("reportQuery");
        List ruleIds = rules.stream().map(RuleDto::getId).collect(Collectors.toList());
        stats.appendMessage(StrUtils.format((String)"bizruleIds: {},request size: {}", (Object[])new Object[]{ruleIds, requests.size()}));
        Stats.StatItem statItem = stats.createStatItem(StrUtils.format((String)"filterPermRead,request size: {}", (Object[])new Object[]{requests.size()}));
        requests = AlgoCalcUtils.filterPermRead(requests, modelCache);
        statItem.close();
        if (requests.isEmpty()) {
            stats.appendMessage("all request is empty");
            log.info(stats.toString("budget-olap-log:"));
            return Collections.emptyList();
        }
        requests.forEach(request -> {
            Options options = request.getOptions();
            if (options == null) {
                options = new Options();
                request.setOptions(options);
            }
            options.setNeedFilterRule(false);
            this.dealSpecialViewMap((QueryRequest)request, modelCache, options);
        });
        for (QueryRequest request2 : requests) {
            Long bizModelId = request2.getDatasetId();
            List dimensionList = modelCache.getDimensionList(bizModelId);
            OlapManager.getInstance().checkDimension(request2.getMemberInfo(), (List<Dimension>)dimensionList);
        }
        if (!rules.isEmpty()) {
            MutableGraph<Long> graph = this.buildDagGraph(rules);
            while (!graph.nodes().isEmpty()) {
                Set zeroNodes = graph.nodes().stream().filter(node -> graph.inDegree(node) == 0).collect(Collectors.toSet());
                if (!CollectionUtils.isNotEmpty((Collection)zeroNodes)) continue;
                List zeroRules = rules.stream().filter(ruleDto -> zeroNodes.contains(ruleDto.getId())).collect(Collectors.toList());
                boolean isChange = false;
                for (RuleDto ruleDto2 : zeroRules) {
                    for (QueryRequest request3 : requests) {
                        List<BGCell> changedCells = this.calcRule(ruleDto2, request3.getMemberInfo(), request3.getViewMap(), request3.getDatasetId(), request3.getOptions(), modelCache);
                        if (changedCells.isEmpty()) continue;
                        isChange = true;
                        this.calcChain(ruleTemplateInfo, modelCache, request3, changedCells, request3.getOptions());
                        changedCells.clear();
                    }
                    graph.removeNode((Object)ruleDto2.getId());
                }
                if (!isChange) continue;
                MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u89c4\u5219\u8ba1\u7b97", "AbstractOlapServiceCaller_11", "epm-eb-olap");
                MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u62a5\u8868\u5237\u65b0\u8ba1\u7b97", "AbstractOlapServiceCaller_13", "epm-eb-olap");
                OperationLogUtil.log((String)"bgmd", (String)"eb_bizruleset", (String)"reportQuery", (String)"reportQuery", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, null);
            }
        }
        ArrayList cells = Lists.newArrayListWithExpectedSize((int)100);
        for (QueryRequest request4 : requests) {
            List<BGCell> dbCells = OlapManager.getInstance().queryList(request4);
            cells.addAll(AlgoCalcUtils.filterPermRead(dbCells, request4.getDatasetId(), request4.getViewMap(), modelCache));
        }
        boolean retryerrorcalc = ParamQueryServiceHelper.getBoolean((long)modelId, (ParamEnum)ParamEnum.BG041);
        if (retryerrorcalc) {
            RuleRetryService.getInstance().retryErrorCalc(modelId, modelCache);
        }
        log.info(stats.toString("budget-olap-log:"));
        return cells;
    }

    public void checkBindRuleToTemplate(Long bizModelId) {
        String cache = Cache.get().get("CACHE_BIND_RULE_TO_TEMPLATE" + bizModelId);
        String applyCache = Cache.get().get("CACHE_BIND_RULE_TO_APPLY_TEMPLATE" + bizModelId);
        if (StringUtils.isNotEmpty((CharSequence)cache) || StringUtils.isNotEmpty((CharSequence)applyCache)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u6b63\u5728\u53d1\u5e03\u4e2d\uff0c\u4e3a\u4fdd\u8bc1\u6570\u636e\u7684\u51c6\u786e\u6027\uff0c\u8bf75\u5206\u949f\u540e\u518d\u8bd5", (String)"RuleExecutionService_3", (String)"epm-eb-business", (Object[])new Object[0]));
        }
    }

    private List<Map<String, Set<String>>> optimizeByEntity(IModelCacheHelper modelCache, Long dataSetId, Map<String, Set<String>> queryMemberMap, RuleDto ruleDto) {
        if (MapUtils.isEmpty(ruleDto.getRightPageMembers())) {
            return Collections.emptyList();
        }
        String formulaString = ruleDto.getFormulaString();
        Parse2RPN parse2RPN = new Parse2RPN(formulaString);
        parse2RPN.parse();
        BinaryExpr expr = (BinaryExpr)parse2RPN.getExpr();
        Dataset dataSet = DatasetServiceHelper.getInstance().getDataSet(dataSetId);
        String[] dimensionNums = modelCache.getDimensionNums(dataSetId);
        String partDimension = "Entity";
        Set<String> entitySet = queryMemberMap.get(partDimension);
        Long mainDimensionId = ruleDto.getMainDimensionId();
        Dimension dimension = modelCache.getDimension(mainDimensionId);
        int maxSize = 0;
        if (entitySet.size() > 200 || dimension != null && dimension.getNumber().equals(partDimension)) {
            log.info(ResManager.loadKDString((String)"\u7ec4\u7ec7\u6570\u91cf\u8d85\u8fc7200\u4e2a\uff0c\u8bf7\u4ee5\u53e6\u4e00\u4e2a\u7ef4\u5ea6\u4f5c\u4e3a\u57fa\u51c6\u3002", (String)"ExecuteRuleServiceImpl_35", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            for (Map.Entry<String, Set<String>> entry : queryMemberMap.entrySet()) {
                String dimNumber = entry.getKey();
                int size = entry.getValue().size();
                if (size > 200 || SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber) || dimension != null && dimension.getNumber().equals(dimNumber) || size <= maxSize) continue;
                maxSize = size;
                partDimension = dimNumber;
                entitySet = entry.getValue();
            }
        }
        Evaluator evaluator = new Evaluator(partDimension, ruleDto, modelCache, dimensionNums, dataSet);
        ArrayList returnCollection = Lists.newArrayListWithExpectedSize((int)entitySet.size());
        for (String entity : entitySet) {
            evaluator.clearCollect();
            HashMap partEntityMap = Maps.newHashMap(queryMemberMap);
            partEntityMap.put(partDimension, Sets.newHashSet((Object[])new String[]{entity}));
            Map<String, Set<String>> hasTrimMap = expr.analyzeRange(partEntityMap, evaluator);
            if (hasTrimMap == null) {
                returnCollection.add(partEntityMap);
                continue;
            }
            if (hasTrimMap.isEmpty() || hasTrimMap.size() == 1 && "ignore".equals(hasTrimMap.entrySet().iterator().next().getKey())) continue;
            returnCollection.add(hasTrimMap);
        }
        return returnCollection;
    }

    private void calcChain(RuleTemplateInfo ruleTemplateInfo, IModelCacheHelper modelCache, QueryRequest request, List<BGCell> changedCells, Options options) {
        Map<String, Long> viewMap = request.getViewMap();
        Set<String> entityNumberSet = request.getMemberInfo().get(SysDimensionEnum.Entity.getNumber());
        Long currentEntityId = modelCache.getMember(SysDimensionEnum.Entity.getNumber(), viewMap.get(SysDimensionEnum.Entity.getNumber()), entityNumberSet.iterator().next()).getId();
        HashMap templateScope = Maps.newHashMap();
        kd.epm.eb.common.utils.MapUtils.mergeMap(request.getMemberInfo(), (Map)templateScope);
        if (ruleTemplateInfo != null) {
            ruleTemplateInfo.setCurrentEntityId(currentEntityId);
            ruleTemplateInfo.setTemplateScope(templateScope);
        }
        RuleExecuteTypeEnum ruleExecuteType = RuleExecuteTypeEnum.REFRESH;
        if (options != null && options.getUseAnalysis().booleanValue()) {
            ruleExecuteType = RuleExecuteTypeEnum.ANALYSIS;
        }
        String appId = "eb";
        String _appId = ParamServiceHelper.queryParam((String)"BCS_SERVICE_APPID", (String)appId);
        if (options == null) {
            options = new Options();
        }
        options.setViewMap(request.getViewMap());
        DispatchServiceHelper.invokeBizService((String)"epm", (String)_appId, (String)"RuleExecutionService", (String)"executeRuleChain", (Object[])new Object[]{ruleTemplateInfo, request.getDatasetId(), modelCache.getModelobj().getId(), changedCells, ruleExecuteType.getType(), options});
    }

    private List<BGCell> calcRule(RuleDto ruleDto, Map<String, Set<String>> reqScope, Map<String, Long> viewMap, Long datasetId, Options options, IModelCacheHelper modelCache) {
        CalcBizTemplate calcBizTemplate = CalcBizTemplate.newInstance();
        calcBizTemplate.setReturnChangeData(true);
        HashMap optMap = Maps.newHashMapWithExpectedSize((int)reqScope.size());
        ArrayList calcCells = Lists.newArrayList();
        HashMap<String, Set<String>> calcMap = new HashMap<String, Set<String>>(reqScope.size());
        Map<String, Set<String>> leftMembers = ruleDto.getLeftMembers();
        for (Map.Entry<String, Set<String>> entry : reqScope.entrySet()) {
            String dimNumber = entry.getKey();
            Set<String> set = leftMembers.get(dimNumber);
            if (CollectionUtils.isEmpty(set)) {
                calcMap.put(dimNumber, (Set<String>)entry.getValue());
                continue;
            }
            Set intersection = set.stream().filter(((Set)entry.getValue())::contains).collect(Collectors.toSet());
            if (intersection.isEmpty()) {
                return Collections.emptyList();
            }
            calcMap.put(dimNumber, new HashSet(intersection));
        }
        BigInteger sum = BigInteger.ONE;
        for (Object members : calcMap.values()) {
            sum = sum.multiply(BigInteger.valueOf(members.size()));
        }
        if (BigInteger.valueOf(10000000L).compareTo(sum) > 0) {
            AlgoCalcRequest calcRequest = new AlgoCalcRequest(modelCache.getModelobj().getId(), datasetId, viewMap, calcMap, Lists.newArrayList((Object[])new RuleDto[]{ruleDto}), options);
            return calcBizTemplate.doService(calcRequest);
        }
        log.info("\u5927\u5bbd\u8868\u8303\u56f4\u4f18\u5316");
        List<Map<String, Set<String>>> partByEntity = this.optimizeByEntity(modelCache, datasetId, calcMap, ruleDto);
        for (Map map : partByEntity) {
            kd.epm.eb.common.utils.MapUtils.mergeMap((Map)map, (Map)optMap);
        }
        if (optMap.isEmpty()) {
            return calcCells;
        }
        Iterator<Map<String, Set<String>>> pageIte = PageUtil.getPageMapExcludeBpIterator(optMap, 10000000);
        while (pageIte.hasNext()) {
            Map<String, Set<String>> map = pageIte.next();
            AlgoCalcRequest calcRequest = new AlgoCalcRequest(modelCache.getModelobj().getId(), datasetId, viewMap, map, Lists.newArrayList((Object[])new RuleDto[]{ruleDto}), options);
            calcCells.addAll(calcBizTemplate.doService(calcRequest));
        }
        return calcCells;
    }

    public MutableGraph<Long> buildDagGraph(List<RuleDto> ruleDtoList) {
        MutableGraph graph = GraphBuilder.directed().allowsSelfLoops(false).build();
        for (RuleDto ruleDto : ruleDtoList) {
            if (graph.nodes().contains(ruleDto.getId())) continue;
            graph.addNode((Object)ruleDto.getId());
        }
        for (RuleDto ruleDto : ruleDtoList) {
            String successors = ruleDto.getSuccessors();
            if (!StringUtils.isNotBlank((CharSequence)successors)) continue;
            for (String su : StringUtils.split((String)successors, (String)",")) {
                long nodeId = Long.parseLong(su);
                if (!graph.nodes().contains(nodeId) || ruleDto.getId().equals(nodeId)) continue;
                graph.putEdge((Object)ruleDto.getId(), (Object)nodeId);
            }
        }
        return graph;
    }

    private void dealSpecialViewMap(QueryRequest request, IModelCacheHelper modelCache, Options options) {
        Map<String, Long> viewMap = request.getViewMap();
        if (MapUtils.isEmpty(viewMap)) {
            request.setViewMap(modelCache.getViewsByDataSet(request.getDatasetId()));
        } else {
            HashMap<String, Long> newViewMap = new HashMap<String, Long>(16);
            for (Map.Entry<String, Long> entry : viewMap.entrySet()) {
                String key = entry.getKey();
                if (key.contains("_")) {
                    String[] s = key.split("_");
                    newViewMap.put(s[0], entry.getValue());
                    continue;
                }
                newViewMap.put(key, entry.getValue());
            }
            request.setViewMap(newViewMap);
            options.setAnalysisView(true);
        }
    }

    public List<BGCell> reportSave(RuleTemplateInfo ruleTemplateInfo, List<SaveRequest> requests) {
        log.info(StrUtils.format((String)"reportSave,reportId: {},requests: {}", (Object[])new Object[]{ruleTemplateInfo == null ? null : ruleTemplateInfo.getTemplateId(), requests.toString()}));
        Stats stats = new Stats("reportSave");
        Long modelId = requests.get(0).getModelId();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Long bizModelId = modelCacheHelper.getBusModelByDataSet(requests.get(0).getDatasetId());
        this.checkBindRuleToTemplate(bizModelId);
        SaveBizTemplate saveBizTemplate = SaveBizTemplate.newInstance();
        OlapWriteOption writeOption = new OlapWriteOption();
        writeOption.setValidPerm(requests.get(0).isValidPerm());
        saveBizTemplate.setOlapWriteOption(writeOption);
        ArrayList<BGCell> allChangedCells = new ArrayList<BGCell>(16);
        for (SaveRequest request : requests) {
            Stats.StatItem doSave = stats.createStatItem("do Save");
            List<BGCell> changedCells = saveBizTemplate.doService(request);
            doSave.close();
            Stats.StatItem executeRuleChain = stats.createStatItem("do executeRuleChain");
            if (!changedCells.isEmpty()) {
                String appId = "eb";
                String _appId = ParamServiceHelper.queryParam((String)"BCS_SERVICE_APPID", (String)appId);
                Options options = new Options();
                options.setViewMap(request.getViewMap());
                this.executeRuleChain(ruleTemplateInfo, modelId, request, changedCells, _appId, options);
            }
            executeRuleChain.close();
            allChangedCells.addAll(changedCells);
        }
        log.info(stats.toString("budget-olap-query:"));
        return allChangedCells;
    }

    private void executeRuleChain(RuleTemplateInfo ruleTemplateInfo, Long modelId, SaveRequest request, List<BGCell> changedCells, String _appId, Options options) {
        DispatchServiceHelper.invokeBizService((String)"epm", (String)_appId, (String)"RuleExecutionService", (String)"executeRuleChain", (Object[])new Object[]{ruleTemplateInfo, request.getDatasetId(), modelId, changedCells, RuleExecuteTypeEnum.DEPEN.getType(), options});
    }

    private static class InnerClass {
        private static OlapReportService instance = new OlapReportService();

        private InnerClass() {
        }
    }
}

