/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.rule.execute.RuleExecuteLogStatusEnum;
import kd.epm.eb.common.rule.execute.RuleExecuteTypeEnum;
import kd.epm.eb.common.rule.execute.RulePushStatusEnum;
import kd.epm.eb.common.rule.execute.RuleRetryStatusEnum;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.olap.impl.bizrule.entity.RuleExecutionRequest;
import kd.epm.eb.olap.service.OlapCommService;
import kd.epm.eb.olap.service.request.Options;
import kd.epm.eb.olap.service.request.QueryRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class RuleRetryService {
    private static final Log log = LogFactory.getLog(RuleRetryService.class);

    private RuleRetryService() {
    }

    public static RuleRetryService getInstance() {
        return Singleton.INSTANCE.instance;
    }

    public void retryErrorCalc(Long modelId, IModelCacheHelper modelCache) {
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        qf.and("retrynumber", "<", (Object)1);
        qf.and("executestatus", "in", Arrays.asList(RuleExecuteLogStatusEnum.EXECUTING.getCode(), RuleExecuteLogStatusEnum.FAIL.getCode()));
        this.retryErrorCalc(qf, modelCache);
    }

    public void retryErrorCalc(QFilter qf, IModelCacheHelper modelCache) {
        Long modelId = modelCache.getModelobj().getId();
        DLock lock = DLock.create((String)("eb_rule_retryErrorCalc_" + modelId), (String)ResManager.loadKDString((String)"\u4f9d\u8d56\u8ba1\u7b97\u91cd\u8bd5\u9501", (String)"RuleRetryService_0", (String)"epm-eb-olap", (Object[])new Object[0]));
        lock.fastMode();
        if (lock.tryLock()) {
            log.info("\u4f9d\u8d56\u8ba1\u7b97\u91cd\u8bd5\u9501\u83b7\u53d6\u5931\u8d25");
            return;
        }
        EpmThreadPools.RULE_EXECUTION_POOL.execute(() -> {
            try {
                DynamicObjectCollection logs = QueryServiceHelper.query((String)"eb_rule_instance", (String)"id,executestatus,createtime,traceid,retrysrctraceid", (QFilter[])qf.toArray());
                List logMainList = logs.stream().filter(e -> {
                    if (StringUtils.isNotBlank((CharSequence)e.getString("retrysrctraceid"))) {
                        return false;
                    }
                    String executestatus = e.getString("executestatus");
                    if (RuleExecuteLogStatusEnum.FAIL.getCode().equals(executestatus)) {
                        return true;
                    }
                    if (RuleExecuteLogStatusEnum.EXECUTING.getCode().equals(executestatus)) {
                        Date createtime = e.getDate("createtime");
                        Date fourLater = DateUtils.addHours((Date)createtime, (int)2);
                        Date now = new Date();
                        return fourLater.getTime() < now.getTime();
                    }
                    return false;
                }).collect(Collectors.toList());
                ArrayList errorList = Lists.newArrayList();
                for (DynamicObject logMainObj : logMainList) {
                    QFilter qfDet = new QFilter("logid", "=", (Object)logMainObj.getLong("id"));
                    qfDet.and("pushstatus", "=", (Object)RulePushStatusEnum.FAIL.getCode());
                    DynamicObjectCollection logDets = QueryServiceHelper.query((String)"eb_rule_instance_detail", (String)"pushstatus,datascope", (QFilter[])qfDet.toArray());
                    String traceid = logMainObj.getString("traceid");
                    boolean hasError = false;
                    for (DynamicObject logDet : logDets) {
                        String datascope = logDet.getString("datascope");
                        Map dataMap = (Map)JSON.parseObject((String)datascope, (TypeReference)new TypeReference<Map<String, Set<String>>>(){}, (Feature[])new Feature[0]);
                        Set accSet = (Set)dataMap.get(SysDimensionEnum.Account.getNumber());
                        if (accSet == null || accSet.isEmpty()) continue;
                        boolean emptyMember = this.isEmptyMember(modelCache, dataMap);
                        if (emptyMember) {
                            log.error("\u91cd\u8bd5\u6267\u884c\u62a5\u9519\uff0c\u6210\u5458\u4e0d\u5b58\u5728: " + JSON.toJSONString((Object)dataMap));
                            errorList.add(logMainObj);
                            continue;
                        }
                        Member luckyAcc = modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, (String)accSet.iterator().next());
                        try {
                            Long datasetId = luckyAcc.getDatasetId();
                            List<BGCell> bgCells = OlapCommService.getInstance().queryList(new QueryRequest(modelId, datasetId, dataMap));
                            RuleExecutionRequest request = new RuleExecutionRequest();
                            request.setDatasetId(datasetId);
                            request.setModelId(modelId);
                            request.setCells(bgCells);
                            request.setExeType(RuleExecuteTypeEnum.REPEAT_CALC.getType());
                            request.setRetrySrcTraceid(traceid);
                            this.calcRule(request);
                        }
                        catch (Exception ignore) {
                            log.error("\u91cd\u8bd5\u6267\u884c\u62a5\u9519", (Throwable)ignore);
                            hasError = true;
                        }
                    }
                    if (!hasError) continue;
                    errorList.add(logMainObj);
                }
                Map<Long, DynamicObject> errMap = errorList.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
                LinkedList successParams = Lists.newLinkedList();
                LinkedList errParams = Lists.newLinkedList();
                for (DynamicObject logMain : logMainList) {
                    long id = logMain.getLong("id");
                    if (errMap.containsKey(id)) {
                        Object[] errParam = new Object[]{RuleRetryStatusEnum.FAIL.getCode(), id};
                        errParams.add(errParam);
                        continue;
                    }
                    Object[] successParam = new Object[]{RuleRetryStatusEnum.SUCCESS.getCode(), id};
                    successParams.add(successParam);
                }
                if (!successParams.isEmpty()) {
                    String successSql = "update t_eb_rule_instance set fretrynumber = fretrynumber+1,fretrystatus=? where fid = ?";
                    DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)successSql, (List)successParams);
                }
                if (!errParams.isEmpty()) {
                    String errSql = "update t_eb_rule_instance set fretrynumber = fretrynumber+1,fretrystatus=? where fid = ?";
                    DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)errSql, (List)errParams);
                }
            }
            finally {
                lock.unlock();
            }
        });
    }

    private boolean isEmptyMember(IModelCacheHelper modelCache, Map<String, Set<String>> dataMap) {
        boolean emptyMember = false;
        for (Map.Entry<String, Set<String>> entry : dataMap.entrySet()) {
            Set<String> memberSet = entry.getValue();
            HashSet existSet = Sets.newHashSet();
            memberSet.forEach(e -> {
                if (modelCache.getMemberByAnyView((String)entry.getKey(), e) != null) {
                    existSet.add(e);
                }
            });
            if (existSet.isEmpty()) {
                emptyMember = true;
                break;
            }
            memberSet.clear();
            memberSet.addAll(existSet);
        }
        return emptyMember;
    }

    private void calcRule(RuleExecutionRequest request) {
        DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"RuleExecutionService", (String)"executeRuleChain", (Object[])new Object[]{request, new Options()});
    }

    private static enum Singleton {
        INSTANCE;

        private final RuleRetryService instance = new RuleRetryService();
    }
}

