/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.service.biztemplate;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.log.Stats;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.utils.base.StrUtils;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import kd.epm.eb.olap.service.AlgoCalcUtils;
import kd.epm.eb.olap.service.OlapCommService;
import kd.epm.eb.olap.service.OlapManager;
import kd.epm.eb.olap.service.request.AlgoCalcRequest;
import kd.epm.eb.olap.service.request.QueryRequest;
import org.apache.commons.collections4.CollectionUtils;

public class QueryBizTemplate {
    private static final Log log = LogFactory.getLog(QueryBizTemplate.class);
    private boolean filterPermRead = true;
    private Stats stats = new Stats("QueryBizTemplate");

    public static QueryBizTemplate newInstance() {
        return new QueryBizTemplate();
    }

    private QueryBizTemplate() {
    }

    public final List<BGCell> doService(AlgoCalcRequest request) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)request.getModelId());
        log.info(StrUtils.format((String)"QueryBizTemplate,request: {}", (Object[])new Object[]{request.toString()}));
        Stats.StatItem filterPermRead = this.stats.createStatItem("filterPermRead");
        AlgoCalcRequest filterReq = this.filterPermRead(request, modelCache);
        filterPermRead.close();
        if (filterReq == null) {
            return Collections.emptyList();
        }
        if (request.getOptions().getNeedFilterRule().booleanValue() && CollectionUtils.isNotEmpty(request.getRules())) {
            List<RuleDto> ruleDtos = AlgoCalcUtils.filterRuleByScope(request.getMemberInfo(), request.getRules(), null);
            if (ruleDtos.isEmpty()) {
                filterPermRead.append((Object)"rule is not in scope.");
            }
            request.setRules(ruleDtos);
        }
        Stats.StatItem queryData = this.stats.createStatItem("queryData");
        List<BGCell> bgCells1 = this.queryNoNumberData(modelCache, filterReq);
        List<BGCell> bgCells = this.queryData(filterReq);
        bgCells.addAll(bgCells1);
        queryData.close();
        this.stats.appendMessage(StrUtils.format((String)"result size:{},results sampling:{}", (Object[])new Object[]{bgCells.size(), bgCells.isEmpty() ? "null" : bgCells.get(0).toString()}));
        Stats.StatItem filterPermReadAfter = this.stats.createStatItem("filterPermReadAfter");
        bgCells = this.filterPermReadAfter(bgCells, request.getDatasetId(), request.getViewMap(), modelCache);
        filterPermReadAfter.close();
        log.info(this.stats.toString("budget-olap-log:"));
        return bgCells;
    }

    public AlgoCalcRequest filterPermRead(AlgoCalcRequest request, IModelCacheHelper modelCache) {
        if (this.filterPermRead) {
            return AlgoCalcUtils.filterPermRead(request, modelCache);
        }
        return request;
    }

    public List<BGCell> filterPermReadAfter(List<BGCell> cells, long datasetId, Map<String, Long> viewMap, IModelCacheHelper modelCache) {
        if (this.filterPermRead) {
            cells = AlgoCalcUtils.filterPermRead(cells, datasetId, viewMap, modelCache);
        }
        return cells;
    }

    private List<BGCell> queryNoNumberData(IModelCacheHelper modelCache, AlgoCalcRequest request) {
        Map<String, Set<String>> queryInfo = request.getMemberInfo();
        Set<String> metricNumbers = queryInfo.get(SysDimensionEnum.Metric.getNumber());
        Dimension metricDimension = modelCache.getDimension(SysDimensionEnum.Metric.getNumber());
        Set filterSet = metricNumbers.stream().filter(metricNumber -> !MetricDataTypeEnum.isNumber((String)metricDimension.getMember(null, metricNumber).getDatatype())).collect(Collectors.toSet());
        if (filterSet.isEmpty()) {
            return Collections.emptyList();
        }
        queryInfo.put(SysDimensionEnum.Metric.getNumber(), filterSet);
        List<BGCell> bgCells = OlapCommService.getInstance().queryList(QueryRequest.of(request));
        queryInfo.put(SysDimensionEnum.Metric.getNumber(), metricNumbers);
        return bgCells;
    }

    private List<BGCell> queryData(AlgoCalcRequest request) {
        QueryRequest req = new QueryRequest(request.getModelId(), request.getDatasetId(), request.getViewMap(), request.getMemberInfo(), null);
        req.setOptions(request.getOptions());
        return OlapManager.getInstance().queryList(req);
    }

    public void setFilterPermRead(boolean filterPermRead) {
        this.filterPermRead = filterPermRead;
    }
}

