/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.service.biztemplate;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.log.Stats;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.olapdao.OlapWriteOption;
import kd.epm.eb.common.utils.base.StrUtils;
import kd.epm.eb.olap.service.AlgoCalcUtils;
import kd.epm.eb.olap.service.OlapManager;
import kd.epm.eb.olap.service.request.QueryRequest;
import kd.epm.eb.olap.service.request.SaveRequest;
import org.apache.commons.collections4.CollectionUtils;

public class SaveBizTemplate {
    private static final Log log = LogFactory.getLog(SaveBizTemplate.class);
    private OlapWriteOption olapWriteOption = new OlapWriteOption();
    private Stats stats = new Stats("SaveBizTemplate");

    public static SaveBizTemplate newInstance() {
        return new SaveBizTemplate();
    }

    private SaveBizTemplate() {
    }

    public final List<BGCell> doService(SaveRequest request) {
        if (CollectionUtils.isEmpty(request.getDatas())) {
            return Collections.emptyList();
        }
        log.info(StrUtils.format((String)"SaveBizTemplate,request: {}", (Object[])new Object[]{request.toString()}));
        this.stats.appendMessage(StrUtils.format((String)"save data sampling: {}", (Object[])new Object[]{request.getDatas().get(0)}));
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)request.getModelId());
        Stats.StatItem filterPermWrite = this.stats.createStatItem("filterPermWrite");
        this.filterPermWrite(request, modelCache);
        filterPermWrite.close();
        Stats.StatItem saveData = this.stats.createStatItem("saveData");
        List<BGCell> bgCells = this.saveData(request, modelCache);
        saveData.close();
        this.stats.appendMessage(StrUtils.format((String)"result size:{},results sampling:{}", (Object[])new Object[]{bgCells.size(), bgCells.isEmpty() ? "null" : bgCells.get(0).toString()}));
        log.info(this.stats.toString("budget-olap-log:"));
        return bgCells;
    }

    public void filterPermWrite(SaveRequest request, IModelCacheHelper modelCache) {
        if (this.olapWriteOption.isValidPerm()) {
            AlgoCalcUtils.filterPermWrite(request, modelCache);
        }
    }

    private List<BGCell> saveData(SaveRequest request, IModelCacheHelper modelCache) {
        if (request.getDatas().isEmpty()) {
            return Collections.emptyList();
        }
        if (!this.olapWriteOption.isIncrement()) {
            HashMap queryInfo = Maps.newHashMap();
            for (BGCell data : request.getDatas()) {
                data.getMemberMap().forEach((k, v) -> queryInfo.computeIfAbsent(k, v1 -> Sets.newLinkedHashSet()).add(v));
            }
            QueryRequest oldReq = new QueryRequest(request.getModelId(), request.getDatasetId(), request.getViewMap(), queryInfo, null);
            List<BGCell> oldCells = OlapManager.getInstance().queryList(oldReq);
            LinkedList<BGCell> changeCells = AlgoCalcUtils.getOnlyNewChangeCell(oldCells, request.getDatas(), modelCache.getDimensionList(request.getDatasetId()));
            request.setDatas(changeCells);
        }
        return OlapManager.getInstance().saveList(request, this.olapWriteOption);
    }

    public void setOlapWriteOption(OlapWriteOption olapWriteOption) {
        if (olapWriteOption != null) {
            this.olapWriteOption = olapWriteOption;
        }
    }
}

