/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.service.biztemplate.strategy;

import java.util.Collections;
import java.util.List;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.olap.service.AlgoCalcUtils;
import kd.epm.eb.olap.service.OlapManager;
import kd.epm.eb.olap.service.request.QueryRequest;

public class ReturnChangeDataStrategy {
    private final boolean returnChangeData;
    private QueryRequest queryRequest;
    private List<BGCell> oldCells = null;

    public ReturnChangeDataStrategy(boolean returnChangeData) {
        this.returnChangeData = returnChangeData;
    }

    public void queryBefore(QueryRequest queryRequest) {
        if (this.returnChangeData) {
            this.queryRequest = queryRequest;
            this.oldCells = OlapManager.getInstance().queryList(queryRequest);
        }
    }

    public List<BGCell> getChangeData() {
        if (this.returnChangeData && this.queryRequest != null) {
            List<BGCell> newCells = OlapManager.getInstance().queryList(this.queryRequest);
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.queryRequest.getModelId());
            List dimensionList = modelCache.getDimensionList(this.queryRequest.getDatasetId());
            return AlgoCalcUtils.getChangeCell(this.oldCells, newCells, dimensionList);
        }
        return Collections.emptyList();
    }
}

