/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.service.request;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.olap.api.metadata.IDataRow;

public class DrillQueryRequest {
    private Long modelId;
    private Long bizModelId;
    private Long datasetId;
    private Map<String, Long> viewMap;
    private List<Dimension> rowDims;
    private List<Dimension> colDims;
    private List<Dimension> commDims;
    private List<IDataRow> dataRows;

    public Long getModelId() {
        return this.modelId;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public Long getBizModelId() {
        return this.bizModelId;
    }

    public void setBizModelId(Long bizModelId) {
        this.bizModelId = bizModelId;
    }

    public Long getDatasetId() {
        return this.datasetId;
    }

    public void setDatasetId(Long datasetId) {
        this.datasetId = datasetId;
    }

    public Map<String, Long> getViewMap() {
        return this.viewMap;
    }

    public void setViewMap(Map<String, Long> viewMap) {
        this.viewMap = viewMap;
    }

    public List<Dimension> getRowDims() {
        return this.rowDims;
    }

    public void setRowDims(List<Dimension> rowDims) {
        this.rowDims = rowDims;
    }

    public List<Dimension> getColDims() {
        return this.colDims;
    }

    public void setColDims(List<Dimension> colDims) {
        this.colDims = colDims;
    }

    public List<Dimension> getCommDims() {
        return this.commDims;
    }

    public void setCommDims(List<Dimension> commDims) {
        this.commDims = commDims;
    }

    public List<IDataRow> getDataRows() {
        return this.dataRows;
    }

    public void setDataRows(List<IDataRow> dataRows) {
        this.dataRows = dataRows;
    }

    public String toString() {
        return "DrillQueryRequest{modelId=" + this.modelId + ", bizModelId=" + this.bizModelId + ", datasetId=" + this.datasetId + ", viewMap=" + this.viewMap + ", rowDims=" + this.getPrintInfo(this.rowDims) + ", colDims=" + this.getPrintInfo(this.colDims) + ", commDims=" + this.getPrintInfo(this.commDims) + ", dataRows=" + this.dataRows + '}';
    }

    private String getPrintInfo(List<Dimension> dimensions) {
        if (dimensions != null) {
            StringBuilder sb = new StringBuilder();
            for (Dimension dimension : dimensions) {
                sb.append(dimension.getNumber());
                if (dimension.getMembers() != null) {
                    sb.append(dimension.getMembers().stream().map(e -> e.getNumber()).collect(Collectors.toSet()));
                    continue;
                }
                sb.append("[]");
            }
            return sb.toString();
        }
        return "null";
    }
}

