/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.service.view;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.viewgroup.ViewGroupServiceHelper;
import kd.epm.eb.olap.service.view.ViewMemberManager;
import kd.epm.eb.olap.service.view.bean.DimensionView;
import kd.epm.eb.olap.service.view.bean.DimensionViewGroup;

public class ViewGroupManager {
    private static final ViewGroupManager instance = new ViewGroupManager();
    public static final String EB_DIMENSIONVIEW_GROUP = "eb_dimensionview_group";
    private static final String selectFields = "id,model,number,name,parent,description,dimension,creater,createdate,type,defaultview,source";

    public static ViewGroupManager getInstance() {
        return instance;
    }

    public void saveViewGroup(DimensionViewGroup dimensionViewGroup) {
        if (!this.checkNumber(dimensionViewGroup.getNumber())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f16\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"ViewGroupManager_1", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)dimensionViewGroup.getName().getLocaleValue())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DimensionMemberSaveValidator_13", (String)"epm-eb-cube", (Object[])new Object[0]));
        }
        if (dimensionViewGroup.getId() == null) {
            QFilter qFilter = new QFilter("number", "=", (Object)dimensionViewGroup.getNumber()).and("model", "=", (Object)dimensionViewGroup.getModelId()).and("dimension", "=", (Object)dimensionViewGroup.getDimensionId());
            if (QueryServiceHelper.exists((String)EB_DIMENSIONVIEW_GROUP, (QFilter[])qFilter.toArray())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u6b64\u7f16\u7801\u7684\u7ef4\u5ea6\u89c6\u56fe\u5206\u7ec4\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ViewGroupManager_7", (String)"epm-eb-olap", (Object[])new Object[0]));
            }
            DynamicObject newNode = BusinessDataServiceHelper.newDynamicObject((String)EB_DIMENSIONVIEW_GROUP);
            newNode.set("id", (Object)DBServiceHelper.genGlobalLongId());
            newNode.set("model", (Object)dimensionViewGroup.getModelId());
            newNode.set("number", (Object)dimensionViewGroup.getNumber());
            newNode.set("name", (Object)dimensionViewGroup.getName());
            newNode.set("parent", (Object)dimensionViewGroup.getParent());
            newNode.set("description", (Object)dimensionViewGroup.getDescription());
            newNode.set("dimension", (Object)dimensionViewGroup.getDimensionId());
            newNode.set("creater", (Object)UserUtils.getUserId());
            newNode.set("createdate", (Object)TimeServiceHelper.now());
            newNode.set("type", (Object)dimensionViewGroup.getType());
            newNode.set("defaultview", (Object)dimensionViewGroup.getDefaultViewId());
            newNode.set("source", (Object)dimensionViewGroup.getSource());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newNode});
        } else {
            DynamicObject editNode = BusinessDataServiceHelper.loadSingle((Object)dimensionViewGroup.getId(), (String)EB_DIMENSIONVIEW_GROUP);
            if (editNode == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5206\u7ec4\u4e0d\u5b58\u5728", (String)"ViewGroupManager_3", (String)"epm-eb-olap", (Object[])new Object[0]));
            }
            if (dimensionViewGroup.getDefaultViewId().longValue() != editNode.getLong("defaultview.id")) {
                CubeUtils.updateDimensionVersion((Long)dimensionViewGroup.getModelId(), (Long)dimensionViewGroup.getDimensionId());
            }
            editNode.set("name", (Object)dimensionViewGroup.getName());
            editNode.set("modifier", (Object)UserUtils.getUserId());
            editNode.set("modifydate", (Object)TimeServiceHelper.now());
            editNode.set("parent", (Object)dimensionViewGroup.getParent());
            editNode.set("defaultview", (Object)dimensionViewGroup.getDefaultViewId());
            editNode.set("description", (Object)dimensionViewGroup.getDescription());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{editNode});
        }
    }

    public void deleteViewGroup(Long modelId, String dimNum, List<Long> viewGroupIds) {
        if (CollectionUtils.isEmpty(viewGroupIds)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u9700\u8981\u5220\u9664\u5206\u7ec4\u7684id", (String)"ViewGroupManager_4", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        Set<Long> allView = this.getAllViewByGroupId(viewGroupIds);
        this.deleteViews(modelId, dimNum, new ArrayList<Long>(allView));
        DeleteServiceHelper.delete((String)EB_DIMENSIONVIEW_GROUP, (QFilter[])new QFilter("id", "in", viewGroupIds).toArray());
    }

    public void saveView(DimensionView dimensionView) {
        DynamicObject view;
        if (!this.checkNumber(dimensionView.getNumber())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f16\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"ViewGroupManager_1", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)dimensionView.getName().getLocaleValue())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DimensionMemberSaveValidator_13", (String)"epm-eb-cube", (Object[])new Object[0]));
        }
        Long userId = UserUtils.getUserId();
        if (dimensionView.getId() == null) {
            QFilter qFilter = new QFilter("number", "=", (Object)dimensionView.getNumber()).and("model", "=", (Object)dimensionView.getModelId());
            qFilter.and("dimension", "=", (Object)dimensionView.getDimensionId());
            if (QueryServiceHelper.exists((String)"eb_dimensionview", (QFilter[])qFilter.toArray())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u6b64\u7f16\u7801\u7684\u7ef4\u5ea6\u89c6\u56fe\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ViewGroupManager_11", (String)"epm-eb-olap", (Object[])new Object[0]));
            }
            view = BusinessDataServiceHelper.newDynamicObject((String)"eb_dimensionview");
            Long id = GlobalIdUtil.genGlobalLongId();
            view.set("id", (Object)id);
            dimensionView.setId(id);
            view.set("creater", (Object)userId);
            view.set("createdate", (Object)TimeServiceHelper.now());
            view.set("model", (Object)dimensionView.getModelId());
            view.set("dimension", (Object)dimensionView.getDimensionId());
            view.set("longnumber", (Object)("!" + dimensionView.getNumber()));
            Long parentId = 0L;
            int parentLevel = 0;
            view.set("level", (Object)(parentLevel + 1));
            view.set("parent", (Object)parentId);
            int dseq = this.getMaxDseq(parentId, dimensionView.getDimensionId(), dimensionView.getModelId());
            view.set("dseq", (Object)(dseq + 1));
            view.set("source", (Object)0);
            view.set("isleaf", (Object)true);
            view.set("usage", (Object)"0");
            view.set("number", (Object)dimensionView.getNumber());
        } else {
            view = BusinessDataServiceHelper.loadSingle((Object)dimensionView.getId(), (String)"eb_dimensionview");
        }
        view.set("viewgroup", (Object)dimensionView.getViewGroupId());
        view.set("name", (Object)dimensionView.getName());
        view.set("description", (Object)dimensionView.getDescription());
        view.set("modifier", (Object)userId);
        view.set("modifydate", (Object)TimeServiceHelper.now());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{view});
    }

    protected int getMaxDseq(Long parentId, Long dimId, Long modelId) {
        QFilter dimQf = new QFilter("dimension", "=", (Object)dimId);
        QFilter modelQf = new QFilter("model", "=", (Object)modelId);
        QFilter parentQf = new QFilter("parent", "=", (Object)parentId);
        QFilter[] filters = new QFilter[]{dimQf, modelQf, parentQf};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)"eb_dimensionview", (String)"dseq", (QFilter[])filters, (String)"dseq desc");
        if (dcs != null) {
            if (dcs.size() == 0) {
                return 0;
            }
            return ((DynamicObject)dcs.get(0)).getInt("dseq");
        }
        return 0;
    }

    public void deleteViews(Long modelId, String dimNum, List<Long> viewIds) {
        for (Long viewId : viewIds) {
            ViewMemberManager.getInstance().deleteMemberByView(modelId, dimNum, viewId);
        }
        QFilter model = new QFilter("model", "=", (Object)modelId);
        QFilter filter = new QFilter("id", "in", viewIds);
        DeleteServiceHelper.delete((String)"eb_dimensionview", (QFilter[])new QFilter[]{filter, model});
    }

    private boolean checkNumber(String number) {
        return NumberCheckUtils.checkNumber((String)number);
    }

    private boolean checkName(String name) {
        return NumberCheckUtils.checkName((String)name);
    }

    public Set<Long> getAllViewByGroupId(List<Long> groupIds) {
        return ViewGroupServiceHelper.getInstance().getAllViewByGroupId(groupIds);
    }

    public DynamicObjectCollection getViewByDimensionId(long modelId, long dimensionId) {
        return QueryServiceHelper.query((String)"eb_dimensionview", (String)"id,name,number,source", (QFilter[])new QFilter("model", "=", (Object)modelId).and("dimension", "=", (Object)dimensionId).toArray());
    }

    public Map<Long, List<DimensionView>> getViewByModelId(long modelId) {
        DynamicObjectCollection views = QueryServiceHelper.query((String)"eb_dimensionview", (String)"id,name,number,source,dimension.id", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray());
        return views.stream().map(x -> {
            DimensionView dimensionView = new DimensionView();
            dimensionView.setId(x.getLong("id"));
            dimensionView.setName(x.getString("name"));
            dimensionView.setNumber(x.getString("number"));
            dimensionView.setSource(x.getInt("source"));
            dimensionView.setDimensionId(x.getLong("dimension.id"));
            return dimensionView;
        }).collect(Collectors.groupingBy(x -> x.getDimensionId()));
    }

    public Set<Long> getViewsByViewId(long viewId) {
        return ViewGroupServiceHelper.getInstance().getViewsByViewId(viewId);
    }

    public boolean isCrossGroup(String sourceViewId, Long targetViewId) {
        if (StringUtils.isEmpty((String)sourceViewId)) {
            return false;
        }
        if (this.isOrganization(sourceViewId)) {
            return false;
        }
        Set<Long> targetViews = ViewGroupManager.getInstance().getViewsByViewId(targetViewId);
        return !targetViews.contains(Long.parseLong(sourceViewId));
    }

    public boolean isOrganization(String sourceViewId) {
        return StringUtils.equals((String)sourceViewId, (String)"01") || StringUtils.equals((String)sourceViewId, (String)"15") || StringUtils.equals((String)sourceViewId, (String)"02");
    }

    public Set<Long> getViewGroupIdByViewId(long viewId) {
        return ViewGroupServiceHelper.getInstance().getViewGroupIdByViewId(viewId);
    }

    public void initDefaultView(DimensionView dimensionView) {
        Long defaultview;
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)dimensionView.getViewGroupId(), (String)EB_DIMENSIONVIEW_GROUP);
        String type = dynamicObject.getString("type");
        if ("2".equals(type)) {
            long parent = dynamicObject.getLong("parent.id");
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)parent, (String)EB_DIMENSIONVIEW_GROUP);
        }
        if ((defaultview = Long.valueOf(dynamicObject.getLong("defaultview.id"))) != null && defaultview != 0L) {
            return;
        }
        CubeUtils.updateDimensionVersion((Long)dimensionView.getModelId(), (Long)dimensionView.getDimensionId());
        dynamicObject.set("defaultview", (Object)dimensionView.getId());
        SaveServiceHelper.update((DynamicObject)dynamicObject);
    }
}

