/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.service.view;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.cache.DimMembPermVerHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.entity.property.CustomPropertyUtils;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.enums.dimensionEnums.ViewMemberSourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.eventbus.EventBusUtil;
import kd.epm.eb.common.eventbus.event.FactoryChangeEvent;
import kd.epm.eb.common.permission.MembPermRecordUtil;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.domain.ShrekConfig;
import kd.epm.eb.common.shrek.service.ShrekConfigServiceHelper;
import kd.epm.eb.common.utils.BizRequire;
import kd.epm.eb.common.utils.Builder;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.CommonCheckUtil;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.DateTimeUtils;
import kd.epm.eb.common.utils.DynamicObjectUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.base.BeanCopyUtils;
import kd.epm.eb.olap.service.view.ViewGroupManager;
import kd.epm.eb.olap.service.view.bean.DimensionViewMember;
import kd.epm.eb.olap.service.view.context.SaveMemberContext;
import kd.epm.eb.olap.service.view.valid.MemberValidator;
import kd.epm.eb.olap.service.view.valid.ValidResult;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ViewMemberManager {
    private static final Log log = LogFactory.getLog(ViewMemberManager.class);

    private ViewMemberManager() {
    }

    public static ViewMemberManager getInstance() {
        return Singleton.INSTANCE.instance;
    }

    public void insertViewAndDimMember(long modelId, String dimNumber, Long viewId, List<DimensionViewMember> newMembers) {
        if (newMembers.isEmpty()) {
            return;
        }
        DynamicObject viewDy = BusinessDataServiceHelper.loadSingle((Object)viewId, (String)"eb_dimensionview");
        BizRequire.notNull((Object)viewDy, (String)ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u89c6\u56fe\u3002", (String)"ViewMemberManager_3", (String)"epm-eb-olap", (Object[])new Object[0]));
        Set distinctSet = newMembers.stream().map(DimensionViewMember::getShowNumber).collect(Collectors.toSet());
        BizRequire.isTrue((distinctSet.size() == newMembers.size() ? 1 : 0) != 0, (String)ResManager.loadKDString((String)"\u663e\u793a\u7f16\u7801\u4e0d\u80fd\u91cd\u590d\u3002", (String)"ViewMemberManager_4", (String)"epm-eb-olap", (Object[])new Object[0]));
        distinctSet = newMembers.stream().map(DimensionViewMember::getNumber).collect(Collectors.toSet());
        BizRequire.isTrue((distinctSet.size() == newMembers.size() ? 1 : 0) != 0, (String)ResManager.loadKDString((String)"\u5185\u7801\u4e0d\u80fd\u91cd\u590d\u3002", (String)"ViewMemberManager_5", (String)"epm-eb-olap", (Object[])new Object[0]));
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Dimension dimension = modelCache.getDimension(dimNumber);
        SaveMemberContext ctx = new SaveMemberContext(modelCache, dimNumber, dimension.getMemberModel(), dimension.getMemberTable(), viewId);
        MemberValidator validator = MemberValidator.getValidator(modelCache, dimNumber, viewId);
        for (DimensionViewMember viewMember : newMembers) {
            ValidResult<String> validResult = validator.valid(viewMember);
            BizRequire.isTrue((boolean)validResult.ok(), (String)validResult.getErrMsg());
        }
        String viewMembersource = newMembers.get(0).getViewMembersource();
        if (StringUtils.equals((CharSequence)viewMembersource, (CharSequence)ViewMemberSourceEnum.ADD.getIndex()) || StringUtils.equals((CharSequence)viewMembersource, (CharSequence)ViewMemberSourceEnum.OUTER_REF.getIndex())) {
            Set<Object> viewIds = Sets.newLinkedHashSet();
            if (StringUtils.equals((CharSequence)viewMembersource, (CharSequence)ViewMemberSourceEnum.ADD.getIndex())) {
                viewIds = ViewGroupManager.getInstance().getViewByDimensionId(modelId, dimension.getId()).stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            } else if (StringUtils.equals((CharSequence)viewMembersource, (CharSequence)ViewMemberSourceEnum.OUTER_REF.getIndex())) {
                viewIds = ViewGroupManager.getInstance().getViewsByViewId(viewId);
            }
            viewIds.removeIf(e -> e.equals(viewDy.getLong("id")));
            QFBuilder builder = new QFBuilder();
            builder.add(new QFilter("model", "=", (Object)modelId));
            builder.add(new QFilter("view", "in", (Object)viewIds));
            builder.add(new QFilter("dimension", "=", (Object)dimension.getId()));
            builder.add(new QFilter("number", "in", newMembers.stream().map(DimensionViewMember::getNumber).collect(Collectors.toSet())));
            DynamicObject existObj = QueryServiceHelper.queryOne((String)"eb_viewmember", (String)"id,number,name,view.name", (QFilter[])builder.toArray());
            if (existObj != null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u6210\u5458\u3010%1\u3011\u5728\u89c6\u56fe\u3010%2\u3011\u4e2d\u5b58\u5728\uff0c\u8bf7\u4ece\u6210\u5458\u6240\u5728\u89c6\u56fe\u3010%3\u3011\u4e2d\u5bfc\u5165\u3002", (String)"ViewMemberManager_6", (String)"epm-eb-olap", (Object[])new Object[]{existObj.getString("number"), existObj.getString("view.name"), existObj.getString("view.name")}));
            }
        }
        ArrayList dimMembers = Lists.newArrayListWithCapacity((int)newMembers.size());
        ArrayList viewMembers = Lists.newArrayListWithCapacity((int)newMembers.size());
        for (DimensionViewMember saveMember : newMembers) {
            if (!validator.getDbDimMemberMap().containsKey(saveMember.getNumber())) {
                DynamicObject dimMember = this.buiDimMember(saveMember, ctx);
                dimMembers.add(dimMember);
            }
            DynamicObject viewMember = this.buiViewMember(saveMember, null, ctx);
            viewMembers.add(viewMember);
        }
        Set ids = viewMembers.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        List topMembers = viewMembers.stream().filter(e -> !ids.contains(e.getLong("parent"))).collect(Collectors.toList());
        HashMap parentDeqMap = Maps.newHashMapWithExpectedSize((int)1);
        for (DynamicObject topMember : topMembers) {
            long parentId = topMember.getLong("parent");
            Integer curMax = parentDeqMap.computeIfAbsent(parentId, v -> this.getMaxDSeq(parentId, "eb_viewmember", viewId));
            curMax = curMax + 1;
            topMember.set("dseq", (Object)curMax);
            parentDeqMap.put(parentId, curMax);
        }
        List<DynamicObject> newRefMembers = this.newRefMember(newMembers, viewDy, null, dimension, ctx);
        if (!newRefMembers.isEmpty()) {
            Set newRefMemberId = newRefMembers.stream().map(e -> e.getLong("memberid")).collect(Collectors.toSet());
            Set refViewid = newRefMembers.stream().map(e -> e.getLong("view")).collect(Collectors.toSet());
            QFBuilder builder = new QFBuilder();
            builder.add(new QFilter("model", "=", (Object)modelId));
            builder.add(new QFilter("view", "in", refViewid));
            builder.add(new QFilter("dimension", "=", (Object)dimension.getId()));
            builder.add(new QFilter("memberid", "in", newRefMemberId));
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"eb_viewmember", (String)"number", (QFilter[])builder.toArray(), null);){
                if (ds.hasNext()) {
                    Row row = ds.next();
                    throw new KDBizException(ResManager.loadResFormat((String)"\u5bfc\u5165\u7684\u89c6\u56fe\u6210\u5458\u3010%1\u3011\u5b58\u5728\u5faa\u73af\u5f15\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ViewMemberManager_18", (String)"epm-eb-olap", (Object[])new Object[]{row.getString("number")}));
                }
            }
        }
        boolean isSyncOlap = false;
        try (TXHandle tx = TX.required((String)"insert bgmd Member");){
            try {
                DynamicObjectUtils.save((List)dimMembers);
                DynamicObjectUtils.save((List)viewMembers);
                for (DynamicObject topMember : topMembers) {
                    this.updateParentViewMember(Collections.singleton(topMember));
                }
                if (!newRefMembers.isEmpty()) {
                    DynamicObjectUtils.save(newRefMembers);
                    Set refIds = newRefMembers.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
                    List refTopMembers = newRefMembers.stream().filter(e -> !refIds.contains(e.getLong("parent"))).collect(Collectors.toList());
                    for (DynamicObject topMember : refTopMembers) {
                        this.updateParentViewMember(Collections.singleton(topMember));
                    }
                }
                MemberPropCacheService.updateVersion((Long)modelId, (Long)dimension.getId());
                DimMembPermVerHelper.updateVer4MembChanged((Long)viewId, (Long)modelId, (Long)dimension.getId(), (String)"afterInsertViewAndDimMember");
                CubeUtils.clearCentralizedCache((Long)modelId, (Long)dimension.getId());
                this.syncOlapData(ctx);
                isSyncOlap = true;
            }
            catch (Throwable e2) {
                log.error("\u6210\u5458\u5bfc\u5165\u5931\u8d25", e2);
                tx.markRollback();
                throw new KDBizException(e2.getMessage());
            }
            finally {
                if (!isSyncOlap) {
                    CubeUtils.updateDimensionVersion((Long)modelId, (Long)dimension.getId());
                }
            }
        }
    }

    public void syncViewMemberDeq(long modelId, String dimNumber, long viewId, DynamicObject srcParent) {
        Set<Long> groupViewIds = ViewGroupManager.getInstance().getViewsByViewId(viewId);
        groupViewIds.removeIf(e -> e.equals(viewId));
        if (groupViewIds.isEmpty()) {
            return;
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Dimension dimension = modelCache.getDimension(dimNumber);
        QFBuilder builder = new QFBuilder(new QFilter("model", "=", (Object)modelId));
        builder.add(new QFilter("view", "in", groupViewIds));
        builder.add(new QFilter("dimension", "=", (Object)dimension.getId()));
        builder.add(new QFilter("memberid", "=", (Object)srcParent.getLong("memberid")));
        builder.add(new QFilter("membersource", "=", (Object)ViewMemberSourceEnum.INNER_REF.getIndex()));
        DynamicObjectCollection tarParentList = QueryServiceHelper.query((String)"eb_viewmember", (String)"id,memberid,view.id", (QFilter[])builder.toArray());
        if (tarParentList.isEmpty()) {
            return;
        }
        Map<Long, Integer> srcMemberMap = QueryServiceHelper.query((String)"eb_viewmember", (String)"id,memberid,dseq", (QFilter[])new QFilter[]{new QFilter("parent.id", "=", (Object)srcParent.getLong("id"))}).stream().collect(Collectors.toMap(e -> e.getLong("memberid"), e -> e.getInt("dseq"), (v1, v2) -> v1));
        DynamicObjectCollection tarChildren = QueryServiceHelper.query((String)"eb_viewmember", (String)"id,memberid,dseq,view.id", (QFilter[])new QFilter[]{new QFilter("parent.id", "in", tarParentList.stream().map(e -> e.getLong("id")).collect(Collectors.toSet()))});
        ArrayList<Object[]> params = new ArrayList<Object[]>(tarChildren.size());
        for (DynamicObject tarChild : tarChildren) {
            long tarMemberId = tarChild.getLong("memberId");
            Integer srcSeq = srcMemberMap.get(tarMemberId);
            if (srcSeq == null) continue;
            params.add(new Object[]{srcSeq, tarChild.getLong("id")});
        }
        if (!params.isEmpty()) {
            String sql = "update t_eb_viewmember set fdseq=? where fid=?";
            DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)sql, params);
        }
    }

    public void syncViewMember(long modelId, String dimNumber, long viewId, Set<Long> modViewMemberIds) {
        DynamicObject srcViewDy = BusinessDataServiceHelper.loadSingle((Object)viewId, (String)"eb_dimensionview");
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Dimension dimension = modelCache.getDimension(dimNumber);
        SaveMemberContext ctx = new SaveMemberContext(modelCache, dimNumber, dimension.getMemberModel(), dimension.getMemberTable(), viewId);
        Set<Long> groupViewIds = ViewGroupManager.getInstance().getViewsByViewId(srcViewDy.getLong("id"));
        groupViewIds.removeIf(e -> e.equals(srcViewDy.getLong("id")));
        if (groupViewIds.isEmpty()) {
            return;
        }
        QFBuilder qfMy = new QFBuilder(new QFilter("view", "=", (Object)viewId));
        qfMy.add(new QFilter("model", "=", (Object)modelId));
        qfMy.add(new QFilter("dimension", "=", (Object)dimension.getId()));
        String selectFields = "id,longnumber,memberid,membersource,view.id,parent.id,parent.memberid,isoffsetentry,mergernode,disable,shownumber,name,simplename,aggoprt";
        List myMembers = Arrays.stream(BusinessDataServiceHelper.load((String)"eb_viewmember", (String)selectFields, (QFilter[])qfMy.toArray())).collect(Collectors.toList());
        QFBuilder qfOther = new QFBuilder(new QFilter("model", "=", (Object)modelId));
        qfOther.add(new QFilter("view", "in", groupViewIds));
        qfOther.add(new QFilter("dimension", "=", (Object)dimension.getId()));
        qfOther.add(new QFilter("membersource", "=", (Object)ViewMemberSourceEnum.INNER_REF.getIndex()));
        qfOther.add(new QFilter("memberid", "in", myMembers.stream().map(e -> e.getLong("memberid")).collect(Collectors.toSet())));
        DynamicObjectCollection otherMembers = QueryServiceHelper.query((String)"eb_viewmember", (String)"id,shownumber,longnumber,memberid,view.id,parent.id,parent.memberid,membersource,aggoprt,showchildren,showself,dseq", (QFilter[])qfOther.toArray());
        if (otherMembers.isEmpty()) {
            return;
        }
        List myPairMembers = myMembers.stream().map(e -> Pair.of((Object)e.getLong("memberid"), (Object)e.getLong("parent.memberid"))).collect(Collectors.toList());
        boolean isSyncOlap = false;
        try (TXHandle tx = TX.required((String)"syncViewMember");){
            try {
                Map<Long, List<DynamicObject>> otherViewGroup = otherMembers.stream().collect(Collectors.groupingBy(e -> e.getLong("view.id")));
                otherViewGroup.forEach((otherViewId, otherViewMembers) -> {
                    ArrayList allSyncSrcTopMembers = Lists.newArrayList();
                    HashSet delVmIds = Sets.newHashSet();
                    Set ids = otherViewMembers.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
                    List<DynamicObject> otherTopMembers = otherViewMembers.stream().filter(e -> !ids.contains(e.getLong("parent.id"))).collect(Collectors.toList());
                    ArrayList removeTops = Lists.newArrayListWithCapacity((int)1);
                    Set otherTopSet = otherTopMembers.stream().map(e -> e.getLong("memberid")).collect(Collectors.toSet());
                    otherTopMembers.forEach(otherTop -> {
                        for (Long topId : otherTopSet) {
                            Set<Long> children;
                            if (topId.equals(otherTop.getLong("memberid")) || !(children = this.findChildren(topId, myPairMembers)).contains(otherTop.getLong("memberid"))) continue;
                            removeTops.add(otherTop);
                        }
                    });
                    if (!removeTops.isEmpty()) {
                        Map<Long, Set<Long>> delIdMap = this.deleteMemberByParent(modelId, dimension, removeTops, true);
                        Set delIds = delIdMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
                        delVmIds.addAll(delIds);
                    }
                    this.getSyncMembers(otherTopMembers, dimension, ctx, myMembers, (List<DynamicObject>)otherViewMembers, allSyncSrcTopMembers, delVmIds, srcViewDy, modViewMemberIds);
                    Set topMemberIds = allSyncSrcTopMembers.stream().map(e -> e.getLong("memberid")).collect(Collectors.toSet());
                    QFBuilder qfMyTop = new QFBuilder(new QFilter("model", "=", (Object)modelId));
                    qfMyTop.add(new QFilter("view", "=", (Object)viewId));
                    qfMyTop.add(new QFilter("dimension", "=", (Object)dimension.getId()));
                    qfMyTop.add(new QFilter("memberid", "in", topMemberIds));
                    DynamicObjectCollection srcTops = QueryServiceHelper.query((String)"eb_viewmember", (String)"id,longnumber,memberid,view.id,parent.id", (QFilter[])qfMyTop.toArray());
                    for (DynamicObject srcTop : srcTops) {
                        List<DimensionViewMember> srcChildren = this.getViewMemberAllChildren(srcTop.getLong("id"), srcTop.getString("longnumber"), viewId, modelId, dimension.getId(), true);
                        List<DynamicObject> newChildren = this.newRefMember(srcChildren, srcViewDy, Sets.newHashSet((Object[])new Long[]{otherViewId}), dimension, ctx);
                        Map<Long, DynamicObject> delMap = otherViewMembers.stream().filter(e -> delVmIds.contains(e.getLong("id"))).collect(Collectors.toMap(e -> e.getLong("memberid"), e -> e));
                        newChildren.forEach(newObj -> {
                            DynamicObject delObj = (DynamicObject)delMap.get(newObj.getLong("memberid"));
                            if (delObj != null) {
                                newObj.set("shownumber", (Object)delObj.getString("shownumber"));
                                newObj.set("aggoprt", (Object)delObj.getString("aggoprt"));
                                newObj.set("showchildren", (Object)delObj.getString("showchildren"));
                                newObj.set("showself", (Object)delObj.getString("showself"));
                                newObj.set("dseq", (Object)delObj.getString("dseq"));
                            }
                        });
                        if (newChildren.isEmpty()) continue;
                        DynamicObjectUtils.save(newChildren);
                        Set refIds = newChildren.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
                        List refTopMembers = newChildren.stream().filter(e -> !refIds.contains(e.getLong("parent"))).collect(Collectors.toList());
                        for (DynamicObject topMember : refTopMembers) {
                            this.updateParentViewMember(Collections.singleton(topMember));
                        }
                    }
                });
                this.syncOlapData(ctx);
                isSyncOlap = true;
            }
            catch (Throwable e2) {
                log.error("\u540c\u6b65\u65b0\u589e\u6210\u5458\u5230\u5176\u5b83\u89c6\u56fe\u5931\u8d25", e2);
                tx.markRollback();
                throw new KDBizException(e2.getMessage());
            }
            finally {
                if (!isSyncOlap) {
                    CubeUtils.updateDimensionVersion((Long)modelId, (Long)dimension.getId());
                }
            }
        }
    }

    private Set<Long> findChildren(long parentId, List<Pair<Long, Long>> myMembers) {
        HashSet children = Sets.newHashSetWithExpectedSize((int)10);
        LinkedList parentList = Lists.newLinkedList();
        parentList.addAll(myMembers.stream().filter(e -> ((Long)e.getLeft()).equals(parentId)).map(Pair::getLeft).collect(Collectors.toList()));
        while (!parentList.isEmpty()) {
            Long currParentId = (Long)parentList.poll();
            children.add(currParentId);
            parentList.addAll(myMembers.stream().filter(e -> ((Long)e.getRight()).equals(currParentId)).map(Pair::getLeft).collect(Collectors.toList()));
        }
        return children;
    }

    private void getSyncMembers(List<DynamicObject> otherTopMembers, Dimension dimension, SaveMemberContext ctx, List<DynamicObject> myMembers, List<DynamicObject> otherViewMembers, List<DynamicObject> allSyncSrcTopMembers, Set<Long> delVmIds, DynamicObject srcViewDy, Set<Long> modViewMemberIds) {
        Long modelId = ctx.getModelCache().getModelobj().getId();
        for (DynamicObject otherTopMember : otherTopMembers) {
            Set sameMemberIdSet;
            Sets.SetView srcDiff;
            List tarChildren = otherViewMembers.stream().filter(e -> e.getLong("parent.id") == otherTopMember.getLong("id")).collect(Collectors.toList());
            Set tarMemberIdSet = tarChildren.stream().map(e -> e.getLong("memberid")).collect(Collectors.toSet());
            DynamicObject myTopMember = myMembers.stream().filter(e -> e.getLong("memberid") == otherTopMember.getLong("memberid")).findFirst().get();
            List srcChildren = myMembers.stream().filter(e -> e.getLong("parent.id") == myTopMember.getLong("id")).collect(Collectors.toList());
            Set srcMemberIdSet = srcChildren.stream().map(e -> e.getLong("memberid")).collect(Collectors.toSet());
            Sets.SetView tarDiff = Sets.difference(tarMemberIdSet, srcMemberIdSet);
            if (!tarDiff.isEmpty()) {
                List<DynamicObject> tarDelMembers = tarChildren.stream().filter(e -> tarDiff.contains((Object)e.getLong("memberid"))).collect(Collectors.toList());
                Map<Long, Set<Long>> delIdMap = this.deleteMemberByParent(modelId, dimension, tarDelMembers, true);
                Set delIds = delIdMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
                delVmIds.addAll(delIds);
            }
            if (!(srcDiff = Sets.difference(srcMemberIdSet, tarMemberIdSet)).isEmpty()) {
                List srcTopChildren = srcChildren.stream().filter(e -> srcDiff.contains((Object)e.getLong("memberid"))).collect(Collectors.toList());
                allSyncSrcTopMembers.addAll(srcTopChildren);
            }
            if ((sameMemberIdSet = srcMemberIdSet.stream().filter(tarMemberIdSet::contains).collect(Collectors.toSet())).isEmpty()) continue;
            if (CollectionUtils.isNotEmpty(modViewMemberIds)) {
                Set upMemberIds = sameMemberIdSet.stream().filter(modViewMemberIds::contains).collect(Collectors.toSet());
                List<DynamicObject> srcSameChildren = srcChildren.stream().filter(e -> upMemberIds.contains(e.getLong("memberid"))).collect(Collectors.toList());
                this.syncUpdateRefMemberInfo(srcSameChildren, srcViewDy, dimension, ctx.getModelCache());
            }
            List<DynamicObject> sameChildren = tarChildren.stream().filter(e -> sameMemberIdSet.contains(e.getLong("memberid"))).collect(Collectors.toList());
            this.getSyncMembers(sameChildren, dimension, ctx, myMembers, otherViewMembers, allSyncSrcTopMembers, delVmIds, srcViewDy, modViewMemberIds);
        }
    }

    public void delViewMemberToRawView(long modelId, String dimNumber, Long viewId, long memberId) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Dimension dimension = modelCache.getDimension(dimNumber);
        QFBuilder qf = new QFBuilder();
        qf.add(new QFilter("model", "=", (Object)modelId));
        qf.add(new QFilter("dimension", "=", (Object)dimension.getId()));
        qf.add(new QFilter("memberid", "=", (Object)memberId));
        qf.add(new QFilter("membersource", "<>", (Object)ViewMemberSourceEnum.INNER_REF.getIndex()));
        DynamicObject rawViewMember = QueryServiceHelper.queryOne((String)"eb_viewmember", (String)"id,view.id,parent.id", (QFilter[])qf.toArray());
        if (rawViewMember != null) {
            DynamicObject rawParent = BusinessDataServiceHelper.loadSingle((Object)rawViewMember.getLong("parent.id"), (String)"eb_viewmember");
            DynamicObject rawView = BusinessDataServiceHelper.loadSingle((Object)rawViewMember.getLong("view.id"), (String)"eb_dimensionview");
            DynamicObjectCollection relViewMembers = this.getViewMemberByMemberId(Collections.singleton(memberId), rawView, modelId, dimension.getId());
            DynamicObject old = BusinessDataServiceHelper.loadSingle((Object)rawViewMember.get("id"), (String)"eb_viewmember");
            try (TXHandle tx = TX.required((String)"deleteViewMember");){
                try {
                    DeleteServiceHelper.delete((String)"eb_viewmember", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)old.getLong("id"))});
                    this.deleteRefViewMember(modelId, dimension, rawView, Collections.singleton(old));
                    this.updateViewMemberParent((Collection<DynamicObject>)relViewMembers, modelId, dimension);
                    Set<Long> delMemberIds = this.deleteDimMemberByViewMember(Sets.newHashSet((Object[])new Long[]{memberId}), modelId, dimension);
                    if (!delMemberIds.isEmpty()) {
                        List<String> delMembers = modelCache.getMembers(dimNumber, viewId, new ArrayList<Long>(delMemberIds)).stream().map(e -> e.getNumber()).collect(Collectors.toList());
                        this.delOlapMember(delMembers, dimNumber, modelCache);
                        MemberPropCacheService.updateVersion((Long)modelId, (Long)dimension.getId());
                    }
                }
                catch (Throwable ex) {
                    log.error("delete-member-error:", ex);
                    tx.markRollback();
                    throw new KDBizException(ex.getMessage());
                }
                finally {
                    CubeUtils.updateDimensionVersion((Long)modelId, (Long)dimension.getId());
                }
                Set<Long> memberIds = Collections.singleton(rawParent.getLong("memberid"));
                Long userId = UserUtils.getUserId();
                String traceId = RequestContext.get().getTraceId();
                EventBusUtil.asyncPost((Object)new FactoryChangeEvent(Long.valueOf(modelId), dimension.getId(), viewId, memberIds, userId, traceId));
            }
        }
    }

    public void insertViewMemberToRawView(long modelId, String dimNumber, Long viewId, String parentNumber, List<DimensionViewMember> newMembers) {
        if (newMembers.isEmpty()) {
            return;
        }
        DynamicObject viewDy = BusinessDataServiceHelper.loadSingle((Object)viewId, (String)"eb_dimensionview");
        BizRequire.notNull((Object)viewDy, (String)ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u89c6\u56fe\u3002", (String)"ViewMemberManager_3", (String)"epm-eb-olap", (Object[])new Object[0]));
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Dimension dimension = modelCache.getDimension(dimNumber);
        DynamicObject rawParentDy = this.getRawParent(parentNumber, viewDy, modelCache, dimension);
        viewId = rawParentDy.getLong("view.id");
        Member rawParentMember = modelCache.getMember(dimNumber, viewId, parentNumber);
        ArrayList addMembers = Lists.newArrayListWithExpectedSize((int)newMembers.size());
        int maxDSeq = this.getMaxDSeq(rawParentDy.getLong("id"), "eb_viewmember", viewId);
        for (DimensionViewMember newMember : newMembers) {
            DimensionViewMember vm = (DimensionViewMember)Builder.of(DimensionViewMember::new).with(DimensionViewMember::setNumber, (Object)newMember.getNumber()).with(DimensionViewMember::setParentId, (Object)rawParentDy.getLong("id")).with(DimensionViewMember::setParentMemberId, (Object)rawParentMember.getId()).with(DimensionViewMember::setShowNumber, (Object)newMember.getShowNumber()).with(DimensionViewMember::setName, (Object)newMember.getName()).with(DimensionViewMember::setViewMembersource, (Object)ViewMemberSourceEnum.ADD.getIndex()).with(DimensionViewMember::setLevel, (Object)(rawParentDy.getInt("level") + 1)).with(DimensionViewMember::setLongNumber, (Object)(rawParentDy.getString("longnumber") + "!" + newMember.getNumber())).with(DimensionViewMember::setIsLeaf, (Object)true).with(DimensionViewMember::setView, (Object)viewId).with(DimensionViewMember::setDimension, (Object)dimension.getId()).with(DimensionViewMember::setModel, (Object)modelId).with(DimensionViewMember::setDseq, (Object)(++maxDSeq)).build();
            addMembers.add(vm);
        }
        this.insertViewAndDimMember(modelId, dimNumber, viewId, addMembers);
    }

    private DynamicObject getRawParent(String parentNumber, DynamicObject viewDy, IModelCacheHelper modelCache, Dimension dimension) {
        DynamicObject rawParentDy;
        long modelId = modelCache.getModelobj().getId();
        long viewId = viewDy.getLong("id");
        Member parent = modelCache.getMember(dimension.getNumber(), Long.valueOf(viewId), parentNumber);
        String viewMemberSource = parent.getSource();
        String field = "id,number,longnumber,memberid,level,view.id";
        if (ViewMemberSourceEnum.INNER_REF.getIndex().equals(viewMemberSource)) {
            Set<Long> groupViewIds = ViewGroupManager.getInstance().getViewsByViewId(viewDy.getLong("id"));
            groupViewIds.removeIf(e -> e.equals(viewId));
            QFBuilder qf = new QFBuilder();
            qf.add(new QFilter("model", "=", (Object)modelId));
            qf.add(new QFilter("view", "in", groupViewIds));
            qf.add(new QFilter("dimension", "=", (Object)dimension.getId()));
            qf.add(new QFilter("memberid", "=", (Object)parent.getId()));
            rawParentDy = QueryServiceHelper.queryOne((String)"eb_viewmember", (String)field, (QFilter[])qf.toArray());
            BizRequire.notNull((Object)rawParentDy, (String)ResManager.loadKDString((String)"\u672a\u627e\u5230\u7236\u6210\u5458\u3002", (String)"ViewMemberManager_7", (String)"epm-eb-olap", (Object[])new Object[0]));
        } else {
            QFBuilder qf = new QFBuilder();
            qf.add(new QFilter("model", "=", (Object)modelId));
            qf.add(new QFilter("view", "=", (Object)viewId));
            qf.add(new QFilter("dimension", "=", (Object)dimension.getId()));
            qf.add(new QFilter("memberid", "=", (Object)parent.getId()));
            rawParentDy = QueryServiceHelper.queryOne((String)"eb_viewmember", (String)field, (QFilter[])qf.toArray());
        }
        return rawParentDy;
    }

    public void insertViewMemberToRawView2(long modelId, String dimNumber, Long viewId, List<DimensionViewMember> newMembers) {
        if (newMembers.isEmpty()) {
            return;
        }
        DynamicObject viewDy = BusinessDataServiceHelper.loadSingle((Object)viewId, (String)"eb_dimensionview");
        BizRequire.notNull((Object)viewDy, (String)ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u89c6\u56fe\u3002", (String)"ViewMemberManager_3", (String)"epm-eb-olap", (Object[])new Object[0]));
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Dimension dimension = modelCache.getDimension(dimNumber);
        Set ids = newMembers.stream().map(DimensionViewMember::getMemberId).collect(Collectors.toSet());
        List<DimensionViewMember> topMembers = newMembers.stream().filter(e -> !ids.contains(e.getParentId())).collect(Collectors.toList());
        HashMap topGroup = Maps.newHashMap();
        topMembers.forEach(top -> {
            String topLongNumber = top.getLongNumber();
            List topList = newMembers.stream().filter(e -> e.getLongNumber().startsWith(topLongNumber)).collect(Collectors.toList());
            topGroup.put(top, topList);
        });
        ArrayList allMembers = Lists.newArrayList();
        HashMap parentDeqMap = Maps.newHashMapWithExpectedSize((int)1);
        for (Map.Entry entry : topGroup.entrySet()) {
            DimensionViewMember top2 = (DimensionViewMember)entry.getKey();
            List topList = (List)entry.getValue();
            Set pidSet = topList.stream().map(DimensionViewMember::getParentId).collect(Collectors.toSet());
            DynamicObject parent = BusinessDataServiceHelper.loadSingle((Object)top2.getParentId(), (String)"eb_viewmember");
            DynamicObject rawParentDy = this.getRawParent(parent.getString("number"), viewDy, modelCache, dimension);
            long rawViewId = rawParentDy.getLong("view.id");
            Member rawParentMember = modelCache.getMember(dimNumber, Long.valueOf(rawViewId), rawParentDy.getString("number"));
            int levelDiff = rawParentDy.getInt("level") - parent.getInt("level");
            ArrayList addMembers = Lists.newArrayListWithExpectedSize((int)topList.size());
            for (DimensionViewMember vm : topList) {
                DimensionViewMember newVm = (DimensionViewMember)Builder.of(DimensionViewMember::new).with(DimensionViewMember::setId, (Object)vm.getViewMemberId()).with(DimensionViewMember::setViewMemberId, (Object)vm.getViewMemberId()).with(DimensionViewMember::setParentId, (Object)vm.getParentId()).with(DimensionViewMember::setParentMemberId, (Object)rawParentMember.getId()).with(DimensionViewMember::setNumber, (Object)vm.getNumber()).with(DimensionViewMember::setShowNumber, (Object)vm.getShowNumber()).with(DimensionViewMember::setName, (Object)vm.getName()).with(DimensionViewMember::setViewMembersource, (Object)ViewMemberSourceEnum.ADD.getIndex()).with(DimensionViewMember::setLevel, (Object)(vm.getLevel() + levelDiff)).with(DimensionViewMember::setIsLeaf, (Object)(!pidSet.contains(vm.getId()) ? 1 : 0)).with(DimensionViewMember::setView, (Object)rawViewId).with(DimensionViewMember::setDimension, (Object)dimension.getId()).with(DimensionViewMember::setModel, (Object)modelId).with(DimensionViewMember::setDseq, (Object)vm.getDseq()).build();
                addMembers.add(newVm);
            }
            long rawPid = rawParentDy.getLong("id");
            Integer curMax = parentDeqMap.computeIfAbsent(rawPid, v -> this.getMaxDSeq(rawPid, "eb_viewmember", rawViewId));
            curMax = curMax + 1;
            top2.setDseq(curMax);
            parentDeqMap.put(rawPid, curMax);
            HashMap longNumberMap = Maps.newHashMap();
            top2.setParentId(rawPid);
            top2.setLongNumber(rawParentDy.getString("longnumber") + "!" + top2.getNumber());
            longNumberMap.put(top2.getId(), top2.getLongNumber());
            Integer minLevel = topList.stream().map(DimensionViewMember::getLevel).min(Integer::compareTo).get();
            Integer maxLevel = topList.stream().map(DimensionViewMember::getLevel).max(Integer::compareTo).get();
            Integer curLevel = minLevel = Integer.valueOf(minLevel + 1);
            while (curLevel <= maxLevel) {
                Integer finalCurLevel = curLevel;
                List<DimensionViewMember> levelChildren = topList.stream().filter(e -> e.getLevel() == finalCurLevel.intValue()).collect(Collectors.toList());
                levelChildren.forEach(e -> {
                    e.setLongNumber((String)longNumberMap.get(e.getParentId()) + "!" + e.getNumber());
                    longNumberMap.put(e.getId(), e.getLongNumber());
                });
                Integer n = curLevel;
                Integer n2 = curLevel = Integer.valueOf(curLevel + 1);
            }
            allMembers.addAll(addMembers);
        }
        this.insertViewAndDimMember(modelId, dimNumber, viewId, allMembers);
    }

    public void saveViewMemberOnly(long modelId, String dimNumber, Long viewId, DimensionViewMember inputMember) {
        DynamicObject viewDy = BusinessDataServiceHelper.loadSingle((Object)viewId, (String)"eb_dimensionview");
        BizRequire.notNull((Object)viewDy, (String)ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u89c6\u56fe\u3002", (String)"ViewMemberManager_3", (String)"epm-eb-olap", (Object[])new Object[0]));
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Dimension dimension = modelCache.getDimension(dimNumber);
        SaveMemberContext ctx = new SaveMemberContext(modelCache, dimNumber, dimension.getMemberModel(), dimension.getMemberTable(), viewId);
        MemberValidator validator = MemberValidator.getValidator(modelCache, dimNumber, viewId);
        validator.setSingleDbCheck(true);
        ValidResult<String> validResult = validator.valid(inputMember);
        BizRequire.isTrue((boolean)validResult.ok(), (String)validResult.getErrMsg());
        DynamicObject dbViewMemberObj = null;
        boolean isUpdate = false;
        if (inputMember.getViewMemberId() != null && QueryServiceHelper.exists((String)"eb_viewmember", (Object)inputMember.getViewMemberId())) {
            dbViewMemberObj = BusinessDataServiceHelper.loadSingle((Object)inputMember.getViewMemberId(), (String)"eb_viewmember");
            isUpdate = true;
        }
        boolean needSyncOlapMeta = true;
        if (isUpdate) {
            long dbPid = dbViewMemberObj.getLong("parent.id");
            String dbAgg = dbViewMemberObj.getString("aggoprt");
            boolean dbIsLeaf = dbViewMemberObj.getBoolean("isleaf");
            if (dbPid == inputMember.getParentId() && dbAgg.equals(inputMember.getAggoprt()) && dbIsLeaf == inputMember.getIsLeaf()) {
                needSyncOlapMeta = false;
            }
        }
        DynamicObject saveObj = this.buiViewMember(inputMember, dbViewMemberObj, ctx);
        List<DynamicObject> newRefMembers = this.newRefMember(inputMember, saveObj, dbViewMemberObj, viewDy, dimension, ctx);
        List<DimensionViewMember> children = this.getViewMemberAllChildren(inputMember.getViewMemberId(), inputMember.getLongNumber(), viewId, modelId, ctx.getModelCache().getDimension(dimNumber).getId(), false);
        boolean hasSyncOlap = false;
        try (TXHandle tx = TX.required((String)"save bgmd ViewMember");){
            try {
                DynamicObjectUtils.save((List)Lists.newArrayList((Object[])new DynamicObject[]{saveObj}));
                this.updateParentViewMember(Collections.singleton(saveObj));
                boolean disable = saveObj.getBoolean("disable");
                if (!disable) {
                    DynamicObject parent = BusinessDataServiceHelper.loadSingle((Object)inputMember.getParentId(), (String)"eb_viewmember");
                    BizRequire.isFalse((boolean)parent.getBoolean("disable"), (String)ResManager.loadKDString((String)"\u5f53\u524d\u6210\u5458\u65e0\u6cd5\u542f\u7528\uff0c\u56e0\u4e3a\u4e0a\u7ea7\u6210\u5458\u5df2\u88ab\u7981\u7528\u3002", (String)"ViewMemberManager_8", (String)"epm-eb-olap", (Object[])new Object[0]));
                }
                this.updateViewMemberDisableOrEnable(Sets.newHashSet((Object[])new Long[]{saveObj.getLong("memberid")}), disable, modelId, dimNumber, viewId);
                if (!newRefMembers.isEmpty()) {
                    DynamicObjectUtils.save(newRefMembers);
                    this.updateParentViewMember(newRefMembers);
                }
                this.syncUpdateRefMemberInfo(Collections.singleton(saveObj), viewDy, dimension, modelCache);
                this.updateChildrenShowStatus(saveObj, dbViewMemberObj, children);
                if (needSyncOlapMeta) {
                    this.syncOlapData(ctx);
                }
                hasSyncOlap = true;
            }
            catch (Throwable e) {
                tx.markRollback();
                log.error(e.getMessage(), e);
                throw new KDBizException(e.getMessage());
            }
            finally {
                if (needSyncOlapMeta && !hasSyncOlap) {
                    CubeUtils.updateDimensionVersion((Long)modelId, (Long)dimension.getId());
                }
            }
        }
    }

    public List<DynamicObject> queryViewMemberByNumber(long modelId, String dimNumber, Long viewId, List<String> numbers, String selectFields) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Dimension dimension = modelCache.getDimension(dimNumber);
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)modelId));
        builder.add(new QFilter("view", "=", (Object)viewId));
        builder.add(new QFilter("dimension", "=", (Object)dimension.getId()));
        builder.add(new QFilter("number", "in", numbers));
        if (StringUtils.isBlank((CharSequence)selectFields)) {
            selectFields = "id,number,name,isleaf,level,parent,view,modifydate,longnumber,dseq,memberid,dimension,shownumber";
        }
        return QueryServiceHelper.query((String)"eb_viewmember", (String)selectFields, (QFilter[])builder.toArray());
    }

    public Set<String> deleteViewMember(long modelId, String dimNumber, Long viewId, Long viewMemberId) {
        boolean allOutRef;
        DynamicObject viewDy = BusinessDataServiceHelper.loadSingle((Object)viewId, (String)"eb_dimensionview");
        BizRequire.notNull((Object)viewDy, (String)ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u89c6\u56fe\u3002", (String)"ViewMemberManager_3", (String)"epm-eb-olap", (Object[])new Object[0]));
        DimensionViewMember dbViewMember = this.getViewMember(modelId, viewId, viewMemberId);
        BizRequire.isTrue((dbViewMember.getLevel() > 1 ? 1 : 0) != 0, (String)ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u89c6\u56fe\u6210\u5458\u7684\u6839\u8282\u70b9\u3002", (String)"ViewMemberManager_9", (String)"epm-eb-olap", (Object[])new Object[0]));
        BizRequire.isFalse((boolean)ViewMemberSourceEnum.PRESET.getIndex().equals(dbViewMember.getViewMembersource()), (String)ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u9884\u7f6e\u6210\u5458\u3002", (String)"ViewMemberManager_10", (String)"epm-eb-olap", (Object[])new Object[0]));
        DynamicObject parent = BusinessDataServiceHelper.loadSingle((Object)dbViewMember.getParentId(), (String)"eb_viewmember");
        if (ViewMemberSourceEnum.INNER_REF.getIndex().equals(parent.getString("membersource"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u6539\u53d8\u5f15\u7528\u6210\u5458\u7684\u5c42\u7ea7\u7ed3\u6784\u3002", (String)"ViewMemberManager_11", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Dimension dimension = modelCache.getDimension(dimNumber);
        List<DimensionViewMember> children = this.getViewMemberAllChildren(dbViewMember.getViewMemberId(), dbViewMember.getLongNumber(), viewId, modelId, dimension.getId(), false);
        Set vmDelIds = children.stream().map(DimensionViewMember::getViewMemberId).collect(Collectors.toSet());
        Set<Long> mDelIds = children.stream().map(DimensionViewMember::getMemberId).collect(Collectors.toSet());
        vmDelIds.add(viewMemberId);
        mDelIds.add(dbViewMember.getMemberId());
        Set<Long> srcMemberId = children.stream().filter(e -> ViewMemberSourceEnum.ADD.getIndex().equals(e.getViewMembersource())).map(DimensionViewMember::getMemberId).collect(Collectors.toSet());
        if (ViewMemberSourceEnum.ADD.getIndex().equals(dbViewMember.getViewMembersource())) {
            srcMemberId.add(dbViewMember.getMemberId());
        }
        Set<Long> viewIds = ViewGroupManager.getInstance().getViewByDimensionId(modelId, dimension.getId()).stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        this.validRefMember(modelId, dimension, srcMemberId, viewIds);
        boolean bl = allOutRef = ViewMemberSourceEnum.OUTER_REF.getIndex().equals(dbViewMember.getViewMembersource()) && (children.isEmpty() || children.stream().allMatch(e -> ViewMemberSourceEnum.OUTER_REF.getIndex().equals(e.getViewMembersource())));
        if (allOutRef) {
            Set<Long> groupViewIds = ViewGroupManager.getInstance().getViewsByViewId(viewId);
            groupViewIds.removeIf(e -> e.equals(viewId));
            srcMemberId = children.stream().map(DimensionViewMember::getMemberId).collect(Collectors.toSet());
            srcMemberId.add(dbViewMember.getMemberId());
            this.validRefMember(modelId, dimension, srcMemberId, groupViewIds);
        }
        HashMap optMap = Maps.newHashMap();
        optMap.put("checkChild", true);
        optMap.put("excludeViewMember", true);
        optMap.put("viewId", viewId);
        if (ViewMemberSourceEnum.INNER_REF.getIndex().equals(parent.getString("membersource"))) {
            optMap.put("dataCheck", false);
            optMap.put("onlyCurrView", true);
        }
        Pair pair = (Pair)DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"checkQuoteResult", (Object[])new Object[]{modelId, dimension.getId(), dbViewMember.getMemberId(), MemberTypeEnum.MEMBER, optMap});
        BizRequire.isFalse((boolean)((Boolean)pair.getLeft()), (String)((String)pair.getRight()));
        HashSet delSet = Sets.newHashSetWithExpectedSize((int)(children.size() + 1));
        delSet.add(dbViewMember.getNumber());
        delSet.addAll(children.stream().map(DimensionViewMember::getNumber).collect(Collectors.toSet()));
        DynamicObjectCollection relViewMembers = this.getViewMemberByMemberId(Collections.singleton(dbViewMember.getMemberId()), viewDy, modelId, dimension.getId());
        LogStats stats = new LogStats("budget-log : ");
        stats.addInfo("begin-delete-viewMember.");
        try (TXHandle tx = TX.required((String)"deleteViewMember");){
            try {
                DeleteServiceHelper.delete((String)"eb_viewmember", (QFilter[])new QFilter[]{new QFilter("id", "in", vmDelIds)});
                stats.add("over-delete-viewMember.");
                this.updateViewMemberParent((Collection<DynamicObject>)relViewMembers, modelId, dimension);
                stats.add("over-update-parent-leaf.");
                Set<Long> delMemberIds = this.deleteDimMemberByViewMember(mDelIds, modelId, dimension);
                MembPermRecordUtil.delDetailRecordByMembIds((Long)modelId, (Long)dimension.getId(), (Collection)Sets.newHashSet((Object[])new Long[]{viewId}), mDelIds);
                stats.add("over-delete-member-permission.");
                if (!delMemberIds.isEmpty()) {
                    List<String> delMembers = modelCache.getMembers(dimNumber, viewId, new ArrayList<Long>(delMemberIds)).stream().map(e -> e.getNumber()).collect(Collectors.toList());
                    this.delOlapMember(delMembers, dimNumber, modelCache);
                    MemberPropCacheService.updateVersion((Long)modelId, (Long)dimension.getId());
                }
                stats.add("over-sync-shrek.");
            }
            catch (Throwable ex) {
                log.error("delete-member-error:", ex);
                tx.markRollback();
                throw new KDBizException(ex.getMessage());
            }
            finally {
                CubeUtils.updateDimensionVersion((Long)modelId, (Long)dimension.getId());
            }
            Set<Long> memberIds = Collections.singleton(parent.getLong("memberid"));
            Long userId = UserUtils.getUserId();
            String traceId = RequestContext.get().getTraceId();
            EventBusUtil.asyncPost((Object)new FactoryChangeEvent(Long.valueOf(modelId), dimension.getId(), viewId, memberIds, userId, traceId));
            stats.add("over-factory-change-shrek.");
            stats.addInfo("end-delete-member.");
            log.info(stats.toString());
            HashSet hashSet = delSet;
            return hashSet;
        }
    }

    private void validRefMember(long modelId, Dimension dimension, Set<Long> srcMemberId, Set<Long> viewIds) {
        if (!srcMemberId.isEmpty()) {
            QFBuilder builder = new QFBuilder();
            builder.add(new QFilter("model", "=", (Object)modelId));
            builder.add(new QFilter("view", "in", viewIds));
            builder.add(new QFilter("dimension", "=", (Object)dimension.getId()));
            builder.add(new QFilter("memberid", "in", srcMemberId));
            builder.add(new QFilter("membersource", "in", Arrays.asList(ViewMemberSourceEnum.INNER_REF.getIndex(), ViewMemberSourceEnum.OUTER_REF.getIndex())));
            DynamicObject existObj = QueryServiceHelper.queryOne((String)"eb_viewmember", (String)"id,number,name,view.name", (QFilter[])builder.toArray());
            if (existObj != null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u6210\u5458\u6216\u5176\u4e0b\u7ea7\u6210\u5458\u88ab\u5176\u4ed6\u89c6\u56fe\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ViewMemberManager_6_1", (String)"epm-eb-olap", (Object[])new Object[0]));
            }
        }
    }

    public void deleteMemberByView(long modelId, String dimNumber, Long viewId) {
        DynamicObject viewDy = BusinessDataServiceHelper.loadSingle((Object)viewId, (String)"eb_dimensionview");
        BizRequire.notNull((Object)viewDy, (String)ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u89c6\u56fe\u3002", (String)"ViewMemberManager_3", (String)"epm-eb-olap", (Object[])new Object[0]));
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Dimension dimension = modelCache.getDimension(dimNumber);
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)modelId));
        builder.add(new QFilter("view", "=", (Object)viewId));
        builder.add(new QFilter("dimension", "=", (Object)dimension.getId()));
        builder.add(new QFilter("level", "=", (Object)1));
        long rootId = QueryServiceHelper.queryOne((String)"eb_viewmember", (String)"id", (QFilter[])builder.toArray()).getLong("id");
        DimensionViewMember dbRootViewMember = this.getViewMember(modelId, viewId, rootId);
        List<DimensionViewMember> children = this.getViewMemberAllChildren(dbRootViewMember.getViewMemberId(), dbRootViewMember.getLongNumber(), viewId, modelId, dimension.getId(), false);
        Set vmDelIds = children.stream().map(DimensionViewMember::getViewMemberId).collect(Collectors.toSet());
        Set<Long> mDelIds = children.stream().map(DimensionViewMember::getMemberId).collect(Collectors.toSet());
        List<String> delMembers = children.stream().map(DimensionViewMember::getNumber).collect(Collectors.toList());
        vmDelIds.add(rootId);
        mDelIds.add(dbRootViewMember.getMemberId());
        delMembers.add(dbRootViewMember.getNumber());
        Set<Long> srcMemberId = children.stream().filter(e -> ViewMemberSourceEnum.ADD.getIndex().equals(e.getViewMembersource())).map(DimensionViewMember::getMemberId).collect(Collectors.toSet());
        Set<Long> viewIds = ViewGroupManager.getInstance().getViewByDimensionId(modelId, dimension.getId()).stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        this.validRefMember(modelId, dimension, srcMemberId, viewIds);
        boolean allOutRef = children.stream().allMatch(e -> ViewMemberSourceEnum.OUTER_REF.getIndex().equals(e.getViewMembersource()));
        if (allOutRef) {
            Set<Long> groupViewIds = ViewGroupManager.getInstance().getViewsByViewId(viewId);
            groupViewIds.removeIf(e -> e.equals(viewId));
            srcMemberId = children.stream().map(DimensionViewMember::getMemberId).collect(Collectors.toSet());
            this.validRefMember(modelId, dimension, srcMemberId, groupViewIds);
        }
        HashMap optMap = Maps.newHashMap();
        optMap.put("checkChild", true);
        optMap.put("excludeViewMember", true);
        optMap.put("viewId", viewId);
        optMap.put("dataCheck", false);
        optMap.put("onlyCurrView", true);
        Pair pair = (Pair)DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"checkQuoteResult", (Object[])new Object[]{modelId, dimension.getId(), dbRootViewMember.getMemberId(), MemberTypeEnum.MEMBER, optMap});
        BizRequire.isFalse((boolean)((Boolean)pair.getLeft()), (String)((String)pair.getRight()));
        Set<Long> addMids = children.stream().filter(e -> ViewMemberSourceEnum.ADD.getIndex().equals(e.getViewMembersource())).map(DimensionViewMember::getMemberId).collect(Collectors.toSet());
        DynamicObjectCollection relViewMembers = this.getViewMemberByMemberId(addMids, viewDy, modelId, dimension.getId());
        LogStats stats = new LogStats("budget-log : ");
        stats.addInfo("begin-delete-viewMember.");
        try (TXHandle tx = TX.required((String)"deleteViewMember");){
            try {
                DeleteServiceHelper.delete((String)"eb_viewmember", (QFilter[])new QFilter[]{new QFilter("id", "in", vmDelIds)});
                stats.add("over-delete-viewMember.");
                this.updateViewMemberParent((Collection<DynamicObject>)relViewMembers, modelId, dimension);
                stats.add("over-update-parent-leaf.");
                this.deleteDimMemberByViewMember(mDelIds, modelId, dimension);
                MembPermRecordUtil.delDetailRecordByMembIds((Long)modelId, (Long)dimension.getId(), (Collection)Sets.newHashSet((Object[])new Long[]{viewId}), mDelIds);
                stats.add("over-delete-member-permission.");
                this.delOlapMember(delMembers, dimNumber, modelCache);
                stats.add("over-sync-shrek.");
            }
            catch (Throwable ex) {
                log.error("delete-member-error:", ex);
                tx.markRollback();
                throw new KDBizException(ex.getMessage());
            }
            finally {
                if (vmDelIds.size() > 0) {
                    CubeUtils.updateDimensionVersion((Long)modelId, (Long)dimension.getId());
                }
            }
            stats.addInfo("end-delete-member.");
            log.info(stats.toString());
        }
    }

    private Set<Long> deleteDimMemberByViewMember(Set<Long> mDelIds, long modelId, Dimension dimension) {
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)modelId));
        builder.add(new QFilter("dimension", "=", (Object)dimension.getId()));
        builder.add(new QFilter("memberid", "in", mDelIds));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_viewmember", (String)"id,memberid", (QFilter[])builder.toArray());
        Map<Long, Long> memberCountMap = query.stream().collect(Collectors.groupingBy(e -> e.getLong("memberid"), Collectors.counting()));
        Set keepMids = memberCountMap.entrySet().stream().filter(e -> (Long)e.getValue() > 0L).map(Map.Entry::getKey).collect(Collectors.toSet());
        Sets.SetView delMids = Sets.difference(mDelIds, keepMids);
        if (delMids.isEmpty()) {
            return Collections.emptySet();
        }
        LogStats stats = new LogStats("budget-log : ");
        stats.addInfo("begin-delete-member.");
        DeleteServiceHelper.delete((String)dimension.getMemberModel(), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)delMids)});
        stats.add("over-delete-member.");
        CustomPropertyUtils.deletePropertyByRef((Collection)delMids);
        stats.add("over-delete-member-propertyRef.");
        stats.addInfo("end-delete-member.");
        log.info(stats.toString());
        return delMids;
    }

    public Set<String> deleteDimMember(long modelId, String dimNumber, Long memberId) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Dimension dimension = modelCache.getDimension(dimNumber);
        DimensionViewMember dimMember = this.getDimMember(modelId, dimension, memberId);
        BizRequire.isTrue((dimMember.getLevel() > 1 ? 1 : 0) != 0, (String)ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u7ef4\u5ea6\u6210\u5458\u7684\u6839\u8282\u70b9\u3002", (String)"ViewMemberManager_12", (String)"epm-eb-olap", (Object[])new Object[0]));
        BizRequire.isFalse((boolean)MemberSourceEnum.PRESET.getIndex().equals(dimMember.getViewMembersource()), (String)ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u9884\u7f6e\u6210\u5458\u3002", (String)"ViewMemberManager_10", (String)"epm-eb-olap", (Object[])new Object[0]));
        Member delMember = modelCache.getMember(dimNumber, Long.valueOf(0L), memberId);
        if (SysDimensionEnum.AuditTrail.getNumber().equals(dimNumber) && !CommonCheckUtil.checkCanCutOrDelete((IModelCacheHelper)modelCache, (String)delMember.getNumber())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u8c03\u6574\u5206\u89e3\u7528\u9014\u7684\u7ebf\u7d22\u6210\u5458\u65f6\uff0c\u81f3\u5c11\u5b58\u5728\u4e00\u4e2a\u540c\u5c42\u7ea7\u7684\u62a5\u8868\u586b\u62a5\u7528\u9014\u6210\u5458\u3002", (String)"ViewMemberManager_13", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        HashMap optMap = Maps.newHashMap();
        optMap.put("checkChild", true);
        optMap.put("excludeViewMember", true);
        Pair pair = (Pair)DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"checkQuoteResult", (Object[])new Object[]{modelId, dimension.getId(), memberId, MemberTypeEnum.MEMBER, optMap});
        BizRequire.isFalse((boolean)((Boolean)pair.getLeft()), (String)((String)pair.getRight()));
        List<Pair<Long, String>> children = this.getDimMemberAllChildren(delMember, modelId, dimension);
        Set childrenIds = children.stream().map(Pair::getLeft).collect(Collectors.toSet());
        List<String> childrenNumbers = children.stream().map(Pair::getRight).collect(Collectors.toList());
        childrenIds.add(memberId);
        childrenNumbers.add(delMember.getNumber());
        HashSet delSet = Sets.newHashSetWithExpectedSize((int)(children.size() + 1));
        delSet.add(delMember.getNumber());
        delSet.addAll(childrenNumbers);
        LogStats stats = new LogStats("budget-log : ");
        stats.addInfo("begin-delete-member.");
        try (TXHandle tx = TX.required((String)"deleteMember");){
            try {
                DeleteServiceHelper.delete((String)dimension.getMemberModel(), (QFilter[])new QFilter[]{new QFilter("id", "in", childrenIds)});
                stats.add("over-delete-member.");
                this.updateDimMemberParent(modelId, dimension, delMember);
                stats.add("over-update-parent-leaf.");
                MembPermRecordUtil.delDetailRecordByMembIds((Long)modelId, (Long)dimension.getId(), null, childrenIds);
                stats.add("over-delete-member-permission.");
                CustomPropertyUtils.deletePropertyByRef(childrenIds);
                stats.add("over-delete-member-propertyRef.");
                this.delOlapMember(childrenNumbers, dimNumber, modelCache);
                stats.add("over-sync-shrek.");
            }
            catch (Throwable ex) {
                log.error("delete-member-error:", ex);
                tx.markRollback();
                throw new KDBizException(ex.getMessage());
            }
            finally {
                if (!childrenIds.isEmpty()) {
                    CubeUtils.updateDimensionVersion((Long)modelId, (Long)dimension.getId());
                }
            }
            Set<Long> memberIds = Collections.singleton(delMember.getParentId());
            Long userId = UserUtils.getUserId();
            String traceId = RequestContext.get().getTraceId();
            EventBusUtil.asyncPost((Object)new FactoryChangeEvent(Long.valueOf(modelId), dimension.getId(), memberIds, userId, traceId));
            stats.add("over-factory-change-shrek.");
            stats.addInfo("end-delete-member.");
            log.info(stats.toString());
        }
        return delSet;
    }

    private List<DynamicObject> newRefMember(DimensionViewMember inputMember, DynamicObject saveObj, DynamicObject dbViewMemberObj, DynamicObject viewDy, Dimension dimension, SaveMemberContext ctx) {
        ArrayList refLeafMembers = Lists.newArrayList();
        if (ViewMemberSourceEnum.INNER_REF.getIndex().equals(saveObj.getString("membersource")) || dbViewMemberObj != null) {
            return refLeafMembers;
        }
        Set<Long> groupViewIds = ViewGroupManager.getInstance().getViewsByViewId(viewDy.getLong("id"));
        groupViewIds.removeIf(e -> e.equals(viewDy.getLong("id")));
        if (groupViewIds.isEmpty()) {
            return refLeafMembers;
        }
        DynamicObject parent = BusinessDataServiceHelper.loadSingle((Object)inputMember.getParentId(), (String)"eb_viewmember");
        QFBuilder query = new QFBuilder(new QFilter("view", "in", groupViewIds));
        query.add(new QFilter("model", "=", (Object)ctx.getModelCache().getModelobj().getId()));
        query.add(new QFilter("dimension", "=", (Object)dimension.getId()));
        query.add(new QFilter("memberid", "=", (Object)parent.getLong("memberid")));
        query.add(new QFilter("membersource", "=", (Object)ViewMemberSourceEnum.INNER_REF.getIndex()));
        DynamicObjectCollection refParents = QueryServiceHelper.query((String)"eb_viewmember", (String)"id,view.id,showchildren,showself,longnumber", (QFilter[])query.toArray());
        for (DynamicObject refParent : refParents) {
            DimensionViewMember newRefLeaf = new DimensionViewMember();
            BeanCopyUtils.copyProperties((Object)newRefLeaf, (Object)inputMember);
            newRefLeaf.setViewMemberId(null);
            newRefLeaf.setParentId(refParent.getLong("id"));
            newRefLeaf.setLongNumber(refParent.getString("longnumber") + "!" + newRefLeaf.getNumber());
            newRefLeaf.setViewMembersource(ViewMemberSourceEnum.INNER_REF.getIndex());
            newRefLeaf.setRefview(inputMember.getView());
            if ("0".equals(refParent.getString("showchildren"))) {
                newRefLeaf.setShowSelf(false);
                newRefLeaf.setShowChildren(false);
            }
            DynamicObject dy = this.buiViewMember(newRefLeaf, null, ctx);
            dy.set("view", (Object)refParent.getLong("view.id"));
            refLeafMembers.add(dy);
        }
        return refLeafMembers;
    }

    private List<DynamicObject> newRefMember(List<DimensionViewMember> srcMembers, DynamicObject srcViewDy, Set<Long> tarViews, Dimension dimension, SaveMemberContext ctx) {
        Set ids = srcMembers.stream().map(DimensionViewMember::getViewMemberId).collect(Collectors.toSet());
        Set srcTopPids = srcMembers.stream().map(DimensionViewMember::getParentId).filter(parentId -> !ids.contains(parentId)).collect(Collectors.toSet());
        QFBuilder query = new QFBuilder(new QFilter("view", "=", (Object)ctx.getViewId()));
        query.add(new QFilter("model", "=", (Object)ctx.getModelCache().getModelobj().getId()));
        query.add(new QFilter("id", "in", srcTopPids));
        DynamicObjectCollection srcParents = QueryServiceHelper.query((String)"eb_viewmember", (String)"id,memberid,level,view.id,showchildren,showself,longnumber", (QFilter[])query.toArray());
        Set<Long> groupViewIds = ViewGroupManager.getInstance().getViewsByViewId(srcViewDy.getLong("id"));
        if (CollectionUtils.isNotEmpty(tarViews)) {
            groupViewIds = groupViewIds.stream().filter(tarViews::contains).collect(Collectors.toSet());
        }
        groupViewIds.removeIf(e -> e.equals(srcViewDy.getLong("id")));
        if (groupViewIds.isEmpty()) {
            return Collections.emptyList();
        }
        QFBuilder refQ = new QFBuilder(new QFilter("view", "in", groupViewIds));
        refQ.add(new QFilter("model", "=", (Object)ctx.getModelCache().getModelobj().getId()));
        refQ.add(new QFilter("dimension", "=", (Object)dimension.getId()));
        refQ.add(new QFilter("memberid", "in", srcParents.stream().map(e -> e.getLong("memberid")).collect(Collectors.toSet())));
        refQ.add(new QFilter("membersource", "=", (Object)ViewMemberSourceEnum.INNER_REF.getIndex()));
        DynamicObjectCollection tarParents = QueryServiceHelper.query((String)"eb_viewmember", (String)"id,memberid,level,view.id,showchildren,showself,longnumber", (QFilter[])refQ.toArray());
        if (tarParents.isEmpty()) {
            return Collections.emptyList();
        }
        Set tarParentMidSet = tarParents.stream().map(e -> e.getLong("memberid")).collect(Collectors.toSet());
        Set syncTarParents = srcParents.stream().filter(e -> tarParentMidSet.contains(e.getLong("memberid"))).collect(Collectors.toSet());
        HashMap syncTarGroup = Maps.newHashMapWithExpectedSize((int)syncTarParents.size());
        for (DynamicObject syncTarParent : syncTarParents) {
            long tarParentMemberid = syncTarParent.getLong("memberid");
            String parentLongNumber = syncTarParent.getString("longnumber");
            syncTarGroup.put(tarParentMemberid, Pair.of((Object)syncTarParent, srcMembers.stream().filter(e -> e.getLongNumber().startsWith(parentLongNumber + "!")).collect(Collectors.toList())));
        }
        ArrayList allNewMembers = Lists.newArrayList();
        for (DynamicObject tarParent : tarParents) {
            DynamicObject syncTarParent = (DynamicObject)((Pair)syncTarGroup.get(tarParent.getLong("memberid"))).getLeft();
            List syncChildren = (List)((Pair)syncTarGroup.get(tarParent.getLong("memberid"))).getRight();
            int levelDiff = tarParent.getInt("level") - syncTarParent.getInt("level");
            ArrayList newChildren = Lists.newArrayListWithExpectedSize((int)syncChildren.size());
            HashMap idMap = Maps.newHashMapWithExpectedSize((int)syncChildren.size());
            for (DimensionViewMember syncChild : syncChildren) {
                DimensionViewMember newChild = new DimensionViewMember();
                BeanCopyUtils.copyProperties((Object)newChild, (Object)syncChild);
                long newId = DBServiceHelper.genGlobalLongId();
                newChild.setViewMemberId(newId);
                idMap.put(syncChild.getViewMemberId(), newId);
                newChild.setLevel(syncChild.getLevel() + levelDiff);
                newChild.setViewMembersource(ViewMemberSourceEnum.INNER_REF.getIndex());
                long refView = syncChild.getRefview() == null || syncChild.getRefview().equals(0L) ? srcViewDy.getLong("id") : syncChild.getRefview().longValue();
                newChild.setRefview(refView);
                if ("0".equals(tarParent.getString("showchildren"))) {
                    newChild.setShowSelf(false);
                    newChild.setShowChildren(false);
                }
                DynamicObject dy = this.buiViewMember(newChild, null, ctx);
                dy.set("view", (Object)tarParent.getLong("view.id"));
                newChildren.add(dy);
            }
            for (DynamicObject newChild : newChildren) {
                Long newPid = (Long)idMap.get(newChild.getLong("parent"));
                if (newPid == null) continue;
                newChild.set("parent", (Object)newPid);
            }
            HashMap longNumberMap = Maps.newHashMap();
            List<DynamicObject> tops = newChildren.stream().filter(e -> !idMap.containsValue(e.getLong("parent"))).collect(Collectors.toList());
            tops.forEach(e -> {
                e.set("parent", (Object)tarParent.getLong("id"));
                e.set("longnumber", (Object)(tarParent.getString("longnumber") + "!" + e.getString("number")));
                longNumberMap.put(e.getLong("id"), e.getString("longnumber"));
            });
            Integer minLevel = newChildren.stream().map(e -> e.getInt("level")).min(Integer::compareTo).get();
            Integer maxLevel = newChildren.stream().map(e -> e.getInt("level")).max(Integer::compareTo).get();
            Integer curLevel = minLevel = Integer.valueOf(minLevel + 1);
            while (curLevel <= maxLevel) {
                Integer finalCurLevel = curLevel;
                List<DynamicObject> levelChildren = newChildren.stream().filter(e -> e.getInt("level") == finalCurLevel.intValue()).collect(Collectors.toList());
                levelChildren.forEach(e -> {
                    e.set("longnumber", (Object)((String)longNumberMap.get(e.getLong("parent")) + "!" + e.getString("number")));
                    longNumberMap.put(e.getLong("id"), e.getString("longnumber"));
                });
                Integer n = curLevel;
                Integer n2 = curLevel = Integer.valueOf(curLevel + 1);
            }
            allNewMembers.addAll(newChildren);
        }
        return allNewMembers;
    }

    public void syncUpdateRefMemberInfo(Collection<DynamicObject> updateViewMembers, DynamicObject srcViewDy, Dimension dimension, IModelCacheHelper modelCache) {
        Object[] sqlParam;
        ILocaleString _simpleName;
        ILocaleString _name;
        StringBuilder inSb;
        String sql;
        if ((updateViewMembers = (Collection)updateViewMembers.stream().filter(e -> !ViewMemberSourceEnum.INNER_REF.getIndex().equals(e.getString("membersource"))).collect(Collectors.toList())).isEmpty()) {
            return;
        }
        Set<Long> myGroupViewIds = ViewGroupManager.getInstance().getViewsByViewId(srcViewDy.getLong("id"));
        List viewList = dimension.getViewList();
        Set otherGroupViewIds = viewList.stream().filter(e -> !myGroupViewIds.contains(e)).collect(Collectors.toSet());
        LinkedList sqlParams = Lists.newLinkedList();
        LinkedHashSet checker = Sets.newLinkedHashSet();
        myGroupViewIds.removeIf(e -> e.equals(srcViewDy.getLong("id")));
        if (!myGroupViewIds.isEmpty()) {
            sql = "update t_eb_viewmember set fshownumber=?,fname=?,fsimplename=?,fisoffsetentry=?,fmergernode=?,fdisable=? where fmodelid =? and fdimensionid =? and fmemberid =? and  fviewid in({})";
            inSb = new StringBuilder();
            for (int i = 0; i < myGroupViewIds.size(); ++i) {
                inSb.append("?,");
            }
            inSb.setLength(inSb.length() - 1);
            sql = StringUtils.replaceOnce((String)sql, (String)"{}", (String)inSb.toString());
            ArrayList<Object[]> params = new ArrayList<Object[]>(10);
            for (DynamicObject saveObj : updateViewMembers) {
                boolean isoffsetentry = saveObj.getBoolean("isoffsetentry");
                boolean mergernode = saveObj.getBoolean("mergernode");
                boolean disable = saveObj.getBoolean("disable");
                String showNumber = saveObj.getString("shownumber");
                String name = saveObj.getString("name");
                String simplename = saveObj.getString("simplename");
                long modelId = srcViewDy.getLong("model.id");
                long dimensionId = srcViewDy.getLong("dimension.id");
                long memberid = saveObj.getLong("memberid");
                ArrayList paramList = Lists.newArrayList();
                paramList.add(showNumber);
                paramList.add(name);
                paramList.add(simplename);
                paramList.add(isoffsetentry ? "1" : "0");
                paramList.add(mergernode ? "1" : "0");
                paramList.add(disable ? "1" : "0");
                paramList.add(modelId);
                paramList.add(dimensionId);
                paramList.add(memberid);
                paramList.addAll(myGroupViewIds);
                params.add(paramList.toArray());
                _name = saveObj.getLocaleString("name");
                _simpleName = saveObj.getLocaleString("simplename");
                for (String _lang : _name.keySet()) {
                    sqlParam = new Object[]{_name.get((Object)_lang), _simpleName.get((Object)_lang), modelId, dimensionId, memberid, _lang};
                    if (!checker.add("" + modelId + '.' + dimensionId + '.' + memberid + '.' + _lang)) continue;
                    sqlParams.add(sqlParam);
                }
            }
            DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)sql, params);
            Set memberIdSet = updateViewMembers.stream().map(e -> e.getLong("memberid")).collect(Collectors.toSet());
            QFBuilder query = new QFBuilder(new QFilter("view", "in", myGroupViewIds));
            query.add(new QFilter("model", "=", (Object)modelCache.getModelobj().getId()));
            query.add(new QFilter("dimension", "=", (Object)dimension.getId()));
            query.add(new QFilter("memberid", "in", memberIdSet));
            DynamicObjectCollection refViewMembers = QueryServiceHelper.query((String)"eb_viewmember", (String)"id,memberid,membersource,parent.id,parent.membersource", (QFilter[])query.toArray());
            ArrayList aggParams = new ArrayList(10);
            Map<Long, String> aggMap = updateViewMembers.stream().collect(Collectors.toMap(e -> e.getLong("memberid"), e -> e.getString("aggoprt"), (v1, v2) -> v1));
            refViewMembers.stream().filter(e -> ViewMemberSourceEnum.INNER_REF.getIndex().equals(e.getString("parent.membersource"))).forEach(e -> {
                String agg = (String)aggMap.get(e.getLong("memberid"));
                if (agg != null) {
                    ArrayList paramList = Lists.newArrayList();
                    paramList.add(agg);
                    paramList.add(e.getLong("id"));
                    aggParams.add(paramList.toArray());
                }
            });
            if (!aggParams.isEmpty()) {
                String aggSql = "update t_eb_viewmember set faggoprt=? where fid =? ";
                DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)aggSql, aggParams);
            }
        }
        if (!otherGroupViewIds.isEmpty()) {
            sql = "update t_eb_viewmember set fshownumber=?,fname=?,fsimplename=? where fmodelid =? and fdimensionid =? and fmemberid =? and  fviewid in({})";
            inSb = new StringBuilder();
            for (int i = 0; i < otherGroupViewIds.size(); ++i) {
                inSb.append("?,");
            }
            inSb.setLength(inSb.length() - 1);
            sql = StringUtils.replaceOnce((String)sql, (String)"{}", (String)inSb.toString());
            ArrayList<Object[]> params = new ArrayList<Object[]>(10);
            for (DynamicObject saveObj : updateViewMembers) {
                String showNumber = saveObj.getString("shownumber");
                String name = saveObj.getString("name");
                String simplename = saveObj.getString("simplename");
                long modelId = srcViewDy.getLong("model.id");
                long dimensionId = srcViewDy.getLong("dimension.id");
                long memberid = saveObj.getLong("memberid");
                ArrayList paramList = Lists.newArrayList();
                paramList.add(showNumber);
                paramList.add(name);
                paramList.add(simplename);
                paramList.add(modelId);
                paramList.add(dimensionId);
                paramList.add(memberid);
                paramList.addAll(otherGroupViewIds);
                params.add(paramList.toArray());
                _name = saveObj.getLocaleString("name");
                _simpleName = saveObj.getLocaleString("simplename");
                for (String _lang : _name.keySet()) {
                    sqlParam = new Object[]{_name.get((Object)_lang), _simpleName.get((Object)_lang), modelId, dimensionId, memberid, _lang};
                    if (!checker.add(this.getSqlParamKey(modelId, dimensionId, memberid, _lang))) continue;
                    sqlParams.add(sqlParam);
                }
            }
            DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)sql, params);
        }
        if (!myGroupViewIds.isEmpty() || !otherGroupViewIds.isEmpty()) {
            if (!sqlParams.isEmpty()) {
                sql = "update t_eb_viewmember_l set fname = ?, fsimplename = ? where exists (select fid from t_eb_viewmember v where t_eb_viewmember_l.fid = v.fid and v.fmodelid = ? and v.fdimensionid = ? and v.fmemberid = ?) and flocaleid = ?";
                DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)sql, (List)sqlParams);
            }
            CacheServiceHelper.clearEntityCache((String)"eb_viewmember");
        }
    }

    private String getSqlParamKey(Long modelId, Long dimensionId, Long memberId, String lang) {
        return "" + modelId + '.' + dimensionId + '.' + memberId + '.' + lang;
    }

    private void updateParentViewMember(Collection<DynamicObject> saveObjs) {
        if (saveObjs.isEmpty()) {
            return;
        }
        Set pids = saveObjs.stream().map(e -> e.getLong("parent")).collect(Collectors.toSet());
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("update t_eb_viewmember set fisleaf = '0' where ", new Object[0]);
        sqlBuilder.appendIn("fid", pids.toArray());
        DB.execute((DBRoute)BgBaseConstant.epm, (SqlBuilder)sqlBuilder);
    }

    private void updateChildrenShowStatus(DynamicObject saveObj, DynamicObject dbViewMemberObj, List<DimensionViewMember> children) {
        if (children.isEmpty()) {
            return;
        }
        if (dbViewMemberObj != null) {
            SqlBuilder sqlBuilder = new SqlBuilder();
            if (!saveObj.getBoolean("showchildren")) {
                sqlBuilder.append("update t_eb_viewmember set fshowchildren = '0',fshowself='0' where ", new Object[0]);
                sqlBuilder.appendIn("fid", children.stream().map(DimensionViewMember::getViewMemberId).distinct().toArray());
            } else {
                sqlBuilder.append("update t_eb_viewmember set fshowchildren = '1',fshowself='1' where ", new Object[0]);
                sqlBuilder.appendIn("fid", children.stream().map(DimensionViewMember::getViewMemberId).distinct().toArray());
            }
            DB.execute((DBRoute)BgBaseConstant.epm, (SqlBuilder)sqlBuilder);
        }
    }

    public DimensionViewMember buildViewMemberByOldMember(DynamicObject dimMemberObj, Long viewId, Long viewMemberId, Boolean isAdd) {
        DynamicObject view = BusinessDataServiceHelper.loadSingle((Object)viewId, (String)"eb_dimensionview");
        DimensionViewMember dimensionViewMember = new DimensionViewMember();
        DynamicObject parentObject = null;
        if (isAdd.booleanValue()) {
            if (viewMemberId != null && viewMemberId != 0L) {
                parentObject = BusinessDataServiceHelper.loadSingle((Object)viewMemberId, (String)"eb_viewmember");
                dimensionViewMember.setLevel(parentObject.getInt("level") + 1);
                dimensionViewMember.setDseq(this.getMaxDSeq(parentObject.getLong("id"), "eb_viewmember", viewId) + 1);
            } else {
                dimensionViewMember.setLevel(dimMemberObj.getInt("level"));
                dimensionViewMember.setDseq(dimMemberObj.getInt("dseq"));
            }
            dimensionViewMember.setViewMemberId(ID.genLongId());
            dimensionViewMember.setViewMembersource("1");
        } else {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)viewMemberId, (String)"eb_viewmember");
            parentObject = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.getLong("parent.id"), (String)"eb_viewmember");
            dimensionViewMember.setViewMemberId(dynamicObject.getLong("id"));
            dimensionViewMember.setId(dynamicObject.getLong("id"));
            dimensionViewMember.setViewMembersource(dynamicObject.getString("membersource"));
            dimensionViewMember.setLevel(dynamicObject.getInt("level"));
            dimensionViewMember.setDseq(dynamicObject.getInt("dseq"));
            dimensionViewMember.setRefview(dynamicObject.getLong("refview.id"));
        }
        dimensionViewMember.setView(viewId);
        dimensionViewMember.setDimension(dimMemberObj.getLong("dimension.id"));
        dimensionViewMember.setMemberId(dimMemberObj.getLong("id"));
        dimensionViewMember.setAggoprt(dimMemberObj.getString("aggoprt"));
        if (dimMemberObj.getInt("level") == 1) {
            if (StringUtils.isEmpty((CharSequence)dimMemberObj.getString("number"))) {
                dimensionViewMember.setNumber(dimMemberObj.getString("shownumber") + "_" + view.getString("number"));
            } else {
                dimensionViewMember.setNumber(dimMemberObj.getString("number") + "_" + view.getString("number"));
            }
            dimensionViewMember.setLongNumber(dimensionViewMember.getNumber());
        } else if (parentObject != null) {
            dimensionViewMember.setLongNumber(parentObject.getString("longnumber") + "!" + dimMemberObj.getString("number"));
            if (StringUtils.isEmpty((CharSequence)dimMemberObj.getString("number"))) {
                dimensionViewMember.setNumber(dimMemberObj.getString("shownumber"));
            } else {
                dimensionViewMember.setNumber(dimMemberObj.getString("number"));
            }
        }
        String shownumber = dimMemberObj.getString("shownumber");
        if (StringUtils.isEmpty((CharSequence)shownumber)) {
            dimensionViewMember.setShowNumber(dimMemberObj.getString("number"));
        } else {
            dimensionViewMember.setShowNumber(shownumber);
        }
        if (parentObject != null) {
            DimensionViewMember parent = new DimensionViewMember();
            parent.setViewMemberId(parentObject.getLong("id"));
            parent.setMemberId(parentObject.getLong("memberid"));
            dimensionViewMember.setParent(parent);
            dimensionViewMember.setParentId(parent.getViewMemberId());
            dimensionViewMember.setParentMemberId(parent.getMemberId());
        }
        dimensionViewMember.setName(dimMemberObj.getLocaleString("name"));
        dimensionViewMember.setSimpleName(dimMemberObj.getLocaleString("simplename"));
        dimensionViewMember.setIsLeaf(dimMemberObj.getBoolean("isleaf"));
        dimensionViewMember.setMembersource(dimMemberObj.getString("membersource"));
        dimensionViewMember.setModel(dimMemberObj.getLong("model.id"));
        dimensionViewMember.setStatus(dimMemberObj.getString("status"));
        boolean enable = dimMemberObj.getBoolean("enable");
        dimensionViewMember.setEnable(enable ? "1" : "0");
        String dimNumber = dimMemberObj.getString("dimension.number");
        if (SysDimensionEnum.Entity.getNumber().equals(dimNumber)) {
            dimensionViewMember.setMergernode(dimMemberObj.getString("mergernode"));
            dimensionViewMember.setIsoffsetentry(dimMemberObj.getString("isoffsetentry"));
        }
        if (!View.NoViewDimNums.contains(dimNumber)) {
            dimensionViewMember.setShowChildren(dimMemberObj.getBoolean("showchildren"));
        }
        dimensionViewMember.setDisable(dimMemberObj.getString("disable"));
        dimensionViewMember.setDseq(dimMemberObj.getInt("dseq"));
        return dimensionViewMember;
    }

    public void delOlapMember(List<String> delMembers, String dimNumber, IModelCacheHelper modelCache) {
        if (CollectionUtils.isEmpty(delMembers)) {
            return;
        }
        DynamicObject model = BusinessDataServiceHelper.loadSingleFromCache((Object)modelCache.getModelobj().getId(), (String)"epm_model");
        if (ShrekOlapServiceHelper.needDMLOlap((DynamicObject)model)) {
            boolean isAccount = SysDimensionEnum.Account.getNumber().equals(dimNumber);
            List<Dataset> deleteDataSets = Lists.newArrayList();
            if (isAccount && modelCache.getModelobj().isModelByBGMD()) {
                Member luckyAcc = modelCache.getMember(dimNumber, null, delMembers.get(0));
                DynamicObject datasetObj = BusinessDataServiceHelper.loadSingle((Object)luckyAcc.getDatasetId(), (String)"eb_dataset");
                deleteDataSets.add(new Dataset(Long.valueOf(datasetObj.getLong("id")), datasetObj.getString("number")));
            } else {
                deleteDataSets = DatasetServiceHelper.getDatasetsForDelete((DynamicObject)model, (String)dimNumber);
            }
            Model modelObj = Model.of((DynamicObject)model);
            ShrekOlapServiceHelper.dropCubeMembers((Model)modelObj, (List)deleteDataSets, (String)dimNumber, delMembers);
        }
    }

    private void updateDimMemberParent(long modelId, Dimension dimension, Member delMember) {
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)modelId));
        builder.add(new QFilter("dimension", "=", (Object)dimension.getId()));
        builder.add(new QFilter("parent.id", "=", (Object)delMember.getParentId()));
        SysDimensionEnum def = SysDimensionEnum.Project;
        SysDimensionEnum dimensionEnum = SysDimensionEnum.getEnumByNumber((String)dimension.getNumber());
        if (dimensionEnum != null) {
            def = dimensionEnum;
        }
        if (!QueryServiceHelper.exists((String)dimension.getMemberModel(), (QFilter[])builder.toArray())) {
            DB.execute((DBRoute)BgBaseConstant.epm, (String)("update " + def.getMemberTreetable() + " set fisleaf = '1' where fisleaf = '0' and  fid = ?"), (Object[])new Object[]{delMember.getParentId()});
        }
    }

    private void updateViewMemberParent(Collection<DynamicObject> relViewMembers, long modelId, Dimension dimension) {
        for (DynamicObject relViewMember : relViewMembers) {
            QFBuilder builder = new QFBuilder();
            builder.add(new QFilter("model", "=", (Object)modelId));
            builder.add(new QFilter("dimension", "=", (Object)dimension.getId()));
            builder.add(new QFilter("parent.id", "=", (Object)relViewMember.getLong("parent.id")));
            if (QueryServiceHelper.exists((String)"eb_viewmember", (QFilter[])builder.toArray())) continue;
            this.parentToLeaf(relViewMember);
        }
    }

    private void parentToLeaf(DynamicObject relViewMember) {
        DB.execute((DBRoute)BgBaseConstant.epm, (String)"update t_eb_viewmember set fisleaf = '1' where fid = ?", (Object[])new Object[]{relViewMember.getLong("parent.id")});
    }

    private Map<Long, Set<Long>> deleteRefViewMember(long modelId, Dimension dimension, DynamicObject srcViewDy, Collection<DynamicObject> delViewMembers) {
        if (delViewMembers.isEmpty()) {
            return Collections.emptyMap();
        }
        List delAddList = delViewMembers.stream().filter(e -> !ViewMemberSourceEnum.INNER_REF.getIndex().equals(e.getString("membersource"))).collect(Collectors.toList());
        List delInnerList = delViewMembers.stream().filter(e -> ViewMemberSourceEnum.INNER_REF.getIndex().equals(e.getString("membersource"))).collect(Collectors.toList());
        Set<Long> groupViewIds = ViewGroupManager.getInstance().getViewsByViewId(srcViewDy.getLong("id"));
        groupViewIds.removeIf(e -> e.equals(srcViewDy.getLong("id")));
        if (groupViewIds.isEmpty()) {
            return Collections.emptyMap();
        }
        DynamicObjectCollection refMembers = new DynamicObjectCollection();
        if (!delAddList.isEmpty()) {
            QFBuilder query = new QFBuilder(new QFilter("view", "in", groupViewIds));
            query.add(new QFilter("model", "=", (Object)modelId));
            query.add(new QFilter("dimension", "=", (Object)dimension.getId()));
            query.add(new QFilter("memberid", "in", delAddList.stream().map(e -> e.getLong("memberid")).collect(Collectors.toSet())));
            query.add(new QFilter("membersource", "=", (Object)ViewMemberSourceEnum.INNER_REF.getIndex()));
            refMembers = QueryServiceHelper.query((String)"eb_viewmember", (String)"id,memberid,view.id,longnumber,parent.id", (QFilter[])query.toArray());
        }
        if (!delInnerList.isEmpty()) {
            Set pids = delViewMembers.stream().map(e -> e.getLong("parent.id")).collect(Collectors.toSet());
            QFBuilder qf = new QFBuilder(new QFilter("id", "in", pids));
            qf.add(new QFilter("membersource", "<>", (Object)ViewMemberSourceEnum.INNER_REF.getIndex()));
            DynamicObjectCollection parents = QueryServiceHelper.query((String)"eb_viewmember", (String)"id,memberid,view.id,longnumber", (QFilter[])qf.toArray());
            if (!parents.isEmpty()) {
                Set memberIdSet = parents.stream().map(e -> e.getLong("memberid")).collect(Collectors.toSet());
                QFBuilder query = new QFBuilder(new QFilter("view", "in", groupViewIds));
                query.add(new QFilter("model", "=", (Object)modelId));
                query.add(new QFilter("dimension", "=", (Object)dimension.getId()));
                query.add(new QFilter("memberid", "in", memberIdSet));
                query.add(new QFilter("membersource", "=", (Object)ViewMemberSourceEnum.INNER_REF.getIndex()));
                DynamicObjectCollection refPs = QueryServiceHelper.query((String)"eb_viewmember", (String)"id,memberid,view.id,longnumber", (QFilter[])query.toArray());
                Set refViews = refPs.stream().map(e -> e.getLong("view.id")).collect(Collectors.toSet());
                Set refPids = refPs.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
                QFBuilder query2 = new QFBuilder(new QFilter("model", "=", (Object)modelId));
                query2.add(new QFilter("view", "in", refViews));
                query2.add(new QFilter("dimension", "=", (Object)dimension.getId()));
                query2.add(new QFilter("parent", "in", refPids));
                query2.add(new QFilter("memberid", "in", delInnerList.stream().map(e -> e.getLong("memberid")).collect(Collectors.toSet())));
                DynamicObjectCollection refMembers2 = QueryServiceHelper.query((String)"eb_viewmember", (String)"id,memberid,view.id,longnumber,parent.id", (QFilter[])query2.toArray());
                refMembers.addAll((Collection)refMembers2);
            }
        }
        return this.deleteMemberByParent(modelId, dimension, (List<DynamicObject>)refMembers, true);
    }

    private Map<Long, Set<Long>> deleteMemberByParent(long modelId, Dimension dimension, List<DynamicObject> parents, boolean includeParent) {
        HashSet allDelIds = Sets.newHashSet();
        HashMap delMap = Maps.newHashMapWithExpectedSize((int)2);
        for (DynamicObject parent : parents) {
            long viewId = parent.getLong("view.id");
            List<DimensionViewMember> children = this.getViewMemberAllChildren(parent.getLong("id"), parent.getString("longnumber"), viewId, modelId, dimension.getId(), false);
            Set delIdSet = children.stream().map(DimensionViewMember::getViewMemberId).collect(Collectors.toSet());
            if (includeParent) {
                delIdSet.add(parent.getLong("id"));
            }
            allDelIds.addAll(delIdSet);
            Set delSet = delMap.computeIfAbsent(viewId, v -> Sets.newHashSet());
            delSet.addAll(delIdSet);
        }
        if (!allDelIds.isEmpty()) {
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("delete from t_eb_viewmember where ", new Object[0]);
            sqlBuilder.appendIn("fid", allDelIds.toArray());
            DB.execute((DBRoute)BgBaseConstant.epm, (SqlBuilder)sqlBuilder);
        }
        this.updateViewMemberParent(parents, modelId, dimension);
        return delMap;
    }

    private List<Pair<Long, String>> getDimMemberAllChildren(Member delMember, long modelId, Dimension dimension) {
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)modelId));
        builder.add(new QFilter("dimension", "=", (Object)dimension.getId()));
        builder.add(new QFilter("longnumber", "like", (Object)(delMember.getLongNumber() + "!%")));
        String fields = "id,number";
        ArrayList children = Lists.newArrayList();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)dimension.getMemberModel(), (String)fields, (QFilter[])builder.toArray(), null);){
            while (ds.hasNext()) {
                Row row = ds.next();
                children.add(Pair.of((Object)row.getLong("id"), (Object)row.getString("number")));
            }
        }
        return children;
    }

    private List<DimensionViewMember> getViewMemberAllChildren(Long parentId, String longNumber, long viewId, long modelId, Long dimensionId, boolean includeSelf) {
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)modelId));
        builder.add(new QFilter("view.id", "=", (Object)viewId));
        builder.add(new QFilter("dimension", "=", (Object)dimensionId));
        builder.add(new QFilter("longnumber", "like", (Object)(longNumber + "!%")));
        String fields = "id,parent.id,number,shownumber,name,longnumber,memberid,level,isleaf,membersource,dseq,refview.id,model.id,dimension.id,view.id,aggoprt,status,enable,disable,mergernode,isoffsetentry";
        ArrayList children = Lists.newArrayList();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"eb_viewmember", (String)fields, (QFilter[])builder.toArray(), null);){
            while (ds.hasNext()) {
                Row obj = ds.next();
                DimensionViewMember viewMember = (DimensionViewMember)Builder.of(DimensionViewMember::new).with(DimensionViewMember::setViewMemberId, (Object)obj.getLong("id")).with(DimensionViewMember::setParentId, (Object)obj.getLong("parent.id")).with(DimensionViewMember::setNumber, (Object)obj.getString("number")).with(DimensionViewMember::setShowNumber, (Object)obj.getString("shownumber")).with(DimensionViewMember::setName, (Object)obj.getString("name")).with(DimensionViewMember::setLongNumber, (Object)obj.getString("longnumber")).with(DimensionViewMember::setMemberId, (Object)obj.getLong("memberid")).with(DimensionViewMember::setLevel, (Object)obj.getInteger("level")).with(DimensionViewMember::setIsLeaf, (Object)obj.getBoolean("isleaf")).with(DimensionViewMember::setViewMembersource, (Object)obj.getString("membersource")).with(DimensionViewMember::setDseq, (Object)obj.getInteger("dseq")).with(DimensionViewMember::setRefview, (Object)obj.getLong("refview.id")).with(DimensionViewMember::setModel, (Object)obj.getLong("model.id")).with(DimensionViewMember::setDimension, (Object)obj.getLong("dimension.id")).with(DimensionViewMember::setView, (Object)obj.getLong("view.id")).with(DimensionViewMember::setAggoprt, (Object)obj.getString("aggoprt")).with(DimensionViewMember::setStatus, (Object)obj.getString("status")).with(DimensionViewMember::setEnable, (Object)obj.getString("enable")).with(DimensionViewMember::setDisable, (Object)obj.getString("disable")).with(DimensionViewMember::setMergernode, (Object)obj.getString("mergernode")).with(DimensionViewMember::setIsoffsetentry, (Object)obj.getString("isoffsetentry")).build();
                children.add(viewMember);
            }
        }
        if (includeSelf) {
            DynamicObject parentObj = BusinessDataServiceHelper.loadSingle((Object)parentId, (String)"eb_viewmember", (String)fields);
            DimensionViewMember viewMember = (DimensionViewMember)Builder.of(DimensionViewMember::new).with(DimensionViewMember::setViewMemberId, (Object)parentObj.getLong("id")).with(DimensionViewMember::setParentId, (Object)parentObj.getLong("parent.id")).with(DimensionViewMember::setNumber, (Object)parentObj.getString("number")).with(DimensionViewMember::setShowNumber, (Object)parentObj.getString("shownumber")).with(DimensionViewMember::setName, (Object)parentObj.getString("name")).with(DimensionViewMember::setLongNumber, (Object)parentObj.getString("longnumber")).with(DimensionViewMember::setMemberId, (Object)parentObj.getLong("memberid")).with(DimensionViewMember::setLevel, (Object)parentObj.getInt("level")).with(DimensionViewMember::setIsLeaf, (Object)parentObj.getBoolean("isleaf")).with(DimensionViewMember::setViewMembersource, (Object)parentObj.getString("membersource")).with(DimensionViewMember::setDseq, (Object)parentObj.getInt("dseq")).with(DimensionViewMember::setRefview, (Object)parentObj.getLong("refview.id")).with(DimensionViewMember::setModel, (Object)parentObj.getLong("model.id")).with(DimensionViewMember::setDimension, (Object)parentObj.getLong("dimension.id")).with(DimensionViewMember::setView, (Object)parentObj.getLong("view.id")).with(DimensionViewMember::setAggoprt, (Object)parentObj.getString("aggoprt")).with(DimensionViewMember::setStatus, (Object)parentObj.getString("status")).with(DimensionViewMember::setEnable, (Object)parentObj.getString("enable")).with(DimensionViewMember::setDisable, (Object)parentObj.getString("disable")).with(DimensionViewMember::setMergernode, (Object)parentObj.getString("mergernode")).with(DimensionViewMember::setIsoffsetentry, (Object)parentObj.getString("isoffsetentry")).build();
            children.add(viewMember);
        }
        return children;
    }

    private DynamicObjectCollection getViewMemberByMemberId(Collection<Long> memberIds, DynamicObject viewDy, long modelId, Long dimensionId) {
        Set<Long> groupViewIds = ViewGroupManager.getInstance().getViewsByViewId(viewDy.getLong("id"));
        QFBuilder builder = new QFBuilder(new QFilter("view", "in", groupViewIds));
        builder.add(new QFilter("model", "=", (Object)modelId));
        builder.add(new QFilter("dimension", "=", (Object)dimensionId));
        builder.add(new QFilter("memberid", "in", memberIds));
        String fields = "id,parent.id,memberid,number";
        return QueryServiceHelper.query((String)"eb_viewmember", (String)fields, (QFilter[])builder.toArray());
    }

    public DimensionViewMember getViewMember(long modelId, Long viewId, Long viewMemberId) {
        BizRequire.isTrue((viewId != null && viewId > 0L ? 1 : 0) != 0, (String)ResManager.loadKDString((String)"\u89c6\u56feID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ViewMemberManager_15", (String)"epm-eb-olap", (Object[])new Object[0]));
        BizRequire.isTrue((viewMemberId != null && viewMemberId > 0L ? 1 : 0) != 0, (String)ResManager.loadKDString((String)"\u89c6\u56fe\u6210\u5458ID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ViewMemberManager_16", (String)"epm-eb-olap", (Object[])new Object[0]));
        QFBuilder builder = new QFBuilder();
        builder.add("id", "=", (Object)viewMemberId);
        builder.add("model.id", "=", (Object)modelId);
        builder.add("view.id", "=", (Object)viewId);
        String field = "id,parent.id,number,shownumber,name,longnumber,memberid,level,isleaf,membersource,dseq,refview.id,model.id,dimension.id,view.id,aggoprt,status,enable,disable,mergernode,isoffsetentry";
        DynamicObject obj = QueryServiceHelper.queryOne((String)"eb_viewmember", (String)field, (QFilter[])builder.toArray());
        BizRequire.notNull((Object)obj, (String)ResManager.loadKDString((String)"\u89c6\u56fe\u6210\u5458\u4e0d\u5b58\u5728\u3002", (String)"ViewMemberManager_17", (String)"epm-eb-olap", (Object[])new Object[0]));
        return (DimensionViewMember)Builder.of(DimensionViewMember::new).with(DimensionViewMember::setViewMemberId, (Object)obj.getLong("id")).with(DimensionViewMember::setParentId, (Object)obj.getLong("parent.id")).with(DimensionViewMember::setNumber, (Object)obj.getString("number")).with(DimensionViewMember::setShowNumber, (Object)obj.getString("shownumber")).with(DimensionViewMember::setName, (Object)obj.getString("name")).with(DimensionViewMember::setLongNumber, (Object)obj.getString("longnumber")).with(DimensionViewMember::setMemberId, (Object)obj.getLong("memberid")).with(DimensionViewMember::setLevel, (Object)obj.getInt("level")).with(DimensionViewMember::setIsLeaf, (Object)obj.getBoolean("isleaf")).with(DimensionViewMember::setViewMembersource, (Object)obj.getString("membersource")).with(DimensionViewMember::setDseq, (Object)obj.getInt("dseq")).with(DimensionViewMember::setRefview, (Object)obj.getLong("refview.id")).with(DimensionViewMember::setModel, (Object)obj.getLong("model.id")).with(DimensionViewMember::setDimension, (Object)obj.getLong("dimension.id")).with(DimensionViewMember::setView, (Object)obj.getLong("view.id")).with(DimensionViewMember::setAggoprt, (Object)obj.getString("aggoprt")).with(DimensionViewMember::setStatus, (Object)obj.getString("status")).with(DimensionViewMember::setEnable, (Object)obj.getString("enable")).with(DimensionViewMember::setDisable, (Object)obj.getString("disable")).with(DimensionViewMember::setMergernode, (Object)obj.getString("mergernode")).with(DimensionViewMember::setIsoffsetentry, (Object)obj.getString("isoffsetentry")).build();
    }

    public DimensionViewMember getDimMember(long modelId, Dimension dimension, Long viewMemberId) {
        QFBuilder builder = new QFBuilder();
        builder.add("id", "=", (Object)viewMemberId);
        builder.add("model.id", "=", (Object)modelId);
        builder.add("dimension.id", "=", (Object)dimension.getId());
        String field = "id,number,shownumber,name,longnumber,level,isleaf,membersource,dseq,model.id,dimension.id,aggoprt,status,enable,disable";
        DynamicObject obj = QueryServiceHelper.queryOne((String)dimension.getMemberModel(), (String)field, (QFilter[])builder.toArray());
        BizRequire.notNull((Object)obj, (String)ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u4e0d\u5b58\u5728\u3002", (String)"ViewMemberManager_2", (String)"epm-eb-olap", (Object[])new Object[0]));
        return (DimensionViewMember)Builder.of(DimensionViewMember::new).with(DimensionViewMember::setViewMemberId, (Object)obj.getLong("id")).with(DimensionViewMember::setNumber, (Object)obj.getString("number")).with(DimensionViewMember::setShowNumber, (Object)obj.getString("shownumber")).with(DimensionViewMember::setName, (Object)obj.getString("name")).with(DimensionViewMember::setLongNumber, (Object)obj.getString("longnumber")).with(DimensionViewMember::setLevel, (Object)obj.getInt("level")).with(DimensionViewMember::setIsLeaf, (Object)obj.getBoolean("isleaf")).with(DimensionViewMember::setViewMembersource, (Object)obj.getString("membersource")).with(DimensionViewMember::setDseq, (Object)obj.getInt("dseq")).with(DimensionViewMember::setModel, (Object)obj.getLong("model.id")).with(DimensionViewMember::setDimension, (Object)obj.getLong("dimension.id")).with(DimensionViewMember::setAggoprt, (Object)obj.getString("aggoprt")).with(DimensionViewMember::setStatus, (Object)obj.getString("status")).with(DimensionViewMember::setEnable, (Object)obj.getString("enable")).with(DimensionViewMember::setDisable, (Object)obj.getString("disable")).build();
    }

    public void syncOlapData(SaveMemberContext ctx) {
        DynamicObject model = BusinessDataServiceHelper.loadSingleFromCache((Object)ctx.getModelCache().getModelobj().getId(), (String)"epm_model");
        List datasets = DatasetServiceHelper.getDatasets((DynamicObject)model, (String)ctx.getDimNumber());
        if (datasets.size() == 0) {
            return;
        }
        ShrekConfig config = ShrekConfigServiceHelper.getDefaultConfig((DynamicObject)model);
        ShrekOlapServiceHelper.updateDimension((Model)Model.of((DynamicObject)model), (List)datasets, (String)ctx.getDimNumber(), (ShrekConfig)config);
    }

    private DynamicObject buiViewMember(DimensionViewMember saveMember, DynamicObject dbViewMemberObj, SaveMemberContext ctx) {
        Dimension dimension = ctx.getModelCache().getDimension(ctx.getDimNumber());
        DynamicObject viewMember = dbViewMemberObj;
        if (dbViewMemberObj == null) {
            viewMember = BusinessDataServiceHelper.newDynamicObject((String)"eb_viewmember");
            Long id = saveMember.getViewMemberId();
            if (id == null) {
                id = DBServiceHelper.genGlobalLongId();
            }
            viewMember.set("id", (Object)id);
        }
        viewMember.set("model", (Object)ctx.getModelCache().getModelobj().getId());
        viewMember.set("dimension", (Object)dimension.getId());
        viewMember.set("view", (Object)ctx.getViewId());
        Date now = DateTimeUtils.getCurrentDate();
        viewMember.set("modifydate", (Object)now);
        Long userId = UserUtils.getUserId();
        viewMember.set("modifier", (Object)userId);
        viewMember.set("number", (Object)saveMember.getNumber());
        viewMember.set("shownumber", (Object)saveMember.getShowNumber());
        viewMember.set("name", (Object)saveMember.getName());
        viewMember.set("simplename", (Object)saveMember.getSimpleName());
        viewMember.set("parent", (Object)saveMember.getParentId());
        viewMember.set("longnumber", (Object)saveMember.getLongNumber());
        viewMember.set("memberid", (Object)saveMember.getMemberId());
        viewMember.set("level", (Object)saveMember.getLevel());
        viewMember.set("dseq", (Object)saveMember.getDseq());
        viewMember.set("isleaf", (Object)saveMember.isLeaf());
        if (StringUtils.isNotEmpty((CharSequence)saveMember.getViewMembersource())) {
            viewMember.set("membersource", (Object)saveMember.getViewMembersource());
        }
        viewMember.set("status", (Object)saveMember.getStatus());
        viewMember.set("enable", (Object)saveMember.getEnable());
        viewMember.set("disable", (Object)saveMember.getDisable());
        viewMember.set("aggoprt", (Object)saveMember.getAggoprt());
        viewMember.set("refview", (Object)saveMember.getRefview());
        viewMember.set("showchildren", (Object)saveMember.isShowChildren());
        if (SysDimensionEnum.Entity.getNumber().equals(ctx.getDimNumber())) {
            viewMember.set("mergernode", (Object)saveMember.getMergernode());
            viewMember.set("isoffsetentry", (Object)saveMember.getIsoffsetentry());
        }
        return viewMember;
    }

    public DynamicObject buiDimMember(DimensionViewMember saveMember, SaveMemberContext ctx) {
        Dimension dimension = ctx.getModelCache().getDimension(ctx.getDimNumber());
        DynamicObject dimMember = BusinessDataServiceHelper.newDynamicObject((String)dimension.getMemberModel());
        dimMember.set("model", (Object)ctx.getModelCache().getModelobj().getId());
        dimMember.set("dimension", (Object)dimension.getId());
        Date now = DateTimeUtils.getCurrentDate();
        dimMember.set("createtime", (Object)now);
        dimMember.set("modifytime", (Object)now);
        Long userId = UserUtils.getUserId();
        dimMember.set("creator", (Object)userId);
        dimMember.set("modifier", (Object)userId);
        if (saveMember.getMemberId() == null) {
            saveMember.setMemberId(DBServiceHelper.genGlobalLongId());
        }
        dimMember.set("id", (Object)saveMember.getMemberId());
        dimMember.set("number", (Object)saveMember.getNumber());
        dimMember.set("shownumber", (Object)saveMember.getShowNumber());
        dimMember.set("name", (Object)saveMember.getName());
        dimMember.set("parent", (Object)saveMember.getParentMemberId());
        dimMember.set("longnumber", (Object)saveMember.getLongNumber());
        dimMember.set("level", (Object)saveMember.getLevel());
        dimMember.set("dseq", (Object)saveMember.getDseq());
        dimMember.set("isleaf", (Object)saveMember.isLeaf());
        dimMember.set("membersource", (Object)saveMember.getMembersource());
        if (StringUtils.isNotBlank((CharSequence)saveMember.getDescription())) {
            dimMember.set("description", (Object)saveMember.getDescription());
        }
        dimMember.set("status", (Object)saveMember.getStatus());
        dimMember.set("enable", (Object)saveMember.getEnable());
        dimMember.set("disable", (Object)saveMember.getDisable());
        dimMember.set("aggoprt", (Object)saveMember.getAggoprt());
        if (SysDimensionEnum.Account.getNumber().equals(ctx.getDimNumber())) {
            dimMember.set("accounttype", (Object)saveMember.getAccountType());
            dimMember.set("drcrdirect", (Object)saveMember.getDrcrdirect());
        } else if (SysDimensionEnum.Entity.getNumber().equals(ctx.getDimNumber())) {
            dimMember.set("currency", (Object)saveMember.getCurrency());
        } else if (SysDimensionEnum.Project.getMemberTreemodel().equals(dimension.getMemberModel())) {
            dimMember.set("datatype", (Object)"0");
        }
        if (StringUtils.equalsAny((CharSequence)ctx.getDimNumber(), (CharSequence[])new CharSequence[]{SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.Account.getNumber()}) || SysDimensionEnum.Project.getMemberTreemodel().equals(dimension.getMemberModel())) {
            dimMember.set("simplename", (Object)saveMember.getSimpleName());
        }
        return dimMember;
    }

    public void updateViewMemberDisableOrEnable(Set<Long> memIds, boolean disable, long modelId, String dimensionNumber, long viewId) {
        DynamicObject[] viewMemberArray;
        if (CollectionUtils.isEmpty(memIds) || modelId == 0L || viewId == 0L) {
            return;
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Dimension dimension = modelCache.getDimension(dimensionNumber);
        List viewMembers = dimension.getMembers(memIds, Long.valueOf(viewId));
        HashSet viewMemberSet = new HashSet(viewMembers);
        if (disable) {
            for (Member viewMember : viewMembers) {
                if (viewMember.isLeaf()) continue;
                List children = modelCache.getChildren(viewMember, false);
                viewMemberSet.addAll(children);
            }
        }
        Set updateMemberIds = viewMemberSet.stream().map(e -> e.getId()).collect(Collectors.toSet());
        Set<Long> groupViewIds = ViewGroupManager.getInstance().getViewsByViewId(viewId);
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)modelId));
        builder.add(new QFilter("view", "in", groupViewIds));
        builder.add(new QFilter("dimension", "=", (Object)dimension.getId()));
        builder.add(new QFilter("memberid", "in", updateMemberIds));
        for (DynamicObject dy : viewMemberArray = BusinessDataServiceHelper.load((String)"eb_viewmember", (String)"id,disable", (QFilter[])builder.toArray())) {
            dy.set("disable", (Object)disable);
        }
        SaveServiceHelper.save((DynamicObject[])viewMemberArray);
    }

    public int getMaxDSeq(long parentId, String entityNumber, long viewId) {
        QFBuilder builder = new QFBuilder();
        builder.add("parent", "=", (Object)parentId);
        if ("eb_viewmember".equals(entityNumber) && viewId != 0L) {
            builder.add("view", "=", (Object)viewId);
        }
        int seq = 0;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getMaxDSeq", (String)entityNumber, (String)"dseq", (QFilter[])builder.toArrays(), (String)"dseq desc", (int)1);){
            if (ds != null && ds.hasNext()) {
                seq = ds.next().getInteger("dseq");
            }
        }
        return seq;
    }

    public Long getViewMemberByDimMemberId(Long modelId, Long dimId, Long viewId, Long dimMemberId) {
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)modelId));
        builder.add(new QFilter("view", "=", (Object)viewId));
        builder.add(new QFilter("dimension", "=", (Object)dimId));
        builder.add(new QFilter("memberid", "=", (Object)dimMemberId));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_viewmember", (String)"id", (QFilter[])builder.toArray());
        if (dynamicObject == null) {
            return 0L;
        }
        return dynamicObject.getLong("id");
    }

    private static enum Singleton {
        INSTANCE;

        private final ViewMemberManager instance = new ViewMemberManager();
    }
}

