/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.service.view.bean.utils;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.epm.eb.common.entity.property.CustomProperty;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.excelImport.POIUtils;
import kd.epm.eb.olap.service.view.bean.DimensionViewMember;
import kd.epm.eb.olap.service.view.bean.utils.MemberVoUtils;
import kd.epm.eb.olap.service.view.bean.vo.AccountMemberExcelVO;
import kd.epm.eb.olap.service.view.bean.vo.IMemberVO;
import kd.epm.eb.olap.service.view.bean.vo.MemberExcelVO;
import kd.epm.eb.olap.service.view.context.IMemberContext;
import kd.epm.eb.olap.service.view.context.SaveMemberContext;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

public class AccountMemberVoUtils
extends MemberVoUtils {
    public AccountMemberVoUtils(IMemberContext context) {
        super(context);
    }

    @Override
    public String getFields() {
        String fields = super.getFields();
        fields = fields + ",accounttype,drcrdirect";
        if (!this.getContext().getModel().isModelByEB()) {
            fields = fields + ",entryentity.id,entryentity.metric,entryentity.databytime,entryentity.skip,entryentity.metricdescription,entryentity.change,entryentity.istopoly";
        }
        return fields;
    }

    @Override
    public String getViewFields() {
        return super.getViewFields();
    }

    @Override
    public IMemberVO toMember(Row row) {
        String metricStr;
        int index = 0;
        AccountMemberExcelVO member = new AccountMemberExcelVO();
        member.setRowIndex(row.getRowNum());
        member.setNumber(POIUtils.getStringValue((Cell)row.getCell(index++)));
        if (!this.getContext().getModel().isModelByEB()) {
            member.setShowNumber(POIUtils.getStringValue((Cell)row.getCell(index++)));
        }
        member.setName(POIUtils.getStringValue((Cell)row.getCell(index++)));
        member.setSimpleName(POIUtils.getStringValue((Cell)row.getCell(index++)));
        member.setParentNumber(POIUtils.getStringValue((Cell)row.getCell(index++)));
        if (this.getContext() instanceof SaveMemberContext) {
            member.transAggoprt(POIUtils.getStringValue((Cell)row.getCell(index++)), (SaveMemberContext)this.getContext());
            member.transAccountType(POIUtils.getStringValue((Cell)row.getCell(index++)), (SaveMemberContext)this.getContext());
            member.transDirection(POIUtils.getStringValue((Cell)row.getCell(index++)), (SaveMemberContext)this.getContext());
        } else {
            index += 3;
        }
        if (!this.getContext().getModel().isModelByEB() && StringUtils.isNotEmpty((String)(metricStr = POIUtils.getStringValue((Cell)row.getCell(index++))))) {
            Object[] metrics = StringUtils.removeBlank((String)metricStr).split(",");
            member.setMetrics(CollectionUtils.asSet((Object[])metrics));
        }
        List customProperties = this.getContext().getPropCache().getPropertiesByDim(this.getContext().getDimNumber());
        for (CustomProperty _property : customProperties) {
            member.addPropValue(_property.getNumber(), POIUtils.getStringValue((Cell)row.getCell(index++)));
        }
        return member;
    }

    @Override
    public AccountMemberExcelVO createExcelVo() {
        return new AccountMemberExcelVO();
    }

    @Override
    public boolean checkUpdate(MemberExcelVO excelVO, DimensionViewMember current) {
        boolean isUpdate = super.checkUpdate(excelVO, current);
        if (!isUpdate) {
            AccountMemberExcelVO accountVO = (AccountMemberExcelVO)excelVO;
            isUpdate = StringUtils.notEquals((String)excelVO.getShowNumber(), (String)current.getShowNumber()) || StringUtils.notEquals((ILocaleString)excelVO.getSimpleName(), (ILocaleString)current.getSimpleName(), (boolean)true) || StringUtils.notEquals((String)accountVO.getAccountType(), (String)current.getAccountType()) || StringUtils.notEquals((String)accountVO.getDrcrdirect(), (String)current.getDrcrdirect()) || this.checkMetric(accountVO, current);
        }
        return isUpdate;
    }

    protected boolean checkMetric(AccountMemberExcelVO excelVO, DimensionViewMember current) {
        boolean isUpdate = excelVO.getMetrics() != null && current.getMetrics() != null ? !excelVO.getMetrics().equals(current.getMetrics()) : excelVO.getMetrics() != null || current.getMetrics() != null;
        return isUpdate;
    }

    @Override
    public boolean checkViewUpdate(MemberExcelVO excelVO, DimensionViewMember current) {
        boolean isUpdate = super.checkViewUpdate(excelVO, current);
        if (!isUpdate) {
            isUpdate = StringUtils.notEquals((ILocaleString)excelVO.getSimpleName(), (ILocaleString)current.getSimpleName(), (boolean)true);
        }
        return isUpdate;
    }

    @Override
    public DynamicObject toMemberObject(MemberExcelVO excelVO, Map<Object, DynamicObject> updateObjects) {
        DynamicObject object = super.toMemberObject(excelVO, updateObjects);
        if (object != null) {
            AccountMemberExcelVO account = (AccountMemberExcelVO)excelVO;
            object.set("accounttype", (Object)account.getAccountType());
            object.set("drcrdirect", (Object)account.getDrcrdirect());
            if (account.isAddNew()) {
                object.set("dataset", (Object)this.getContext().getDatasetId());
                if (CollectionUtils.isEmpty(account.getMetrics())) {
                    if (StringUtils.equals((String)"50", (String)account.getAccountType())) {
                        account.addMetric("Money");
                    } else {
                        account.addMetric("Amount");
                    }
                }
            }
            this.dealMetrics(account, object);
        }
        return object;
    }

    @Override
    public DynamicObject toViewMemberObject(MemberExcelVO excelVO, Map<Object, DynamicObject> updateViewObjects) {
        return super.toViewMemberObject(excelVO, updateViewObjects);
    }

    protected void dealMetrics(AccountMemberExcelVO excelVO, DynamicObject object) {
        if (this.getContext().getModel().isModelByEB()) {
            return;
        }
        DynamicObjectCollection metrics = object.getDynamicObjectCollection("entryentity");
        metrics.clear();
        if (excelVO.getMetrics() != null) {
            for (String metric : excelVO.getMetrics()) {
                DynamicObject refMetric = metrics.addNew();
                DynamicObject sysMetric = this.getMetrics().get(metric);
                refMetric.set("databytime", (Object)"0");
                refMetric.set("skip", (Object)"0");
                refMetric.set("metricdescription", (Object)"");
                if ("Amount".equals(metric)) {
                    refMetric.set("change", (Object)6);
                } else {
                    refMetric.set("change", (Object)1);
                }
                refMetric.set("istopoly", (Object)sysMetric.getBoolean("isagg"));
                refMetric.set("metric", (Object)sysMetric.getString("id"));
            }
        }
    }

    protected Map<String, DynamicObject> getMetrics() {
        return ((SaveMemberContext)this.getContext()).getVoAssistUtils().getMetric(this.getContext().getModel().getId());
    }
}

