/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.service.view.bean.utils;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.entity.property.CustomProperty;
import kd.epm.eb.common.enums.OffsetEntrySourceEnum;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.excelImport.POIUtils;
import kd.epm.eb.olap.service.view.bean.DimensionViewMember;
import kd.epm.eb.olap.service.view.bean.utils.MemberVoUtils;
import kd.epm.eb.olap.service.view.bean.vo.EntityMemberExcelVO;
import kd.epm.eb.olap.service.view.bean.vo.IMemberVO;
import kd.epm.eb.olap.service.view.bean.vo.MemberExcelVO;
import kd.epm.eb.olap.service.view.context.IMemberContext;
import kd.epm.eb.olap.service.view.context.SaveMemberContext;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

public class EntityMemberVoUtils
extends MemberVoUtils {
    private Long currencyId = null;

    public EntityMemberVoUtils(IMemberContext context) {
        super(context);
    }

    @Override
    public String getFields() {
        String fields = super.getFields();
        fields = fields + ",currency.id,owner.id,executor.id";
        return fields;
    }

    @Override
    public String getViewFields() {
        String viewFields = super.getViewFields();
        viewFields = viewFields + ",isoffsetentry,disable";
        return viewFields;
    }

    @Override
    public IMemberVO toMember(Row row) {
        int index = 0;
        EntityMemberExcelVO member = new EntityMemberExcelVO();
        member.setRowIndex(row.getRowNum());
        member.setNumber(POIUtils.getStringValue((Cell)row.getCell(index++)));
        if (!this.getContext().getModel().isModelByEB()) {
            member.setShowNumber(POIUtils.getStringValue((Cell)row.getCell(index++)));
        }
        member.setName(POIUtils.getStringValue((Cell)row.getCell(index++)));
        member.setSimpleName(POIUtils.getStringValue((Cell)row.getCell(index++)));
        member.setParentNumber(POIUtils.getStringValue((Cell)row.getCell(index++)));
        if (this.getContext() instanceof SaveMemberContext) {
            member.transAggoprt(POIUtils.getStringValue((Cell)row.getCell(index++)), (SaveMemberContext)this.getContext());
        }
        int n = ++index;
        member.setOwnerName(POIUtils.getStringValue((Cell)row.getCell(n)));
        int n2 = ++index;
        member.setOwnerNumber(POIUtils.getStringValue((Cell)row.getCell(n2)));
        int n3 = ++index;
        member.setExecutorName(POIUtils.getStringValue((Cell)row.getCell(n3)));
        int n4 = ++index;
        ++index;
        member.setExecutorNumber(POIUtils.getStringValue((Cell)row.getCell(n4)));
        List customProperties = this.getContext().getPropCache().getPropertiesByDim(this.getContext().getDimNumber());
        for (CustomProperty _property : customProperties) {
            member.addPropValue(_property.getNumber(), POIUtils.getStringValue((Cell)row.getCell(index++)));
        }
        member.setDescription(POIUtils.getStringValue((Cell)row.getCell(index + 5)));
        return member;
    }

    @Override
    public EntityMemberExcelVO createExcelVo() {
        return new EntityMemberExcelVO();
    }

    @Override
    public boolean checkUpdate(MemberExcelVO excelVO, DimensionViewMember current) {
        boolean isUpdate = super.checkUpdate(excelVO, current);
        if (!isUpdate) {
            boolean bl = isUpdate = StringUtils.notEquals((ILocaleString)excelVO.getSimpleName(), (ILocaleString)current.getSimpleName(), (boolean)true) || StringUtils.notEquals((String)excelVO.getDescription(), (String)current.getDescription(), (boolean)true);
            if (!isUpdate && !this.checkRefMember(excelVO)) {
                EntityMemberExcelVO _entityVO = (EntityMemberExcelVO)excelVO;
                isUpdate = !Objects.equals(_entityVO.getExecutorId(), current.getExecutorId()) || !Objects.equals(_entityVO.getOwnerId(), current.getOwnerId());
            }
        }
        return isUpdate;
    }

    @Override
    public boolean checkViewUpdate(MemberExcelVO excelVO, DimensionViewMember current) {
        boolean isUpdate = super.checkViewUpdate(excelVO, current);
        if (!isUpdate) {
            isUpdate = StringUtils.notEquals((ILocaleString)excelVO.getSimpleName(), (ILocaleString)current.getSimpleName(), (boolean)true);
        }
        return isUpdate;
    }

    public Long getCurrencyId() {
        if (this.currencyId == null) {
            QFBuilder builder = new QFBuilder();
            builder.add("model", "=", (Object)this.getContext().getModel().getId());
            builder.add("number", "=", (Object)"CNY");
            DynamicObject object = QueryServiceHelper.queryOne((String)"epm_currencymembertree", (String)"id", (QFilter[])builder.toArray());
            this.currencyId = object != null ? Long.valueOf(object.getLong("id")) : Long.valueOf(0L);
        }
        return this.currencyId;
    }

    @Override
    public DynamicObject toMemberObject(MemberExcelVO excelVO, Map<Object, DynamicObject> updateObjects) {
        DynamicObject object = super.toMemberObject(excelVO, updateObjects);
        if (object != null) {
            EntityMemberExcelVO entityVO = (EntityMemberExcelVO)excelVO;
            if (excelVO.isAddNew()) {
                object.set("offsetsource", (Object)OffsetEntrySourceEnum.IGNORE.getIndex());
                object.set("isoffsetentry", (Object)"0");
                object.set("mergernode", (Object)"0");
                object.set("isinnerorg", (Object)"0");
                object.set("isouterorg", (Object)"0");
                object.set("currency", (Object)this.getCurrencyId());
            }
            if (!this.checkRefMember(excelVO)) {
                object.set("owner", (Object)entityVO.getOwnerId());
                object.set("executor", (Object)entityVO.getExecutorId());
            }
        }
        return object;
    }

    @Override
    public DynamicObject toViewMemberObject(MemberExcelVO excelVO, Map<Object, DynamicObject> updateViewObjects) {
        return super.toViewMemberObject(excelVO, updateViewObjects);
    }
}

