/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.service.view.bean.utils;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.entity.property.CustomProperty;
import kd.epm.eb.common.entity.property.CustomPropertyUtils;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.enums.dimensionEnums.ViewMemberSourceEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.excelImport.POIUtils;
import kd.epm.eb.olap.service.view.bean.DimensionViewMember;
import kd.epm.eb.olap.service.view.bean.vo.IMemberVO;
import kd.epm.eb.olap.service.view.bean.vo.MemberExcelVO;
import kd.epm.eb.olap.service.view.context.IMemberContext;
import kd.epm.eb.olap.service.view.context.SaveMemberContext;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

public class MemberVoUtils {
    private final IMemberContext context;
    private Boolean customProperty = null;

    protected IMemberContext getContext() {
        return this.context;
    }

    public MemberVoUtils(IMemberContext context) {
        this.context = context;
    }

    public Long getId(MemberExcelVO excelVO, boolean hasView) {
        if (hasView) {
            return excelVO.getViewMemberId();
        }
        return excelVO.getId();
    }

    public String getFields() {
        String fields = "id,number,name,longnumber,shownumber,aggoprt,membersource,isleaf,level,dseq,description,modifier,modifytime,parent.id";
        if (Dimension.hasSimpleName((String)this.getContext().getMemberModel())) {
            fields = fields + ",simpleName";
        }
        if (this.getContext().hasCustomProperty()) {
            fields = fields + ",propertyentry.id,propertyentry.seq,propertyentry.propertyvalue";
        }
        return fields;
    }

    public String getViewFields() {
        String fields = "id,memberid,number,name,longnumber,shownumber,aggoprt,membersource,isleaf,level,dseq,modifier,modifydate,parent.id";
        if (Dimension.hasSimpleName((String)this.getContext().getMemberModel())) {
            fields = fields + ",simpleName";
        }
        return fields;
    }

    public IMemberVO toMember(Row row) {
        if (row == null) {
            return null;
        }
        int index = 0;
        MemberExcelVO member = this.createExcelVo();
        member.setRowIndex(row.getRowNum());
        member.setNumber(POIUtils.getStringValue((Cell)row.getCell(index++)));
        if (!this.getContext().getModel().isModelByEB()) {
            member.setShowNumber(POIUtils.getStringValue((Cell)row.getCell(index++)));
        }
        member.setName(POIUtils.getStringValue((Cell)row.getCell(index++)));
        member.setParentNumber(POIUtils.getStringValue((Cell)row.getCell(index++)));
        if (this.getContext() instanceof SaveMemberContext) {
            member.transAggoprt(POIUtils.getStringValue((Cell)row.getCell(index)), (SaveMemberContext)this.getContext());
        }
        return member;
    }

    public MemberExcelVO createExcelVo() {
        return new MemberExcelVO();
    }

    public boolean checkUpdate(MemberExcelVO excelVO, DimensionViewMember current) {
        if (!this.getContext().hasView()) {
            excelVO.setUpdateParent(StringUtils.notEquals((String)excelVO.getParentNumber(), (String)current.getParentNumber()));
        }
        return StringUtils.notEquals((ILocaleString)excelVO.getName(), (ILocaleString)current.getName(), (boolean)true) || excelVO.isUpdateParent() || StringUtils.notEquals((String)excelVO.getAggoprt(), (String)current.getAggoprt()) || this.checkCustomProperty(excelVO, current);
    }

    public boolean checkViewUpdate(MemberExcelVO excelVO, DimensionViewMember current) {
        excelVO.setUpdateParentView(StringUtils.notEquals((String)excelVO.getParentNumber(), (String)current.getParentNumber()));
        return StringUtils.notEquals((String)excelVO.getShowNumber(), (String)current.getShowNumber()) || StringUtils.notEquals((ILocaleString)excelVO.getName(), (ILocaleString)current.getName()) || excelVO.isUpdateParentView() || StringUtils.notEquals((String)excelVO.getAggoprt(), (String)current.getAggoprt());
    }

    protected boolean checkRefMember(MemberExcelVO excelVO) {
        return ViewMemberSourceEnum.INNER_REF == excelVO.getMemberSource() || ViewMemberSourceEnum.OUTER_REF == excelVO.getMemberSource();
    }

    protected boolean hasCustomProperty() {
        if (this.customProperty == null) {
            this.customProperty = CustomPropertyUtils.hasCustomPropertyByEntityNumber((String)this.getContext().getMemberModel());
        }
        return this.customProperty;
    }

    protected boolean checkCustomProperty(MemberExcelVO excelVO, DimensionViewMember current) {
        if (!this.hasCustomProperty()) {
            return false;
        }
        return CollectionUtils.notEquals(excelVO.getPropValues(), current.getPropValues());
    }

    public DynamicObject toMemberObject(MemberExcelVO excelVO, Map<Object, DynamicObject> updateObjects) {
        if (!excelVO.isAddNew() && !excelVO.isUpdate()) {
            return null;
        }
        DynamicObject object = this.getObject(excelVO, updateObjects);
        this.dealBasePropInfo(excelVO, object);
        if (excelVO.isUpdate()) {
            object.set("id", (Object)excelVO.getId());
        } else {
            if (IDUtils.isNull((Long)excelVO.getId())) {
                excelVO.setId(DBServiceHelper.genGlobalLongId());
                excelVO.setMemberId(excelVO.getId());
            }
            object.set("id", (Object)excelVO.getId());
            this.dealAddNewBasePropInfo(excelVO, object);
            object.set("storagetype", (Object)"2");
            object.set("masterid", (Object)object.getLong("id"));
            object.set("creator", (Object)this.getContext().getUserId());
            object.set("createtime", (Object)this.getContext().getTime());
            object.set("membersource", (Object)MemberSourceEnum.FILE_IMPORT.getIndex());
        }
        object.set("level", (Object)excelVO.getLevel());
        object.set("dseq", (Object)excelVO.getSeq());
        object.set("longnumber", (Object)excelVO.getLongNumber());
        object.set("parent", (Object)excelVO.getParentId());
        object.set("modifier", (Object)this.getContext().getUserId());
        object.set("modifytime", (Object)this.getContext().getTime());
        object.set("description", (Object)excelVO.getDescription());
        this.dealCustomProperty(excelVO, object);
        return object;
    }

    protected DynamicObject getObject(MemberExcelVO excelVO, Map<Object, DynamicObject> updateObjects) {
        return excelVO.isUpdate() ? updateObjects.get(excelVO.getId()) : BusinessDataServiceHelper.newDynamicObject((String)this.getContext().getMemberModel());
    }

    public DynamicObject toViewMemberObject(MemberExcelVO excelVO, Map<Object, DynamicObject> updateViewObjects) {
        if (!excelVO.isAddNewView() && !excelVO.isUpdateView()) {
            return null;
        }
        DynamicObject object = this.getViewObject(excelVO, updateViewObjects);
        this.dealBasePropInfo(excelVO, object);
        if (excelVO.isUpdateView()) {
            object.set("id", (Object)excelVO.getViewMemberId());
        } else {
            if (IDUtils.isNotNull((Long)excelVO.getViewMemberId())) {
                object.set("id", (Object)excelVO.getViewMemberId());
            } else {
                object.set("id", (Object)DBServiceHelper.genGlobalLongId());
            }
            this.dealAddNewBasePropInfo(excelVO, object);
            object.set("view", (Object)this.getContext().getViewId());
            object.set("memberid", (Object)excelVO.getMemberId());
            object.set("membersource", (Object)excelVO.getMemberSourceIndex());
            if ((excelVO.getMemberSource() == ViewMemberSourceEnum.INNER_REF || excelVO.getMemberSource() == ViewMemberSourceEnum.OUTER_REF) && IDUtils.isNotNull((Long)excelVO.getRefViewId())) {
                object.set("refview", (Object)excelVO.getRefViewId());
            }
        }
        object.set("level", (Object)excelVO.getViewLevel());
        object.set("dseq", (Object)excelVO.getViewSeq());
        object.set("longnumber", (Object)excelVO.getViewLongNumber());
        object.set("parent", (Object)excelVO.getViewParentId());
        object.set("modifier", (Object)this.getContext().getUserId());
        object.set("modifydate", (Object)this.getContext().getTime());
        return object;
    }

    protected DynamicObject getViewObject(MemberExcelVO excelVO, Map<Object, DynamicObject> updateObjects) {
        return excelVO.isUpdateView() ? updateObjects.get(excelVO.getViewMemberId()) : BusinessDataServiceHelper.newDynamicObject((String)"eb_viewmember");
    }

    protected void dealAddNewBasePropInfo(MemberExcelVO excelVO, DynamicObject object) {
        object.set("model", (Object)this.getContext().getModel().getId());
        object.set("dimension", (Object)this.getContext().getDimensionId());
        object.set("number", (Object)excelVO.getNumber());
        object.set("status", (Object)"C");
        object.set("enable", (Object)"1");
        object.set("disable", (Object)"0");
    }

    protected void dealBasePropInfo(MemberExcelVO excelVO, DynamicObject object) {
        if (excelVO == null || object == null) {
            return;
        }
        object.set("name", (Object)excelVO.getName());
        if (Dimension.hasSimpleName((String)this.getContext().getMemberModel())) {
            object.set("simpleName", (Object)excelVO.getSimpleName());
        }
        object.set("longnumber", (Object)excelVO.getLongNumber());
        if (this.getContext().getModelCache().getModelobj().isModelByEB()) {
            object.set("shownumber", (Object)excelVO.getNumber());
        } else {
            object.set("shownumber", (Object)excelVO.getShowNumber());
        }
        object.set("aggoprt", (Object)excelVO.getAggoprt());
        object.set("modifier", (Object)this.getContext().getUserId());
    }

    protected void dealCustomProperty(MemberExcelVO excelVO, DynamicObject object) {
        List<CustomProperty> properties;
        if (excelVO.getMemberSource() == ViewMemberSourceEnum.INNER_REF || excelVO.getMemberSource() == ViewMemberSourceEnum.OUTER_REF) {
            return;
        }
        if (this.getContext().hasCustomProperty() && !(properties = this.getContext().getProperties()).isEmpty()) {
            DynamicObjectCollection entry = object.getDynamicObjectCollection("propertyentry");
            entry.clear();
            int dseq = 1;
            if (excelVO.getPropValues() != null) {
                for (CustomProperty _property : properties) {
                    CustomPropertyValue propertyValue;
                    String propValue = excelVO.getPropValues().get(_property.getNumber());
                    if (!StringUtils.isNotEmpty((String)propValue) || (propertyValue = this.getContext().getPropCache().getPropertyValue(this.getContext().getDimNumber(), _property.getNumber(), propValue)) == null) continue;
                    DynamicObject propertyValueObj = entry.addNew();
                    propertyValueObj.set("seq", (Object)dseq++);
                    propertyValueObj.set("propertyvalue", (Object)propertyValue.getId());
                }
            }
        }
    }
}

