/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.service.view.context;

import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.lang.Lang;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.entity.property.CustomProperty;
import kd.epm.eb.common.entity.property.CustomPropertyUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.olap.service.view.context.IMemberContext;
import kd.epm.eb.olap.service.view.context.MemberOperEnum;
import kd.epm.eb.olap.service.view.context.MemberOperationSourceEnum;
import org.jetbrains.annotations.NotNull;

public class MemberContext
implements IMemberContext {
    private final IModelCacheHelper modelCache;
    private MemberPropCache propCache = null;
    private final String dimNumber;
    private final String memberModel;
    private final String memberTable;
    private final Long dimensionId;
    private final Long viewId;
    private Long datasetId = null;
    private final Long userId;
    private final Date date;
    private final Lang lang;
    private boolean checkPermission = true;
    private Long permissionUserId = null;
    private Boolean customProperty = null;
    private List<CustomProperty> properties = null;
    private Dimension dimension = null;
    private View view = null;
    private Boolean hasView = null;
    private MemberOperEnum operation = MemberOperEnum.ADD;
    private MemberOperationSourceEnum operationSource = MemberOperationSourceEnum.EXCEL;

    @Override
    public void setCheckPermission(boolean checkPermission) {
        this.checkPermission = checkPermission;
    }

    @Override
    public boolean isCheckPermission() {
        return this.checkPermission;
    }

    @Override
    public void setPermissionUserId(Long permissionUserId) {
        this.permissionUserId = permissionUserId;
    }

    @Override
    public Long getPermissionUserId() {
        return this.permissionUserId;
    }

    public MemberContext(@NotNull IModelCacheHelper modelCache, @NotNull String dimNumber, String memberModel, String memberTable, Long viewId) {
        this.modelCache = modelCache;
        this.dimNumber = dimNumber;
        this.memberModel = memberModel;
        this.memberTable = memberTable;
        this.viewId = viewId;
        this.dimensionId = modelCache.getDimension(dimNumber).getId();
        this.userId = UserUtils.getUserId();
        this.lang = RequestContext.get().getLang();
        this.date = new Date();
    }

    @Override
    public IModelCacheHelper getModelCache() {
        return this.modelCache;
    }

    @Override
    public MemberPropCache getPropCache() {
        if (this.propCache == null) {
            this.propCache = MemberPropCacheService.getOrCreate((Long)this.getModelCache().getModelobj().getId());
        }
        return this.propCache;
    }

    @Override
    public boolean hasCustomProperty() {
        if (this.customProperty == null) {
            this.customProperty = CustomPropertyUtils.hasCustomPropertyByEntityNumber((String)this.getMemberModel());
        }
        return this.customProperty;
    }

    @Override
    public List<CustomProperty> getProperties() {
        if (this.properties == null) {
            this.properties = this.getPropCache().getPropertiesByDim(this.getDimNumber());
        }
        return this.properties;
    }

    @Override
    public Model getModel() {
        return this.getModelCache().getModelobj();
    }

    @Override
    public String getDimNumber() {
        return this.dimNumber;
    }

    @Override
    public Long getDimensionId() {
        return this.dimensionId;
    }

    @Override
    public String getMemberModel() {
        return this.memberModel;
    }

    @Override
    public String getMemberTable() {
        return this.memberTable;
    }

    @Override
    public Dimension getDimension() {
        if (this.dimension == null) {
            this.dimension = this.getModelCache().getDimension(this.getDimensionId());
        }
        return this.dimension;
    }

    @Override
    public Long getViewId() {
        return this.viewId;
    }

    @Override
    public View getView() {
        if (this.view == null) {
            this.view = this.getDimension().getView(this.getViewId());
        }
        return this.view;
    }

    @Override
    public boolean hasView() {
        if (this.hasView == null) {
            this.hasView = !View.NoViewDimNums.contains(this.getDimNumber()) && !this.getModel().isModelByEB();
        }
        return this.hasView;
    }

    @Override
    public void setDatasetId(Long datasetId) {
        this.datasetId = datasetId;
    }

    @Override
    public Long getDatasetId() {
        return this.datasetId;
    }

    @Override
    public Long getUserId() {
        return this.userId;
    }

    @Override
    public Date getTime() {
        return this.date;
    }

    @Override
    public Lang getLang() {
        return this.lang;
    }

    @Override
    public void setOperationType(MemberOperEnum operation) {
        this.operation = operation;
    }

    @Override
    public MemberOperEnum getOperationType() {
        if (this.operation == null) {
            this.operation = MemberOperEnum.ADD;
        }
        return this.operation;
    }

    @Override
    public MemberOperationSourceEnum getOperationSource() {
        if (this.operationSource == null) {
            this.operationSource = MemberOperationSourceEnum.EXCEL;
        }
        return this.operationSource;
    }

    @Override
    public void setOperationSource(MemberOperationSourceEnum operationSource) {
        this.operationSource = operationSource;
    }
}

