/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.service.view.valid;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.olap.service.view.bean.DimensionViewMember;
import kd.epm.eb.olap.service.view.bean.vo.AccountMemberExcelVO;
import kd.epm.eb.olap.service.view.bean.vo.IMemberVO;
import kd.epm.eb.olap.service.view.context.IMemberContext;
import kd.epm.eb.olap.service.view.context.SaveMemberContext;
import kd.epm.eb.olap.service.view.valid.MemberExtExcelImportValidator;
import kd.epm.eb.olap.service.view.valid.ValidResult;

public class AccountExcelImportValidator
extends MemberExtExcelImportValidator {
    private final Map<Long, DynamicObject> datasetMap = Maps.newLinkedHashMap();

    public static AccountExcelImportValidator get(IMemberContext context) {
        return new AccountExcelImportValidator(context);
    }

    public AccountExcelImportValidator(IMemberContext context) {
        super(context);
    }

    @Override
    public ValidResult<String> $valid(IMemberVO member) {
        ValidResult<String> valid = super.$valid(member);
        if (valid.isOk() && member instanceof AccountMemberExcelVO) {
            AccountMemberExcelVO _excelVO = (AccountMemberExcelVO)member;
            SaveMemberContext context = (SaveMemberContext)this.getContext();
            this.checkDataset(_excelVO);
            this.checkAccountType(_excelVO);
            this.checkDebitCredit(_excelVO);
            this.checkMetric(_excelVO, context);
        }
        return valid;
    }

    protected void checkDataset(AccountMemberExcelVO excelVO) {
        DimensionViewMember current = this.getMemValidator().getDbDimMemberMap().get(excelVO.getNumber());
        if (current != null && !Objects.equals(current.getDatasetId(), this.getContext().getDatasetId())) {
            DynamicObject dataset = this.getDataset(current.getDatasetId());
            throw new KDBizException(ResManager.loadResFormat((String)"\u8be5\u7f16\u7801\u5df2\u5b58\u5728\u4e8e\u6570\u636e\u96c6%1\u3002", (String)"AccountMemberImport_5", (String)"epm-eb-formplugin", (Object[])new Object[]{dataset.getString("name")}));
        }
        DimensionViewMember parent = this.getMemValidator().getDbDimMemberMap().get(excelVO.getParentNumber());
        if (parent != null && StringUtils.notEquals((String)"Account", (String)parent.getNumber()) && !Objects.equals(this.getContext().getDatasetId(), parent.getDatasetId())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u7ea7\u4e0d\u5c5e\u4e8e\u5f53\u524d\u6570\u636e\u96c6\u3002", (String)"AccountMemberImport_69", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private DynamicObject getDataset(Long datasetId) {
        return this.datasetMap.computeIfAbsent(datasetId, f -> DatasetServiceHelper.loadDatasets((Long)datasetId));
    }

    protected void checkAccountType(AccountMemberExcelVO excelVO) {
        if (StringUtils.isEmpty((String)excelVO.getAccountType())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u79d1\u76ee\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u4e0d\u5141\u8bb8\u66f4\u65b0\u3002", (String)"AccountMemberImport_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    protected void checkDebitCredit(AccountMemberExcelVO excelVO) {
        if (StringUtils.isEmpty((String)excelVO.getDrcrdirect())) {
            excelVO.setDrcrdirect("0");
        }
        if (StringUtils.equals((String)excelVO.getAccountType(), (String)"51")) {
            excelVO.setDrcrdirect("0");
        }
    }

    protected void checkMetric(AccountMemberExcelVO excelVO, SaveMemberContext context) {
        if (CollectionUtils.isNotEmpty(excelVO.getMetrics())) {
            if (excelVO.getMetrics().size() > 6) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5ea6\u91cf\u6700\u591a\u53ea\u80fd\u5bfc\u51656\u4e2a\uff0c\u8bf7\u68c0\u67e5\u5ea6\u91cf\u6570\u91cf\u3002", (String)"AccountMemberImport_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (excelVO.getMetrics().contains("Metric")) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u80fd\u4f7f\u7528Metric\u5ea6\u91cf\u6210\u5458\u3002", (String)"AccountMemberImport_35", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            LinkedHashSet notExist = Sets.newLinkedHashSetWithExpectedSize((int)excelVO.getMetrics().size());
            for (String _metricNum : excelVO.getMetrics()) {
                if (context.getVoAssistUtils().getMetric(context.getModel().getId()).containsKey(_metricNum)) continue;
                notExist.add(_metricNum);
            }
            if (!notExist.isEmpty()) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u7cfb\u7edf\u4e2d\u6ca1\u6709\u5ea6\u91cf\uff1a%1\u3002", (String)"AccountMemberImport_19", (String)"epm-eb-formplugin", (Object[])new Object[]{StringUtils.join((Collection)notExist, (char)',')}));
            }
        }
    }

    @Override
    protected ValidResult<String> $batchValid(Map<String, IMemberVO> members) {
        return super.$batchValid(members);
    }
}

