/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.service.view.valid;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.olap.service.view.bean.vo.EntityMemberExcelVO;
import kd.epm.eb.olap.service.view.bean.vo.IMemberVO;
import kd.epm.eb.olap.service.view.context.IMemberContext;
import kd.epm.eb.olap.service.view.valid.MemberExtExcelImportValidator;
import kd.epm.eb.olap.service.view.valid.ValidResult;

public class EntityExcelImportValidator
extends MemberExtExcelImportValidator {
    public static EntityExcelImportValidator get(IMemberContext context) {
        return new EntityExcelImportValidator(context);
    }

    public EntityExcelImportValidator(IMemberContext context) {
        super(context);
    }

    @Override
    protected ValidResult<String> $valid(IMemberVO member) {
        return super.$valid(member);
    }

    @Override
    protected ValidResult<String> $batchValid(Map<String, IMemberVO> members) {
        ValidResult<String> valid = super.$batchValid(members);
        if (valid.isOk()) {
            EntityMemberExcelVO excelVO;
            LinkedHashSet userNumbers = Sets.newLinkedHashSet();
            LinkedHashSet userNames = Sets.newLinkedHashSet();
            for (IMemberVO _member : members.values()) {
                if (!(_member instanceof EntityMemberExcelVO)) continue;
                excelVO = (EntityMemberExcelVO)_member;
                if (StringUtils.isNotEmpty((String)excelVO.getExecutorNumber())) {
                    userNumbers.add(excelVO.getExecutorNumber());
                } else if (StringUtils.isNotEmpty((String)excelVO.getExecutorName())) {
                    userNames.add(excelVO.getExecutorName());
                }
                if (StringUtils.isNotEmpty((String)excelVO.getOwnerNumber())) {
                    userNumbers.add(excelVO.getOwnerNumber());
                    continue;
                }
                if (!StringUtils.isNotEmpty((String)excelVO.getOwnerName())) continue;
                userNames.add(excelVO.getOwnerName());
            }
            if (!userNumbers.isEmpty() || !userNames.isEmpty()) {
                HashMap userNameMap = Maps.newHashMapWithExpectedSize((int)userNames.size());
                DynamicObjectCollection users = this.queryUserByNumber(userNumbers);
                Map<String, Long> userNumberMap = users.stream().collect(Collectors.toMap(u -> u.getString("number"), u -> u.getLong("id")));
                users = this.queryUserByName(userNames);
                for (DynamicObject _user : users) {
                    Set tmpSet = userNameMap.computeIfAbsent(_user.getString("name"), f -> Sets.newHashSet());
                    tmpSet.add(_user.getLong("id"));
                }
                for (IMemberVO _member : members.values()) {
                    if (!(_member instanceof EntityMemberExcelVO)) continue;
                    excelVO = (EntityMemberExcelVO)_member;
                    if (StringUtils.isNotEmpty((String)excelVO.getExecutorNumber())) {
                        excelVO.setExecutorId(this.dealUserNumber(excelVO, excelVO.getExecutorNumber(), userNumberMap, valid));
                    } else if (StringUtils.isNotEmpty((String)excelVO.getExecutorName())) {
                        excelVO.setExecutorId(this.dealUserName(excelVO, excelVO.getExecutorName(), userNameMap, valid));
                    }
                    if (StringUtils.isNotEmpty((String)excelVO.getOwnerNumber())) {
                        excelVO.setOwnerId(this.dealUserNumber(excelVO, excelVO.getOwnerNumber(), userNumberMap, valid));
                        continue;
                    }
                    if (!StringUtils.isNotEmpty((String)excelVO.getOwnerName())) continue;
                    excelVO.setOwnerId(this.dealUserName(excelVO, excelVO.getOwnerName(), userNameMap, valid));
                }
            }
        }
        return valid;
    }

    protected DynamicObjectCollection queryUserByNumber(Set<String> userNumbers) {
        if (userNumbers == null || userNumbers.isEmpty()) {
            return new DynamicObjectCollection();
        }
        QFBuilder builder = new QFBuilder();
        builder.add("number", "in", userNumbers);
        return QueryServiceHelper.query((String)"bos_user", (String)"id,number", (QFilter[])builder.toArray());
    }

    protected DynamicObjectCollection queryUserByName(Set<String> userNames) {
        if (userNames == null || userNames.isEmpty()) {
            return new DynamicObjectCollection();
        }
        QFBuilder builder = new QFBuilder();
        builder.add("name", "in", userNames);
        return QueryServiceHelper.query((String)"bos_user", (String)"id,name,number", (QFilter[])builder.toArray());
    }

    protected Long dealUserNumber(EntityMemberExcelVO excelVO, String userNumber, Map<String, Long> userNumberMap, ValidResult<String> valid) {
        Long userId = userNumberMap.get(userNumber);
        if (IDUtils.isNull((Long)userId)) {
            valid.setOk(false);
            valid.getValidResultMap().put(String.valueOf(excelVO.getRowIndex()), ResManager.loadKDString((String)"\u8d23\u4efb\u4eba\u6216\u6267\u884c\u4eba\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u4eba\u5458\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u66f4\u65b0\u3002", (String)"EntityMemberImport_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return userId;
    }

    protected Long dealUserName(EntityMemberExcelVO excelVO, String userName, Map<String, Set<Long>> userNameMap, ValidResult<String> valid) {
        Set<Long> tmpSet = userNameMap.get(userName);
        if (tmpSet != null && !tmpSet.isEmpty()) {
            if (tmpSet.size() > 1) {
                valid.setOk(false);
                valid.getValidResultMap().put(String.valueOf(excelVO.getRowIndex()), ResManager.loadKDString((String)"\u8d23\u4efb\u4eba\u6216\u6267\u884c\u4eba\u5b58\u5728\u91cd\u540d\u7528\u6237\uff0c\u4e0d\u80fd\u66f4\u65b0\u3002", (String)"EntityMemberImport_35", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        } else {
            valid.setOk(false);
            valid.getValidResultMap().put(String.valueOf(excelVO.getRowIndex()), ResManager.loadKDString((String)"\u8d23\u4efb\u4eba\u6216\u6267\u884c\u4eba\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u4eba\u5458\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u66f4\u65b0\u3002", (String)"EntityMemberImport_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return tmpSet != null && !tmpSet.isEmpty() ? tmpSet.iterator().next() : null;
    }
}

