/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.service.view.valid;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.sonmodel.BgmdMainSubControlHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.olap.service.view.bean.DimensionViewMember;
import kd.epm.eb.olap.service.view.bean.vo.AccountMemberExcelVO;
import kd.epm.eb.olap.service.view.bean.vo.IMemberVO;
import kd.epm.eb.olap.service.view.bean.vo.MemberExcelVO;
import kd.epm.eb.olap.service.view.context.IMemberContext;
import kd.epm.eb.olap.service.view.context.MemberOperEnum;
import kd.epm.eb.olap.service.view.valid.AbstractValidator;
import kd.epm.eb.olap.service.view.valid.IMemberValidator;
import kd.epm.eb.olap.service.view.valid.ValidResult;

public class MainSubMemberValidator
extends AbstractValidator {
    private Map<String, Map<String, Object>> mainSubNumberValidate = null;
    private Map<String, Map<String, Object>> mainSubDataValidate = null;
    private BgmdMainSubControlHelper instance = null;
    private Boolean dimControl = null;
    private Integer modelType = null;

    public static IMemberValidator get(IMemberContext context) {
        return new MainSubMemberValidator(context);
    }

    protected Map<String, Map<String, Object>> getMainSubNumberValidate() {
        return this.mainSubNumberValidate;
    }

    protected Map<String, Map<String, Object>> getMainSubDataValidate() {
        return this.mainSubDataValidate;
    }

    protected BgmdMainSubControlHelper getInstance() {
        if (this.instance == null) {
            this.instance = BgmdMainSubControlHelper.getInstance();
        }
        return this.instance;
    }

    protected boolean isDimControl() {
        if (this.dimControl == null) {
            this.dimControl = this.getInstance().validateIsControl(this.getContext().getModel().getId(), this.getContext().getDimNumber());
        }
        return this.dimControl;
    }

    protected Integer getModelType() {
        if (this.modelType == null) {
            this.modelType = this.getInstance().checkModelType(this.getContext().getModel().getId());
        }
        return this.modelType;
    }

    public MainSubMemberValidator(IMemberContext context) {
        super(context);
    }

    public ValidResult<String> valid(IMemberVO member) {
        return ValidResult.SUCCEED;
    }

    public ValidResult<String> batchValid(Map<String, IMemberVO> members) {
        ValidResult<String> valid;
        try {
            valid = this.$batchValid(members);
        }
        catch (KDBizException ex) {
            valid = new ValidResult(ex.getMessage());
        }
        return valid;
    }

    protected ValidResult<String> $batchValid(Map<String, IMemberVO> members) {
        if (this.getContext().getModel().isModelByEB() || this.getContext().getModel().isModelByNewEB()) {
            return ValidResult.SUCCEED;
        }
        ValidResult<String> valid = new ValidResult<String>();
        Set controlFields = Collections.emptySet();
        if (CollectionUtils.isNotEmpty(members)) {
            Long modelId = this.getContext().getModel().getId();
            String dimNumber = this.getContext().getDimNumber();
            String viewNumber = this.getContext().hasView() ? this.getContext().getView().getNumber() : null;
            this.mainSubNumberValidate = this.getInstance().checkDataWhenImport(this.getContext().getMemberModel(), members.keySet(), modelId, dimNumber, viewNumber, "all", null);
            if (1 == this.getModelType()) {
                DynamicObject mainSubControl = null;
                if (MemberOperEnum.UPDATE == this.getContext().getOperationType() || MemberOperEnum.ADD_AND_UPDATE == this.getContext().getOperationType()) {
                    QFBuilder builder = new QFBuilder();
                    builder.add("basename", "=", (Object)this.getContext().getMemberModel());
                    builder.add("controlmodeltype", "=", (Object)"1");
                    builder.add("controltype", "=", (Object)"1");
                    builder.and("isenable", "=", (Object)true);
                    mainSubControl = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_mainsubset", (QFilter[])builder.toArray());
                    if (mainSubControl != null && StringUtils.isNotEmpty((String)mainSubControl.getString("controlname"))) {
                        controlFields = CollectionUtils.asSet((Object[])mainSubControl.getString("controlname").split(";"));
                    }
                }
                this.mainSubDataValidate = this.getInstance().checkDataWhenImport(this.getContext().getMemberModel(), members.keySet(), modelId, dimNumber, viewNumber, "self", mainSubControl);
            }
        }
        String mainSubErrorMsg = ResManager.loadResFormat((String)"\u4e3b\u4f53\u7cfb %1 \u7ba1\u63a7\u7684\u57fa\u7840\u8d44\u6599\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"BgmdMainSubControlHelper_1", (String)"epm-eb-formplugin", (Object[])new Object[]{this.getInstance().getMainModelName(this.getContext().getModel().getId())});
        boolean hasEntity = StringUtils.equals((String)"Entity", (String)this.getContext().getDimNumber());
        boolean hasAccount = StringUtils.equals((String)"Account", (String)this.getContext().getDimNumber());
        boolean hasSimpleName = Dimension.hasSimpleName((String)this.getContext().getMemberModel());
        for (Map.Entry<String, IMemberVO> entry : members.entrySet()) {
            Map<String, Object> dynamicObject;
            Map<String, Object> mainSubData;
            DimensionViewMember parent;
            MemberExcelVO excelVO = (MemberExcelVO)entry.getValue();
            DimensionViewMember current = this.getContext().hasView() ? this.getMemValidator().getDbViewMemberMap().get(excelVO.getNumber()) : this.getMemValidator().getDbDimMemberMap().get(excelVO.getNumber());
            if (this.isDimControl() && (parent = this.getContext().hasView() ? this.getMemValidator().getDbViewMemberMap().get(excelVO.getParentNumber()) : this.getMemValidator().getDbDimMemberMap().get(excelVO.getParentNumber())) != null && !parent.isLeaf()) {
                valid.addValidResult(excelVO.getRowIndex(), ResManager.loadKDString((String)"\u5f53\u524d\u6210\u5458\u4e3b\u4f53\u7cfb\u8bbe\u7f6e\u7ba1\u63a7\u7b56\u7565\u4e3a\u975e\u660e\u7ec6\u4e0d\u5141\u8bb8\u65b0\u589e\u4e0b\u7ea7\u3002", (String)"MainSubModel_29", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            Map<String, Object> map = mainSubData = this.getMainSubDataValidate() != null ? this.getMainSubDataValidate().get(entry.getKey()) : null;
            if (mainSubData != null) {
                if (controlFields.contains("name") && this.getInstance().validateDataWhenImport("name", excelVO.getLocaleName(), mainSubData)) {
                    valid.addValidResult(excelVO.getRowIndex(), mainSubErrorMsg);
                } else if (hasSimpleName && controlFields.contains("simplename") && this.getInstance().validateDataWhenImport("simplename", excelVO.getLocaleSimpleName(), mainSubData)) {
                    valid.addValidResult(excelVO.getRowIndex(), mainSubErrorMsg);
                } else if (controlFields.contains("parent.number") && this.getInstance().validateDataWhenImport("parent.number", excelVO.getParentNumber(), mainSubData)) {
                    valid.addValidResult(excelVO.getRowIndex(), mainSubErrorMsg);
                } else if (controlFields.contains("aggoprt") && this.getInstance().validateDataWhenImport("aggoprt", excelVO.getAggoprt(), mainSubData)) {
                    valid.addValidResult(excelVO.getRowIndex(), mainSubErrorMsg);
                }
                if (controlFields.contains("propertyvalue") && this.getContext().hasCustomProperty()) {
                    Map propertyMap = (Map)mainSubData.get("property");
                    if (StringUtils.isNotEmpty((String)((String)mainSubData.get("syncstatus"))) && CollectionUtils.notEquals((Map)propertyMap, excelVO.getPropValues())) {
                        valid.addValidResult(excelVO.getRowIndex(), mainSubErrorMsg);
                    }
                }
                if (!hasEntity && hasAccount) {
                    AccountMemberExcelVO accountVo = (AccountMemberExcelVO)excelVO;
                    if (controlFields.contains("accounttype") && this.getInstance().validateDataWhenImport("accounttype", accountVo.getAccountType(), mainSubData)) {
                        valid.addValidResult(excelVO.getRowIndex(), mainSubErrorMsg);
                    }
                }
            }
            if (current != null || (dynamicObject = this.getMainSubNumberValidate() != null ? this.getMainSubNumberValidate().get(entry.getKey()) : null) == null) continue;
            valid.addValidResult(excelVO.getRowIndex(), ResManager.loadKDString((String)"\u7f16\u7801\u4e0e\u5f53\u524d\u4f53\u7cfb\u7684\u4e3b\u4f53\u7cfb\u6216\u5b50\u4f53\u7cfb\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"BgmdMainSubControlHelper_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return valid;
    }
}

