/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.service.view.valid;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.DBServiceHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.enums.dimensionEnums.ViewMemberSourceEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.olap.service.view.ViewGroupManager;
import kd.epm.eb.olap.service.view.bean.DimensionViewMember;
import kd.epm.eb.olap.service.view.bean.utils.MemberVoUtils;
import kd.epm.eb.olap.service.view.bean.vo.IMemberVO;
import kd.epm.eb.olap.service.view.bean.vo.MemberExcelVO;
import kd.epm.eb.olap.service.view.context.IMemberContext;
import kd.epm.eb.olap.service.view.context.SaveMemberContext;
import kd.epm.eb.olap.service.view.valid.AbstractValidator;
import kd.epm.eb.olap.service.view.valid.ValidResult;

public class MemberExtExcelImportValidator
extends AbstractValidator {
    private final Map<Long, Set<Long>> viewsMap = Maps.newLinkedHashMap();
    private static final String INNER_SOURCE = ViewMemberSourceEnum.INNER_REF.getIndex();
    private static final String OUTER_SOURCE = ViewMemberSourceEnum.OUTER_REF.getIndex();

    public static MemberExtExcelImportValidator get(IMemberContext context) {
        return new MemberExtExcelImportValidator(context);
    }

    public MemberExtExcelImportValidator(IMemberContext context) {
        super(context);
    }

    public ValidResult<String> valid(IMemberVO member) {
        ValidResult<String> result;
        try {
            result = this.$valid(member);
        }
        catch (KDBizException ex) {
            result = new ValidResult(ex.getMessage());
        }
        return result;
    }

    protected Map<Long, Set<Long>> getViewsMap() {
        return this.viewsMap;
    }

    protected ValidResult<String> $valid(IMemberVO member) {
        MemberExcelVO _excelVo = (MemberExcelVO)member;
        if (StringUtils.isEmpty((String)_excelVo.getParentNumber())) {
            if (IDUtils.isNotNull((Long)this.getContext().getViewId())) {
                Member rootMember = this.getContext().getModelCache().getRootMember(this.getContext().getDimNumber(), this.getContext().getViewId());
                _excelVo.setParentNumber(rootMember.getNumber());
            } else {
                _excelVo.setParentNumber(this.getContext().getDimNumber());
            }
        }
        if (IDUtils.isNotNull((Long)_excelVo.getMemberId())) {
            DimensionViewMember sourceMember = this.getMemValidator().getAllMemberMap().get(_excelVo.getMemberId());
            if (sourceMember != null) {
                Set viewIds = this.getViewsMap().computeIfAbsent(sourceMember.getView(), f -> ViewGroupManager.getInstance().getViewsByViewId(sourceMember.getView()));
                _excelVo.setMemberSource(viewIds.contains(this.getContext().getViewId()) ? ViewMemberSourceEnum.INNER_REF : ViewMemberSourceEnum.OUTER_REF);
                _excelVo.setRefViewId(sourceMember.getView());
            } else {
                DimensionViewMember otherMember = this.getMemValidator().getOtherGroupMemberMap().get(_excelVo.getMemberId());
                if (otherMember != null) {
                    _excelVo.setMemberSource(ViewMemberSourceEnum.OUTER_REF);
                    _excelVo.setRefViewId(otherMember.getView());
                }
                if (this.getMemValidator().getGroupMemberSet().contains(_excelVo.getMemberId())) {
                    _excelVo.setMemberSource(ViewMemberSourceEnum.INNER_REF);
                }
            }
        }
        String number = _excelVo.getNumber();
        String parentNumber = _excelVo.getParentNumber();
        if (parentNumber.indexOf(13) >= 0 || parentNumber.indexOf(10) >= 0 || parentNumber.contains(" ")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u7ea7\u7f16\u7801\u5b58\u5728\u6362\u884c\u7b26\u6216\u8005\u7a7a\u683c\u3002", (String)"DimMemImportBasePlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (parentNumber.equalsIgnoreCase(number)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u7ea7\u7f16\u7801\u4e0d\u53ef\u4e0e\u81ea\u8eab\u7f16\u7801\u76f8\u540c\u3002", (String)"DimMemImportBasePlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (this.getContext().getDimension().hasUserDefinedDim() && StringUtils.equals((String)this.getContext().getDimension().getNoneNumber(), (String)parentNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u4e0d\u533a\u5206\u6210\u5458\u201d\u4e0d\u5141\u8bb8\u65b0\u589e\u4e0b\u7ea7\u6210\u5458\u3002", (String)"DefinedDimensionAction_0", (String)"epm-eb-cube", (Object[])new Object[0]));
        }
        if (this.getContext().hasView()) {
            DimensionViewMember parent = this.getMemValidator().getDbDimMemberMap().get(this.getContext().getDimNumber());
            if (parent != null) {
                String longNumber = parent.getLongNumber() + "!" + number;
                if (longNumber.length() > 728) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u957f\u7f16\u7801\u957f\u5ea6\u8d85\u8fc7728\u4e2a\u5b57\u7b26\uff0c\u8bf7\u68c0\u67e5\u5c42\u7ea7\u662f\u5426\u8fc7\u591a\u3002", (String)"DefinedDimensionAction_4", (String)"epm-eb-cube", (Object[])new Object[0]));
                }
                _excelVo.setLevel(parent.getLevel() + 1);
                _excelVo.setParentId(parent.getMemberId());
                _excelVo.setLongNumber(longNumber);
            }
            if ((parent = this.getMemValidator().getDbViewMemberMap().get(parentNumber)) != null) {
                if (parent.isDisable()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u7981\u7528\u7684\u6210\u5458\u4e0d\u5141\u8bb8\u65b0\u589e\u4e0b\u7ea7\u6210\u5458\u3002", (String)"DefinedDimensionAction_3", (String)"epm-eb-cube", (Object[])new Object[0]));
                }
                if (StringUtils.notEquals((String)_excelVo.getParentNumber(), (String)parent.getNumber())) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u7ea7\u6210\u5458\u4e0e\u7cfb\u7edf\u4e2d\u8bbe\u7f6e\u7684\u4e0a\u7ea7\u4e0d\u4e00\u81f4\u3002", (String)"DimMemImportBasePlugin_47", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                String viewLongNumber = parent.getLongNumber() + "!" + number;
                if (viewLongNumber.length() > 728) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u957f\u7f16\u7801\u957f\u5ea6\u8d85\u8fc7728\u4e2a\u5b57\u7b26\uff0c\u8bf7\u68c0\u67e5\u5c42\u7ea7\u662f\u5426\u8fc7\u591a\u3002", (String)"DefinedDimensionAction_4", (String)"epm-eb-cube", (Object[])new Object[0]));
                }
                _excelVo.setViewLevel(parent.getLevel() + 1);
                _excelVo.setViewParentId(parent.getViewMemberId());
                _excelVo.setViewLongNumber(viewLongNumber);
                _excelVo.setParentMemberId(parent.getMemberId());
                boolean hasParentInner = StringUtils.equals((String)INNER_SOURCE, (String)parent.getViewMembersource());
                boolean hasInner = StringUtils.equals((String)INNER_SOURCE, (String)_excelVo.getMemberSourceIndex());
                boolean hasOuter = StringUtils.equals((String)OUTER_SOURCE, (String)_excelVo.getMemberSourceIndex());
                DimensionViewMember current = this.getMemValidator().getDbViewMemberMap().get(_excelVo.getNumber());
                if (current != null) {
                    DimensionViewMember oldParent = this.getMemValidator().getDbViewMemberMap().get(current.getParentNumber());
                    DimensionViewMember currentDb = this.getMemValidator().getDbDimMemberMap().get(_excelVo.getNumber());
                    if (oldParent != null) {
                        hasParentInner = StringUtils.equals((String)INNER_SOURCE, (String)oldParent.getViewMembersource());
                    }
                    if (hasParentInner) {
                        if (!StringUtils.equals((String)_excelVo.getParentNumber(), (String)current.getParentNumber())) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u5f15\u7528\u6210\u5458\u4e0d\u80fd\u4fee\u6539\u5c42\u7ea7\u7ed3\u6784\u3002", (String)"DefinedDimensionAction_7", (String)"epm-eb-cube", (Object[])new Object[0]));
                        }
                        if (!StringUtils.equals((String)_excelVo.getAggoprt(), (String)current.getAggoprt())) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u5f15\u7528\u6210\u5458\u4e0d\u80fd\u4fee\u6539\u805a\u5408\u7b97\u6cd5\u3002", (String)"DefinedDimensionAction_10", (String)"epm-eb-cube", (Object[])new Object[0]));
                        }
                    }
                    if (hasInner || hasOuter) {
                        if (!StringUtils.equals((ILocaleString)_excelVo.getName(), (ILocaleString)current.getName())) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u5f15\u7528\u6210\u5458\u4e0d\u80fd\u4fee\u6539\u540d\u79f0\uff0c\u8bf7\u5728\u6e90\u89c6\u56fe\u4e0a\u4fee\u6539\u8be5\u6210\u5458\u540d\u79f0\u3002", (String)"DefinedDimensionAction_11", (String)"epm-eb-cube", (Object[])new Object[0]));
                        }
                        if (!StringUtils.equals((ILocaleString)_excelVo.getSimpleName(), (ILocaleString)current.getSimpleName(), (boolean)true)) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u5f15\u7528\u6210\u5458\u4e0d\u80fd\u4fee\u6539\u7b80\u79f0\uff0c\u8bf7\u5728\u6e90\u89c6\u56fe\u4e0a\u4fee\u6539\u8be5\u6210\u5458\u7b80\u79f0\u3002", (String)"DefinedDimensionAction_12", (String)"epm-eb-cube", (Object[])new Object[0]));
                        }
                        if (currentDb != null && !CollectionUtils.equals(currentDb.getPropValues(), _excelVo.getPropValues())) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u5f15\u7528\u6210\u5458\u4e0d\u80fd\u4fee\u6539\u81ea\u5b9a\u4e49\u5c5e\u6027\uff0c\u8bf7\u5728\u6e90\u89c6\u56fe\u4e0a\u4fee\u6539\u8be5\u6210\u5458\u81ea\u5b9a\u4e49\u5c5e\u6027\u3002", (String)"DefinedDimensionAction_13", (String)"epm-eb-cube", (Object[])new Object[0]));
                        }
                    }
                } else {
                    if (hasParentInner) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5f15\u7528\u6210\u5458\u4e0d\u5141\u8bb8\u65b0\u589e\u4e0b\u7ea7\u6210\u5458\u3002", (String)"DefinedDimensionAction_5", (String)"epm-eb-cube", (Object[])new Object[0]));
                    }
                    DimensionViewMember otherView = this.getMemValidator().getAllMemberNumMap().get(_excelVo.getNumber());
                    if (otherView == null) {
                        otherView = this.getMemValidator().getOtherGroupMemberNumMap().get(_excelVo.getNumber());
                    }
                    if (otherView != null && (hasInner || hasOuter)) {
                        _excelVo.setName(otherView.getName());
                        _excelVo.setSimpleName(otherView.getSimpleName());
                    }
                }
            }
        } else {
            DimensionViewMember parent = this.getMemValidator().getDbDimMemberMap().get(parentNumber);
            if (parent != null) {
                if (parent.isDisable()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u7981\u7528\u7684\u6210\u5458\u4e0d\u5141\u8bb8\u65b0\u589e\u4e0b\u7ea7\u6210\u5458\u3002", (String)"DefinedDimensionAction_3", (String)"epm-eb-cube", (Object[])new Object[0]));
                }
                if (StringUtils.notEquals((String)_excelVo.getParentNumber(), (String)parent.getNumber())) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u7ea7\u6210\u5458\u4e0e\u7cfb\u7edf\u4e2d\u8bbe\u7f6e\u7684\u4e0a\u7ea7\u4e0d\u4e00\u81f4\u3002", (String)"DimMemImportBasePlugin_47", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                String longNumber = parent.getLongNumber() + "!" + number;
                if (longNumber.length() > 728) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u957f\u7f16\u7801\u957f\u5ea6\u8d85\u8fc7728\u4e2a\u5b57\u7b26\uff0c\u8bf7\u68c0\u67e5\u5c42\u7ea7\u662f\u5426\u8fc7\u591a\u3002", (String)"DefinedDimensionAction_4", (String)"epm-eb-cube", (Object[])new Object[0]));
                }
                _excelVo.setLevel(parent.getLevel() + 1);
                _excelVo.setParentId(parent.getMemberId());
                _excelVo.setLongNumber(longNumber);
            }
        }
        if (StringUtils.isEmpty((String)_excelVo.getAggoprt())) {
            _excelVo.setAggoprt("1");
        }
        return ValidResult.SUCCEED;
    }

    public ValidResult<String> batchValid(Map<String, IMemberVO> members) {
        ValidResult<String> result;
        try {
            result = this.$batchValid(members);
            if (result.isOk()) {
                this.afterBatch(members, result);
            }
        }
        catch (KDBizException ex) {
            result = new ValidResult(ex.getMessage());
        }
        return result;
    }

    protected ValidResult<String> $batchValid(Map<String, IMemberVO> members) {
        ValidResult<String> _result;
        View view;
        ValidResult<String> result = new ValidResult<String>();
        DimensionViewMember rootViewMember = null;
        DimensionViewMember rootMember = this.getMemValidator().getDbDimMemberMap().get(this.getContext().getDimNumber());
        if (this.getContext().hasView() && (view = this.getContext().getDimension().getView(this.getContext().getViewId())) != null) {
            String dimMemberNum = this.getContext().getDimNumber();
            if (!"1".equals(view.getSource())) {
                dimMemberNum = this.getContext().getDimNumber() + '_' + view.getNumber();
            }
            rootViewMember = this.getMemValidator().getDbViewMemberMap().get(dimMemberNum);
        }
        if (!(_result = this.checkChildren(members)).isOk()) {
            result.mergeErrorValidResult(_result);
            return result;
        }
        for (IMemberVO member : members.values()) {
            this.dealCurrentMemberParent((MemberExcelVO)member, members, rootMember, rootViewMember, result);
        }
        return result;
    }

    protected void dealCurrentMemberParent(MemberExcelVO current, Map<String, IMemberVO> members, DimensionViewMember rootMember, DimensionViewMember rootViewMember, ValidResult<String> result) {
        if (IDUtils.isNotNull((Long)this.getContext().getViewId()) ? IDUtils.isNotNull((Long)current.getParentId()) && IDUtils.isNotNull((Long)current.getViewParentId()) : IDUtils.isNotNull((Long)current.getParentId())) {
            return;
        }
        MemberExcelVO parent = (MemberExcelVO)members.get(current.getParentNumber());
        if (parent == null) {
            result.addValidResult(current.getRowIndex(), ResManager.loadResFormat((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a(%1)\u7684\u7236\u6210\u5458\uff0c\u8bf7\u68c0\u67e5\u7236\u6210\u5458\u7f16\u7801\u662f\u5426\u6b63\u786e\u3002", (String)"DefinedDimensionAction_9", (String)"epm-eb-cube", (Object[])new Object[]{current.getParentNumber()}));
        } else {
            String longNumber;
            int seq;
            this.dealCurrentMemberParent(parent, members, rootMember, rootViewMember, result);
            if (IDUtils.isNotNull((Long)parent.getRefViewId()) && StringUtils.equals((String)INNER_SOURCE, (String)parent.getMemberSourceIndex())) {
                if (IDUtils.isNull((Long)current.getRefViewId())) {
                    result.addValidResult(current.getRowIndex(), ResManager.loadKDString((String)"\u5f15\u7528\u6210\u5458\u4e0d\u5141\u8bb8\u65b0\u589e\u4e0b\u7ea7\u6210\u5458\u3002", (String)"DefinedDimensionAction_5", (String)"epm-eb-cube", (Object[])new Object[0]));
                } else if (!IDUtils.equals((Object)parent.getRefViewId(), (Object)current.getRefViewId()) && current.isCheckParent()) {
                    result.addValidResult(current.getRowIndex(), ResManager.loadKDString((String)"\u5f15\u7528\u6210\u5458\u4e0e\u4e0d\u80fd\u5f15\u7528\u5176\u5b83\u89c6\u56fe\u7684\u4e0b\u7ea7\u6210\u5458\u3002", (String)"DefinedDimensionAction_6", (String)"epm-eb-cube", (Object[])new Object[0]));
                }
                if (current.isCheckParent()) {
                    DimensionViewMember _refMember = this.getMemValidator().getAllMemberMap().get(current.getMemberId());
                    if (_refMember != null && !StringUtils.equals((String)_refMember.getParentNumber(), (String)current.getParentNumber())) {
                        result.addValidResult(current.getRowIndex(), ResManager.loadKDString((String)"\u5f15\u7528\u6210\u5458\u4e0d\u80fd\u4fee\u6539\u5c42\u7ea7\u7ed3\u6784\u3002", (String)"DefinedDimensionAction_7", (String)"epm-eb-cube", (Object[])new Object[0]));
                    }
                    if ((_refMember = this.getMemValidator().getOtherGroupMemberMap().get(current.getMemberId())) != null && !StringUtils.equals((String)_refMember.getParentNumber(), (String)current.getParentNumber())) {
                        result.addValidResult(current.getRowIndex(), ResManager.loadKDString((String)"\u5f15\u7528\u6210\u5458\u4e0d\u80fd\u4fee\u6539\u5c42\u7ea7\u7ed3\u6784\u3002", (String)"DefinedDimensionAction_7", (String)"epm-eb-cube", (Object[])new Object[0]));
                    }
                }
            }
            if (IDUtils.isNotNull((Long)this.getContext().getViewId())) {
                String viewLongNumber = parent.getViewLongNumber() + "!" + current.getNumber();
                if (viewLongNumber.length() > 728) {
                    result.addValidResult(current.getRowIndex(), ResManager.loadKDString((String)"\u957f\u7f16\u7801\u957f\u5ea6\u8d85\u8fc7728\u4e2a\u5b57\u7b26\uff0c\u8bf7\u68c0\u67e5\u5c42\u7ea7\u662f\u5426\u8fc7\u591a\u3002", (String)"DefinedDimensionAction_4", (String)"epm-eb-cube", (Object[])new Object[0]));
                }
                if (IDUtils.isNull((Long)parent.getViewMemberId())) {
                    parent.setViewMemberId(DBServiceHelper.genGlobalLongId());
                }
                current.setViewParentId(parent.getViewMemberId());
                current.setViewLongNumber(viewLongNumber);
                current.setViewLevel(parent.getViewLevel() + 1);
                if (current.getViewSeq() == 0) {
                    seq = this.getMemValidator().getDbViewSeqMap().compute(current.getViewParentId(), (k, v) -> v != null ? v + 1 : 1);
                    current.setViewSeq(seq);
                }
                parent = new MemberExcelVO();
                parent.setId(rootMember.getMemberId());
                parent.setMemberId(rootMember.getMemberId());
                parent.setNumber(rootMember.getNumber());
                parent.setLongNumber(rootMember.getLongNumber());
                parent.setLevel(rootMember.getLevel());
            }
            if ((longNumber = parent.getLongNumber() + "!" + current.getNumber()).length() > 728) {
                result.addValidResult(current.getRowIndex(), ResManager.loadKDString((String)"\u957f\u7f16\u7801\u957f\u5ea6\u8d85\u8fc7728\u4e2a\u5b57\u7b26\uff0c\u8bf7\u68c0\u67e5\u5c42\u7ea7\u662f\u5426\u8fc7\u591a\u3002", (String)"DefinedDimensionAction_4", (String)"epm-eb-cube", (Object[])new Object[0]));
            }
            if (IDUtils.isNull((Long)parent.getId())) {
                parent.setId(DBServiceHelper.genGlobalLongId());
                parent.setMemberId(parent.getId());
            }
            current.setParentId(parent.getId());
            current.setLongNumber(longNumber);
            current.setLevel(parent.getLevel() + 1);
            if (current.getSeq() == 0) {
                seq = this.getMemValidator().getDbSeqMap().compute(current.getParentId(), (k, v) -> v != null ? v + 1 : 1);
                current.setSeq(seq);
            }
        }
    }

    protected ValidResult<String> checkChildren(Map<String, IMemberVO> members) {
        ValidResult<String> result = new ValidResult<String>();
        if (members == null || members.isEmpty()) {
            return result;
        }
        SaveMemberContext context = (SaveMemberContext)this.getContext();
        MemberVoUtils voUtils = context.getVoUtils();
        LinkedHashMap replenishMemberMap = Maps.newLinkedHashMap();
        for (IMemberVO member : members.values()) {
            MemberExcelVO excelVO = (MemberExcelVO)member;
            this.checkChildren(excelVO, excelVO, members, replenishMemberMap, voUtils, result);
        }
        if (result.isOk() && !replenishMemberMap.isEmpty()) {
            members.putAll(replenishMemberMap);
        }
        return result;
    }

    private void checkChildren(MemberExcelVO root, MemberExcelVO current, Map<String, IMemberVO> members, Map<String, IMemberVO> replenishMemberMap, MemberVoUtils voUtils, ValidResult<String> result) {
        if (IDUtils.isNull((Long)current.getRefViewId()) || IDUtils.isNull((Long)current.getMemberId())) {
            return;
        }
        ViewMemberSourceEnum source = current.getMemberSource();
        if (source == ViewMemberSourceEnum.OUTER_REF) {
            return;
        }
        LinkedHashMap tmpReplenish = Maps.newLinkedHashMap();
        Set<Long> childrenIds = this.getMemValidator().getAllMemChildMap().get(current.getMemberId());
        if (childrenIds != null) {
            for (Long childrenId : childrenIds) {
                MemberExcelVO replenishVO;
                DimensionViewMember refChild = this.getMemValidator().getAllMemberMap().get(childrenId);
                if (refChild == null) {
                    refChild = this.getMemValidator().getOtherGroupMemberMap().get(childrenId);
                }
                if (refChild == null) {
                    log.error("checkChildren-refChild-is null." + childrenId);
                    continue;
                }
                IMemberVO importVO = members.get(refChild.getNumber());
                if (importVO == null) {
                    DimensionViewMember viewMember = this.getMemValidator().getDbViewMemberMap().get(refChild.getNumber());
                    if (viewMember == null) {
                        DimensionViewMember dbMember = this.getMemValidator().getDbDimMemberIdMap().get(childrenId);
                        replenishVO = voUtils.createExcelVo();
                        replenishVO.setId(childrenId);
                        replenishVO.setMemberId(childrenId);
                        replenishVO.setMemberSource(current.getMemberSource());
                        replenishVO.setNumber(dbMember.getNumber());
                        replenishVO.setShowNumber(dbMember.getShowNumber());
                        replenishVO.setParentNumber(current.getNumber());
                        replenishVO.setAggoprt(dbMember.getAggoprt());
                        replenishVO.setName(refChild.getName());
                        replenishVO.setSimpleName(dbMember.getSimpleName());
                        replenishVO.setLongNumber(dbMember.getLongNumber());
                        replenishVO.setCheckParent(false);
                        DimensionViewMember sourceMember = this.getMemValidator().getAllMemberNumMap().get(replenishVO.getNumber());
                        if (sourceMember == null) {
                            sourceMember = this.getMemValidator().getOtherGroupMemberNumMap().get(replenishVO.getNumber());
                        }
                        replenishVO.setRefViewId(sourceMember.getView());
                        if (StringUtils.isNotEmpty((String)current.getViewLongNumber())) {
                            replenishVO.setViewLongNumber(current.getViewLongNumber() + '!' + replenishVO.getNumber());
                            if (replenishVO.getViewLongNumber().length() > 728) {
                                throw new KDBizException(ResManager.loadResFormat((String)"\u65b0\u589e\u5f15\u7528\u6210\u5458(%1)\u957f\u7f16\u7801(%2)\u957f\u5ea6\u8d85\u8fc7728\u4e2a\u5b57\u7b26\uff0c\u8bf7\u68c0\u67e5\u5c42\u7ea7\u662f\u5426\u8fc7\u591a\u3002", (String)"DefinedDimensionAction_8", (String)"epm-eb-cube", (Object[])new Object[]{replenishVO.getNumber(), replenishVO.getViewLongNumber()}));
                            }
                        }
                        if (current.getViewLevel() > 0) {
                            replenishVO.setViewLevel(current.getViewLevel() + 1);
                        }
                        if (replenishMemberMap.containsKey(replenishVO.getNumber())) {
                            result.addValidResult(root.getRowIndex(), ResManager.loadResFormat((String)"\u5f15\u5165\u7684\u6210\u5458(%1)\u7684\u4e0b\u7ea7\u6210\u5458(%2)\u5b58\u5728\u91cd\u53e0\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165\u7684\u6587\u4ef6\u3002", (String)"DefinedDimensionAction_15", (String)"epm-eb-cube", (Object[])new Object[]{root.getNumber(), replenishVO.getNumber()}));
                        } else {
                            tmpReplenish.put(refChild.getMemberId(), replenishVO);
                        }
                    } else {
                        if (StringUtils.notEquals((String)refChild.getParentNumber(), (String)current.getNumber())) {
                            result.addValidResult(root.getRowIndex(), ResManager.loadResFormat((String)"\u5df2\u7ecf\u5b58\u5728\u4e0b\u7ea7\u5f15\u7528\u6210\u5458%1\uff0c\u4e0d\u80fd\u518d\u5bfc\u5165\u4e0a\u7ea7\u5f15\u7528\u6210\u5458\u3002", (String)"DefinedDimensionAction_14", (String)"epm-eb-cube", (Object[])new Object[]{viewMember.getNumber()}));
                        }
                        replenishVO = voUtils.createExcelVo();
                        replenishVO.setViewMemberId(viewMember.getViewMemberId());
                        replenishVO.setMemberId(viewMember.getMemberId());
                        replenishVO.setViewParentId(viewMember.getParentId());
                        replenishVO.setNumber(viewMember.getNumber());
                        replenishVO.setShowNumber(viewMember.getShowNumber());
                        replenishVO.setViewLongNumber(viewMember.getLongNumber());
                        replenishVO.setViewLevel(viewMember.getLevel());
                        replenishVO.setMemberSource(source);
                    }
                } else {
                    replenishVO = (MemberExcelVO)importVO;
                    if (StringUtils.notEquals((String)replenishVO.getParentNumber(), (String)current.getNumber())) {
                        result.addValidResult(root.getRowIndex(), ResManager.loadResFormat((String)"\u5df2\u7ecf\u5b58\u5728\u4e0b\u7ea7\u5f15\u7528\u6210\u5458%1\uff0c\u4e0d\u80fd\u518d\u5bfc\u5165\u4e0a\u7ea7\u5f15\u7528\u6210\u5458\u3002", (String)"DefinedDimensionAction_14", (String)"epm-eb-cube", (Object[])new Object[]{replenishVO.getNumber()}));
                    }
                }
                if (!result.isOk()) continue;
                this.checkChildren(root, replenishVO, members, replenishMemberMap, voUtils, result);
            }
            for (IMemberVO entry : tmpReplenish.values()) {
                replenishMemberMap.put(entry.getNumber(), entry);
            }
        }
    }

    protected void afterBatch(Map<String, IMemberVO> members, ValidResult<String> valid) {
        SaveMemberContext saveMemberContext = (SaveMemberContext)this.getContext();
        for (IMemberVO _member : members.values()) {
            int seq;
            MemberExcelVO _parent;
            MemberExcelVO _excelVo = (MemberExcelVO)_member;
            DimensionViewMember current = this.getMemValidator().getDbDimMemberMap().get(_excelVo.getNumber());
            DimensionViewMember parent = this.getMemValidator().getDbDimMemberMap().get(_excelVo.getParentNumber());
            if (parent == null) {
                _parent = (MemberExcelVO)members.get(_excelVo.getParentNumber());
                _parent.setIsLeaf(false);
                parent = new DimensionViewMember();
                parent.setId(_parent.getId());
                parent.setParentId(_parent.getParentId());
            }
            _excelVo.checkAddNewOrUpdate(saveMemberContext.getVoUtils(), current);
            if (_excelVo.isUpdateParent()) {
                _excelVo.setOldParentId(current.getParentId());
                _excelVo.setOldLevel(current.getLevel());
                seq = this.getMemValidator().getDbSeqMap().compute(_excelVo.getParentId(), (k, v) -> v != null ? v + 1 : 1);
                _excelVo.setSeq(seq);
            }
            if (_excelVo.getSeq() == 0) {
                seq = this.getMemValidator().getDbSeqMap().compute(_excelVo.getParentId(), (k, v) -> v != null ? v + 1 : 1);
                _excelVo.setSeq(seq);
            }
            if (!this.getContext().hasView()) continue;
            current = this.getMemValidator().getDbViewMemberMap().get(_excelVo.getNumber());
            parent = this.getMemValidator().getDbViewMemberMap().get(_excelVo.getParentNumber());
            if (parent == null) {
                _parent = (MemberExcelVO)members.get(_excelVo.getParentNumber());
                _parent.setIsLeaf(false);
                parent = new DimensionViewMember();
                parent.setViewMemberId(_parent.getViewMemberId());
                parent.setMemberId(_parent.getId());
                parent.setParentId(_parent.getViewParentId());
            }
            _excelVo.checkAddNewOrUpdateByView(saveMemberContext.getVoUtils(), current);
            if (_excelVo.isUpdateParentView()) {
                _excelVo.setOldViewParentId(current.getParentId());
                _excelVo.setOldViewLevel(current.getLevel());
                seq = this.getMemValidator().getDbViewSeqMap().compute(_excelVo.getViewParentId(), (k, v) -> v != null ? v + 1 : 1);
                _excelVo.setViewSeq(seq);
            }
            if (_excelVo.getViewSeq() != 0) continue;
            seq = this.getMemValidator().getDbViewSeqMap().compute(_excelVo.getViewParentId(), (k, v) -> v != null ? v + 1 : 1);
            _excelVo.setViewSeq(seq);
        }
    }
}

