/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.service.view.valid;

import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.olap.service.view.bean.vo.IMemberVO;
import kd.epm.eb.olap.service.view.bean.vo.MemberExcelVO;
import kd.epm.eb.olap.service.view.context.IMemberContext;
import kd.epm.eb.olap.service.view.context.MemberOperEnum;
import kd.epm.eb.olap.service.view.valid.AbstractValidator;
import kd.epm.eb.olap.service.view.valid.IMemberValidator;
import kd.epm.eb.olap.service.view.valid.ValidResult;

public class MemberPermValidator
extends AbstractValidator {
    private boolean hasInitPerm = false;
    private Set<String> memberPerms = null;

    public static IMemberValidator get(IMemberContext context) {
        return new MemberPermValidator(context);
    }

    public Set<String> getMemberPerms() {
        if (!this.hasInitPerm) {
            Long modelId = this.getContext().getModel().getId();
            String dimensionNumber = this.getContext().getDimNumber();
            Long viewId = this.getContext().getViewId();
            this.memberPerms = IDUtils.isNotNull((Long)this.getContext().getPermissionUserId()) ? DimMembPermHelper.getPermMembNumbers((Long)this.getContext().getPermissionUserId(), (String)dimensionNumber, (Long)modelId, (Long)0L, (Long)viewId, (DimMembPermType)DimMembPermType.MANAGER, (boolean)true) : DimMembPermHelper.getPermMembNumbers((String)dimensionNumber, (Long)modelId, (Long)0L, (Long)viewId, (DimMembPermType)DimMembPermType.MANAGER, (boolean)true);
            if (this.memberPerms == null) {
                log.info("MemberPermValidator-is admin.");
            }
            this.hasInitPerm = true;
        }
        return this.memberPerms;
    }

    public MemberPermValidator(IMemberContext context) {
        super(context);
    }

    public ValidResult<String> valid(IMemberVO member) {
        return ValidResult.SUCCEED;
    }

    public ValidResult<String> batchValid(Map<String, IMemberVO> members) {
        ValidResult<String> result;
        try {
            result = this.$batchValid(members);
        }
        catch (KDBizException ex) {
            result = new ValidResult(ex.getMessage());
        }
        return result;
    }

    public ValidResult<String> $batchValid(Map<String, IMemberVO> members) {
        ValidResult<String> result = new ValidResult<String>();
        if (!this.getContext().isCheckPermission()) {
            return result;
        }
        try {
            for (IMemberVO member : members.values()) {
                boolean hasExist;
                MemberExcelVO excelVO = (MemberExcelVO)member;
                if (this.checkUpdate() && IDUtils.isNotNull((Long)excelVO.getMemberId())) {
                    if (this.getMemberPerms() == null || this.getMemberPerms().contains(excelVO.getNumber())) continue;
                    result.addValidResult(excelVO.getRowIndex(), ResManager.loadKDString((String)"\u65e0\u8be5\u6210\u5458\u7684\u65b0\u589e\u3001\u4fee\u6539\u6216\u5220\u9664\u6743\u9650\u3002", (String)"DimMemImportBasePlugin_42", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    continue;
                }
                boolean bl = hasExist = this.getContext().hasView() ? this.getMemValidator().getDbViewMemberMap().containsKey(excelVO.getParentNumber()) : this.getMemValidator().getDbDimMemberMap().containsKey(excelVO.getParentNumber());
                if (!hasExist && members.containsKey(excelVO.getParentNumber()) || this.getMemberPerms() == null || this.getMemberPerms().contains(excelVO.getParentNumber())) continue;
                result.addValidResult(excelVO.getRowIndex(), ResManager.loadKDString((String)"\u7236\u6210\u5458\u6ca1\u6709\u65b0\u589e\u4e0b\u7ea7\u6210\u5458\u7684\u6570\u636e\u6743\u9650", (String)"DimMemImportBasePlugin_43", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        catch (KDBizException ex) {
            result = new ValidResult(ex.getMessage());
        }
        return result;
    }

    private boolean checkUpdate() {
        return this.getContext().getOperationType() == MemberOperEnum.ADD_AND_UPDATE || this.getContext().getOperationType() == MemberOperEnum.UPDATE;
    }
}

