/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.service.view.valid;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableGraph;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.cache.utils.ObjectCache;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.entity.property.CustomPropertyUtils;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.ViewMemberSourceEnum;
import kd.epm.eb.common.utils.BizRequire;
import kd.epm.eb.common.utils.Builder;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.MetaUtils;
import kd.epm.eb.common.utils.MetricUtils;
import kd.epm.eb.common.utils.NameCheckUtils;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.olap.service.view.ViewGroupManager;
import kd.epm.eb.olap.service.view.bean.DimensionViewMember;
import kd.epm.eb.olap.service.view.bean.vo.IMemberVO;
import kd.epm.eb.olap.service.view.bean.vo.MemberExcelVO;
import kd.epm.eb.olap.service.view.valid.CommMemberValidator;
import kd.epm.eb.olap.service.view.valid.IMemberValidator;
import kd.epm.eb.olap.service.view.valid.ValidResult;

public class MemberValidator {
    private final IModelCacheHelper modelCache;
    private Dimension dimension = null;
    private final String dimNumber;
    private final Long viewId;
    private final Set<String> dbViewLowerNumber = Sets.newHashSet();
    private final Map<String, String> dbViewShowNumber = Maps.newLinkedHashMap();
    private final Map<String, DimensionViewMember> dbViewMemberMap = Maps.newHashMap();
    private final Map<Long, DimensionViewMember> dbViewMemberIdMap = Maps.newHashMap();
    private final Set<String> dbDimLowerNumber = Sets.newHashSet();
    private final Map<String, DimensionViewMember> dbDimMemberMap = Maps.newHashMap();
    private final Map<Long, DimensionViewMember> dbDimMemberIdMap = Maps.newHashMap();
    private final Map<Long, Integer> dbSeqMap = Maps.newLinkedHashMap();
    private final Map<Long, Integer> dbViewSeqMap = Maps.newLinkedHashMap();
    private final Map<Long, DimensionViewMember> allMemberMap = Maps.newLinkedHashMap();
    private final Set<Long> groupMemberIdSet = Sets.newLinkedHashSet();
    private final Map<Long, DimensionViewMember> otherGroupMemberMap = Maps.newLinkedHashMap();
    private final Map<String, DimensionViewMember> otherGroupMemberNumMap = Maps.newLinkedHashMap();
    private final Map<String, DimensionViewMember> allMemberNumMap = Maps.newLinkedHashMap();
    private final Map<Long, Set<Long>> allMemChildMap = Maps.newLinkedHashMap();
    private final Set<String> dbViewNameSet = Sets.newLinkedHashSet();
    private boolean hasInitData;
    private boolean singleDbCheck;
    private boolean initAllMember = false;
    private boolean initCusPropValue = false;
    private boolean initMetric = false;
    private Set<String> refNumbers = null;
    private final List<IMemberValidator> validators = Lists.newLinkedList();
    private static final Set<String> EXCLUDE_NUMBERS = new HashSet<String>();
    private DynamicObjectType dt = null;

    protected Map<String, String> getDbViewShowNumber() {
        return this.dbViewShowNumber;
    }

    public Map<Long, DimensionViewMember> getAllMemberMap() {
        return this.allMemberMap;
    }

    public Set<Long> getGroupMemberSet() {
        return this.groupMemberIdSet;
    }

    public Map<Long, DimensionViewMember> getOtherGroupMemberMap() {
        return this.otherGroupMemberMap;
    }

    public Map<String, DimensionViewMember> getOtherGroupMemberNumMap() {
        return this.otherGroupMemberNumMap;
    }

    public Map<String, DimensionViewMember> getAllMemberNumMap() {
        return this.allMemberNumMap;
    }

    public Map<Long, Set<Long>> getAllMemChildMap() {
        return this.allMemChildMap;
    }

    public Set<String> getDbViewNameSet() {
        return this.dbViewNameSet;
    }

    public void setInitAllMember(boolean initAllMember) {
        this.initAllMember = initAllMember;
    }

    public boolean isInitAllMember() {
        return this.initAllMember;
    }

    public void setInitCusPropValue(boolean initCusPropValue) {
        this.initCusPropValue = initCusPropValue;
    }

    public boolean isInitCusPropValue() {
        return this.initCusPropValue;
    }

    public void setInitMetric(boolean initMetric) {
        this.initMetric = initMetric;
    }

    public boolean isInitMetric() {
        return this.initMetric;
    }

    public void setRefNumbers(Set<String> refNumbers) {
        this.refNumbers = refNumbers;
    }

    public Set<String> getRefNumbers() {
        return this.refNumbers;
    }

    protected boolean hasVerifyName() {
        return StringUtils.equals((String)"InternalCompany", (String)this.getDimension().getNumber()) || StringUtils.equals((String)"ChangeType", (String)this.getDimension().getNumber());
    }

    public List<IMemberValidator> getValidators() {
        return this.validators;
    }

    public void registerValidator(IMemberValidator validator) {
        if (validator != null) {
            validator.setMemValidator(this);
            this.getValidators().add(validator);
        }
    }

    public MemberValidator(IModelCacheHelper modelCache, String dimNumber, Long viewId) {
        this.modelCache = modelCache;
        this.dimNumber = dimNumber;
        this.viewId = viewId;
    }

    protected IModelCacheHelper getModelCache() {
        return this.modelCache;
    }

    protected Dimension getDimension() {
        if (this.dimension == null) {
            this.dimension = this.modelCache.getDimension(this.dimNumber);
        }
        return this.dimension;
    }

    protected Long getViewId() {
        return this.viewId;
    }

    public static MemberValidator getValidator(IModelCacheHelper modelCache, String dimNumber, Long viewId) {
        return new CommMemberValidator(modelCache, dimNumber, viewId);
    }

    public ValidResult<String> valid(IMemberVO member) {
        try {
            String name = member.getLocaleName();
            BizRequire.isTrue((boolean)org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)name), (String)ResManager.loadKDString((String)"\u540d\u79f0\u4e3a\u7a7a\uff0c\u6216\u4e0d\u662f\u6587\u672c\u5185\u5bb9\u3002", (String)"DimMemImportBasePlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            BizRequire.isFalse((boolean)org.apache.commons.lang3.StringUtils.containsAny((CharSequence)name, (CharSequence[])new CharSequence[]{"\r", "\n"}), (String)ResManager.loadKDString((String)"\u540d\u79f0\u5b58\u5728\u6362\u884c\u7b26\u3002", (String)"DimMemImportBasePlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            BizRequire.isTrue((boolean)MetaUtils.verifyMetaLength((DynamicObjectType)this.getMemberDT(), (String)"name", (String)name), (String)ResManager.loadKDString((String)"\u540d\u79f0\u8fc7\u957f\u3002", (String)"DimMemImportBasePlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            if (org.apache.commons.lang3.StringUtils.equalsAny((CharSequence)this.dimNumber, (CharSequence[])new CharSequence[]{SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.Account.getNumber()}) || SysDimensionEnum.Project.getMemberTreemodel().equals(this.getDimension().getMemberModel())) {
                BizRequire.isTrue((boolean)MetaUtils.verifyMetaLength((DynamicObjectType)this.getMemberDT(), (String)"simplename", (String)member.getLocaleSimpleName()), (String)ResManager.loadKDString((String)"\u7b80\u79f0\u8fc7\u957f\u3002", (String)"DimMemImportBasePlugin_49", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.validNumber(member);
            if (!this.getValidators().isEmpty()) {
                for (IMemberValidator _validator : this.getValidators()) {
                    ValidResult<?> _tmpValid = _validator.valid(member);
                    BizRequire.isTrue((boolean)_tmpValid.isOk(), (String)_tmpValid.getErrMsg());
                }
            }
        }
        catch (KDBizException e) {
            return new ValidResult<String>(e.getMessage());
        }
        return ValidResult.SUCCEED;
    }

    public void validNumber(IMemberVO saveMember) {
        Dimension dimension;
        String number = saveMember.getNumber();
        String showNumber = saveMember.getShowNumber();
        ILocaleString name = saveMember.getName();
        if (name != null && (dimension = this.getDimension()) != null) {
            NameCheckUtils.checkViewExistNameBoolean((IModelCacheHelper)this.modelCache, (Long)dimension.getId(), (Long)this.getViewId(), (Long)saveMember.getMemberId(), (String)name.getLocaleValue(), null);
        }
        if (this.modelCache.getModelobj().isModelByEB()) {
            BizRequire.isFalse((boolean)org.apache.commons.lang3.StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{number}), (String)ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u7a7a\uff0c\u6216\u4e0d\u662f\u6587\u672c\u5185\u5bb9\u3002", (String)"DimMemImportBasePlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            BizRequire.isFalse((boolean)org.apache.commons.lang3.StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{number}), (String)ResManager.loadKDString((String)"\u5185\u7801\u4e3a\u7a7a\uff0c\u6216\u4e0d\u662f\u6587\u672c\u5185\u5bb9\u3002", (String)"DimMemImportBasePlugin_53", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            BizRequire.isFalse((boolean)org.apache.commons.lang3.StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{showNumber}), (String)ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u7a7a\uff0c\u6216\u4e0d\u662f\u6587\u672c\u5185\u5bb9\u3002", (String)"DimMemImportBasePlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String lowNumber = number.toLowerCase();
        String lowShowNumber = showNumber != null ? showNumber.toLowerCase() : "";
        boolean noSpecial = NumberCheckUtils.checkNumber((String)lowNumber);
        if (this.modelCache.getModelobj().isModelByEB()) {
            BizRequire.isTrue((boolean)noSpecial, (String)ResManager.loadKDString((String)"\u7f16\u7801\u53ef\u80fd\u5305\u542b\u4e2d\u6587\u3001\u7279\u6b8a\u5b57\u7b26\u6216\u8005\u4ee5\u7279\u6b8a\u5b57\u7b26\u5f00\u5934\u3002", (String)"DimMemImportBasePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            BizRequire.isTrue((boolean)noSpecial, (String)ResManager.loadKDString((String)"\u5185\u7801\u53ef\u80fd\u5305\u542b\u4e2d\u6587\u3001\u7279\u6b8a\u5b57\u7b26\u6216\u8005\u4ee5\u7279\u6b8a\u5b57\u7b26\u5f00\u5934\u3002", (String)"DimMemImportBasePlugin_54", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            Dimension dimension2 = this.getDimension();
            noSpecial = NumberCheckUtils.checkShowNumberBoolean((Dimension)dimension2, (String)lowShowNumber);
            BizRequire.isTrue((boolean)noSpecial, (String)ResManager.loadKDString((String)"\u7f16\u7801\u53ef\u80fd\u5305\u542b\u4e2d\u6587\u3001\u7279\u6b8a\u5b57\u7b26\u6216\u8005\u4ee5\u7279\u6b8a\u5b57\u7b26\u5f00\u5934\u3002", (String)"DimMemImportBasePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        boolean olapKeyWord = this.checkReservedWordNumber(lowNumber);
        if (this.modelCache.getModelobj().isModelByEB()) {
            BizRequire.isFalse((boolean)olapKeyWord, (String)ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u4fdd\u7559\u5b57\uff1a'all', 'none', 'null', 'other'\u3002", (String)"ShrekMember_2", (String)"epm-eb-common", (Object[])new Object[0]));
            BizRequire.isFalse((boolean)org.apache.commons.lang3.StringUtils.endsWithIgnoreCase((CharSequence)lowNumber, (CharSequence)"._inv"), (String)ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4ee5'._inv'\u7ed3\u5c3e", (String)"DimensionMemberSaveValidator_21", (String)"epm-eb-cube", (Object[])new Object[0]));
        } else {
            BizRequire.isFalse((boolean)olapKeyWord, (String)ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u5185\u7801\u4e0d\u80fd\u4e3a\u4fdd\u7559\u5b57\uff1a'all', 'none', 'null', 'other'\u3002", (String)"ShrekMember_4", (String)"epm-eb-common", (Object[])new Object[0]));
            BizRequire.isFalse((boolean)org.apache.commons.lang3.StringUtils.endsWithIgnoreCase((CharSequence)lowNumber, (CharSequence)"._inv"), (String)ResManager.loadKDString((String)"\u5185\u7801\u4e0d\u80fd\u4ee5'._inv'\u7ed3\u5c3e", (String)"DimensionMemberSaveValidator_25", (String)"epm-eb-cube", (Object[])new Object[0]));
        }
        boolean numberContainLineBreakBoolean = org.apache.commons.lang3.StringUtils.containsAny((CharSequence)number, (CharSequence[])new CharSequence[]{"\r", "\n", " "});
        if (this.modelCache.getModelobj().isModelByEB()) {
            BizRequire.isFalse((boolean)numberContainLineBreakBoolean, (String)ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u8f93\u5165\u7f16\u7801\uff0c\u907f\u514d\u4f7f\u7528\u6362\u884c\u7b26\u6216\u7a7a\u683c\u3002", (String)"DimMemImportBasePlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            BizRequire.isFalse((boolean)numberContainLineBreakBoolean, (String)ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u8f93\u5165\u5185\u7801\uff0c\u907f\u514d\u4f7f\u7528\u6362\u884c\u7b26\u6216\u7a7a\u683c\u3002", (String)"DimMemImportBasePlugin_55", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            boolean shownumberContainLineBreakBoolean = org.apache.commons.lang3.StringUtils.containsAny((CharSequence)showNumber, (CharSequence[])new CharSequence[]{"\r", "\n", " "});
            BizRequire.isFalse((boolean)shownumberContainLineBreakBoolean, (String)ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u8f93\u5165\u7f16\u7801\uff0c\u907f\u514d\u4f7f\u7528\u6362\u884c\u7b26\u6216\u7a7a\u683c\u3002", (String)"DimMemImportBasePlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        boolean numberLengthCheck = MetaUtils.verifyMetaLength((DynamicObjectType)this.getMemberDT(), (String)"number", (String)number);
        if (this.modelCache.getModelobj().isModelByEB()) {
            BizRequire.isTrue((boolean)numberLengthCheck, (String)ResManager.loadKDString((String)"\u7f16\u7801\u8fc7\u957f\u3002", (String)"MemberValidator_8", (String)"epm-eb-olap", (Object[])new Object[0]));
        } else {
            BizRequire.isTrue((boolean)numberLengthCheck, (String)ResManager.loadKDString((String)"\u5185\u7801\u8fc7\u957f\u3002", (String)"MemberValidator_1", (String)"epm-eb-olap", (Object[])new Object[0]));
            boolean showNumberLengthCheck = MetaUtils.verifyMetaLength((DynamicObjectType)this.getMemberDT(), (String)"shownumber", (String)showNumber);
            BizRequire.isTrue((boolean)showNumberLengthCheck, (String)ResManager.loadKDString((String)"\u7f16\u7801\u8fc7\u957f\u3002", (String)"MemberValidator_8", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        if (View.NoViewDimNums.contains(this.dimNumber) || this.modelCache.getModelobj().isModelByEB()) {
            DimensionViewMember dbDimMember = this.getDbDimMemberMap().get(number);
            if (dbDimMember != null && this.equals(dbDimMember, saveMember)) {
                if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)dbDimMember.getShowNumber(), (CharSequence)showNumber)) {
                    BizRequire.isFalse((boolean)this.dbViewShowNumber.containsKey(showNumber), (String)ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u91cd\u590d\u3002", (String)"MemberValidator_9", (String)"epm-eb-olap", (Object[])new Object[0]));
                }
            } else if (this.modelCache.getModelobj().isModelByEB()) {
                BizRequire.isFalse((boolean)this.getDbDimMemberMap().containsKey(number), (String)ResManager.loadKDString((String)"\u8be5\u7f16\u7801\u5df2\u5b58\u5728\u4e8e\u7cfb\u7edf\u4e2d\u3002", (String)"MemberValidator_6", (String)"epm-eb-olap", (Object[])new Object[0]));
                BizRequire.isFalse((boolean)this.getDbDimLowerNumber().contains(lowNumber), (String)ResManager.loadKDString((String)"\u5728\u7cfb\u7edf\u4e2d\u5df2\u7ecf\u5b58\u5728\u8be5\u7f16\u7801\u7684\u5927\u5199\u6216\u5c0f\u5199\u7f16\u7801\uff0c\u8bf7\u4fdd\u6301\u4e00\u81f4\u3002", (String)"MemberValidator_5", (String)"epm-eb-olap", (Object[])new Object[0]));
            } else {
                BizRequire.isFalse((boolean)this.getDbDimMemberMap().containsKey(number), (String)ResManager.loadKDString((String)"\u8be5\u5185\u7801\u5df2\u5b58\u5728\u4e8e\u7cfb\u7edf\u4e2d\u3002", (String)"MemberValidator_10", (String)"epm-eb-olap", (Object[])new Object[0]));
                BizRequire.isFalse((boolean)this.getDbDimLowerNumber().contains(lowNumber), (String)ResManager.loadKDString((String)"\u5728\u7cfb\u7edf\u4e2d\u5df2\u7ecf\u5b58\u5728\u8be5\u5185\u7801\u7684\u5927\u5199\u6216\u5c0f\u5199\u7f16\u7801\uff0c\u8bf7\u4fdd\u6301\u4e00\u81f4\u3002", (String)"MemberValidator_11", (String)"epm-eb-olap", (Object[])new Object[0]));
            }
        } else {
            if (this.singleDbCheck) {
                this.singleDbCheck(saveMember, number, showNumber);
                return;
            }
            DimensionViewMember dbViewMember = this.getDbViewMemberMap().get(number);
            if (dbViewMember != null && this.equalsByView(dbViewMember, saveMember)) {
                if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)dbViewMember.getShowNumber(), (CharSequence)showNumber)) {
                    BizRequire.isFalse((boolean)this.dbViewShowNumber.containsKey(showNumber), (String)ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u91cd\u590d\u3002", (String)"MemberValidator_9", (String)"epm-eb-olap", (Object[])new Object[0]));
                }
            } else {
                BizRequire.isFalse((boolean)this.getDbViewMemberMap().containsKey(number), (String)ResManager.loadKDString((String)"\u8be5\u5185\u7801\u5df2\u5b58\u5728\u4e8e\u7cfb\u7edf\u4e2d\u3002", (String)"MemberValidator_10", (String)"epm-eb-olap", (Object[])new Object[0]));
                BizRequire.isFalse((boolean)this.getDbViewLowerNumber().contains(lowNumber), (String)ResManager.loadKDString((String)"\u5728\u7cfb\u7edf\u4e2d\u5df2\u7ecf\u5b58\u5728\u8be5\u5185\u7801\u7684\u5927\u5199\u6216\u5c0f\u5199\u7f16\u7801\uff0c\u8bf7\u4fdd\u6301\u4e00\u81f4\u3002", (String)"MemberValidator_11", (String)"epm-eb-olap", (Object[])new Object[0]));
                BizRequire.isFalse((boolean)this.dbViewShowNumber.containsKey(showNumber), (String)ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u91cd\u590d\u3002", (String)"MemberValidator_9", (String)"epm-eb-olap", (Object[])new Object[0]));
                DimensionViewMember viewMemberParent = this.dbViewMemberIdMap.get(saveMember.getParentId());
                if (viewMemberParent != null) {
                    boolean notAllowAdd = ViewMemberSourceEnum.INNER_REF.getIndex().equals(viewMemberParent.getViewMembersource());
                    BizRequire.isFalse((boolean)notAllowAdd, (String)ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u6539\u53d8\u5f15\u7528\u6210\u5458\u7684\u5c42\u7ea7\u7ed3\u6784\u3002", (String)"MemberValidator_4", (String)"epm-eb-olap", (Object[])new Object[0]));
                }
            }
        }
    }

    private void singleDbCheck(IMemberVO saveMember, String number, String showNumber) {
        QFBuilder vmQf = new QFBuilder();
        vmQf.add("model", "=", (Object)this.modelCache.getModelobj().getId());
        vmQf.add("view", "=", (Object)this.viewId);
        vmQf.add("dimension", "=", (Object)this.getDimension().getId());
        String field = "id,number,membersource";
        boolean isNew = true;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"eb_viewmember", (String)field, (QFilter[])vmQf.toArray(), null);){
            while (ds.hasNext()) {
                Row row = ds.next();
                if (!number.equalsIgnoreCase(row.getString("number"))) continue;
                QFBuilder showNumberQf = new QFBuilder();
                showNumberQf.add("model", "=", (Object)this.modelCache.getModelobj().getId());
                showNumberQf.add("view", "=", (Object)this.viewId);
                showNumberQf.add("dimension", "=", (Object)this.getDimension().getId());
                showNumberQf.add(new QFilter("shownumber", "=", (Object)showNumber).or("shownumber", "=", (Object)org.apache.commons.lang3.StringUtils.lowerCase((String)showNumber)));
                if (row.getLong("id").equals(saveMember.getId())) {
                    isNew = false;
                    showNumberQf.and("id", "<>", (Object)row.getLong("id"));
                }
                if (!QueryServiceHelper.exists((String)"eb_viewmember", (QFilter[])showNumberQf.toArray())) break;
                throw new KDBizException(ResManager.loadKDString((String)"\u5728\u7cfb\u7edf\u4e2d\u5df2\u7ecf\u5b58\u5728\u8be5\u7f16\u7801\u7684\u5927\u5199\u6216\u5c0f\u5199\u7f16\u7801\uff0c\u8bf7\u4fdd\u6301\u4e00\u81f4\u3002", (String)"MemberValidator_5", (String)"epm-eb-olap", (Object[])new Object[0]));
            }
        }
        if (isNew) {
            DynamicObject viewMemberParent;
            QFBuilder builder = new QFBuilder();
            builder.add("model", "=", (Object)this.modelCache.getModelobj().getId());
            builder.add("view", "=", (Object)this.viewId);
            builder.add("dimension", "=", (Object)this.getDimension().getId());
            builder.add(new QFilter("shownumber", "=", (Object)showNumber).or("shownumber", "=", (Object)org.apache.commons.lang3.StringUtils.lowerCase((String)showNumber)));
            BizRequire.isFalse((boolean)QueryServiceHelper.exists((String)"eb_viewmember", (QFilter[])builder.toArray()), (String)ResManager.loadKDString((String)"\u663e\u793a\u7f16\u7801\u4e0d\u80fd\u91cd\u590d\u3002", (String)"MemberValidator_3", (String)"epm-eb-olap", (Object[])new Object[0]));
            if (saveMember.getParentId() != null && saveMember.getParentId() > 0L && (viewMemberParent = BusinessDataServiceHelper.loadSingle((Object)saveMember.getParentId(), (String)"eb_viewmember")) != null) {
                boolean notAllowAdd = ViewMemberSourceEnum.INNER_REF.getIndex().equals(viewMemberParent.getString("membersource"));
                BizRequire.isFalse((boolean)notAllowAdd, (String)ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u6539\u53d8\u5f15\u7528\u6210\u5458\u7684\u5c42\u7ea7\u7ed3\u6784\u3002", (String)"MemberValidator_4", (String)"epm-eb-olap", (Object[])new Object[0]));
            }
        }
    }

    protected boolean equals(DimensionViewMember dbDimMember, IMemberVO saveMember) {
        return dbDimMember.getMemberId().equals(saveMember.getMemberId());
    }

    protected boolean equalsByView(DimensionViewMember dbDimMember, IMemberVO saveMember) {
        return dbDimMember.getViewMemberId().equals(saveMember.getId());
    }

    private void initDbMember(IModelCacheHelper modelCache, String dimNumber, Long viewId) {
        String field;
        QFBuilder builder;
        this.hasInitData = true;
        String memberTreemodel = SysDimensionEnum.Project.getMemberTreemodel();
        String memberTreeTable = SysDimensionEnum.Project.getMemberTreetable();
        SysDimensionEnum dimensionEnum = SysDimensionEnum.getEnumByNumber((String)dimNumber);
        if (dimensionEnum != null) {
            memberTreemodel = dimensionEnum.getMemberTreemodel();
            memberTreeTable = dimensionEnum.getMemberTreetable();
        }
        boolean hasEntity = StringUtils.equals((String)"Entity", (String)dimNumber);
        boolean hasAccount = StringUtils.equals((String)"Account", (String)dimNumber);
        boolean hasSimpleName = Dimension.hasSimpleName((String)memberTreemodel);
        boolean hasView = !View.NoViewDimNums.contains(this.dimNumber) && !modelCache.getModelobj().isModelByEB();
        boolean hasVerifyName = this.hasVerifyName();
        ObjectCache cache = ObjectCache.get();
        Long modelId = modelCache.getModelobj().getId();
        Long dimensionId = this.getDimension().getId();
        if (hasView) {
            Object member;
            builder = new QFBuilder();
            builder.add("model", "=", (Object)modelId);
            builder.add("view", "=", (Object)viewId);
            builder.add("dimension", "=", (Object)dimensionId);
            if (CollectionUtils.isNotEmpty(this.getRefNumbers())) {
                builder.add("number", "in", this.getRefNumbers());
            }
            field = "id,number,name,shownumber,longnumber,aggoprt,level,dseq,membersource,parent.id,parent.number,memberid,disable";
            if (hasSimpleName) {
                field = field + ",simpleName";
            }
            DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_viewmember", (String)field, (QFilter[])builder.toArrays());
            for (DynamicObject obj : query) {
                member = (DimensionViewMember)Builder.of(DimensionViewMember::new).with(DimensionViewMember::setViewMemberId, cache.valueOf((Object)obj.getLong("id"))).with(DimensionViewMember::setMemberId, cache.valueOf((Object)obj.getLong("memberid"))).with(DimensionViewMember::setNumber, cache.valueOf((Object)obj.getString("number"))).with(DimensionViewMember::setName, (Object)obj.getString("name")).with(DimensionViewMember::setShowNumber, cache.valueOf((Object)obj.getString("shownumber"))).with(DimensionViewMember::setLongNumber, (Object)obj.getString("longnumber")).with(DimensionViewMember::setAggoprt, cache.valueOf((Object)obj.getString("aggoprt"))).with(DimensionViewMember::setLevel, cache.valueOf((Object)obj.getInt("level"))).with(DimensionViewMember::setDseq, cache.valueOf((Object)obj.getInt("dseq"))).with(DimensionViewMember::setParentId, cache.valueOf((Object)obj.getLong("parent.id"))).with(DimensionViewMember::setParentNumber, cache.valueOf((Object)obj.getString("parent.number"))).with(DimensionViewMember::setViewMembersource, cache.valueOf((Object)obj.getString("membersource"))).with(DimensionViewMember::setEnable, (Object)(obj.getBoolean("disable") ? "0" : "1")).build();
                if (hasSimpleName) {
                    ((DimensionViewMember)member).setSimpleName(obj.getString("simpleName"));
                }
                this.dbViewLowerNumber.add(((DimensionViewMember)member).getNumber().toLowerCase());
                this.dbViewShowNumber.put(((DimensionViewMember)member).getShowNumber(), ((DimensionViewMember)member).getNumber());
                this.dbViewMemberMap.put(((DimensionViewMember)member).getNumber(), (DimensionViewMember)member);
                this.dbViewMemberIdMap.put(((DimensionViewMember)member).getViewMemberId(), (DimensionViewMember)member);
                if (!hasVerifyName) continue;
                this.dbViewNameSet.add(((DimensionViewMember)member).getLocaleName());
            }
            SqlBuilder sql = new SqlBuilder();
            sql.append("select fparentid, max(fdseq) as fseq from t_eb_viewmember where fmodelid = ? and fviewid = ? and fdimensionid = ? group by fparentid", new Object[]{modelId, viewId, dimensionId});
            DataSet ds = DB.queryDataSet((String)"queryDseq", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
            member = null;
            try {
                if (ds != null) {
                    for (Row row : ds) {
                        this.dbViewSeqMap.put(row.getLong("fparentid"), row.getInteger("fseq"));
                    }
                }
            }
            catch (Throwable throwable) {
                member = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (member != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)member).addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        if (hasView && this.isInitAllMember()) {
            ViewGroupManager viewGroupManager = ViewGroupManager.getInstance();
            DynamicObjectCollection views = viewGroupManager.getViewByDimensionId(modelCache.getModelobj().getId(), this.getDimension().getId());
            Set<Long> groupViewIds = viewGroupManager.getViewsByViewId(viewId);
            if (views != null && !views.isEmpty()) {
                Set viewIds = views.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
                viewIds.remove(viewId);
                if (!viewIds.isEmpty()) {
                    QFBuilder builder2 = new QFBuilder();
                    builder2.add("model", "=", (Object)modelId);
                    builder2.add("dimension", "=", (Object)dimensionId);
                    builder2.add("view", "in", viewIds);
                    String fields = "id,memberid,view.id,name,simplename,number,refview,parent.id,parent.number,parent.memberid,parent.refview";
                    LinkedHashMap refMember = Maps.newLinkedHashMap();
                    DynamicObjectCollection members = QueryServiceHelper.query((String)"eb_viewmember", (String)fields, (QFilter[])builder2.toArray(), (String)"level, dseq");
                    for (DynamicObject row : members) {
                        Map refParentMap;
                        long pRefView;
                        DimensionViewMember member = (DimensionViewMember)Builder.of(DimensionViewMember::new).with(DimensionViewMember::setId, cache.valueOf((Object)row.getLong("id"))).with(DimensionViewMember::setParentId, cache.valueOf((Object)row.getLong("parent.id"))).with(DimensionViewMember::setMemberId, cache.valueOf((Object)row.getLong("memberid"))).with(DimensionViewMember::setName, (Object)row.getString("name")).with(DimensionViewMember::setSimpleName, (Object)row.getString("simplename")).with(DimensionViewMember::setNumber, cache.valueOf((Object)row.getString("number"))).with(DimensionViewMember::setParentMemberId, cache.valueOf((Object)row.getLong("parent.memberid"))).with(DimensionViewMember::setParentNumber, cache.valueOf((Object)row.getString("parent.number"))).with(DimensionViewMember::setView, cache.valueOf((Object)row.getLong("view.id"))).build();
                        boolean isGroup = groupViewIds.contains(member.getView());
                        if (isGroup) {
                            this.getGroupMemberSet().add(member.getMemberId());
                        }
                        if (IDUtils.isNotNull((long)(pRefView = row.getLong("parent.refview")))) {
                            if (!isGroup) continue;
                            refParentMap = refMember.computeIfAbsent(member.getMemberId(), f -> Maps.newHashMap());
                            refParentMap.put(member.getParentMemberId(), member);
                            continue;
                        }
                        long refView = row.getLong("refview");
                        if (isGroup) {
                            if (refView == 0L) {
                                this.getAllMemberMap().put(member.getMemberId(), member);
                                this.getAllMemberNumMap().put(member.getNumber(), member);
                                continue;
                            }
                            refParentMap = refMember.computeIfAbsent(member.getMemberId(), f -> Maps.newHashMap());
                            refParentMap.put(member.getParentMemberId(), member);
                            continue;
                        }
                        if (refView != 0L) continue;
                        this.getOtherGroupMemberMap().put(member.getMemberId(), member);
                        this.getOtherGroupMemberNumMap().put(member.getNumber(), member);
                    }
                    if (!this.getAllMemberMap().isEmpty() || !refMember.isEmpty()) {
                        Set childrenIds;
                        for (DimensionViewMember dimensionViewMember : this.getAllMemberMap().values()) {
                            DimensionViewMember _parent = this.getAllMemberMap().get(dimensionViewMember.getParentMemberId());
                            childrenIds = this.getAllMemChildMap().computeIfAbsent(_parent != null ? _parent.getMemberId() : 0L, f -> Sets.newLinkedHashSet());
                            childrenIds.add(dimensionViewMember.getMemberId());
                        }
                        if (!refMember.isEmpty()) {
                            for (Map map : refMember.values()) {
                                for (Map.Entry _entry : map.entrySet()) {
                                    childrenIds = this.getAllMemChildMap().computeIfAbsent((Long)_entry.getKey(), (Function<Long, Set<Long>>)((Function<Long, Set>)f -> Sets.newLinkedHashSet()));
                                    childrenIds.add(((DimensionViewMember)_entry.getValue()).getMemberId());
                                }
                            }
                        }
                    }
                }
            }
        }
        builder = new QFBuilder();
        builder.add("model", "=", (Object)modelId);
        builder.add("dimension", "=", (Object)dimensionId);
        if (CollectionUtils.isNotEmpty(this.getRefNumbers())) {
            builder.add("number", "in", this.getRefNumbers());
        }
        field = "id,number,name,shownumber,longnumber,aggoprt,level,dseq,description,parent.id,parent.number,disable";
        if (hasSimpleName) {
            field = field + ",simpleName";
        }
        if (hasEntity) {
            field = field + ",executor.id,owner.id";
        } else if (hasAccount) {
            field = field + ",dataset.id,accounttype,drcrdirect";
        }
        Map cusPropValues = null;
        Map propValues = null;
        Map cusProperties = null;
        if (this.isInitCusPropValue() && CustomPropertyUtils.hasCustomPropertyByEntityNumber((String)memberTreemodel) && (cusPropValues = CustomPropertyUtils.getCustomPropertyValueByProperty((Set)IDUtils.toLongs((cusProperties = CustomPropertyUtils.getCustomProperty((Long)modelCache.getModelobj().getId(), (Long)this.getDimension().getId())).keySet()), (String)"id,number,property.id,property.number")) != null && !cusPropValues.isEmpty()) {
            propValues = CustomPropertyUtils.queryAllPropertyValue((Long)modelCache.getModelobj().getId(), (Long)this.getDimension().getId(), (String)this.getDimension().getMemberTable());
        }
        Map accountMap = null;
        if (this.isInitMetric() && org.apache.commons.lang3.StringUtils.equals((CharSequence)"Account", (CharSequence)dimNumber)) {
            accountMap = MetricUtils.queryMetricByAccount((Long)modelCache.getModelobj().getId());
        }
        DynamicObjectCollection members = QueryServiceHelper.query((String)memberTreemodel, (String)field, (QFilter[])builder.toArrays());
        for (DynamicObject obj : members) {
            Set _values;
            DimensionViewMember member = (DimensionViewMember)Builder.of(DimensionViewMember::new).with(DimensionViewMember::setMemberId, cache.valueOf((Object)obj.getLong("id"))).with(DimensionViewMember::setNumber, cache.valueOf((Object)obj.getString("number"))).with(DimensionViewMember::setName, (Object)obj.getString("name")).with(DimensionViewMember::setShowNumber, cache.valueOf((Object)obj.getString("shownumber"))).with(DimensionViewMember::setLongNumber, (Object)obj.getString("longnumber")).with(DimensionViewMember::setAggoprt, cache.valueOf((Object)obj.getString("aggoprt"))).with(DimensionViewMember::setLevel, cache.valueOf((Object)obj.getInt("level"))).with(DimensionViewMember::setDseq, cache.valueOf((Object)obj.getInt("dseq"))).with(DimensionViewMember::setDescription, (Object)obj.getString("description")).with(DimensionViewMember::setParentId, cache.valueOf((Object)obj.getLong("parent.id"))).with(DimensionViewMember::setParentNumber, cache.valueOf((Object)obj.getString("parent.number"))).with(DimensionViewMember::setEnable, (Object)(obj.getBoolean("disable") ? "0" : "1")).build();
            if (hasAccount) {
                Set metrics;
                member.setDatasetId((Long)cache.valueOf((Object)obj.getLong("dataset.id")));
                member.setAccountType((String)cache.valueOf((Object)obj.getString("accounttype")));
                member.setDrcrdirect((String)cache.valueOf((Object)obj.getString("drcrdirect")));
                if (accountMap != null && CollectionUtils.isNotEmpty((Collection)(metrics = (Set)accountMap.get(member.getMemberId())))) {
                    member.setMetrics(metrics);
                }
            } else if (hasEntity) {
                member.setExecutorId((Long)cache.valueOf((Object)obj.getLong("executor.id")));
                member.setOwnerId((Long)cache.valueOf((Object)obj.getLong("owner.id")));
            }
            if (hasSimpleName) {
                member.setSimpleName(obj.getString("simpleName"));
            }
            if (cusProperties != null && !cusProperties.isEmpty()) {
                for (DynamicObject _property : cusProperties.values()) {
                    member.addPropValue((String)cache.valueOf((Object)_property.getString("number")), null);
                }
            }
            if (cusPropValues != null && propValues != null && (_values = (Set)propValues.get(member.getMemberId())) != null) {
                for (Long _propValue : _values) {
                    DynamicObject _cusPropValue = (DynamicObject)cusPropValues.get(_propValue);
                    if (_cusPropValue == null) continue;
                    member.addPropValue((String)cache.valueOf((Object)_cusPropValue.getString("property.number")), (String)cache.valueOf((Object)_cusPropValue.getString("number")));
                }
            }
            this.dbDimLowerNumber.add(member.getNumber().toLowerCase());
            this.dbDimMemberMap.put(member.getNumber(), member);
            this.dbDimMemberIdMap.put(member.getMemberId(), member);
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fparentid, max(fseq) as fseq from ", new Object[0]).append(memberTreeTable, new Object[0]).append(" where fmodelid = ? and fdimensionid = ? group by fparentid", new Object[]{modelId, dimensionId});
        try (DataSet ds = DB.queryDataSet((String)"querySeq", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    this.dbSeqMap.put(row.getLong("fparentid"), row.getInteger("fseq"));
                }
            }
        }
    }

    public Map<String, DimensionViewMember> getDbViewMemberMap() {
        if (this.dbViewMemberMap.isEmpty() && !this.hasInitData) {
            this.initDbMember(this.modelCache, this.dimNumber, this.viewId);
        }
        return this.dbViewMemberMap;
    }

    public Map<String, DimensionViewMember> getDbDimMemberMap() {
        if (this.dbDimMemberMap.isEmpty() && !this.hasInitData) {
            this.initDbMember(this.modelCache, this.dimNumber, this.viewId);
        }
        return this.dbDimMemberMap;
    }

    public Set<String> getDbViewLowerNumber() {
        if (this.dbDimMemberMap.isEmpty() && !this.hasInitData) {
            this.initDbMember(this.modelCache, this.dimNumber, this.viewId);
        }
        return this.dbViewLowerNumber;
    }

    public Map<Long, DimensionViewMember> getDbViewMemberIdMap() {
        if (this.dbViewMemberIdMap.isEmpty() && !this.hasInitData) {
            this.initDbMember(this.modelCache, this.dimNumber, this.viewId);
        }
        return this.dbViewMemberIdMap;
    }

    public Map<Long, DimensionViewMember> getDbDimMemberIdMap() {
        if (this.dbDimMemberIdMap.isEmpty() && !this.hasInitData) {
            this.initDbMember(this.modelCache, this.dimNumber, this.viewId);
        }
        return this.dbDimMemberIdMap;
    }

    public Set<String> getDbDimLowerNumber() {
        if (this.dbDimMemberMap.isEmpty() && !this.hasInitData) {
            this.initDbMember(this.modelCache, this.dimNumber, this.viewId);
        }
        return this.dbDimLowerNumber;
    }

    public Map<Long, Integer> getDbSeqMap() {
        if (this.dbSeqMap.isEmpty() && !this.hasInitData) {
            this.initDbMember(this.modelCache, this.dimNumber, this.viewId);
        }
        return this.dbSeqMap;
    }

    public Map<Long, Integer> getDbViewSeqMap() {
        if (this.dbViewSeqMap.isEmpty() && !this.hasInitData) {
            this.initDbMember(this.modelCache, this.dimNumber, this.viewId);
        }
        return this.dbViewSeqMap;
    }

    public void setSingleDbCheck(boolean singleDbCheck) {
        this.singleDbCheck = singleDbCheck;
    }

    protected boolean checkReservedWordNumber(String lowerNumber) {
        return EXCLUDE_NUMBERS.contains(lowerNumber);
    }

    private DynamicObjectType getMemberDT() {
        if (this.dt == null) {
            this.dt = EntityMetadataCache.getDataEntityType((String)this.getDimension().getMemberModel());
        }
        return this.dt;
    }

    public ValidResult<String> batchValid(Map<String, IMemberVO> members) {
        ValidResult<String> valid = new ValidResult<String>();
        try {
            MutableGraph graph = GraphBuilder.directed().build();
            if (IDUtils.isNotNull((Long)this.getViewId())) {
                for (DimensionViewMember dimensionViewMember : this.getDbViewMemberMap().values()) {
                    graph.putEdge((Object)(dimensionViewMember.getParentNumber() != null ? dimensionViewMember.getParentNumber() : ""), (Object)dimensionViewMember.getNumber());
                }
            } else {
                for (DimensionViewMember dimensionViewMember : this.getDbDimMemberMap().values()) {
                    graph.putEdge((Object)(dimensionViewMember.getParentNumber() != null ? dimensionViewMember.getParentNumber() : ""), (Object)dimensionViewMember.getNumber());
                }
            }
            for (IMemberVO iMemberVO : members.values()) {
                graph.putEdge((Object)iMemberVO.getParentNumber(), (Object)iMemberVO.getNumber());
            }
            if (Graphs.hasCycle((Graph)graph)) {
                LinkedHashSet<String> nodePath = new LinkedHashSet<String>();
                for (String node : graph.nodes()) {
                    Set reachNodes = Graphs.reachableNodes((Graph)graph, (Object)node);
                    for (String reachNode : reachNodes) {
                        Set subReachNodes;
                        if (reachNode.equals(node) || !(subReachNodes = Graphs.reachableNodes((Graph)graph, (Object)reachNode)).contains(node)) continue;
                        this.getCyclePath((MutableGraph<String>)graph, node, node, nodePath);
                        for (String _node : nodePath) {
                            MemberExcelVO member = (MemberExcelVO)members.get(_node);
                            if (member != null) {
                                valid.addValidResult(member.getRowIndex(), ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u6811\u5f62\u7ed3\u6784\u5b58\u5728\u5faa\u73af\u5f15\u7528\u3002", (String)"MemberValidator_7", (String)"epm-eb-olap", (Object[])new Object[0]));
                                continue;
                            }
                            valid.addValidResult(0, ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a%1\u7ef4\u5ea6\u6210\u5458\u6811\u5f62\u7ed3\u6784\u5b58\u5728\u5faa\u73af\u5f15\u7528\u3002", (String)"MemberValidator_71", (String)"epm-eb-olap", (Object[])new Object[]{_node}));
                        }
                    }
                    if (nodePath.isEmpty()) continue;
                    break;
                }
            }
            if (valid.isOk() && !this.getValidators().isEmpty()) {
                for (IMemberValidator iMemberValidator : this.getValidators()) {
                    ValidResult<?> _tmpValid = iMemberValidator.batchValid(members);
                    if (_tmpValid.isOk()) continue;
                    valid.mergeErrorValidResult(_tmpValid);
                }
            }
        }
        catch (Throwable ex) {
            valid = new ValidResult(CommonServiceHelper.getStackTraceStr((Throwable)ex));
        }
        return valid;
    }

    private void getCyclePath(MutableGraph<String> graph, String originNode, String nextStartNode, Collection<String> pathList) {
        pathList.add(nextStartNode);
        Set successors = graph.successors((Object)nextStartNode);
        if (successors.contains(originNode)) {
            pathList.add(originNode);
            return;
        }
        for (String successor : successors) {
            Set reachNodes = Graphs.reachableNodes(graph, (Object)successor);
            if (!reachNodes.contains(originNode) || pathList.contains(successor)) continue;
            this.getCyclePath(graph, originNode, successor, pathList);
            break;
        }
    }

    static {
        EXCLUDE_NUMBERS.add("other");
        EXCLUDE_NUMBERS.add("all");
        EXCLUDE_NUMBERS.add("none");
        EXCLUDE_NUMBERS.add("null");
    }
}

