/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.service.view.valid;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import kd.epm.eb.common.utils.StringUtils;

public class ValidResult<T> {
    public static final ValidResult<String> SUCCEED = new ValidResult();
    private boolean ok = true;
    private String errCode = "";
    private String errMsg;
    private Map<String, T> validResultMap = null;
    private List<T> validResultList = null;

    public ValidResult() {
    }

    public ValidResult(String errMsg) {
        this(false, errMsg);
    }

    public ValidResult(boolean ok, String errMsg) {
        this(ok, null, errMsg);
    }

    public ValidResult(boolean ok, String errCode, String errMsg) {
        this.ok = ok;
        this.errCode = errCode;
        this.errMsg = errMsg;
    }

    public boolean ok() {
        return this.ok;
    }

    public void setOk(boolean ok) {
        this.ok = ok;
    }

    public boolean isOk() {
        return this.ok;
    }

    public String getErrCode() {
        return this.errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.setOk(false);
        this.errMsg = errMsg;
    }

    public Map<String, T> getValidResultMap() {
        if (this.validResultMap == null) {
            this.validResultMap = Maps.newHashMap();
        }
        return this.validResultMap;
    }

    public void addValidResult(int key, T value) {
        this.addValidResult(String.valueOf(key), value);
    }

    public void addValidResult(String key, T value) {
        if (StringUtils.isEmpty((String)key)) {
            return;
        }
        this.setOk(false);
        this.getValidResultMap().put(key, value);
    }

    public void mergeErrorValidResult(ValidResult<?> valid) {
        if (valid == null) {
            return;
        }
        this.setErrMsg(valid.getErrMsg());
        for (Map.Entry<String, ?> entry : valid.getValidResultMap().entrySet()) {
            this.addValidResult(entry.getKey(), entry.getValue());
        }
    }

    public List<T> getValidResultList() {
        if (this.validResultList == null) {
            this.validResultList = Lists.newArrayList();
        }
        return this.validResultList;
    }

    public void setValidResultList(List<T> validResultList) {
        this.validResultList = validResultList;
    }
}

