/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.transaction;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.common.applybill.Count;
import kd.epm.eb.common.constant.BgFormConstant;
import kd.epm.eb.common.model.Pair;
import kd.epm.eb.common.spread.util.GZIPUtils;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.Counter;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogHelper;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.olap.api.base.IKDValue;
import kd.epm.eb.olap.api.dataSource.IKDOlapRequest;
import kd.epm.eb.olap.impl.data.CubeDataResult;
import kd.epm.eb.olap.transaction.OlapCellData;
import kd.epm.eb.olap.transaction.OlapDataInfo;
import kd.epm.eb.olap.transaction.OlapTX;
import kd.epm.eb.olap.transaction.StringInfo;

public class OlapDataLogService {
    private static final String insertSql = "insert into t_eb_olaptransaction_log(fid,fmodelid,ftransactionid,fcubeid,fcreatedate,fcreater,folapdata) values(?,?,?,?,?,?,?)";
    private static final String delSql = "delete from t_eb_olaptransaction_log where ftransactionid = ?";
    private static final String selSql = "select fmodelid,ftransactionid,fcubeid,fcreatedate,folapdata from t_eb_olaptransaction_log where ftransactionid = ?";
    private static final char dateValSign = 'D';
    private static final char numberValSign = 'N';
    private static final char stringValSign = 'S';
    private static final char cellStartSign = '{';
    private static final char cellEndSign = '}';
    private static final char memberEndSign = '!';
    private static final String memberSplitSign = ",";
    private static final char specialSign = '\\';
    private static final Log log = LogFactory.getLog(OlapDataLogService.class);

    public static void delLogByTrxId(Long trxId, Set<Long> rollbackCubeIds) {
        if (IDUtils.isNotNull((Long)trxId) && (rollbackCubeIds == null || rollbackCubeIds.size() > 0)) {
            String sql = delSql;
            if (rollbackCubeIds != null) {
                sql = sql + "and fcubeid in (" + rollbackCubeIds.stream().map(Objects::toString).collect(Collectors.joining(memberSplitSign)) + ")";
            }
            try (TXHandle tx = TX.notSupported((String)"saveLog4Transaction");){
                try {
                    DB.execute((DBRoute)BgFormConstant.DBROUTE, (String)sql, (Object[])new Object[]{trxId});
                }
                catch (Exception e) {
                    log.error("OlapTrx-delLogByTrxIds", (Throwable)e);
                }
            }
        }
    }

    public static void saveLog4Transaction(IKDOlapRequest olapRequest, CubeDataResult cubeDataResult) {
        Long enableTrxId = OlapTX.getEnableTrxId();
        if (IDUtils.isNotNull((Long)enableTrxId)) {
            String serialStr;
            LogHelper logHelper = new LogHelper(log);
            Object[] values = new Object[7];
            values[0] = GlobalIdUtil.genGlobalLongId();
            values[1] = olapRequest.getCubeId();
            values[2] = enableTrxId;
            values[3] = olapRequest.getOlapData().getDatasetId();
            values[4] = TimeServiceHelper.now();
            values[5] = UserUtils.getUserId();
            try {
                serialStr = OlapDataLogService.serializationOlapData(cubeDataResult);
            }
            catch (Exception e) {
                log.error("OlapTrx-saveLog4Transaction", (Throwable)e);
                return;
            }
            values[6] = serialStr;
            logHelper.addInfoLog(String.format("OlapTrx-backOlapData-serializa-{trxId:%s,cellCount:%s,strLength:%s}", enableTrxId, cubeDataResult.getCells().size(), serialStr.length()));
            try (TXHandle tx = TX.notSupported((String)"saveLog4Transaction");){
                try {
                    DB.execute((DBRoute)BgFormConstant.DBROUTE, (String)insertSql, (Object[])values);
                }
                catch (Exception e) {
                    log.error("OlapTrx-saveLog4Transaction", (Throwable)e);
                }
            }
            logHelper.addInfoLog(String.format("OlapTrx-backOlapData-end-{trxId:%s}", enableTrxId));
        }
    }

    private static String serializationOlapData(CubeDataResult cubeDataResult) {
        StringBuilder sb = new StringBuilder();
        if (CollectionUtils.isNotEmpty(cubeDataResult.getCells())) {
            cubeDataResult.getCells().forEach(cell -> {
                sb.append('{');
                for (String memberNum : cell.getMeta().getNumber()) {
                    sb.append(memberNum).append(memberSplitSign);
                }
                sb.setCharAt(sb.length() - 1, '!');
                IKDValue oldValue = cell.getOldValue();
                if (oldValue != null && oldValue.getValue() != null) {
                    if (oldValue.isString()) {
                        String valStr = oldValue.getString();
                        sb.append('S');
                        for (int index = 0; index < valStr.length(); ++index) {
                            char c = valStr.charAt(index);
                            if (c == '}' || c == '\\') {
                                sb.append('\\');
                            }
                            sb.append(c);
                        }
                    } else {
                        if (oldValue.isDate()) {
                            sb.append('D');
                        } else {
                            sb.append('N');
                        }
                        sb.append(cell.getOldValue());
                    }
                }
                sb.append('}');
            });
        }
        return GZIPUtils.zipAndBase64((String)sb.toString());
    }

    public static List<OlapDataInfo> getOlapDataLogByTransaction(Long trxId) {
        LogHelper logHelper = new LogHelper(log);
        ArrayList<OlapDataInfo> result = new ArrayList<OlapDataInfo>(16);
        HashMap<Long, List> dataLogMap = new HashMap<Long, List>(16);
        HashMap<Long, Long> datasetModelMap = new HashMap<Long, Long>(16);
        int logCount = 0;
        try (DataSet dataset = DB.queryDataSet((String)"getOlapDataLogByTransaction", (DBRoute)BgFormConstant.DBROUTE, (String)selSql, (Object[])new Object[]{trxId});){
            for (Row row : dataset) {
                Long modelId = row.getLong("fmodelid");
                Long datasetId2 = row.getLong("fcubeid");
                datasetModelMap.put(datasetId2, modelId);
                dataLogMap.computeIfAbsent(datasetId2, key -> new ArrayList(16)).add(new Pair((Object)row.getString("folapdata"), (Object)row.getDate("fcreatedate")));
                ++logCount;
            }
        }
        logHelper.addInfoLog(String.format("OlapTrx-getOlapDataLog-query-{trxId:%s,logCount:%s}:", trxId, logCount));
        Count cellCount = new Count();
        if (dataLogMap.size() > 0) {
            dataLogMap.forEach((datasetId, dataLog) -> {
                dataLog.sort(Map.Entry.comparingByValue());
                List<String> dataLogList = dataLog.stream().map(Pair::getKey).collect(Collectors.toList());
                Long modelId = (Long)datasetModelMap.get(datasetId);
                List<OlapCellData> cellDataList = OlapDataLogService.deSerializeOlapData(dataLogList);
                cellCount.add(cellDataList.size());
                result.add(new OlapDataInfo((Long)datasetId, modelId, cellDataList));
            });
        }
        logHelper.addInfoLog(String.format("OlapTrx-getOlapDataLog-deSerialize-{trxId:%s,cellCount:%s}:", trxId, cellCount.getCount()));
        return result;
    }

    public static List<OlapCellData> deSerializeOlapData(Collection<String> olapDataStrs) {
        ArrayList<OlapCellData> cells = new ArrayList<OlapCellData>(16);
        HashMap<String, Integer> cellsIndex = new HashMap<String, Integer>(16);
        Counter cellSign = new Counter();
        for (String olapDataStr : olapDataStrs) {
            if (!StringUtils.isNotEmpty((String)(olapDataStr = GZIPUtils.unZipAndBase64((String)olapDataStr)))) continue;
            int length = olapDataStr.length();
            StringBuilder sb = new StringBuilder();
            StringInfo stringInfo = new StringInfo();
            stringInfo.setCurrentIndex(0);
            while (stringInfo.getCurrentIndex() < length) {
                stringInfo.setCurrentIndex(stringInfo.getCurrentIndex() + 1);
                OlapDataLogService.readStr(olapDataStr, '!', stringInfo, sb);
                String memberNumStr = stringInfo.getStrVal();
                OlapDataLogService.readStr(olapDataStr, '}', stringInfo, sb);
                int cellIndex = cellsIndex.computeIfAbsent(memberNumStr, key -> cellSign.getSize());
                if (cellIndex != cellSign.getSize()) continue;
                String valueStr = stringInfo.getStrVal();
                Object cellVal = valueStr != null && valueStr.length() > 0 ? (stringInfo.getTypeSign() == 'S' ? valueStr : (stringInfo.getTypeSign() == 'D' ? DataType.DateType.convertValue((Object)valueStr) : new BigDecimal(valueStr))) : null;
                cells.add(new OlapCellData(memberNumStr.split(memberSplitSign), cellVal));
                cellSign.setSize(cellSign.getSize() + 1);
            }
        }
        return cells;
    }

    private static void readStr(String dataStr, char endChar, StringInfo stringInfo, StringBuilder sb) {
        char c;
        sb.setLength(0);
        int length = dataStr.length();
        int beginIndex = stringInfo.getCurrentIndex();
        if (endChar == '}' && beginIndex < length) {
            c = dataStr.charAt(beginIndex);
            if (c == '}') {
                stringInfo.setTypeSign('N');
            } else {
                stringInfo.setTypeSign(dataStr.charAt(beginIndex));
                ++beginIndex;
            }
        } else {
            stringInfo.setTypeSign('S');
        }
        boolean matchSign = false;
        while (beginIndex < length) {
            c = dataStr.charAt(beginIndex);
            ++beginIndex;
            if (c == '\\') {
                if (!matchSign) {
                    matchSign = true;
                    continue;
                }
                matchSign = false;
                sb.append(c);
                continue;
            }
            if (c == endChar && !matchSign) break;
            sb.append(c);
            matchSign = false;
        }
        stringInfo.setCurrentIndex(beginIndex);
        stringInfo.setStrVal(sb.toString());
    }
}

