/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.transaction;

import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXContext;
import kd.bos.db.tx.TXHandle;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.olap.transaction.OlapTXContext;
import kd.epm.eb.olap.transaction.OlapTXHandle;
import kd.epm.eb.olap.transaction.OlapTransactionHandler;

public class OlapTX {
    private static final ThreadLocal<OlapTXContext> tx_holder = new ThreadLocal();

    public static OlapTXHandle required(String tag) {
        return OlapTX.newRequired(TX.required((String)tag));
    }

    public static OlapTXHandle requiredNew(String tag) {
        return OlapTX.newRequired(TX.requiresNew((String)tag));
    }

    private static OlapTXHandle newRequired(TXHandle requiredNew) {
        OlapTXHandle olapTXHandle = new OlapTXHandle(requiredNew);
        TXContext currentBosContext = OlapTX.getCurrentBosContext();
        OlapTXContext currentContext = OlapTX.getCurrentContext();
        if (currentContext == null || !IDUtils.equals((Object)currentContext.getTrxId(), (Object)currentBosContext.id())) {
            OlapTXContext newContext = new OlapTXContext(currentBosContext, currentContext);
            tx_holder.set(newContext);
            TX.addCommitListener((CommitListener)new OlapTransactionHandler(newContext));
        }
        return olapTXHandle;
    }

    public static OlapTXHandle notSupported(String tag) {
        TXHandle required = TX.notSupported((String)tag);
        OlapTXHandle olapTXHandle = new OlapTXHandle(required);
        OlapTXContext currentContext = OlapTX.getCurrentContext();
        if (currentContext != null) {
            currentContext.suspend();
        }
        return olapTXHandle;
    }

    public static OlapTXContext getCurrentContext() {
        return tx_holder.get();
    }

    public static TXContext getCurrentBosContext() {
        return TX.__getTXContext();
    }

    public static void doEnd(OlapTXContext targetContext) {
        OlapTXContext currentContext = OlapTX.getCurrentContext();
        if (currentContext != null) {
            if (targetContext != null && targetContext != currentContext) {
                return;
            }
            if (currentContext.isSuspend()) {
                currentContext.unSuspend();
            } else {
                tx_holder.remove();
                tx_holder.set(currentContext.getParent());
            }
        }
    }

    public static Long getEnableTrxId() {
        OlapTXContext currentContext = OlapTX.getCurrentContext();
        if (currentContext != null && !currentContext.isSuspend() && currentContext.getBosContext() == OlapTX.getCurrentBosContext()) {
            return currentContext.getTrxId();
        }
        return null;
    }
}

