/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.transaction;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.CommitListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.shrek.controller.IShrekSave;
import kd.epm.eb.common.shrek.service.ShrekExecuteServiceHelper;
import kd.epm.eb.common.shrek.util.ShrekIdCodeUtils;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.LogHelper;
import kd.epm.eb.olap.transaction.OlapDataInfo;
import kd.epm.eb.olap.transaction.OlapDataLogService;
import kd.epm.eb.olap.transaction.OlapTX;
import kd.epm.eb.olap.transaction.OlapTXContext;

public class OlapTransactionHandler
implements CommitListener {
    private static final Log log = LogFactory.getLog(OlapTransactionHandler.class);
    private OlapTXContext olapTXContext;

    public OlapTransactionHandler(OlapTXContext olapTXContext) {
        this.olapTXContext = olapTXContext;
    }

    public OlapTXContext getOlapTXContext() {
        return this.olapTXContext;
    }

    public Long getTrxId() {
        return this.olapTXContext.getTrxId();
    }

    public void onRollbacked() {
    }

    public void onEnded(boolean rollbacked) {
        try {
            Set<Long> rollbackCubeIds = null;
            if (rollbacked) {
                rollbackCubeIds = this.rollbackOlapData();
            }
            OlapDataLogService.delLogByTrxId(this.getTrxId(), rollbackCubeIds);
            OlapTX.doEnd(this.getOlapTXContext());
        }
        catch (Exception e) {
            log.error("OlapTrx-onEnded-error", (Throwable)e);
        }
    }

    private Set<Long> rollbackOlapData() {
        Long trxId = this.getTrxId();
        HashSet<Long> cubeIds = new HashSet<Long>(16);
        List<OlapDataInfo> olapDataLogByTransaction = OlapDataLogService.getOlapDataLogByTransaction(trxId);
        LogHelper logHelper = new LogHelper(log);
        if (olapDataLogByTransaction.size() > 0) {
            for (OlapDataInfo olapDataInfo : olapDataLogByTransaction) {
                try {
                    this.rollbackOlapData(olapDataInfo);
                }
                catch (Exception e) {
                    log.error(String.format("OlapTrx-onRollbacked:trxId:%s,datasetId:%s,modelId:%s,dataSize:%s", trxId, olapDataInfo.getDatasetId(), olapDataInfo.getModelId(), olapDataInfo.getCells().size()), (Throwable)e);
                    continue;
                }
                cubeIds.add(olapDataInfo.getDatasetId());
                log.info(String.format("OlapTrx-onRollbacked:trxId:%s,datasetId:%s,modelId:%s,dataSize:%s", trxId, olapDataInfo.getDatasetId(), olapDataInfo.getModelId(), olapDataInfo.getCells().size()));
            }
        }
        logHelper.addInfoLog("OlapTrx-onRollbacked-end");
        return cubeIds;
    }

    private void rollbackOlapData(OlapDataInfo olapDataInfo) {
        String[] dimensions;
        if (CollectionUtils.isEmpty(olapDataInfo.getCells())) {
            return;
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)olapDataInfo.getModelId());
        Dataset dataset = null;
        if (modelCacheHelper.getModelobj().isModelByEB()) {
            dimensions = modelCacheHelper.getDimensionNums();
        } else {
            dataset = Dataset.of((DynamicObject)BusinessDataServiceHelper.loadSingle((Object)olapDataInfo.getDatasetId(), (String)"eb_dataset"));
            dimensions = modelCacheHelper.getDimensionNums(dataset.getId());
        }
        try (IShrekSave iShrekSave = ShrekExecuteServiceHelper.saveData((Model)modelCacheHelper.getModelobj(), (Dataset)dataset, (String[])dimensions, (Map)ShrekIdCodeUtils.getDefaultIdCodes(null));){
            olapDataInfo.getCells().forEach(cell -> iShrekSave.add(cell.getMemberNums(), cell.getVal()));
        }
    }
}

