/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.DimensionFilterItem;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.olap.entity.DimPage;
import kd.epm.eb.olap.service.request.QueryRequest;

public class PageUtil {
    private static final Log log = LogFactory.getLog(PageUtil.class);

    public static List<QueryRequest> getSelectCommandInfoPage(SelectCommandInfo sci, int orgPageSize) {
        long st = System.currentTimeMillis();
        log.info("\u5f00\u59cb\u5206\u9875");
        Map<String, List<List<String>>> dimPageMap = PageUtil.getTotalPageMapExcludeBp(sci, orgPageSize);
        ArrayList<QueryRequest> result = new ArrayList<QueryRequest>(16);
        ArrayList<List<List<String>>> allMembers = new ArrayList<List<List<String>>>(dimPageMap.size());
        ArrayList<String> dimensions = new ArrayList<String>(dimPageMap.keySet());
        for (String dimNumber : dimensions) {
            allMembers.add(dimPageMap.get(dimNumber));
        }
        CommonServiceHelper.buildDescartes(allMembers, memberPage -> {
            QueryRequest request = new QueryRequest();
            HashMap<String, Set<String>> memberInfo = new HashMap<String, Set<String>>(dimensions.size());
            for (int dimIndex = 0; dimIndex < dimensions.size(); ++dimIndex) {
                memberInfo.put((String)dimensions.get(dimIndex), new HashSet((Collection)memberPage.get(dimIndex)));
            }
            request.setMemberInfo(memberInfo);
            result.add(request);
            return false;
        });
        log.info("\u5206\u9875\u6570\uff1a" + result.size() + ",\u5206\u9875\u8017\u65f6:" + (System.currentTimeMillis() - st));
        return result;
    }

    public static Iterator<Map<String, Set<String>>> getPageMapExcludeBpIterator(Map<String, Set<String>> memberScope, int pageSize) {
        Map<String, List<List<String>>> dimPageMap = PageUtil.getPageMap(memberScope, pageSize);
        List<List<DimPage>> list = PageUtil.getDimPage(dimPageMap);
        return new PageIterator(list);
    }

    public static List<Map<String, Set<String>>> getPageByOrg(Map<String, Set<String>> memberScope, int orgPageSize) {
        Set<String> entitySet = memberScope.get(SysDimensionEnum.Entity.getNumber());
        List partition = Lists.partition(new ArrayList<String>(entitySet), (int)orgPageSize);
        ArrayList orgPages = Lists.newArrayListWithExpectedSize((int)orgPageSize);
        for (List sugOrg : partition) {
            HashMap<String, Set<String>> sub = new HashMap<String, Set<String>>(memberScope);
            sub.put(SysDimensionEnum.Entity.getNumber(), new HashSet(sugOrg));
            orgPages.add(sub);
        }
        return orgPages;
    }

    public static List<Map<String, Set<String>>> getPageMapExcludeBp(Map<String, Set<String>> memberScope, int pageSize) {
        long st = System.currentTimeMillis();
        log.info("\u5f00\u59cb\u5206\u9875");
        Map<String, List<List<String>>> dimPageMap = PageUtil.getPageMap(memberScope, pageSize);
        List<Map<String, Set<String>>> pageList = PageUtil.getSubMap(dimPageMap);
        log.info("\u5206\u9875\u6570\uff1a" + pageList.size() + ",\u5206\u9875\u8017\u65f6:" + (System.currentTimeMillis() - st));
        return pageList;
    }

    private static List<Map<String, Set<String>>> getSubMap(Map<String, List<List<String>>> dimPageMap) {
        List<List<DimPage>> resultList = PageUtil.getDimPage(dimPageMap);
        ArrayList sciList = Lists.newArrayListWithExpectedSize((int)20);
        for (List<DimPage> dimPages : resultList) {
            HashMap scopeMap = Maps.newHashMapWithExpectedSize((int)16);
            for (DimPage dimPage : dimPages) {
                scopeMap.put(dimPage.getDimNumber(), new HashSet<String>(dimPage.getMembers()));
            }
            sciList.add(scopeMap);
        }
        return sciList;
    }

    private static List<List<DimPage>> getDimPage(Map<String, List<List<String>>> dimPageMap) {
        ArrayList list = new ArrayList(dimPageMap.size());
        for (Map.Entry<String, List<List<String>>> entry : dimPageMap.entrySet()) {
            String dimNumber = entry.getKey();
            List<List<String>> pageList = entry.getValue();
            ArrayList<DimPage> dimPageList = new ArrayList<DimPage>(pageList.size());
            for (List<String> page : pageList) {
                DimPage dimPage = new DimPage(dimNumber, page);
                dimPageList.add(dimPage);
            }
            list.add(dimPageList);
        }
        return Lists.cartesianProduct(list);
    }

    public static Map<String, List<List<String>>> getTotalPageMapExcludeBp(SelectCommandInfo queryInfo, int orgPageSize) {
        ConcurrentHashMap<String, List<List<String>>> dimPageMap = new ConcurrentHashMap<String, List<List<String>>>(64);
        for (DimensionFilterItem item : queryInfo.getFilter()) {
            String dimNumber = item.getName();
            List members = item.getValues();
            if (SysDimensionEnum.Entity.getNumber().equals(dimNumber)) {
                List memberPageList = Lists.partition((List)members, (int)orgPageSize);
                dimPageMap.put(dimNumber, memberPageList);
                continue;
            }
            ArrayList memberList = Lists.newArrayListWithExpectedSize((int)1);
            memberList.add(members);
            dimPageMap.put(dimNumber, memberList);
        }
        return dimPageMap;
    }

    public static Map<String, List<List<String>>> getPageMap(Map<String, Set<String>> queryInfo, int pageSize) {
        int currDescar = 1;
        ConcurrentHashMap<String, List<List<String>>> dimPageMap = new ConcurrentHashMap<String, List<List<String>>>(64);
        currDescar *= queryInfo.get(SysDimensionEnum.BudgetPeriod.getNumber()).size();
        for (Map.Entry<String, Set<String>> entry : queryInfo.entrySet()) {
            int partSign;
            List memberPageList;
            String dimNumber = entry.getKey();
            ArrayList members = new ArrayList(entry.getValue());
            if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber)) {
                memberPageList = new ArrayList(1);
                memberPageList.add(members);
                dimPageMap.put(dimNumber, memberPageList);
                continue;
            }
            if (currDescar > pageSize) {
                memberPageList = Lists.partition(members, (int)1);
                dimPageMap.put(dimNumber, memberPageList);
                continue;
            }
            int tmp = Integer.MAX_VALUE / currDescar;
            List memberPageList2 = new ArrayList(16);
            if (tmp >= members.size()) {
                if ((currDescar *= members.size()) > pageSize) {
                    partSign = pageSize / (currDescar / members.size());
                    memberPageList2 = Lists.partition(members, (int)partSign);
                } else {
                    memberPageList2.add(members);
                }
            } else {
                partSign = pageSize / currDescar;
                memberPageList2 = Lists.partition(members, (int)partSign);
            }
            dimPageMap.put(dimNumber, memberPageList2);
        }
        return dimPageMap;
    }

    private static class PageIterator
    implements Iterator<Map<String, Set<String>>> {
        private Iterator<List<DimPage>> dataIterator;

        PageIterator(List<List<DimPage>> list) {
            log.info("PageIterator\u5206\u9875\u5927\u5c0f\uff1a" + list.size());
            this.dataIterator = list.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.dataIterator.hasNext();
        }

        @Override
        public Map<String, Set<String>> next() {
            List<DimPage> dimPages = this.dataIterator.next();
            HashMap pageMap = Maps.newHashMapWithExpectedSize((int)16);
            for (DimPage dimPage : dimPages) {
                pageMap.put(dimPage.getDimNumber(), new HashSet<String>(dimPage.getMembers()));
            }
            return pageMap;
        }
    }
}

