/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.opplugin.Adjust;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelUtils;
import kd.epm.eb.opplugin.quote.AbstractSaveQuoteOp;
import org.jetbrains.annotations.NotNull;

public class AdjustSaveQuoteOp
extends AbstractSaveQuoteOp {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        this.saveMemberQuote(e.getDataEntities());
    }

    @Override
    protected void saveMemberQuote(DynamicObject[] adjusts) {
        if (adjusts == null || adjusts.length == 0) {
            return;
        }
        LinkedList<MemberQuoteDao> quotes = new LinkedList<MemberQuoteDao>();
        IModelCacheHelper modelCache = null;
        for (DynamicObject _adjust : adjusts) {
            Long id = _adjust.getLong("id");
            Long modelId = null;
            Long busModelId = null;
            DynamicObject _object = _adjust.getDynamicObject("model");
            if (_object != null) {
                modelId = _object.getLong("id");
            }
            if ((_object = _adjust.getDynamicObject("bizmodel")) != null) {
                busModelId = _object.getLong("id");
            }
            if (modelId == null || modelId == 0L) continue;
            if (modelCache == null || modelCache.getModelobj().getId().compareTo(modelId) != 0) {
                modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            }
            if (IDUtils.isNotNull((Long)busModelId)) {
                quotes.add(new MemberQuoteDao(modelId, Long.valueOf(0L), Long.valueOf(0L), busModelId, MemberTypeEnum.BUSINESS_MODEL, MemberQuoteResourceEnum.AdjustBill, id));
            }
            quotes.addAll(this.getCommonQuotes(modelId, busModelId, modelCache, _adjust));
        }
        this.saveQuote(quotes);
    }

    private List<MemberQuoteDao> getCommonQuotes(@NotNull Long modelId, Long busModelId, IModelCacheHelper modelCache, DynamicObject adjust) {
        if (modelCache == null || adjust == null) {
            return Collections.emptyList();
        }
        LinkedList<MemberQuoteDao> quotes = new LinkedList<MemberQuoteDao>();
        Long adjustId = adjust.getLong("id");
        LinkedHashSet<Long> memberIds = new LinkedHashSet<Long>();
        Map dimensionMap = modelCache.getDimensionMap();
        int seq = 1;
        List dimensions = IDUtils.isNotNull((Long)busModelId) ? modelCache.getDimensionListByBusModel(busModelId) : modelCache.getDimensionList();
        LinkedHashMap userDimMap = Maps.newLinkedHashMap();
        for (Dimension _dimension : dimensions) {
            if (!BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)_dimension)) continue;
            userDimMap.put(seq++, _dimension);
        }
        DynamicObjectCollection entries = adjust.getDynamicObjectCollection("adjdetailentity");
        if (entries != null && !entries.isEmpty()) {
            for (DynamicObject entry : entries) {
                DynamicObject _tmpDo;
                DynamicObjectCollection dos;
                Dimension dimension;
                Long memberId;
                Long datasetId = 0L;
                DynamicObject _do = entry.getDynamicObject("account");
                if (_do != null) {
                    Member member;
                    memberId = _do.getLong("id");
                    dimension = (Dimension)dimensionMap.get(SysDimensionEnum.Account.getNumber());
                    if (dimension != null && (member = dimension.getMember(Long.valueOf(0L), memberId)) != null && IDUtils.isNotNull((Long)busModelId)) {
                        datasetId = member.getDatasetId();
                        quotes.add(new MemberQuoteDao(modelId, datasetId, dimension.getId(), memberId, MemberQuoteResourceEnum.AdjustBill, adjustId));
                    }
                }
                if (datasetId == null || datasetId == 0L) continue;
                _do = adjust.getDynamicObject("datatype");
                if (_do != null) {
                    memberId = _do.getLong("id");
                    dimension = (Dimension)dimensionMap.get(SysDimensionEnum.DataType.getNumber());
                    if (dimension != null) {
                        quotes.add(new MemberQuoteDao(modelId, dimension.getId(), memberId, MemberQuoteResourceEnum.AdjustBill, adjustId));
                    }
                }
                if ((dos = adjust.getDynamicObjectCollection("budgetperiods")) != null && !dos.isEmpty()) {
                    for (DynamicObject __do : dos) {
                        _tmpDo = __do.getDynamicObject("fbasedataid");
                        if (_tmpDo == null) continue;
                        memberIds.add(_tmpDo.getLong("id"));
                    }
                    dimension = (Dimension)dimensionMap.get(SysDimensionEnum.BudgetPeriod.getNumber());
                    if (dimension != null) {
                        quotes.add(new MemberQuoteDao(modelId, datasetId, dimension.getId(), memberIds, MemberQuoteResourceEnum.AdjustBill, adjustId));
                    }
                }
                if ((_do = adjust.getDynamicObject("year")) != null) {
                    memberId = _do.getLong("id");
                    dimension = (Dimension)dimensionMap.get(SysDimensionEnum.Year.getNumber());
                    if (dimension != null) {
                        quotes.add(new MemberQuoteDao(modelId, datasetId, dimension.getId(), memberId, MemberQuoteResourceEnum.AdjustBill, adjustId));
                    }
                }
                if ((dos = adjust.getDynamicObjectCollection("multperiod")) != null && !dos.isEmpty()) {
                    memberIds.clear();
                    for (DynamicObject __do : dos) {
                        _tmpDo = __do.getDynamicObject("fbasedataid");
                        if (_tmpDo == null) continue;
                        memberIds.add(_tmpDo.getLong("id"));
                    }
                    dimension = (Dimension)dimensionMap.get(SysDimensionEnum.Period.getNumber());
                    if (dimension != null) {
                        quotes.add(new MemberQuoteDao(modelId, datasetId, dimension.getId(), memberIds, MemberQuoteResourceEnum.AdjustBill, adjustId));
                    }
                }
                if ((_do = adjust.getDynamicObject("version")) != null) {
                    memberId = _do.getLong("id");
                    dimension = (Dimension)dimensionMap.get(SysDimensionEnum.Version.getNumber());
                    if (dimension != null) {
                        quotes.add(new MemberQuoteDao(modelId, datasetId, dimension.getId(), memberId, MemberQuoteResourceEnum.AdjustBill, adjustId));
                    }
                }
                if ((_do = adjust.getDynamicObject("changetype")) != null) {
                    memberId = _do.getLong("id");
                    dimension = (Dimension)dimensionMap.get(SysDimensionEnum.ChangeType.getNumber());
                    if (dimension != null) {
                        quotes.add(new MemberQuoteDao(modelId, datasetId, dimension.getId(), memberId, MemberQuoteResourceEnum.AdjustBill, adjustId));
                    }
                }
                if ((_do = adjust.getDynamicObject("currency")) != null) {
                    memberId = _do.getLong("id");
                    dimension = (Dimension)dimensionMap.get(SysDimensionEnum.Currency.getNumber());
                    if (dimension != null) {
                        quotes.add(new MemberQuoteDao(modelId, datasetId, dimension.getId(), memberId, MemberQuoteResourceEnum.AdjustBill, adjustId));
                    }
                }
                if ((_do = entry.getDynamicObject("entity")) != null) {
                    memberId = _do.getLong("id");
                    dimension = (Dimension)dimensionMap.get(SysDimensionEnum.Entity.getNumber());
                    if (dimension != null) {
                        quotes.add(new MemberQuoteDao(modelId, datasetId, dimension.getId(), memberId, MemberQuoteResourceEnum.AdjustBill, adjustId));
                    }
                }
                if ((_do = entry.getDynamicObject("metric")) != null) {
                    memberId = _do.getLong("id");
                    dimension = (Dimension)dimensionMap.get(SysDimensionEnum.Metric.getNumber());
                    if (dimension != null) {
                        quotes.add(new MemberQuoteDao(modelId, datasetId, dimension.getId(), memberId, MemberQuoteResourceEnum.AdjustBill, adjustId));
                    }
                }
                DynamicObject model = ModelUtils.getModel((Long)modelId);
                String reportType = model.getString("reporttype");
                int customDimCounts = 6;
                if (!ApplicationTypeEnum.EB.getIndex().equals(reportType)) {
                    customDimCounts = 50;
                }
                for (int index = 1; index <= customDimCounts; ++index) {
                    _do = entry.getDynamicObject("customdim" + index);
                    if (_do == null) continue;
                    memberId = _do.getLong("id");
                    dimension = (Dimension)userDimMap.get(index);
                    if (dimension == null) continue;
                    quotes.add(new MemberQuoteDao(modelId, datasetId, dimension.getId(), memberId, MemberQuoteResourceEnum.AdjustBill, adjustId));
                }
            }
        }
        return quotes;
    }
}

