/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.opplugin.Adjust;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.adjust.AdjustBillConvertor;
import kd.epm.eb.business.adjust.AdjustHelper;
import kd.epm.eb.business.adjust.service.IAdjustBillService;
import kd.epm.eb.common.adjust.AdjustBill;
import kd.epm.eb.common.adjust.AdjustBillEnum;
import kd.epm.eb.common.dao.adjust.CompareDataPojo;
import kd.epm.eb.common.enums.AdjustBillStateEnum;
import kd.epm.eb.common.enums.BgControlSettingTypeEnum;
import kd.epm.eb.common.enums.EbAdjBillTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.DynamicInfoCollection;
import kd.epm.eb.common.model.Pair;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.controlParamsSetting.ControlParamsSettingUtil;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.control.BgControlCallerImpl;
import kd.epm.eb.control.calc.impl.LimitBalance;
import kd.epm.eb.control.face.IBudgetBalance;
import kd.epm.eb.control.utils.BudgetAdjustCheckUtils;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.opplugin.Adjust.IsSuperPassBudgetValidator;

public class AuditOp
extends AbstractOperationServicePlugIn {
    protected static final Log log = LogFactory.getLog(AuditOp.class);
    private static final String ADJENTRYENTITY = "adjdetailentity";
    private DynamicInfoCollection dynamicInfoCollection;
    private List<Map<String, String>> dimlist;
    private static Map<String, BigDecimal> adjustValueMap;
    private static Map<String, BigDecimal> submitValueMap;
    private static Boolean adjustCheckFlag;
    private LogStats logStats = new LogStats("adjustAudio");

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("model");
        fieldKeys.add("version");
        fieldKeys.add("year");
        fieldKeys.add("changetype");
        fieldKeys.add("currency");
        fieldKeys.add("multperiod");
        fieldKeys.add("adjdetailentity.entity");
        fieldKeys.add("adjdetailentity.account");
        fieldKeys.add("adjdetailentity.customdim1");
        fieldKeys.add("adjdetailentity.customdim2");
        fieldKeys.add("adjdetailentity.customdim3");
        fieldKeys.add("adjdetailentity.customdim4");
        fieldKeys.add("adjdetailentity.customdim5");
        fieldKeys.add("adjdetailentity.customdim6");
        fieldKeys.add("adjdetailentity.groupnum");
        fieldKeys.add("adjdetailentity.budgetbalance");
        fieldKeys.add("adjdetailentity.limitbalance");
        fieldKeys.add("adjdetailentity.limitbalanceshow");
        fieldKeys.add("adjdetailentity.beyond");
        fieldKeys.add("adjdetailentity.budgetdata");
        fieldKeys.add("adjdetailentity.adjustdata");
        fieldKeys.add("adjdetailentity.finaldata");
        fieldKeys.add("adjdetailentity.adjexplain");
        fieldKeys.add("adjdetailentity.period");
        fieldKeys.add("datatype");
        fieldKeys.add("adjdetailentity.ordersign");
        fieldKeys.add("billtype");
        fieldKeys.add("adjdetailentity.submitvalue");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        if (!AdjustHelper.verifyBillStatus((DynamicObject[])dataEntities)) {
            e.setCancel(true);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        this.lock(dataEntities);
    }

    private void lock(DynamicObject[] dataEntities) {
        if (StringUtils.isEmpty((String)"audit/control")) {
            throw new KDBizException("error lock key.");
        }
        try (DLock lock = DLock.create((String)"eb/audit/control/9999");){
            if (!lock.tryLock(5000L)) {
                throw new KDBizException(AuditOp.getLockErrorMessage("audit/control"));
            }
            try {
                AuditOp.dbLock();
                this.adjust(dataEntities);
            }
            catch (Exception ex) {
                log.info("[ExpenseBudgetAuditOp] audit error: {}", (Object)ex);
                throw new KDBizException("audit failed:" + ex.getMessage());
            }
        }
    }

    private void adjust(DynamicObject[] dataEntities) {
        log.info("[ExpenseBudgetAuditOp] adjust start");
        if (dataEntities != null && dataEntities.length > 0) {
            this.logStats.add("begin endOperationTransaction", true);
            DynamicObject doc = dataEntities[0];
            this.dynamicInfoCollection = AuditOp.buildCustomDimInfo(((DynamicObject)doc.get("model")).getLong("id"));
            ArrayList<CompareDataPojo> finalDataByPeriodAndOrgShow = new ArrayList<CompareDataPojo>();
            ArrayList<CompareDataPojo> finalDataByPeriodAndOrg = new ArrayList<CompareDataPojo>();
            this.dimlist = new ArrayList<Map<String, String>>();
            this.getFinalDataByPeriodAndOrgByEnd(doc, this.dynamicInfoCollection, finalDataByPeriodAndOrgShow);
            this.getFinalDataByPeriodAndOrgByEnd(doc, this.dynamicInfoCollection, finalDataByPeriodAndOrg);
            this.getDimQueryListByEnd(this.dimlist, doc, this.dynamicInfoCollection, false, false);
            ArrayList<CompareDataPojo> checkByPeriodAndOrg = new ArrayList<CompareDataPojo>(finalDataByPeriodAndOrgShow.size());
            for (CompareDataPojo com : finalDataByPeriodAndOrgShow) {
                if (com.getAdjustdata().compareTo(BigDecimal.ZERO) == 0) continue;
                checkByPeriodAndOrg.add(com);
            }
            String formType = doc.getString("billtype");
            adjustValueMap = BudgetAdjustCheckUtils.getAdjustValueMap(checkByPeriodAndOrg, (String)"adjustValue", (String)formType);
            submitValueMap = BudgetAdjustCheckUtils.getAdjustValueMap(checkByPeriodAndOrg, (String)"submitValue", (String)formType);
            this.checkAdjustBalance(doc, finalDataByPeriodAndOrgShow);
            try {
                this.updateBillInfoAfterChange(doc, finalDataByPeriodAndOrgShow);
                this.saveDataToOlap(doc);
            }
            catch (Exception exception) {
                throw new KDBizException(exception.getMessage());
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5230\u7684\u52a8\u6001\u5bf9\u8c61\u4e3a\u7a7a\u3002", (String)"AuditOp_0", (String)"epm-eb-opplugin", (Object[])new Object[0]));
        }
        log.info("[ExpenseBudgetAuditOp] adjust end");
    }

    private void checkAdjustBalance(DynamicObject doc, List<CompareDataPojo> finalDataByPeriodAndOrg) {
        Long modelId = doc.getDynamicObject("model").getLong("id");
        String formType = doc.getString("billtype");
        if (formType == null) {
            formType = EbAdjBillTypeEnum.adjust.getNumber();
        }
        String auditTrail = ControlParamsSettingUtil.getAuditTrailShow((Long)modelId, (String)formType, (boolean)ModelUtil.isEbOrBgModel((Long)modelId));
        log.info("[OverallBudgetAuditOp] checkAdjustBalance==>auditTrail={}", (Object)auditTrail);
        adjustCheckFlag = false;
        Collection<IBudgetBalance> iBudgetBalances = this.queryBalance(doc, this.dimlist, auditTrail);
        adjustCheckFlag = true;
        ArrayList<Map<String, String>> checkDimList = new ArrayList<Map<String, String>>(this.dimlist.size());
        this.getDimQueryListByEnd(checkDimList, doc, this.dynamicInfoCollection, true, false);
        if (BudgetAdjustCheckUtils.checkCustomDimExist((long)modelId, (long)0L)) {
            this.getDimQueryListByEnd(checkDimList, doc, this.dynamicInfoCollection, true, true);
        }
        ArrayList<IBudgetBalance> checkIBudgetBalances = new ArrayList(finalDataByPeriodAndOrg.size());
        if (BudgetAdjustCheckUtils.checkAuditTrailParamRelation((Long)modelId, (String)formType).booleanValue()) {
            checkIBudgetBalances = this.queryBalance(doc, checkDimList, auditTrail);
        }
        IsSuperPassBudgetValidator isSuperPassBudgetValidator = new IsSuperPassBudgetValidator(this.dynamicInfoCollection, finalDataByPeriodAndOrg, iBudgetBalances, checkIBudgetBalances);
        isSuperPassBudgetValidator.IsAdjustment();
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
    }

    private void saveDataToOlap(DynamicObject doc) {
        AdjustBill adjustBill = AdjustBillConvertor.dynamic2AdjustBill((DynamicObject)doc, (boolean)true);
        IAdjustBillService adjustBillService = AdjustHelper.getInstance((AdjustBillEnum)AdjustBillEnum.EXPENSE);
        adjustBillService.saveBudgetData2Olap(adjustBill, true);
        adjustBillService.saveOccupyData2Olap(adjustBill, false);
    }

    private static DynamicInfoCollection buildCustomDimInfo(Long modelId) {
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)modelId);
        builder.add("issysdimension", "=", (Object)false);
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"epm_dimension", (String)"number,name,id,shortnumber", (QFilter[])builder.toArrays(), (String)"dseq");
        DynamicInfoCollection customdimInfo = new DynamicInfoCollection(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u4fe1\u606f\uff1a\u524d\u7aef\u6807\u8bc6\u3001\u7f16\u7801\u3001\u540d\u79f0\u3001id\u3001\u9ed8\u8ba4\u4e0d\u533a\u5206\u6210\u5458id\u3001\u4e0d\u533a\u5206\u6210\u5458\u7f16\u7801\u3002", (String)"AuditOp_4", (String)"epm-eb-opplugin", (Object[])new Object[0]), new String[]{"controlkey", "number", "shortNum", "name", "id", "defMemberId", "defMemberNum"});
        int seq = 1;
        for (DynamicObject customDim : dims) {
            String name = customDim.getString("name");
            String number = customDim.getString("number");
            String id = customDim.getString("id");
            String shortNum = customDim.getString("shortnumber");
            customdimInfo.addInfo(new Object[]{"adjcustomdim" + seq++, number, shortNum, name, id, null, null});
        }
        if (!customdimInfo.isEmpty()) {
            QFBuilder qb = new QFBuilder("dimension", "in", (Object)IDUtils.toLongs((List)customdimInfo.getAllValOfOneProp("id")));
            qb.add("membersource", "=", (Object)"1");
            qb.add("number", "like", (Object)"%None");
            DynamicObjectCollection defMembers = QueryServiceHelper.query((String)"epm_userdefinedmembertree", (String)"id,dimension,number", (QFilter[])qb.toArray());
            DynamicInfoCollection.InfoObject infoOb = null;
            for (DynamicObject member : defMembers) {
                String memberId = member.getString("id");
                String dimensionId = member.getString("dimension");
                infoOb = customdimInfo.getInfoByOneProp("id", (Object)dimensionId);
                infoOb.setValueByPropName("defMemberId", (Object)memberId);
                infoOb.setValueByPropName("defMemberNum", (Object)member.getString("number"));
            }
        }
        return customdimInfo;
    }

    private Collection<IBudgetBalance> queryBalance(DynamicObject doc, List<Map<String, String>> dimList, String auditTrail) {
        for (Map<String, String> map : dimList) {
            if (!map.containsKey(SysDimensionEnum.AuditTrail.getNumber())) continue;
            map.put(SysDimensionEnum.AuditTrail.getNumber(), auditTrail);
        }
        ArrayList<String> type = new ArrayList<String>();
        if (!AuditOp.IsExitMixturePeriod(this.dimlist, type)) {
            return AuditOp.getAllIbCollection(dimList, null, type, ((DynamicObject)doc.get("model")).getLong("id"));
        }
        return AuditOp.queryBalanceBytype(null, dimList, type, ((DynamicObject)doc.get("model")).getLong("id"));
    }

    private static Collection<IBudgetBalance> getAllIbCollection(List<Map<String, String>> dimlist, IDataModel dataModel, Collection<String> type, Long modelid) {
        ArrayList<IBudgetBalance> cl = new ArrayList<IBudgetBalance>();
        ArrayList<Map<String, String>> qlist = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> hlist = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> mlist = new ArrayList<Map<String, String>>();
        for (int k = 0; k < dimlist.size(); ++k) {
            for (String key : dimlist.get(k).keySet()) {
                if (key.equals("Period") && dimlist.get(k).get(key).startsWith("Q_")) {
                    qlist.add(dimlist.get(k));
                    continue;
                }
                if (key.equals("Period") && dimlist.get(k).get(key).startsWith("HF_")) {
                    hlist.add(dimlist.get(k));
                    continue;
                }
                if (!key.equals("Period") || !dimlist.get(k).get(key).startsWith("M_")) continue;
                mlist.add(dimlist.get(k));
            }
        }
        if (qlist.size() != 0) {
            type.add(BgControlSettingTypeEnum.QUARTER.getNumber());
            Collection<IBudgetBalance> budgetBalances = AuditOp.queryBalanceBytype(dataModel, qlist, type, modelid);
            cl.addAll(budgetBalances);
            type.clear();
        }
        if (hlist.size() != 0) {
            type.add(BgControlSettingTypeEnum.HALFYEAR.getNumber());
            Collection<IBudgetBalance> budgetBalances = AuditOp.queryBalanceBytype(dataModel, hlist, type, modelid);
            cl.addAll(budgetBalances);
            type.clear();
        }
        if (mlist.size() != 0) {
            type.add(BgControlSettingTypeEnum.MONTH.getNumber());
            Collection<IBudgetBalance> budgetBalances = AuditOp.queryBalanceBytype(dataModel, mlist, type, modelid);
            cl.addAll(budgetBalances);
            type.clear();
        }
        return cl;
    }

    private static Collection<IBudgetBalance> queryBalanceBytype(IDataModel dataModel, List<Map<String, String>> dimlist, Collection<String> type, Long modelid) {
        BgControlCallerImpl bgControlCaller = new BgControlCallerImpl();
        Collection iBudgetBalances = null;
        try {
            iBudgetBalances = dataModel == null ? (adjustCheckFlag.booleanValue() ? bgControlCaller.queryBalance(modelid, dimlist, type, true, Long.valueOf(0L), adjustValueMap, submitValueMap) : bgControlCaller.queryBalance(modelid, dimlist, type, true)) : (adjustCheckFlag.booleanValue() ? bgControlCaller.queryBalance(Long.valueOf(((DynamicObject)dataModel.getValue("model")).getLong("id")), dimlist, type, true, Long.valueOf(0L), adjustValueMap, submitValueMap) : bgControlCaller.queryBalance(Long.valueOf(((DynamicObject)dataModel.getValue("model")).getLong("id")), dimlist, type, true));
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        return iBudgetBalances;
    }

    private static boolean IsExitMixturePeriod(List<Map<String, String>> dimlist, Collection<String> type) {
        int i = 0;
        int j = 0;
        int z = 0;
        for (Map<String, String> map : dimlist) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (entry.getKey() == null || !entry.getKey().equals("Period")) continue;
                if (entry.getValue().startsWith("Q_")) {
                    ++i;
                    continue;
                }
                if (entry.getValue().startsWith("H_")) {
                    ++j;
                    continue;
                }
                if (!entry.getValue().startsWith("M_")) continue;
                ++z;
            }
        }
        if (i != 0 && j == 0 && z == 0) {
            type.add(BgControlSettingTypeEnum.QUARTER.getNumber());
        } else if (i == 0 && j != 0 && z == 0) {
            type.add(BgControlSettingTypeEnum.HALFYEAR.getNumber());
        } else if (i == 0 && j == 0 && z != 0) {
            type.add(BgControlSettingTypeEnum.MONTH.getNumber());
        } else {
            return false;
        }
        return true;
    }

    private void getDimQueryListByEnd(List<Map<String, String>> dimlist, DynamicObject doc, DynamicInfoCollection dynamicInfoCollection, boolean checkFlag, boolean customTotalFlag) {
        long modelId = doc.getDynamicObject("model").getLong("id");
        String formType = doc.getString("billtype");
        String billNumber = doc.getString("billno");
        if (formType == null) {
            formType = EbAdjBillTypeEnum.adjust.getNumber();
        }
        String auditTrail = ControlParamsSettingUtil.getAuditTrail((Long)modelId, (String)formType, (boolean)ModelUtil.isEbOrBgModel((Long)modelId));
        DynamicObjectCollection entryEntity = doc.getDynamicObjectCollection(ADJENTRYENTITY);
        for (DynamicObject entryDynamicObject : entryEntity) {
            if (checkFlag && entryDynamicObject.getBigDecimal("adjustdata").compareTo(BigDecimal.ZERO) >= 0) continue;
            HashMap<String, String> dimMap = new HashMap<String, String>();
            String entryNumber = ((DynamicObject)entryDynamicObject.get("entity")).getString("number");
            String accountNumber = ((DynamicObject)entryDynamicObject.get("account")).getString("number");
            dimMap.put(SysDimensionEnum.Period.getNumber(), ((DynamicObject)entryDynamicObject.get("period")).getString("number"));
            String datatypeNumber = ((DynamicObject)doc.get("datatype")).getString("number");
            dimMap.put(SysDimensionEnum.DataType.getNumber(), datatypeNumber);
            String versionNumber = ((DynamicObject)doc.get("version")).getString("number");
            dimMap.put(SysDimensionEnum.Version.getNumber(), versionNumber);
            String yearNumber = ((DynamicObject)doc.get("year")).getString("number");
            dimMap.put(SysDimensionEnum.Year.getNumber(), yearNumber);
            String currencyNumber = ((DynamicObject)doc.get("currency")).getString("number");
            dimMap.put(SysDimensionEnum.Currency.getNumber(), currencyNumber);
            String changetypeNumber = ((DynamicObject)doc.get("changetype")).getString("number");
            dimMap.put(SysDimensionEnum.ChangeType.getNumber(), changetypeNumber);
            dimMap.put(SysDimensionEnum.Entity.getNumber(), entryNumber);
            dimMap.put(SysDimensionEnum.Account.getNumber(), accountNumber);
            dimMap.put(SysDimensionEnum.AuditTrail.getNumber(), auditTrail);
            if (!dynamicInfoCollection.isEmpty()) {
                for (DynamicInfoCollection.InfoObject in : dynamicInfoCollection.getValues()) {
                    if (checkFlag && customTotalFlag) {
                        dimMap.put((String)in.getValueByPropName("number"), (String)in.getValueByPropName("number"));
                        continue;
                    }
                    String controlkey = (String)in.getValueByPropName("controlkey");
                    if ((DynamicObject)entryDynamicObject.get(controlkey = controlkey.substring(3, controlkey.length())) != null) {
                        dimMap.put((String)in.getValueByPropName("number"), ((DynamicObject)entryDynamicObject.get(controlkey)).getString("number"));
                        continue;
                    }
                    dimMap.put((String)in.getValueByPropName("number"), (String)in.getValueByPropName("shortNum") + "None");
                }
            }
            if (checkFlag) {
                dimMap.put("billNumber", billNumber);
            }
            dimlist.add(dimMap);
        }
    }

    private void getFinalDataByPeriodAndOrgByEnd(DynamicObject doc, DynamicInfoCollection dynamicInfoCollection, List<CompareDataPojo> rowData) {
        long modelId = doc.getDynamicObject("model").getLong("id");
        String formType = doc.getString("billtype");
        if (formType == null) {
            formType = EbAdjBillTypeEnum.adjust.getNumber();
        }
        DynamicObjectCollection entryEntity = doc.getDynamicObjectCollection(ADJENTRYENTITY);
        String versionNumber = ((DynamicObject)doc.get("version")).getString("number");
        String yearNumber = ((DynamicObject)doc.get("year")).getString("number");
        String currencyNumber = ((DynamicObject)doc.get("currency")).getString("number");
        String datatypeNumber = ((DynamicObject)doc.get("datatype")).getString("number");
        String changetypeNumber = ((DynamicObject)doc.get("changetype")).getString("number");
        String billNumber = (String)doc.get("billno");
        int row = 0;
        String entityNumber = doc.getDataEntityType().getName();
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            String orgNumber = ((DynamicObject)entry.get("entity")).getString("number");
            String accountNumber = ((DynamicObject)entry.get("account")).getString("number");
            String periodName = ((DynamicObject)entry.get("period")).getString("name");
            String period = ((DynamicObject)entry.get("period")).getString("number");
            String ordersign = entry.getString("ordersign");
            if (ordersign.indexOf(":") != -1) {
                String substring = ordersign.substring(0, ordersign.indexOf(":"));
                row = Integer.parseInt(substring);
            }
            BigDecimal adjadjustdata = (BigDecimal)entry.get("adjustdata");
            BigDecimal finaldata = (BigDecimal)entry.get("finaldata");
            BigDecimal limitbalance = (BigDecimal)entry.get("limitbalance");
            boolean isbeyond = Convert.toBool((Object)entry.get("beyond"), (Boolean)true);
            BigDecimal submitValue = null;
            if ("eb_adjustbill".equals(entityNumber) || "eb_adjpstbill".equals(entityNumber)) {
                submitValue = entry.getBigDecimal("submitvalue");
            }
            CompareDataPojo com = new CompareDataPojo(periodName, finaldata, adjadjustdata, limitbalance, isbeyond, orgNumber, accountNumber, row);
            com.setSubmitValue(submitValue);
            com.setPreiod(period);
            com.setRowIndex(i);
            com.setCurrencyNumber(currencyNumber);
            com.setYearNumber(yearNumber);
            com.setVersionNumber(versionNumber);
            com.setChangetypeNumber(changetypeNumber);
            com.setDatatypeNumber(datatypeNumber);
            com.setScenarioNumber("NoScenario");
            com.setProcess("IRpt");
            com.setAuditTrailNumber(ControlParamsSettingUtil.getAuditTrail((Long)modelId, (String)formType, (boolean)ModelUtil.isEbOrBgModel((Long)modelId)));
            com.setInternalCompanyNumber("ICNone");
            HashMap<String, String> CustomdimMap = new HashMap<String, String>(16);
            HashMap<String, String> customdimMemberMap = new HashMap<String, String>(16);
            if (dynamicInfoCollection != null && dynamicInfoCollection.getValues().size() != 0) {
                for (DynamicInfoCollection.InfoObject in : dynamicInfoCollection.getValues()) {
                    String controlkey = (String)in.getValueByPropName("controlkey");
                    String memberKey = (String)in.getValueByPropName("number");
                    if (entry.get(controlkey = controlkey.substring(3)) == null) {
                        CustomdimMap.put(controlkey, in.getValueByPropName("shortNum") + "None");
                        customdimMemberMap.put(memberKey, in.getValueByPropName("shortNum") + "None");
                        continue;
                    }
                    CustomdimMap.put(controlkey, ((DynamicObject)entry.get(controlkey)).getString("number"));
                    customdimMemberMap.put(memberKey, ((DynamicObject)entry.get(controlkey)).getString("number"));
                }
                com.setCustomdimMap(CustomdimMap);
                com.setCustomdimMemberMap(customdimMemberMap);
            }
            com.setModel(Long.valueOf(modelId));
            com.setBillNumber(billNumber);
            rowData.add(com);
        }
    }

    private void updateBillInfoAfterChange(DynamicObject billObj, List<CompareDataPojo> finalDataByPeriodAndOrg) {
        if (finalDataByPeriodAndOrg.isEmpty()) {
            return;
        }
        DynamicObjectCollection entityRows = billObj.getDynamicObjectCollection(ADJENTRYENTITY);
        AdjustBill adjustBill = AdjustBillConvertor.dynamic2AdjustBill((DynamicObject)billObj, (boolean)true);
        adjustBill.setAudit(true);
        IAdjustBillService adjustBillService = AdjustHelper.getInstance((AdjustBillEnum)AdjustBillEnum.EXPENSE);
        Map rowBudgetData = adjustBillService.getRowBudgetData(adjustBill);
        for (List rowValueList : rowBudgetData.values()) {
            for (Pair rowValue : rowValueList) {
                DynamicObject entityObj = (DynamicObject)entityRows.get(((Integer)rowValue.getKey()).intValue());
                BigDecimal budgetData = (BigDecimal)rowValue.getValue();
                BigDecimal adjustData = entityObj.getBigDecimal("adjustdata");
                entityObj.set("budgetdata", (Object)budgetData);
                entityObj.set("finaldata", (Object)budgetData.add(adjustData));
            }
        }
        Long modelId = billObj.getDynamicObject("model").getLong("id");
        String formType = billObj.getString("billtype");
        boolean isShowBudgetBalance = ControlParamsSettingUtil.isShowBudgetBalance((Long)modelId, (String)formType, (boolean)true);
        boolean isShowLimitBalance = ControlParamsSettingUtil.isShowLimitBalance((Long)modelId, (String)formType, (boolean)true);
        if (isShowBudgetBalance || isShowLimitBalance) {
            Collection<IBudgetBalance> budgetBalances = this.queryBudgetBalance(modelId, finalDataByPeriodAndOrg, formType);
            LimitBalance limitCalc = new LimitBalance();
            for (IBudgetBalance budgetBalance : budgetBalances) {
                for (CompareDataPojo compareDataPojo : finalDataByPeriodAndOrg) {
                    if (!AdjustHelper.isDimMemberSame((IBudgetBalance)budgetBalance, (CompareDataPojo)compareDataPojo, (DynamicInfoCollection)this.dynamicInfoCollection)) continue;
                    BigDecimal balance = budgetBalance.getBalance();
                    log.info("[ExpenseBudgetAuditOp] row={}, budget balance==>{}", (Object)compareDataPojo.getRowIndex(), (Object)balance);
                    if (balance == null) {
                        balance = BigDecimal.ZERO;
                    }
                    DynamicObject entityObj = (DynamicObject)entityRows.get(compareDataPojo.getRowIndex());
                    if (isShowBudgetBalance) {
                        entityObj.set("budgetbalance", (Object)balance);
                    }
                    if (!isShowLimitBalance) continue;
                    BigDecimal limitbalance = limitCalc.calc(budgetBalance, entityObj.get("budgetdata"));
                    if (limitbalance == null) {
                        limitbalance = BigDecimal.ZERO;
                    }
                    boolean isBeyond = budgetBalance == null || budgetBalance.getSetting() == null || budgetBalance.getSetting().isBeyond();
                    entityObj.set("limitbalance", (Object)limitbalance);
                    entityObj.set("beyond", (Object)isBeyond);
                }
            }
        }
        billObj.set("billstatus", (Object)AdjustBillStateEnum.PASS.getShortNumber());
        try {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{billObj});
        }
        catch (Exception ex) {
            throw new KDBizException(ex.getMessage());
        }
    }

    private Collection<IBudgetBalance> queryBudgetBalance(Long modelId, List<CompareDataPojo> finalDataByPeriodAndOrg, String formType) {
        String auditTrail = ControlParamsSettingUtil.getAuditTrailShow((Long)modelId, (String)formType, (boolean)ModelUtil.isEbOrBgModel((Long)modelId));
        ArrayList type = new ArrayList();
        for (Map<String, String> map : this.dimlist) {
            if (!map.containsKey(SysDimensionEnum.AuditTrail.getNumber())) continue;
            map.put(SysDimensionEnum.AuditTrail.getNumber(), auditTrail);
        }
        if (!AdjustHelper.isExitMixturePeriod(this.dimlist, type)) {
            return AdjustHelper.getAllIbCollection((Long)modelId, this.dimlist, type, finalDataByPeriodAndOrg, (String)formType);
        }
        return AdjustHelper.queryBalance((Long)modelId, this.dimlist, type, finalDataByPeriodAndOrg, (String)formType);
    }

    private static void dbLock() {
        DBRoute eb = DBRoute.of((String)"epm");
        DB.execute((DBRoute)eb, (String)"insert into t_eb_transaction (fid, fcount)  select a.fid, a.fcount FROM  (select fid, fcount from t_eb_transaction UNION select ?, 0 from t_eb_transaction) as a  where a.fid not in (select fid from t_eb_transaction)", (Object[])new Object[]{8888L});
        DB.execute((DBRoute)eb, (String)"update t_eb_transaction set fcount = fcount + 1 where fid = ?", (Object[])new Object[]{8888L});
    }

    private static String getLockErrorMessage(String lockType) {
        return "audit/control".equals(lockType) ? ResManager.loadKDString((String)"\u9884\u7b97\u8c03\u6574\u5355\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u5c1d\u8bd5", (String)"AuditOp_5", (String)"epm-eb-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u9884\u7b97\u8c03\u6574\u5355\u7533\u8bf7\u9501\u5931\u8d25", (String)"AuditOp_6", (String)"epm-eb-opplugin", (Object[])new Object[0]);
    }

    static {
        adjustCheckFlag = false;
    }
}

