/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.opplugin.Adjust;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.adjust.AdjustBillConvertor;
import kd.epm.eb.business.adjust.AdjustHelper;
import kd.epm.eb.business.adjust.service.IAdjustBillService;
import kd.epm.eb.common.adjust.AdjustBill;
import kd.epm.eb.common.adjust.AdjustBillEnum;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.dao.adjust.CompareDataPojo;
import kd.epm.eb.common.enums.AdjustBillStateEnum;
import kd.epm.eb.common.enums.BgControlSettingTypeEnum;
import kd.epm.eb.common.enums.EbAdjBillTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.DynamicInfoCollection;
import kd.epm.eb.common.model.Pair;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.controlParamsSetting.ControlParamsSettingUtil;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.control.BgControlCallerImpl;
import kd.epm.eb.control.calc.impl.LimitBalance;
import kd.epm.eb.control.face.IBudgetBalance;
import kd.epm.eb.control.utils.BudgetAdjustCheckUtils;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.opplugin.Adjust.IsSuperPassBudgetValidator;

public class BgmAuditOp
extends AbstractOperationServicePlugIn {
    protected static final Log log = LogFactory.getLog(BgmAuditOp.class);
    private static final String ADJENTRYENTITY = "adjdetailentity";
    private List<CompareDataPojo> finalDataByPeriodAndOrg;
    private DynamicInfoCollection customDimInfoList;
    private List<Map<String, String>> dimList;
    private static Map<String, BigDecimal> adjustValueMap;
    private static Map<String, BigDecimal> submitValueMap;
    private List<Map<String, String>> checkBalance;
    private static Boolean adjustCheckFlag;
    private LogStats logStats = new LogStats("adjustAudio");
    protected List<String> entryEntityKeys = new ArrayList<String>(Arrays.asList("customdim1", "customdim2", "customdim3", "customdim4", "customdim5", "customdim6", "customdim7", "customdim8", "customdim9", "customdim10", "customdim11", "customdim12", "customdim13", "customdim14", "customdim15", "customdim16", "customdim17", "customdim18", "customdim19", "customdim20", "customdim21", "customdim22", "customdim23", "customdim24", "customdim25", "customdim26", "customdim27", "customdim28", "customdim29", "customdim30", "customdim31", "customdim32", "customdim33", "customdim34", "customdim35", "customdim36", "customdim37", "customdim38", "customdim39", "customdim40", "customdim41", "customdim42", "customdim43", "customdim44", "customdim45", "customdim46", "customdim47", "customdim48", "customdim49", "customdim50"));

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("model");
        fieldKeys.add("version");
        fieldKeys.add("changetype");
        fieldKeys.add("currency");
        fieldKeys.add("budgetperiods");
        fieldKeys.add("bizmodel");
        fieldKeys.add("adjdetailentity.entity");
        fieldKeys.add("adjdetailentity.account");
        fieldKeys.add("adjdetailentity.metric");
        fieldKeys.add("adjdetailentity.customdim1");
        fieldKeys.add("adjdetailentity.customdim2");
        fieldKeys.add("adjdetailentity.customdim3");
        fieldKeys.add("adjdetailentity.customdim4");
        fieldKeys.add("adjdetailentity.customdim5");
        fieldKeys.add("adjdetailentity.customdim6");
        fieldKeys.add("adjdetailentity.customdim7");
        fieldKeys.add("adjdetailentity.customdim8");
        fieldKeys.add("adjdetailentity.customdim9");
        fieldKeys.add("adjdetailentity.customdim10");
        fieldKeys.add("adjdetailentity.customdim11");
        fieldKeys.add("adjdetailentity.customdim12");
        fieldKeys.add("adjdetailentity.customdim13");
        fieldKeys.add("adjdetailentity.customdim14");
        fieldKeys.add("adjdetailentity.customdim15");
        fieldKeys.add("adjdetailentity.customdim16");
        fieldKeys.add("adjdetailentity.customdim17");
        fieldKeys.add("adjdetailentity.customdim18");
        fieldKeys.add("adjdetailentity.customdim19");
        fieldKeys.add("adjdetailentity.customdim20");
        fieldKeys.add("adjdetailentity.customdim21");
        fieldKeys.add("adjdetailentity.customdim22");
        fieldKeys.add("adjdetailentity.customdim23");
        fieldKeys.add("adjdetailentity.customdim24");
        fieldKeys.add("adjdetailentity.customdim25");
        fieldKeys.add("adjdetailentity.customdim26");
        fieldKeys.add("adjdetailentity.customdim27");
        fieldKeys.add("adjdetailentity.customdim28");
        fieldKeys.add("adjdetailentity.customdim29");
        fieldKeys.add("adjdetailentity.customdim30");
        fieldKeys.add("adjdetailentity.customdim31");
        fieldKeys.add("adjdetailentity.customdim32");
        fieldKeys.add("adjdetailentity.customdim33");
        fieldKeys.add("adjdetailentity.customdim34");
        fieldKeys.add("adjdetailentity.customdim35");
        fieldKeys.add("adjdetailentity.customdim36");
        fieldKeys.add("adjdetailentity.customdim37");
        fieldKeys.add("adjdetailentity.customdim38");
        fieldKeys.add("adjdetailentity.customdim39");
        fieldKeys.add("adjdetailentity.customdim40");
        fieldKeys.add("adjdetailentity.customdim41");
        fieldKeys.add("adjdetailentity.customdim42");
        fieldKeys.add("adjdetailentity.customdim43");
        fieldKeys.add("adjdetailentity.customdim44");
        fieldKeys.add("adjdetailentity.customdim45");
        fieldKeys.add("adjdetailentity.customdim46");
        fieldKeys.add("adjdetailentity.customdim47");
        fieldKeys.add("adjdetailentity.customdim48");
        fieldKeys.add("adjdetailentity.customdim49");
        fieldKeys.add("adjdetailentity.customdim50");
        fieldKeys.add("adjdetailentity.groupnum");
        fieldKeys.add("adjdetailentity.budgetbalance");
        fieldKeys.add("adjdetailentity.limitbalance");
        fieldKeys.add("adjdetailentity.limitbalanceshow");
        fieldKeys.add("adjdetailentity.beyond");
        fieldKeys.add("adjdetailentity.budgetdata");
        fieldKeys.add("adjdetailentity.adjustdata");
        fieldKeys.add("adjdetailentity.finaldata");
        fieldKeys.add("adjdetailentity.limitbalance");
        fieldKeys.add("adjdetailentity.beyond");
        fieldKeys.add("adjdetailentity.adjexplain");
        fieldKeys.add("adjdetailentity.budgetperiod");
        fieldKeys.add("adjdetailentity.ordersign");
        fieldKeys.add("adjdetailentity.submitvalue");
        fieldKeys.add("datatype");
        fieldKeys.add("billtype");
        fieldKeys.add("applier");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        if (!AdjustHelper.verifyBillStatus((DynamicObject[])dataEntities)) {
            e.setCancel(true);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        this.lock(dataEntities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lock(DynamicObject[] dataEntities) {
        if (StringUtils.isEmpty((String)"audit/control")) {
            throw new KDBizException("error lock key.");
        }
        DLock lock = DLock.create((String)"eb/audit/control/9999");
        try {
            if (!lock.tryLock(5000L)) {
                throw new KDBizException(BgmAuditOp.getLockErrorMessage("audit/control"));
            }
            try {
                BgmAuditOp.dbLock();
                this.adjust(dataEntities);
            }
            catch (Exception ex) {
                log.info("[OverallBudgetAuditOp] audit error: {}", (Object)ex);
                throw new KDBizException("audit failed:" + ex.getMessage());
            }
        }
        finally {
            lock.unlock();
        }
    }

    public void adjust(DynamicObject[] dataEntities) {
        ArrayList<IBudgetBalance> checkIBudgetBalances;
        String billNo;
        DynamicObject doc;
        if (dataEntities != null && dataEntities.length > 0) {
            this.logStats.add("begin endOperationTransaction", true);
            doc = dataEntities[0];
            billNo = doc.getString("billno");
            log.info("[OverallBudgetAuditOp] adjust==>start, billNo={}", (Object)billNo);
            Long modelId = doc.getDynamicObject("model").getLong("id");
            Long bizModelId = doc.getDynamicObject("bizmodel").getLong("id");
            this.customDimInfoList = AdjustHelper.buildCustomDimInfo((Long)modelId, (Long)bizModelId);
            Map customDimJsonMap = AdjustHelper.buildCustomDimMap((DynamicInfoCollection)this.customDimInfoList);
            AdjustHelper.refactorDynamicObject((DynamicObject)doc, this.entryEntityKeys, (Map)customDimJsonMap);
            this.dimList = new ArrayList<Map<String, String>>();
            this.checkBalance = new ArrayList<Map<String, String>>();
            this.finalDataByPeriodAndOrg = this.getFinalDataByPeriodAndOrgByEnd(doc, this.customDimInfoList);
            ArrayList<CompareDataPojo> checkByPeriodAndOrg = new ArrayList<CompareDataPojo>(this.finalDataByPeriodAndOrg.size());
            for (CompareDataPojo com : this.finalDataByPeriodAndOrg) {
                if (com.getAdjustdata().compareTo(BigDecimal.ZERO) == 0) continue;
                checkByPeriodAndOrg.add(com);
            }
            this.getDimQueryListByEnd(doc, this.customDimInfoList, this.dimList, false, false);
            String formType = doc.getString("billtype");
            adjustValueMap = BudgetAdjustCheckUtils.getAdjustValueMap(checkByPeriodAndOrg, (String)"adjustValue", (String)formType);
            submitValueMap = BudgetAdjustCheckUtils.getAdjustValueMap(checkByPeriodAndOrg, (String)"submitValue", (String)formType);
            adjustCheckFlag = true;
            checkIBudgetBalances = new ArrayList(16);
            if (BudgetAdjustCheckUtils.checkAuditTrailParamRelation((Long)modelId, (String)formType).booleanValue()) {
                checkIBudgetBalances = this.queryBalance(this.customDimInfoList, doc);
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5230\u7684\u52a8\u6001\u5bf9\u8c61\u4e3a\u7a7a\u3002", (String)"AuditOp_0", (String)"epm-eb-opplugin", (Object[])new Object[0]));
        }
        IsSuperPassBudgetValidator isSuperPassBudgetValidator = new IsSuperPassBudgetValidator(this.customDimInfoList, this.finalDataByPeriodAndOrg, checkIBudgetBalances);
        isSuperPassBudgetValidator.bgmIsAdjustment();
        this.updateBillInfoAfterChange(doc);
        this.saveDataToOlap(doc);
        log.info("[OverallBudgetAuditOp] adjust==>end, billNo={}", (Object)billNo);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
    }

    public void saveDataToOlap(DynamicObject doc) {
        AdjustBill adjustBill = AdjustBillConvertor.dynamic2AdjustBill((DynamicObject)doc, (boolean)true);
        IAdjustBillService adjustBillService = AdjustHelper.getInstance((AdjustBillEnum)AdjustBillEnum.OVERALL);
        adjustBillService.saveBudgetData2Olap(adjustBill, true);
        if (ControlParamsSettingUtil.isOpenReduceBill((Long)adjustBill.getModel().getId(), (String)adjustBill.getBillType())) {
            adjustBillService.saveOccupyData2Olap(adjustBill, false);
        }
    }

    public Collection<IBudgetBalance> queryBalance(DynamicInfoCollection customDimInfoList, DynamicObject doc) {
        Long modelId = doc.getDynamicObject("model").getLong("id");
        Long bizModelId = doc.getDynamicObject("bizmodel").getLong("id");
        String formType = doc.getString("billtype");
        if (formType == null) {
            formType = EbAdjBillTypeEnum.adjust.getNumber();
        }
        String auditTrail = ControlParamsSettingUtil.getAuditTrailShow((Long)modelId, (String)formType, (boolean)ModelUtil.isEbOrBgModel((Long)modelId));
        ArrayList<String> type = new ArrayList<String>();
        this.getDimQueryListByEnd(doc, customDimInfoList, this.checkBalance, true, false);
        if (BudgetAdjustCheckUtils.checkCustomDimExist((long)modelId, (long)bizModelId)) {
            this.getDimQueryListByEnd(doc, customDimInfoList, this.checkBalance, true, true);
        }
        this.checkBalance = this.checkBalance.stream().distinct().collect(Collectors.toList());
        if (!this.IsExitMixturePeriod(type)) {
            return this.getAllIbCollection(null, type, ((DynamicObject)doc.get("model")).getLong("id"), auditTrail);
        }
        ArrayList<Map<String, String>> tempList = new ArrayList<Map<String, String>>(this.checkBalance.size());
        for (Map<String, String> map : this.checkBalance) {
            if (map.containsKey(SysDimensionEnum.AuditTrail.getNumber())) {
                map.put(SysDimensionEnum.AuditTrail.getNumber(), auditTrail);
            }
            tempList.add(this.getStringMap(map));
        }
        return BgmAuditOp.queryBalanceByType(null, tempList, type, ((DynamicObject)doc.get("model")).getLong("id"), ((DynamicObject)doc.get("bizmodel")).getLong("id"));
    }

    public Collection<IBudgetBalance> getAllIbCollection(IDataModel dataModel, Collection<String> type, Long modelId, String auditTrail) {
        Collection<IBudgetBalance> budgetBalances;
        ArrayList<IBudgetBalance> cl = new ArrayList<IBudgetBalance>();
        ArrayList<Map<String, String>> qlist = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> hlist = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> mlist = new ArrayList<Map<String, String>>();
        for (Map<String, String> map : this.checkBalance) {
            String bperiod;
            if (map.containsKey(SysDimensionEnum.AuditTrail.getNumber())) {
                map.put(SysDimensionEnum.AuditTrail.getNumber(), auditTrail);
            }
            if ((bperiod = map.get("BudgetPeriod")).contains(".Q")) {
                qlist.add(this.getStringMap(map));
                continue;
            }
            if (bperiod.contains(".HF")) {
                hlist.add(this.getStringMap(map));
                continue;
            }
            if (!bperiod.contains(".M")) continue;
            mlist.add(this.getStringMap(map));
        }
        if (qlist.size() != 0) {
            type.add(BgControlSettingTypeEnum.QUARTER.getNumber());
            budgetBalances = BgmAuditOp.queryBalanceByType(dataModel, qlist, type, modelId, null);
            cl.addAll(budgetBalances);
            type.clear();
        }
        if (hlist.size() != 0) {
            type.add(BgControlSettingTypeEnum.HALFYEAR.getNumber());
            budgetBalances = BgmAuditOp.queryBalanceByType(dataModel, hlist, type, modelId, null);
            cl.addAll(budgetBalances);
            type.clear();
        }
        if (mlist.size() != 0) {
            type.add(BgControlSettingTypeEnum.MONTH.getNumber());
            budgetBalances = BgmAuditOp.queryBalanceByType(dataModel, mlist, type, modelId, null);
            cl.addAll(budgetBalances);
            type.clear();
        }
        return cl;
    }

    public Map<String, String> getStringMap(Map<String, String> map) {
        HashMap<String, String> stringMap = new HashMap<String, String>(16);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringMap.put(entry.getKey(), entry.getValue());
        }
        return stringMap;
    }

    public static Collection<IBudgetBalance> queryBalanceByType(IDataModel dataModel, List<Map<String, String>> tempDimList, Collection<String> type, Long modelId, Long bussModelId) {
        Collection iBudgetBalances;
        BgControlCallerImpl bgControlCaller = new BgControlCallerImpl();
        try {
            iBudgetBalances = dataModel == null ? (adjustCheckFlag.booleanValue() ? bgControlCaller.queryBalance(modelId, tempDimList, type, true, bussModelId, adjustValueMap, submitValueMap) : bgControlCaller.queryBalance(modelId, tempDimList, type, true, bussModelId)) : (adjustCheckFlag.booleanValue() ? bgControlCaller.queryBalance(Long.valueOf(((DynamicObject)dataModel.getValue("model")).getLong("id")), tempDimList, type, true, bussModelId, adjustValueMap, submitValueMap) : bgControlCaller.queryBalance(Long.valueOf(((DynamicObject)dataModel.getValue("model")).getLong("id")), tempDimList, type, true, bussModelId));
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        return iBudgetBalances;
    }

    public boolean IsExitMixturePeriod(Collection<String> type) {
        int i = 0;
        int j = 0;
        int z = 0;
        for (Map<String, String> map : this.dimList) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (!"BudgetPeriod".equals(entry.getKey())) continue;
                String value = entry.getValue();
                if (value.indexOf(".Q") >= 0) {
                    ++i;
                    continue;
                }
                if (value.indexOf(".H") >= 0) {
                    ++j;
                    continue;
                }
                if (value.indexOf(".M") < 0) continue;
                ++z;
            }
        }
        if (i != 0 && j == 0 && z == 0) {
            type.add(BgControlSettingTypeEnum.QUARTER.getNumber());
        } else if (i == 0 && j != 0 && z == 0) {
            type.add(BgControlSettingTypeEnum.HALFYEAR.getNumber());
        } else if (i == 0 && j == 0 && z != 0) {
            type.add(BgControlSettingTypeEnum.MONTH.getNumber());
        } else {
            return false;
        }
        return true;
    }

    public void getDimQueryListByEnd(DynamicObject doc, DynamicInfoCollection dynamicInfoCollection, List<Map<String, String>> dimList, boolean checkFlag, boolean customTotalFlag) {
        Long modelId = doc.getDynamicObject("model").getLong("id");
        String formType = doc.getString("billtype");
        String billNumber = doc.getString("billno");
        if (formType == null) {
            formType = EbAdjBillTypeEnum.adjust.getNumber();
        }
        String auditTrail = ControlParamsSettingUtil.getAuditTrail((Long)modelId, (String)formType, (boolean)ModelUtil.isEbOrBgModel((Long)modelId));
        DynamicObjectCollection entryEntity = doc.getDynamicObjectCollection(ADJENTRYENTITY);
        for (DynamicObject entryDynamicObject : entryEntity) {
            BigDecimal adjustValue;
            if (checkFlag && (adjustValue = entryDynamicObject.getBigDecimal("adjustdata")) != null && adjustValue.compareTo(BigDecimal.ZERO) == 0) continue;
            Long accountId = entryDynamicObject.getLong("account.id");
            Long datasetId = AdjustHelper.getDatasetId((Long)accountId);
            DynamicInfoCollection rowCustomDims = AdjustHelper.getRowCustomDimInfo((DynamicInfoCollection)dynamicInfoCollection, (Long)modelId, (Long)datasetId);
            HashMap<Object, Object> dimMap = new HashMap<Object, Object>(16);
            String entityNumber = ((DynamicObject)entryDynamicObject.get("entity")).getString("number");
            dimMap.put(SysDimensionEnum.Entity.getNumber(), entityNumber);
            String accountNumber = ((DynamicObject)entryDynamicObject.get("account")).getString("number");
            dimMap.put(SysDimensionEnum.Account.getNumber(), accountNumber);
            dimMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), ((DynamicObject)entryDynamicObject.get("budgetperiod")).getString("number"));
            String datatypeNumber = ((DynamicObject)doc.get("datatype")).getString("number");
            dimMap.put(SysDimensionEnum.DataType.getNumber(), datatypeNumber);
            String versionNumber = ((DynamicObject)doc.get("version")).getString("number");
            dimMap.put(SysDimensionEnum.Version.getNumber(), versionNumber);
            String currencyNumber = ((DynamicObject)doc.get("currency")).getString("number");
            dimMap.put(SysDimensionEnum.Currency.getNumber(), currencyNumber);
            String changetypeNumber = ((DynamicObject)doc.get("changetype")).getString("number");
            dimMap.put(SysDimensionEnum.ChangeType.getNumber(), changetypeNumber);
            String metricNumber = ((DynamicObject)entryDynamicObject.get("metric")).getString("number");
            dimMap.put(SysDimensionEnum.Metric.getNumber(), metricNumber);
            dimMap.put(SysDimensionEnum.AuditTrail.getNumber(), auditTrail);
            if (AdjustHelper.isHasInternalCompany((Long)modelId, (Long)datasetId)) {
                dimMap.put(SysDimensionEnum.InternalCompany.getNumber(), "ICNone");
            }
            if (!rowCustomDims.isEmpty()) {
                for (DynamicInfoCollection.InfoObject in : rowCustomDims.getValues()) {
                    if (checkFlag && customTotalFlag) {
                        dimMap.put(in.getValueByPropName("number"), in.getValueByPropName("number"));
                        continue;
                    }
                    String controlkey = (String)in.getValueByPropName("controlkey");
                    if (entryDynamicObject.get(controlkey = controlkey.substring(3)) != null) {
                        dimMap.put(in.getValueByPropName("number"), ((DynamicObject)entryDynamicObject.get(controlkey)).getString("number"));
                        continue;
                    }
                    dimMap.put(in.getValueByPropName("number"), in.getValueByPropName("shortnumber") + "None");
                }
            }
            if (checkFlag) {
                dimMap.put("billNumber", billNumber);
            }
            dimList.add(dimMap);
        }
    }

    public List<CompareDataPojo> getFinalDataByPeriodAndOrgByEnd(DynamicObject doc, DynamicInfoCollection dynamicInfoCollection) {
        ArrayList<CompareDataPojo> rowData = new ArrayList<CompareDataPojo>(16);
        DynamicObjectCollection entryEntity = doc.getDynamicObjectCollection(ADJENTRYENTITY);
        String versionNumber = ((DynamicObject)doc.get("version")).getString("number");
        String currencyNumber = ((DynamicObject)doc.get("currency")).getString("number");
        String datatypeNumber = ((DynamicObject)doc.get("datatype")).getString("number");
        String changetypeNumber = ((DynamicObject)doc.get("changetype")).getString("number");
        Long modelId = doc.getDynamicObject("model").getLong("id");
        Long bizModelId = doc.getDynamicObject("bizmodel").getLong("id");
        String formType = doc.getString("billtype");
        String billNumber = doc.getString("billno");
        if (formType == null) {
            formType = EbAdjBillTypeEnum.adjust.getNumber();
        }
        Map customDimMap = AdjustHelper.getCustomDimsByBizModel((Long)modelId, (Long)bizModelId);
        String auditTrail = ControlParamsSettingUtil.getAuditTrail((Long)modelId, (String)formType, (boolean)ModelUtil.isEbOrBgModel((Long)modelId));
        StringBuilder rowDimMembers = new StringBuilder();
        HashMap<String, CompareDataPojo> rowAdjustDataMap = new HashMap<String, CompareDataPojo>(16);
        HashMap<String, List> rowListMap = new HashMap<String, List>(16);
        int row = 0;
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            Long accountId = entry.getLong("account.id");
            Long datasetId = AdjustHelper.getDatasetId((Long)accountId);
            Map rowCustomDimMap = AdjustHelper.getCustomDimsByDataset((Long)modelId, (Long)datasetId, (Map)customDimMap);
            String orgNumber = ((DynamicObject)entry.get("entity")).getString("number");
            String accountNumber = ((DynamicObject)entry.get("account")).getString("number");
            String metricNumber = ((DynamicObject)entry.get("metric")).getString("number");
            String periodName = ((DynamicObject)entry.get("budgetperiod")).getString("name");
            String period = ((DynamicObject)entry.get("budgetperiod")).getString("number");
            rowDimMembers.append(SysDimensionEnum.BudgetPeriod.getNumber()).append("@").append(period).append("!!").append(SysDimensionEnum.Entity.getNumber()).append("@").append(orgNumber).append("!!").append(SysDimensionEnum.Account.getNumber()).append("@").append(accountNumber).append("!!").append(SysDimensionEnum.Metric.getNumber()).append("@").append(metricNumber);
            String ordersign = entry.getString("ordersign");
            if (ordersign.indexOf(":") != -1) {
                String substring = ordersign.substring(0, ordersign.indexOf(":"));
                row = Integer.parseInt(substring);
            }
            BigDecimal adjadjustdata = (BigDecimal)entry.get("adjustdata");
            BigDecimal finaldata = (BigDecimal)entry.get("finaldata");
            BigDecimal submitValue = (BigDecimal)entry.get("submitvalue");
            BigDecimal limitbalance = (BigDecimal)entry.get("limitbalance");
            boolean isbeyond = Convert.toBool((Object)entry.get("beyond"), (Boolean)true);
            HashMap<String, String> customdimMap = new HashMap<String, String>(16);
            HashMap<String, String> customDimMemberMap = new HashMap<String, String>(16);
            for (Map.Entry customEntry : rowCustomDimMap.entrySet()) {
                String dimKey = (String)customEntry.getKey();
                Dimension customDim = (Dimension)customEntry.getValue();
                DynamicObject customDimObj = entry.getDynamicObject(dimKey);
                String customDimMem = customDimObj != null ? customDimObj.getString("number") : customDim.getNoneNumber();
                customdimMap.put(dimKey, customDimMem);
                customDimMemberMap.put(customDim.getNumber(), customDimMem);
                rowDimMembers.append("!!").append(customDim.getNumber()).append("@").append(customDimMem);
            }
            CompareDataPojo com = new CompareDataPojo(periodName, finaldata, adjadjustdata, limitbalance, isbeyond, orgNumber, accountNumber, row);
            com.setSubmitValue(submitValue);
            com.setPreiod(period);
            com.setRowIndex(i);
            com.setCurrencyNumber(currencyNumber);
            com.setVersionNumber(versionNumber);
            com.setChangetypeNumber(changetypeNumber);
            com.setDatatypeNumber(datatypeNumber);
            com.setAuditTrailNumber(auditTrail);
            com.setMetricNumber(metricNumber);
            if (AdjustHelper.isHasInternalCompany((Long)modelId, (Long)datasetId)) {
                com.setInternalCompanyNumber("ICNone");
            }
            com.setCustomdimMap(customdimMap);
            com.setCustomdimMemberMap(customDimMemberMap);
            com.setModel(modelId);
            com.setBizmodel(bizModelId);
            com.setBillNumber(billNumber);
            if (rowAdjustDataMap.containsKey(rowDimMembers.toString())) {
                CompareDataPojo data = (CompareDataPojo)rowAdjustDataMap.get(rowDimMembers.toString());
                BigDecimal adjustData = data.getAdjustdata().add(adjadjustdata);
                BigDecimal newSubmitValue = data.getSubmitValue().add(submitValue);
                data.setAdjustdata(adjustData);
                data.setFinaldata(finaldata);
                data.setSubmitValue(newSubmitValue);
            } else {
                rowAdjustDataMap.put(rowDimMembers.toString(), com);
            }
            List dataList = rowListMap.computeIfAbsent(rowDimMembers.toString(), v -> new ArrayList(16));
            dataList.add(com);
            rowDimMembers.setLength(0);
        }
        for (Map.Entry rowListEntry : rowListMap.entrySet()) {
            CompareDataPojo dataPojo = (CompareDataPojo)rowAdjustDataMap.get(rowListEntry.getKey());
            List dataList = (List)rowListEntry.getValue();
            for (CompareDataPojo data : dataList) {
                BigDecimal submitValue = dataPojo.getSubmitValue();
                if (submitValue.compareTo(BigDecimal.ZERO) > 0) {
                    dataPojo.setSubmitValue(BigDecimal.ZERO);
                } else {
                    data.setSubmitValue(submitValue);
                }
                data.setAdjustdata(dataPojo.getAdjustdata());
                data.setFinaldata(dataPojo.getFinaldata());
                rowData.add(data);
            }
        }
        return rowData;
    }

    public void updateBillInfoAfterChange(DynamicObject billObj) {
        if (this.finalDataByPeriodAndOrg.isEmpty()) {
            return;
        }
        DynamicObjectCollection entityRows = billObj.getDynamicObjectCollection(ADJENTRYENTITY);
        AdjustBill adjustBill = AdjustBillConvertor.dynamic2AdjustBill((DynamicObject)billObj, (boolean)true);
        IAdjustBillService adjustBillService = AdjustHelper.getInstance((AdjustBillEnum)AdjustBillEnum.OVERALL);
        Map rowBudgetData = adjustBillService.getRowBudgetData(adjustBill);
        for (List rowValueList : rowBudgetData.values()) {
            for (Pair rowValue : rowValueList) {
                DynamicObject entityObj = (DynamicObject)entityRows.get(((Integer)rowValue.getKey()).intValue());
                BigDecimal budgetData = (BigDecimal)rowValue.getValue();
                entityObj.set("budgetdata", (Object)budgetData);
                entityObj.set("finaldata", (Object)budgetData.add(entityObj.getBigDecimal("adjustdata")));
            }
        }
        Long modelId = billObj.getDynamicObject("model").getLong("id");
        Long bizModelId = billObj.getDynamicObject("bizmodel").getLong("id");
        String formType = billObj.getString("billtype");
        String auditTrail = ControlParamsSettingUtil.getAuditTrail((Long)modelId, (String)formType, (boolean)ModelUtil.isEbOrBgModel((Long)modelId));
        boolean isEbParam = ModelUtil.isBGModel((Long)modelId);
        boolean isShowBudgetBalance = ControlParamsSettingUtil.isShowBudgetBalance((Long)modelId, (String)formType, (boolean)isEbParam);
        boolean isShowLimitBalance = ControlParamsSettingUtil.isShowLimitBalance((Long)modelId, (String)formType, (boolean)isEbParam);
        QFilter modelQF = new QFilter("model", "=", (Object)modelId);
        QFilter bizModelQF = new QFilter("businessmodel", "=", (Object)bizModelId);
        boolean exists = QueryServiceHelper.exists((String)"eb_bgmcontroldimension", (QFilter[])new QFilter[]{modelQF, bizModelQF});
        if (isShowBudgetBalance || isShowLimitBalance) {
            if (exists) {
                LimitBalance limitCalc = new LimitBalance();
                Collection<IBudgetBalance> collection = this.queryBudgetBalance(modelId, bizModelId, this.finalDataByPeriodAndOrg, formType);
                for (IBudgetBalance budgetBalance : collection) {
                    for (CompareDataPojo compareDataPojo : this.finalDataByPeriodAndOrg) {
                        if (!AdjustHelper.isDimMemberSame((IBudgetBalance)budgetBalance, (CompareDataPojo)compareDataPojo, (DynamicInfoCollection)this.customDimInfoList)) continue;
                        BigDecimal balance = budgetBalance.getBalance();
                        log.info("[OverallBudgetAuditOp] row={}, budget balance==>{}", (Object)compareDataPojo.getRowIndex(), (Object)balance);
                        if (balance == null) {
                            balance = BigDecimal.ZERO;
                        }
                        DynamicObject entityObj = (DynamicObject)entityRows.get(compareDataPojo.getRowIndex());
                        if (isShowBudgetBalance) {
                            entityObj.set("budgetbalance", (Object)balance);
                        }
                        if (!isShowLimitBalance) continue;
                        BigDecimal limitbalance = limitCalc.calc(budgetBalance, entityObj.get("budgetdata"));
                        if (limitbalance == null) {
                            limitbalance = BigDecimal.ZERO;
                        }
                        boolean isBeyond = budgetBalance == null || budgetBalance.getSetting() == null || budgetBalance.getSetting().isBeyond();
                        entityObj.set("limitbalance", (Object)limitbalance);
                        entityObj.set("beyond", (Object)isBeyond);
                    }
                }
            } else if (isShowBudgetBalance) {
                adjustBill.setActual(true);
                Map rowActualData = adjustBillService.getRowBudgetData(adjustBill);
                for (List rowValueList : rowActualData.values()) {
                    for (Pair rowValue : rowValueList) {
                        DynamicObject entityObj = (DynamicObject)entityRows.get(((Integer)rowValue.getKey()).intValue());
                        BigDecimal budgetData = entityObj.getBigDecimal("budgetdata");
                        entityObj.set("budgetbalance", (Object)budgetData.subtract((BigDecimal)rowValue.getValue()));
                    }
                }
            }
            for (Map map : this.dimList) {
                if (!map.containsKey(SysDimensionEnum.AuditTrail.getNumber())) continue;
                map.put(SysDimensionEnum.AuditTrail.getNumber(), auditTrail);
            }
        }
        billObj.set("billstatus", (Object)AdjustBillStateEnum.PASS.getShortNumber());
        billObj.set("handler", (Object)0L);
        try {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{billObj});
        }
        catch (Exception ex) {
            throw new KDBizException(ex.getMessage());
        }
    }

    private Collection<IBudgetBalance> queryBudgetBalance(Long modelId, Long bizModelId, List<CompareDataPojo> finalDataByPeriodAndOrg, String formType) {
        String auditTrail = ControlParamsSettingUtil.getAuditTrailShow((Long)modelId, (String)formType, (boolean)ModelUtil.isEbOrBgModel((Long)modelId));
        for (Map<String, String> map : this.dimList) {
            if (!map.containsKey(SysDimensionEnum.AuditTrail.getNumber())) continue;
            map.put(SysDimensionEnum.AuditTrail.getNumber(), auditTrail);
        }
        ArrayList type = new ArrayList();
        if (!AdjustHelper.isExitMixturePeriod(this.dimList, type)) {
            return AdjustHelper.getBgmAllIbCollection((Long)modelId, (Long)bizModelId, this.dimList, type, finalDataByPeriodAndOrg, (String)formType);
        }
        return AdjustHelper.queryBgmBalance((Long)modelId, (Long)bizModelId, this.dimList, type, finalDataByPeriodAndOrg, (String)formType);
    }

    private static void dbLock() {
        DBRoute eb = DBRoute.of((String)"epm");
        DB.execute((DBRoute)eb, (String)"insert into t_eb_transaction (fid, fcount)  select a.fid, a.fcount FROM  (select fid, fcount from t_eb_transaction UNION select ?, 0 from t_eb_transaction) as a  where a.fid not in (select fid from t_eb_transaction)", (Object[])new Object[]{8888L});
        DB.execute((DBRoute)eb, (String)"update t_eb_transaction set fcount = fcount + 1 where fid = ?", (Object[])new Object[]{8888L});
    }

    private static String getLockErrorMessage(String lockType) {
        return "audit/control".equals(lockType) ? ResManager.loadKDString((String)"\u9884\u7b97\u8c03\u6574\u5355\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u5c1d\u8bd5", (String)"BgmAuditOp_2", (String)"epm-eb-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u9884\u7b97\u8c03\u6574\u5355\u7533\u8bf7\u9501\u5931\u8d25", (String)"BgmAuditOp_3", (String)"epm-eb-opplugin", (Object[])new Object[0]);
    }

    static {
        adjustCheckFlag = false;
    }
}

