/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.opplugin.Adjust;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.dao.adjust.CompareDataPojo;
import kd.epm.eb.common.enums.EbAdjBillTypeEnum;
import kd.epm.eb.common.model.DynamicInfoCollection;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.control.face.IBudgetBalance;
import kd.epm.eb.control.impl.model.BgControlSetting;
import kd.epm.eb.control.utils.BgControlUtils;
import kd.epm.eb.control.utils.BudgetAdjustCheckUtils;

public class IsSuperPassBudgetValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(IsSuperPassBudgetValidator.class);
    private DynamicInfoCollection dynamicInfoCollection;
    private List<CompareDataPojo> finalDataByPeriodAndOrg;
    private Collection<IBudgetBalance> iBudgetBalances;
    private Collection<IBudgetBalance> checkIBudgetBalances;

    public IsSuperPassBudgetValidator(DynamicInfoCollection dynamicInfoCollection, List<CompareDataPojo> finalDataByPeriodAndOrg, Collection<IBudgetBalance> iBudgetBalances) {
        this.dynamicInfoCollection = dynamicInfoCollection;
        this.finalDataByPeriodAndOrg = finalDataByPeriodAndOrg;
        this.iBudgetBalances = iBudgetBalances;
    }

    public IsSuperPassBudgetValidator(DynamicInfoCollection dynamicInfoCollection, List<CompareDataPojo> finalDataByPeriodAndOrg, Collection<IBudgetBalance> iBudgetBalances, Collection<IBudgetBalance> checkIBudgetBalances) {
        this.dynamicInfoCollection = dynamicInfoCollection;
        this.finalDataByPeriodAndOrg = finalDataByPeriodAndOrg;
        this.iBudgetBalances = iBudgetBalances;
        this.checkIBudgetBalances = checkIBudgetBalances;
    }

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities.length > 0) {
            DynamicObject doc = dataEntities[0].getDataEntity();
            if (doc.getString("billtype").equals(EbAdjBillTypeEnum.adjust.getNumber())) {
                this.IsAdjustment();
            } else if (doc.getString("billtype").equals(EbAdjBillTypeEnum.adjpst.getNumber())) {
                this.IsAdjustment();
                IsSuperPassBudgetValidator.IsAdjust(doc);
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u4e0d\u5b58\u5728\u3002", (String)"IsSuperPassBudgetValidator_0", (String)"epm-eb-opplugin", (Object[])new Object[0]));
            }
        }
    }

    public void IsAdjustment() {
        List values = this.dynamicInfoCollection.getValues();
        if (this.checkIBudgetBalances != null && this.checkIBudgetBalances.size() != 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (IBudgetBalance ibe : this.checkIBudgetBalances) {
                log.info("adjust check balance by eb audit getAccount() = " + ibe.getAccount(true).getNumber() + " getPeriod() = " + ibe.getPeriod(true) + " controltype = " + ibe.getSetting().getSettingType() + " getBalance() = " + ibe.getBalance() + " getAdjustCheckBalance() = " + ibe.getAdjustCheckBalance() + " getAdjustCheckBeyond() = " + ibe.getAdjustCheckBeyond() + " getBudget() = " + ibe.getBudget() + " getAdjustCheckBudget() = " + ibe.getAdjustCheckBudget());
                if (ibe.getSetting().isBeyond() || !ibe.getAdjustCheckBeyond()) continue;
                Collection userDefineDims = ibe.getBizModel().getUserDefinedDimensions();
                String memberString = BgControlUtils.getMemberString((IBudgetBalance)ibe, (boolean)true, (Collection)userDefineDims);
                String periodStr = BudgetAdjustCheckUtils.showMemberName((Member)ibe.getYear(true)) + BudgetAdjustCheckUtils.showMemberName((Member)ibe.getPeriod(true));
                String adjustCheckBalanceStr = new DecimalFormat("#.##").format(ibe.getAdjustCheckBalance());
                String groupName = BudgetAdjustCheckUtils.showGroupName((BgControlSetting)ibe.getSetting());
                String msg = "";
                msg = StringUtils.isNotEmpty((String)memberString) && StringUtils.isNotEmpty((String)groupName) ? ResManager.loadResFormat((String)"\u9884\u7b97\u7ec4\u7ec7\uff1a%1\uff0c\u9884\u7b97\u79d1\u76ee\uff1a%2\uff0c\u8f85\u52a9\u7ef4\u5ea6\uff1a%3\uff0c\u63a7\u5236\u65b9\u5f0f\uff1a%4\uff0c\u5206\u7ec4\u72b6\u6001\uff1a%5\uff0c\u9884\u7b97\u671f\u95f4\uff1a%6\uff0c\u53ef\u7528\u9884\u7b97\u4f59\u989d\uff1a%7\uff0c\u8c03\u6574\u68c0\u67e5\u4e0d\u901a\u8fc7\u4e0d\u5141\u8bb8\u5ba1\u6838\uff1b", (String)"IsSuperPassBudgetValidator_8", (String)"epm-eb-opplugin", (Object[])new Object[]{BudgetAdjustCheckUtils.showMemberName((Member)ibe.getOrgUnit(true)), BudgetAdjustCheckUtils.showMemberName((Member)ibe.getAccount(true)), memberString, BudgetAdjustCheckUtils.showCtrlSet((BgControlSetting)ibe.getSetting()), groupName, periodStr, adjustCheckBalanceStr}) : (StringUtils.isNotEmpty((String)memberString) && StringUtils.isEmpty((String)groupName) ? ResManager.loadResFormat((String)"\u9884\u7b97\u7ec4\u7ec7\uff1a%1\uff0c\u9884\u7b97\u79d1\u76ee\uff1a%2\uff0c\u8f85\u52a9\u7ef4\u5ea6\uff1a%3\uff0c\u63a7\u5236\u65b9\u5f0f\uff1a%4\uff0c\u9884\u7b97\u671f\u95f4\uff1a%5\uff0c\u53ef\u7528\u9884\u7b97\u4f59\u989d\uff1a%6\uff0c\u8c03\u6574\u68c0\u67e5\u4e0d\u901a\u8fc7\u4e0d\u5141\u8bb8\u5ba1\u6838\uff1b", (String)"IsSuperPassBudgetValidator_9", (String)"epm-eb-opplugin", (Object[])new Object[]{BudgetAdjustCheckUtils.showMemberName((Member)ibe.getOrgUnit(true)), BudgetAdjustCheckUtils.showMemberName((Member)ibe.getAccount(true)), memberString, BudgetAdjustCheckUtils.showCtrlSet((BgControlSetting)ibe.getSetting()), periodStr, adjustCheckBalanceStr}) : (StringUtils.isEmpty((String)memberString) && StringUtils.isNotEmpty((String)groupName) ? ResManager.loadResFormat((String)"\u9884\u7b97\u7ec4\u7ec7\uff1a%1\uff0c\u9884\u7b97\u79d1\u76ee\uff1a%2\uff0c\u63a7\u5236\u65b9\u5f0f\uff1a%3\uff0c\u5206\u7ec4\u72b6\u6001\uff1a%4\uff0c\u9884\u7b97\u671f\u95f4\uff1a%5\uff0c\u53ef\u7528\u9884\u7b97\u4f59\u989d\uff1a%6\uff0c\u8c03\u6574\u68c0\u67e5\u4e0d\u901a\u8fc7\u4e0d\u5141\u8bb8\u5ba1\u6838\uff1b", (String)"IsSuperPassBudgetValidator_10", (String)"epm-eb-opplugin", (Object[])new Object[]{BudgetAdjustCheckUtils.showMemberName((Member)ibe.getOrgUnit(true)), BudgetAdjustCheckUtils.showMemberName((Member)ibe.getAccount(true)), BudgetAdjustCheckUtils.showCtrlSet((BgControlSetting)ibe.getSetting()), groupName, periodStr, adjustCheckBalanceStr}) : ResManager.loadResFormat((String)"\u9884\u7b97\u7ec4\u7ec7\uff1a%1\uff0c\u9884\u7b97\u79d1\u76ee\uff1a%2\uff0c\u63a7\u5236\u65b9\u5f0f\uff1a%3\uff0c\u9884\u7b97\u671f\u95f4\uff1a%4\uff0c\u53ef\u7528\u9884\u7b97\u4f59\u989d\uff1a%5\uff0c\u8c03\u6574\u68c0\u67e5\u4e0d\u901a\u8fc7\u4e0d\u5141\u8bb8\u5ba1\u6838\uff1b", (String)"IsSuperPassBudgetValidator_11", (String)"epm-eb-opplugin", (Object[])new Object[]{BudgetAdjustCheckUtils.showMemberName((Member)ibe.getOrgUnit(true)), BudgetAdjustCheckUtils.showMemberName((Member)ibe.getAccount(true)), BudgetAdjustCheckUtils.showCtrlSet((BgControlSetting)ibe.getSetting()), periodStr, adjustCheckBalanceStr})));
                stringBuilder.append(msg).append("\r\n");
            }
            if (stringBuilder.length() > 0) {
                throw new KDBizException(stringBuilder.toString());
            }
        }
        if (this.iBudgetBalances != null && this.iBudgetBalances.size() != 0) {
            for (IBudgetBalance ibe : this.iBudgetBalances) {
                for (CompareDataPojo com : this.finalDataByPeriodAndOrg) {
                    if (!this.customDimsSame(ibe, com, values) || !ibe.getAccount(false).getNumber().equals(com.getAccountNumber()) || !ibe.getOrgUnit(false).getNumber().equals(com.getOrgnumber()) || !ibe.getPeriod(false).getNumber().equals(com.getPreiod()) || !ibe.getVersion(true).getNumber().equals(com.getVersionNumber()) || !ibe.getYear(false).getNumber().equals(com.getYearNumber()) || !ibe.getCurrency(true).getNumber().equals(com.getCurrencyNumber())) continue;
                    IsSuperPassBudgetValidator.setFinaladata(ibe, com);
                }
            }
        }
    }

    public void bgmIsAdjustment() {
        if (this.iBudgetBalances == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (IBudgetBalance ibe : this.iBudgetBalances) {
            log.info("adjust check balance by bgmd audit getAccount() = " + ibe.getAccount(true).getNumber() + " getPeriod() = " + ibe.getPeriod(true) + " controltype = " + ibe.getSetting().getSettingType() + " getBalance() = " + ibe.getBalance() + " getAdjustCheckBalance() = " + ibe.getAdjustCheckBalance() + " getAdjustCheckBeyond() = " + ibe.getAdjustCheckBeyond() + " getBudget() = " + ibe.getBudget() + " getAdjustCheckBudget() = " + ibe.getAdjustCheckBudget());
            if (ibe.getSetting().isBeyond() || !ibe.getAdjustCheckBeyond()) continue;
            Collection userDefineDims = ibe.getBizModel().getUserDefinedDimensions();
            String memberString = BgControlUtils.getMemberString((IBudgetBalance)ibe, (boolean)true, (Collection)userDefineDims);
            String adjustCheckBalanceStr = new DecimalFormat("#.##").format(ibe.getAdjustCheckBalance());
            String groupName = BudgetAdjustCheckUtils.showGroupName((BgControlSetting)ibe.getSetting());
            String msg = "";
            String periodStr = BudgetAdjustCheckUtils.showMemberName((Member)ibe.getPeriod(true));
            msg = StringUtils.isNotEmpty((String)memberString) && StringUtils.isNotEmpty((String)groupName) ? ResManager.loadResFormat((String)"\u9884\u7b97\u7ec4\u7ec7\uff1a%1\uff0c\u9884\u7b97\u79d1\u76ee\uff1a%2\uff0c\u8f85\u52a9\u7ef4\u5ea6\uff1a%3\uff0c\u63a7\u5236\u65b9\u5f0f\uff1a%4\uff0c\u5206\u7ec4\u72b6\u6001\uff1a%5\uff0c\u9884\u7b97\u671f\u95f4\uff1a%6\uff0c\u53ef\u7528\u9884\u7b97\u4f59\u989d\uff1a%7\uff0c\u8c03\u6574\u68c0\u67e5\u4e0d\u901a\u8fc7\u4e0d\u5141\u8bb8\u5ba1\u6838\uff1b", (String)"IsSuperPassBudgetValidator_8", (String)"epm-eb-opplugin", (Object[])new Object[]{BudgetAdjustCheckUtils.showMemberName((Member)ibe.getOrgUnit(true)), BudgetAdjustCheckUtils.showMemberName((Member)ibe.getAccount(true)), memberString, BudgetAdjustCheckUtils.showCtrlSet((BgControlSetting)ibe.getSetting()), groupName, periodStr, adjustCheckBalanceStr}) : (StringUtils.isNotEmpty((String)memberString) && StringUtils.isEmpty((String)groupName) ? ResManager.loadResFormat((String)"\u9884\u7b97\u7ec4\u7ec7\uff1a%1\uff0c\u9884\u7b97\u79d1\u76ee\uff1a%2\uff0c\u8f85\u52a9\u7ef4\u5ea6\uff1a%3\uff0c\u63a7\u5236\u65b9\u5f0f\uff1a%4\uff0c\u9884\u7b97\u671f\u95f4\uff1a%5\uff0c\u53ef\u7528\u9884\u7b97\u4f59\u989d\uff1a%6\uff0c\u8c03\u6574\u68c0\u67e5\u4e0d\u901a\u8fc7\u4e0d\u5141\u8bb8\u5ba1\u6838\uff1b", (String)"IsSuperPassBudgetValidator_9", (String)"epm-eb-opplugin", (Object[])new Object[]{BudgetAdjustCheckUtils.showMemberName((Member)ibe.getOrgUnit(true)), BudgetAdjustCheckUtils.showMemberName((Member)ibe.getAccount(true)), memberString, BudgetAdjustCheckUtils.showCtrlSet((BgControlSetting)ibe.getSetting()), periodStr, adjustCheckBalanceStr}) : (StringUtils.isEmpty((String)memberString) && StringUtils.isNotEmpty((String)groupName) ? ResManager.loadResFormat((String)"\u9884\u7b97\u7ec4\u7ec7\uff1a%1\uff0c\u9884\u7b97\u79d1\u76ee\uff1a%2\uff0c\u63a7\u5236\u65b9\u5f0f\uff1a%3\uff0c\u5206\u7ec4\u72b6\u6001\uff1a%4\uff0c\u9884\u7b97\u671f\u95f4\uff1a%5\uff0c\u53ef\u7528\u9884\u7b97\u4f59\u989d\uff1a%6\uff0c\u8c03\u6574\u68c0\u67e5\u4e0d\u901a\u8fc7\u4e0d\u5141\u8bb8\u5ba1\u6838\uff1b", (String)"IsSuperPassBudgetValidator_10", (String)"epm-eb-opplugin", (Object[])new Object[]{BudgetAdjustCheckUtils.showMemberName((Member)ibe.getOrgUnit(true)), BudgetAdjustCheckUtils.showMemberName((Member)ibe.getAccount(true)), BudgetAdjustCheckUtils.showCtrlSet((BgControlSetting)ibe.getSetting()), groupName, periodStr, adjustCheckBalanceStr}) : ResManager.loadResFormat((String)"\u9884\u7b97\u7ec4\u7ec7\uff1a%1\uff0c\u9884\u7b97\u79d1\u76ee\uff1a%2\uff0c\u63a7\u5236\u65b9\u5f0f\uff1a%3\uff0c\u9884\u7b97\u671f\u95f4\uff1a%4\uff0c\u53ef\u7528\u9884\u7b97\u4f59\u989d\uff1a%5\uff0c\u8c03\u6574\u68c0\u67e5\u4e0d\u901a\u8fc7\u4e0d\u5141\u8bb8\u5ba1\u6838\uff1b", (String)"IsSuperPassBudgetValidator_11", (String)"epm-eb-opplugin", (Object[])new Object[]{BudgetAdjustCheckUtils.showMemberName((Member)ibe.getOrgUnit(true)), BudgetAdjustCheckUtils.showMemberName((Member)ibe.getAccount(true)), BudgetAdjustCheckUtils.showCtrlSet((BgControlSetting)ibe.getSetting()), periodStr, adjustCheckBalanceStr})));
            stringBuilder.append(msg).append("\r\n");
        }
        if (stringBuilder.length() > 0) {
            throw new KDBizException(stringBuilder.toString());
        }
    }

    public boolean adjustDataIsZero(CompareDataPojo com) {
        return com.getAdjustdata().compareTo(BigDecimal.ZERO) != 0;
    }

    private static void setFinaladata(IBudgetBalance ibe, CompareDataPojo com) {
        BigDecimal adjustdata;
        BigDecimal budget = ibe.getBudget();
        if (budget == null) {
            budget = BigDecimal.ZERO;
        }
        if ((adjustdata = com.getAdjustdata()) == null) {
            adjustdata = BigDecimal.ZERO;
        }
        BigDecimal finalData = budget.add(adjustdata);
        com.setFinaldata(finalData);
    }

    private boolean customDimsSame(IBudgetBalance ibe, CompareDataPojo com, List<DynamicInfoCollection.InfoObject> values) {
        int size = values.size();
        Map customdimMap = com.getCustomdimMap();
        if (customdimMap == null) {
            return true;
        }
        for (int i = 0; i < size; ++i) {
            Member member;
            String controlkey = values.get(i).getValueByPropName("controlkey").toString();
            String customMember = (String)customdimMap.get(controlkey = controlkey.substring(3));
            if (StringUtils.isEmpty((String)customMember) || (member = ibe.getMember(true, (String)values.get(i).getValueByPropName("number"))) == null || member.getNumber() == null || controlkey == null || member.getNumber().equals(customMember)) continue;
            return false;
        }
        return true;
    }

    public static void IsAdjust(DynamicObject doc) {
        Map<String, List<DynamicObject>> groups = IsSuperPassBudgetValidator.getGroup(doc);
        DynamicObjectCollection multperiod = (DynamicObjectCollection)doc.get("multperiod");
        BigDecimal finalData = BigDecimal.ZERO;
        for (Map.Entry<String, List<DynamicObject>> group : groups.entrySet()) {
            List<DynamicObject> list = group.getValue();
            for (DynamicObject ldoc : list) {
                BigDecimal adjadjustdata = BigDecimal.ZERO;
                for (int i = 1; i <= multperiod.size(); ++i) {
                    adjadjustdata = adjadjustdata.add(ldoc.getBigDecimal("adjadjustdata" + i));
                }
                finalData = adjadjustdata.add(finalData);
            }
            if (finalData.compareTo(BigDecimal.ZERO) == 0) continue;
            String Message = ResManager.loadResFormat((String)"\u63d0\u4ea4\u5931\u8d25,\u7b2c%s\u7ec4\u8c03\u6574\u7684\u6570\u636e\u4e0d\u5e73\u8861\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u63d0\u4ea4\u3002", (String)"IsSuperPassBudgetValidator_5", (String)"epm-eb-opplugin", (Object[])new Object[]{group.getKey()});
            throw new KDBizException(Message);
        }
    }

    private static Map<String, List<DynamicObject>> getGroup(DynamicObject doc) {
        HashMap<String, List<DynamicObject>> sameGroupMap = new HashMap<String, List<DynamicObject>>();
        DynamicObjectCollection entryEntitys = doc.getDynamicObjectCollection("entryentity");
        for (DynamicObject edoc : entryEntitys) {
            String groupnum = edoc.getString("adjgroupnum");
            if (!sameGroupMap.containsKey(groupnum)) {
                ArrayList<DynamicObject> groupList = new ArrayList<DynamicObject>();
                groupList.add(edoc);
                sameGroupMap.put(groupnum, groupList);
                continue;
            }
            List list = (List)sameGroupMap.get(groupnum);
            list.add(edoc);
        }
        return sameGroupMap;
    }
}

