/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.opplugin.Adjust;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.expr.business.AggregateExpr;
import kd.epm.eb.business.expr.command.ScriptCommand;
import kd.epm.eb.business.servicehelper.EbBatchSave;
import kd.epm.eb.business.servicehelper.EbOlapServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.dao.adjust.CompareDataPojo;
import kd.epm.eb.common.enums.AdjustBillStateEnum;
import kd.epm.eb.common.enums.BgControlSettingTypeEnum;
import kd.epm.eb.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.BgData;
import kd.epm.eb.common.model.DynamicInfoCollection;
import kd.epm.eb.common.model.Pair;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.control.BgControlCallerImpl;
import kd.epm.eb.control.face.IBudgetBalance;
import kd.epm.eb.ebBusiness.serviceHelper.OlapServiceHelper;
import kd.epm.eb.opplugin.Adjust.AuditOp;
import kd.epm.eb.opplugin.Adjust.IsSuperPassBudgetValidator;

public class UnAuditOp
extends AbstractOperationServicePlugIn {
    protected static final Log log = LogFactory.getLog(AuditOp.class);
    private static final String ENTRYENTITY = "entryentity";
    private static final String ADJENTRYENTITY = "adjdetailentity";
    private DynamicInfoCollection dynamicInfoCollection;
    private List<CompareDataPojo> finalDataByPeriodAndOrg;
    private List<Map<String, String>> dimlist;
    private LogStats logStats = new LogStats("adjustAudio");

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("model");
        fieldKeys.add("version");
        fieldKeys.add("year");
        fieldKeys.add("changetype");
        fieldKeys.add("currency");
        fieldKeys.add("multperiod");
        fieldKeys.add("adjdetailentity.entity");
        fieldKeys.add("adjdetailentity.account");
        fieldKeys.add("adjdetailentity.customdim1");
        fieldKeys.add("adjdetailentity.customdim2");
        fieldKeys.add("adjdetailentity.customdim3");
        fieldKeys.add("adjdetailentity.customdim4");
        fieldKeys.add("adjdetailentity.customdim5");
        fieldKeys.add("adjdetailentity.customdim6");
        fieldKeys.add("adjdetailentity.groupnum");
        fieldKeys.add("adjdetailentity.budgetdata");
        fieldKeys.add("adjdetailentity.adjustdata");
        fieldKeys.add("adjdetailentity.finaldata");
        fieldKeys.add("adjdetailentity.adjexplain");
        fieldKeys.add("adjdetailentity.period");
        fieldKeys.add("datatype");
        fieldKeys.add("adjdetailentity.ordersign");
        fieldKeys.add("billtype");
        fieldKeys.add("adjdetailentity.submitvalue");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        this.lock(dataEntities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lock(DynamicObject[] dataEntities) {
        if (StringUtils.isEmpty((String)"audit/control")) {
            throw new KDBizException("error lock key.");
        }
        DLock lock = DLock.create((String)"eb/audit/control/9999");
        try {
            if (!lock.tryLock(5000L)) {
                throw new KDBizException(UnAuditOp.getLockErrorMessage("audit/control"));
            }
            UnAuditOp.dbLock();
            this.adjust(dataEntities);
        }
        finally {
            lock.unlock();
        }
    }

    private void adjust(DynamicObject[] dataEntities) {
        if (dataEntities != null && dataEntities.length > 0) {
            this.logStats.add("begin endOperationTransaction", true);
            DynamicObject doc = dataEntities[0];
            this.dynamicInfoCollection = UnAuditOp.buildCustomDimInfo(((DynamicObject)doc.get("model")).getString("id"));
            this.finalDataByPeriodAndOrg = new ArrayList<CompareDataPojo>();
            this.dimlist = new ArrayList<Map<String, String>>();
            this.getFinalDataByPeriodAndOrgByEnd(doc, this.dynamicInfoCollection, this.finalDataByPeriodAndOrg);
            Collection<IBudgetBalance> iBudgetBalances = this.queryBalance(doc, this.dynamicInfoCollection, this.dimlist, null);
            IsSuperPassBudgetValidator isSuperPassBudgetValidator = new IsSuperPassBudgetValidator(this.dynamicInfoCollection, this.finalDataByPeriodAndOrg, iBudgetBalances);
            this.addDim(this.dimlist, this.finalDataByPeriodAndOrg, this.dynamicInfoCollection, isSuperPassBudgetValidator);
            try {
                this.updateBillInfoAfterChange(doc);
                log.info("auditmessage" + this.dimlist.toString());
                this.saveDataToOlap(doc, this.dimlist);
            }
            catch (Exception exception) {
                throw new KDBizException("updateBill faild:" + exception.getMessage());
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5230\u7684\u52a8\u6001\u5bf9\u8c61\u4e3a\u7a7a\u3002", (String)"AuditOp_0", (String)"epm-eb-opplugin", (Object[])new Object[0]));
        }
        log.info("auditopend");
    }

    private void addDim(List<Map<String, String>> dimlist, List<CompareDataPojo> finalDataByPeriodAndOrg, DynamicInfoCollection dynamicInfoCollection, IsSuperPassBudgetValidator isSuperPassBudgetValidator) {
        List values = dynamicInfoCollection.getValues();
        for (Map<String, String> map : dimlist) {
            for (CompareDataPojo com : finalDataByPeriodAndOrg) {
                if (!isSuperPassBudgetValidator.adjustDataIsZero(com) || !this.dimlistSameComBycustom(com, map, values) || !map.get(SysDimensionEnum.Account.getNumber()).equals(com.getAccountNumber()) || !map.get(SysDimensionEnum.Entity.getNumber()).equals(com.getOrgnumber()) || !map.get(SysDimensionEnum.Period.getNumber()).equals(com.getPreiod()) || !map.get(SysDimensionEnum.Version.getNumber()).equals(com.getVersionNumber()) || !map.get(SysDimensionEnum.Year.getNumber()).equals(com.getYearNumber()) || !map.get(SysDimensionEnum.Currency.getNumber()).equals(com.getCurrencyNumber())) continue;
                map.put(SysDimensionEnum.Scenario.getNumber(), com.getScenarioNumber());
                map.put(SysDimensionEnum.Process.getNumber(), com.getProcess());
                map.put(SysDimensionEnum.AuditTrail.getNumber(), com.getAuditTrailNumber());
                map.put(SysDimensionEnum.InternalCompany.getNumber(), com.getInternalCompanyNumber());
                map.put("adjustdata", String.valueOf(com.getAdjustdata()));
                map.put(FacTabFieldDefEnum.FIELD_MONEY.getField(), String.valueOf(com.getFinaldata()));
            }
        }
    }

    private boolean dimlistSameComBycustom(CompareDataPojo com, Map<String, String> map, List<DynamicInfoCollection.InfoObject> values) {
        Map customdimMap = com.getCustomdimMap();
        if (customdimMap == null) {
            return true;
        }
        for (DynamicInfoCollection.InfoObject in : values) {
            String controlkey = (String)in.getValueByPropName("controlkey");
            if (((String)customdimMap.get(controlkey = controlkey.substring(3, controlkey.length()))).equals(map.get(in.getValueByPropName("number")))) continue;
            return false;
        }
        return true;
    }

    private void saveDataToOlap(DynamicObject doc, List<Map<String, String>> dimlist) {
        EbBatchSave batchSave = EbOlapServiceHelper.getBatchSave();
        SaveCommandInfo saveCommandInfo = null;
        long modelId = doc.getDynamicObject("model").getLong("id");
        String cubeNumber = doc.getDynamicObject("model").getString("number");
        IModelCacheHelper cacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        List dimensions = cacheHelper.getDimensionList();
        ArrayList<String> dimesnionNums = new ArrayList<String>(dimensions.size());
        for (Object dimension : dimensions) {
            dimesnionNums.add(dimension.getNumber());
        }
        try {
            AggregateExpr expr = new AggregateExpr();
            for (Map map : dimlist) {
                Map.Entry entry22;
                BgData bgData = new BgData(Long.valueOf(modelId));
                for (Map.Entry entry22 : map.entrySet()) {
                    if (entry22.getKey() == null || ((String)entry22.getKey()).equals(FacTabFieldDefEnum.FIELD_MONEY.getField())) continue;
                    bgData.setMember((String)entry22.getKey(), (String)entry22.getValue());
                }
                if (saveCommandInfo == null) {
                    saveCommandInfo = new SaveCommandInfo();
                    saveCommandInfo.addDimensions(cacheHelper.getModelobj().getDimensionNums());
                    saveCommandInfo.setMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
                    batchSave.open(((DynamicObject)doc.get("model")).getString("number"), saveCommandInfo);
                }
                SelectCommandInfo commandInfo = new SelectCommandInfo();
                entry22 = dimesnionNums.iterator();
                while (entry22.hasNext()) {
                    String dimesnionNum = (String)entry22.next();
                    if (SysDimensionEnum.AuditTrail.getNumber().equals(dimesnionNum)) {
                        commandInfo.addFilter(SysDimensionEnum.AuditTrail.getNumber(), new String[]{"BudgetOccupation"});
                        continue;
                    }
                    commandInfo.addFilter(dimesnionNum, new String[]{bgData.getMemberNumber(dimesnionNum)});
                }
                commandInfo.addDims(dimesnionNums.toArray(new String[0]));
                commandInfo.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
                BigDecimal adjustData = new BigDecimal((String)map.get("adjustdata"));
                Map olapDatas = EbOlapServiceHelper.queryData((SelectCommandInfo)commandInfo, (String)cubeNumber);
                if (olapDatas.size() != 1 || adjustData.compareTo(BigDecimal.ZERO) > 0) continue;
                for (Map.Entry entry3 : olapDatas.entrySet()) {
                    BigDecimal oldData;
                    if (entry3.getValue() == null || (oldData = new BigDecimal(entry3.getValue().toString())).compareTo(BigDecimal.ZERO) >= 0) continue;
                    adjustData = oldData.subtract(adjustData);
                }
                bgData.setMember(SysDimensionEnum.AuditTrail.getNumber(), "BudgetOccupation");
                if (adjustData.compareTo(BigDecimal.ZERO) >= 0) {
                    bgData.setValue(null);
                    batchSave.add(dimesnionNums, bgData);
                } else {
                    batchSave.add(dimesnionNums, bgData, (Object)adjustData);
                }
                for (String dimNum : dimesnionNums) {
                    expr.addMembers(dimNum, new HashSet<String>(Collections.singletonList(bgData.getMemberNumber(dimNum))));
                }
            }
            batchSave.flush();
            ArrayList<AggregateExpr> expresses = new ArrayList<AggregateExpr>();
            Set set2 = (Set)expr.getMembers().get(SysDimensionEnum.AuditTrail.getNumber());
            set2 = set2 == null ? new HashSet(10) : set2;
            set2.add("ATTotal");
            if (dimesnionNums.size() > 12) {
                for (int i = 12; i < dimesnionNums.size(); ++i) {
                    Set mems = (Set)expr.getMembers().get(dimesnionNums.get(i));
                    mems = mems == null ? new HashSet(10) : mems;
                    mems.add(dimesnionNums.get(i));
                }
            }
            expresses.add(expr);
            ScriptCommand command = ScriptCommand.getIntance((OlapConnection)OlapServiceHelper.getOlapConnection((String)cubeNumber));
            command.execute(Long.valueOf(modelId), expresses);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadResFormat((String)"olap\u4fdd\u5b58\u5931\u8d25%s", (String)"AuditOp_3", (String)"epm-eb-opplugin", (Object[])new Object[]{e.getMessage()}));
        }
        finally {
            batchSave.close();
        }
    }

    private static DynamicInfoCollection buildCustomDimInfo(String modelId) {
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"epm_dimension", (String)"number,name,id,shortnumber", (QFilter[])new QFBuilder().add("model", "=", (Object)Long.valueOf(modelId)).add("issysdimension", "=", (Object)"0").toArray(), (String)"dseq");
        DynamicInfoCollection customdimInfo = new DynamicInfoCollection(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u4fe1\u606f\uff1a\u524d\u7aef\u6807\u8bc6\u3001\u7f16\u7801\u3001\u540d\u79f0\u3001id\u3001\u9ed8\u8ba4\u4e0d\u533a\u5206\u6210\u5458id\u3001\u4e0d\u533a\u5206\u6210\u5458\u7f16\u7801\u3002", (String)"AuditOp_4", (String)"epm-eb-opplugin", (Object[])new Object[0]), new String[]{"controlkey", "number", "shortNum", "name", "id", "defMemberId", "defMemberNum"});
        int seq = 1;
        for (DynamicObject customDim : dims) {
            String name = customDim.getString("name");
            String number = customDim.getString("number");
            String id = customDim.getString("id");
            String shortNum = customDim.getString("shortnumber");
            customdimInfo.addInfo(new Object[]{"adjcustomdim" + seq++, number, shortNum, name, id, null, null});
        }
        if (!customdimInfo.isEmpty()) {
            QFBuilder qb = new QFBuilder("dimension", "in", (Object)IDUtils.toLongs((List)customdimInfo.getAllValOfOneProp("id")));
            qb.add("membersource", "=", (Object)"1");
            qb.add("number", "like", (Object)"%None");
            DynamicObjectCollection defMembers = QueryServiceHelper.query((String)"epm_userdefinedmembertree", (String)"id,dimension,number", (QFilter[])qb.toArray());
            DynamicInfoCollection.InfoObject infoOb = null;
            for (DynamicObject member : defMembers) {
                String memberId = member.getString("id");
                String dimensionId = member.getString("dimension");
                infoOb = customdimInfo.getInfoByOneProp("id", (Object)dimensionId);
                infoOb.setValueByPropName("defMemberId", (Object)memberId);
                infoOb.setValueByPropName("defMemberNum", (Object)member.getString("number"));
            }
        }
        return customdimInfo;
    }

    private Collection<IBudgetBalance> queryBalance(DynamicObject doc, DynamicInfoCollection dynamicInfoCollection, List<Map<String, String>> dimlist, String state) {
        ArrayList<String> type = new ArrayList<String>();
        if (state != null) {
            this.getDimQueryList(dimlist, doc, dynamicInfoCollection);
        } else {
            this.getDimQueryListByEnd(dimlist, doc, dynamicInfoCollection);
        }
        if (!UnAuditOp.IsExitMixturePeriod(dimlist, type)) {
            return UnAuditOp.getAllIbCollection(dimlist, null, type, ((DynamicObject)doc.get("model")).getLong("id"));
        }
        return UnAuditOp.queryBalanceBytype(null, dimlist, type, ((DynamicObject)doc.get("model")).getLong("id"));
    }

    private static Collection<IBudgetBalance> getAllIbCollection(List<Map<String, String>> dimlist, IDataModel dataModel, Collection<String> type, Long modelid) {
        ArrayList<IBudgetBalance> cl = new ArrayList<IBudgetBalance>();
        ArrayList<Map<String, String>> qlist = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> hlist = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> mlist = new ArrayList<Map<String, String>>();
        for (int k = 0; k < dimlist.size(); ++k) {
            for (String key : dimlist.get(k).keySet()) {
                if (key.equals("Period") && dimlist.get(k).get(key).startsWith("Q_")) {
                    qlist.add(dimlist.get(k));
                    continue;
                }
                if (key.equals("Period") && dimlist.get(k).get(key).startsWith("HF_")) {
                    hlist.add(dimlist.get(k));
                    continue;
                }
                if (!key.equals("Period") || !dimlist.get(k).get(key).startsWith("M_")) continue;
                mlist.add(dimlist.get(k));
            }
        }
        if (qlist.size() != 0) {
            type.add(BgControlSettingTypeEnum.QUARTER.getNumber());
            Collection<IBudgetBalance> budgetBalances = UnAuditOp.queryBalanceBytype(dataModel, qlist, type, modelid);
            cl.addAll(budgetBalances);
            type.clear();
        }
        if (hlist.size() != 0) {
            type.add(BgControlSettingTypeEnum.HALFYEAR.getNumber());
            Collection<IBudgetBalance> budgetBalances = UnAuditOp.queryBalanceBytype(dataModel, hlist, type, modelid);
            cl.addAll(budgetBalances);
            type.clear();
        }
        if (mlist.size() != 0) {
            type.add(BgControlSettingTypeEnum.MONTH.getNumber());
            Collection<IBudgetBalance> budgetBalances = UnAuditOp.queryBalanceBytype(dataModel, mlist, type, modelid);
            cl.addAll(budgetBalances);
            type.clear();
        }
        return cl;
    }

    private static Collection<IBudgetBalance> queryBalanceBytype(IDataModel dataModel, List<Map<String, String>> dimlist, Collection<String> type, Long modelid) {
        BgControlCallerImpl bgControlCaller = new BgControlCallerImpl();
        Collection iBudgetBalances = null;
        try {
            iBudgetBalances = dataModel == null ? bgControlCaller.queryBalance(modelid, dimlist, type, true) : bgControlCaller.queryBalance(Long.valueOf(((DynamicObject)dataModel.getValue("model")).getLong("id")), dimlist, type, true);
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        return iBudgetBalances;
    }

    private static boolean IsExitMixturePeriod(List<Map<String, String>> dimlist, Collection<String> type) {
        int i = 0;
        int j = 0;
        int z = 0;
        for (Map<String, String> map : dimlist) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (entry.getKey() == null || !entry.getKey().equals("Period")) continue;
                if (entry.getValue().startsWith("Q_")) {
                    ++i;
                    continue;
                }
                if (entry.getValue().startsWith("H_")) {
                    ++j;
                    continue;
                }
                if (!entry.getValue().startsWith("M_")) continue;
                ++z;
            }
        }
        if (i != 0 && j == 0 && z == 0) {
            type.add(BgControlSettingTypeEnum.QUARTER.getNumber());
        } else if (i == 0 && j != 0 && z == 0) {
            type.add(BgControlSettingTypeEnum.HALFYEAR.getNumber());
        } else if (i == 0 && j == 0 && z != 0) {
            type.add(BgControlSettingTypeEnum.MONTH.getNumber());
        } else {
            return false;
        }
        return true;
    }

    private void getDimQueryList(List<Map<String, String>> dimlist, DynamicObject doc, DynamicInfoCollection dynamicInfoCollection) {
        DynamicObjectCollection priod = (DynamicObjectCollection)doc.get("multperiod");
        DynamicObjectCollection entryEntity = doc.getDynamicObjectCollection(ENTRYENTITY);
        for (DynamicObject entryDynamicObject : entryEntity) {
            String entryNumber = ((DynamicObject)entryDynamicObject.get("adjentity")).getString("number");
            String accountNumber = ((DynamicObject)entryDynamicObject.get("adjaccount")).getString("number");
            for (DynamicObject dynamicObject : priod) {
                HashMap<String, String> dimMap = new HashMap<String, String>();
                dimMap.put(SysDimensionEnum.Period.getNumber(), dynamicObject.getString("fbasedataid.number"));
                String datatypeNumber = ((DynamicObject)doc.get("datatype")).getString("number");
                dimMap.put(SysDimensionEnum.DataType.getNumber(), datatypeNumber);
                String versionNumber = ((DynamicObject)doc.get("version")).getString("number");
                dimMap.put(SysDimensionEnum.Version.getNumber(), versionNumber);
                String yearNumber = ((DynamicObject)doc.get("year")).getString("number");
                dimMap.put(SysDimensionEnum.Year.getNumber(), yearNumber);
                String currencyNumber = ((DynamicObject)doc.get("currency")).getString("number");
                dimMap.put(SysDimensionEnum.Currency.getNumber(), currencyNumber);
                String changetypeNumber = ((DynamicObject)doc.get("changetype")).getString("number");
                dimMap.put(SysDimensionEnum.ChangeType.getNumber(), changetypeNumber);
                dimMap.put(SysDimensionEnum.Entity.getNumber(), entryNumber);
                dimMap.put(SysDimensionEnum.Account.getNumber(), accountNumber);
                if (!dynamicInfoCollection.isEmpty()) {
                    for (DynamicInfoCollection.InfoObject in : dynamicInfoCollection.getValues()) {
                        dimMap.put((String)in.getValueByPropName("number"), ((DynamicObject)entryDynamicObject.get((String)in.getValueByPropName("controlkey"))).getString("number"));
                    }
                }
                dimlist.add(dimMap);
            }
        }
    }

    private void getDimQueryListByEnd(List<Map<String, String>> dimlist, DynamicObject doc, DynamicInfoCollection dynamicInfoCollection) {
        DynamicObjectCollection entryEntity = doc.getDynamicObjectCollection(ADJENTRYENTITY);
        for (DynamicObject entryDynamicObject : entryEntity) {
            HashMap<String, String> dimMap = new HashMap<String, String>();
            String entryNumber = ((DynamicObject)entryDynamicObject.get("entity")).getString("number");
            String accountNumber = ((DynamicObject)entryDynamicObject.get("account")).getString("number");
            dimMap.put(SysDimensionEnum.Period.getNumber(), ((DynamicObject)entryDynamicObject.get("period")).getString("number"));
            String datatypeNumber = ((DynamicObject)doc.get("datatype")).getString("number");
            dimMap.put(SysDimensionEnum.DataType.getNumber(), datatypeNumber);
            String versionNumber = ((DynamicObject)doc.get("version")).getString("number");
            dimMap.put(SysDimensionEnum.Version.getNumber(), versionNumber);
            String yearNumber = ((DynamicObject)doc.get("year")).getString("number");
            dimMap.put(SysDimensionEnum.Year.getNumber(), yearNumber);
            String currencyNumber = ((DynamicObject)doc.get("currency")).getString("number");
            dimMap.put(SysDimensionEnum.Currency.getNumber(), currencyNumber);
            String changetypeNumber = ((DynamicObject)doc.get("changetype")).getString("number");
            dimMap.put(SysDimensionEnum.ChangeType.getNumber(), changetypeNumber);
            dimMap.put(SysDimensionEnum.Entity.getNumber(), entryNumber);
            dimMap.put(SysDimensionEnum.Account.getNumber(), accountNumber);
            if (!dynamicInfoCollection.isEmpty()) {
                for (DynamicInfoCollection.InfoObject in : dynamicInfoCollection.getValues()) {
                    String controlkey = (String)in.getValueByPropName("controlkey");
                    if ((DynamicObject)entryDynamicObject.get(controlkey = controlkey.substring(3, controlkey.length())) != null) {
                        dimMap.put((String)in.getValueByPropName("number"), ((DynamicObject)entryDynamicObject.get(controlkey)).getString("number"));
                        continue;
                    }
                    dimMap.put((String)in.getValueByPropName("number"), (String)in.getValueByPropName("shortNum") + "None");
                }
            }
            dimlist.add(dimMap);
        }
    }

    private void getFinalDataByPeriodAndOrgByEnd(DynamicObject doc, DynamicInfoCollection dynamicInfoCollection, List<CompareDataPojo> rowData) {
        DynamicObjectCollection entryEntity = doc.getDynamicObjectCollection(ADJENTRYENTITY);
        String versionNumber = ((DynamicObject)doc.get("version")).getString("number");
        String yearNumber = ((DynamicObject)doc.get("year")).getString("number");
        String currencyNumber = ((DynamicObject)doc.get("currency")).getString("number");
        String datatypeNumber = ((DynamicObject)doc.get("datatype")).getString("number");
        String changetypeNumber = ((DynamicObject)doc.get("changetype")).getString("number");
        int row = 0;
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            String orgNumber = ((DynamicObject)entry.get("entity")).getString("number");
            String accountNumber = ((DynamicObject)entry.get("account")).getString("number");
            String periodName = ((DynamicObject)entry.get("period")).getString("name");
            String period = ((DynamicObject)entry.get("period")).getString("number");
            String ordersign = entry.getString("ordersign");
            if (ordersign.indexOf(":") != -1) {
                String substring = ordersign.substring(0, ordersign.indexOf(":"));
                row = Integer.parseInt(substring);
            }
            BigDecimal adjadjustdata = (BigDecimal)entry.get("adjustdata");
            BigDecimal finaldata = (BigDecimal)entry.get("finaldata");
            BigDecimal limitbalance = (BigDecimal)entry.get("limitbalance");
            boolean isbeyond = Convert.toBool((Object)entry.get("beyond"), (Boolean)true);
            CompareDataPojo com = new CompareDataPojo(periodName, finaldata, adjadjustdata, limitbalance, isbeyond, orgNumber, accountNumber, row);
            com.setPreiod(period);
            com.setRow(row);
            com.setCurrencyNumber(currencyNumber);
            com.setYearNumber(yearNumber);
            com.setVersionNumber(versionNumber);
            com.setChangetypeNumber(changetypeNumber);
            com.setDatatypeNumber(datatypeNumber);
            com.setScenarioNumber("NoScenario");
            com.setProcess("IRpt");
            com.setAuditTrailNumber("EntityInput");
            com.setInternalCompanyNumber("ICNone");
            HashMap<String, String> CustomdimMap = new HashMap<String, String>();
            if (dynamicInfoCollection != null && dynamicInfoCollection.getValues().size() != 0) {
                for (DynamicInfoCollection.InfoObject in : dynamicInfoCollection.getValues()) {
                    String controlKey = (String)in.getValueByPropName("controlkey");
                    if (entry.get(controlKey = controlKey.substring(3)) == null) {
                        CustomdimMap.put(controlKey, in.getValueByPropName("shortNum") + "None");
                        continue;
                    }
                    CustomdimMap.put(controlKey, ((DynamicObject)entry.get(controlKey)).getString("number"));
                }
                com.setCustomdimMap(CustomdimMap);
            }
            rowData.add(com);
        }
    }

    private void updateBillInfoAfterChange(DynamicObject billObj) {
        if (this.finalDataByPeriodAndOrg.isEmpty()) {
            return;
        }
        QFBuilder qfBuilder = new QFBuilder();
        List<String> billHeadKeys = Arrays.asList("DataType", "Version", "Year", "ChangeType", "Currency");
        List<String> entryentityKeys = Arrays.asList("Period", "Entity", "Account", "customdim1", "customdim2", "customdim3", "customdim4", "customdim5", "customdim6");
        qfBuilder.add("model", "=", (Object)billObj.getLong("model.id"));
        for (String dimKey : billHeadKeys) {
            qfBuilder.add(dimKey, "=", (Object)billObj.getLong(dimKey + ".id"));
        }
        DynamicObjectCollection entityRows = billObj.getDynamicObjectCollection(ADJENTRYENTITY);
        HashMap<String, Pair<Integer, BigDecimal>> allAdjustData = new HashMap<String, Pair<Integer, BigDecimal>>();
        this.selectAdjustData(entityRows, allAdjustData, this.dynamicInfoCollection.getAllValOfOneProp("controlkey"), false, entryentityKeys);
        this.selectOtherBillsAdjustData(qfBuilder, allAdjustData, entryentityKeys, billObj.getLong("id"));
        DynamicObject entityObj = null;
        Pair vals = null;
        int rowIndex = -1;
        CompareDataPojo rowPojo = null;
        for (Object indexAndVal : allAdjustData.values()) {
            vals = (Pair)indexAndVal;
            rowIndex = (Integer)vals.getKey();
            entityObj = (DynamicObject)entityRows.get(rowIndex);
            BigDecimal budgetdata = entityObj.getBigDecimal("budgetdata");
            rowPojo = this.finalDataByPeriodAndOrg.get(rowIndex);
            if (rowPojo != null) {
                vals.setValue((Object)((BigDecimal)vals.getValue()).add(rowPojo.getFinaldata().subtract(rowPojo.getAdjustdata())));
            }
            if (budgetdata.compareTo((BigDecimal)vals.getValue()) == 0) continue;
            BigDecimal adjustdata = entityObj.getBigDecimal("adjustdata");
            entityObj.set("finaldata", (Object)adjustdata.add((BigDecimal)vals.getValue()));
            entityObj.set("budgetdata", vals.getValue());
        }
        billObj.set("billstatus", (Object)AdjustBillStateEnum.SAVE.getShortNumber());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{billObj});
        String entityNumber = billObj.getDataEntityType().getName();
        if ("eb_adjustbill".equals(entityNumber) || "eb_adjpstbill".equals(entityNumber)) {
            DB.execute((DBRoute)BgBaseConstant.epm, (String)"update t_eb_adjdetail set fsubmitvalue = 0 where fid = ?", (Object[])new Object[]{billObj.getLong("id")});
        }
    }

    private void selectOtherBillsAdjustData(QFBuilder qb, Map<String, Pair<Integer, BigDecimal>> allAdjustData, List<String> entryentityKeys, Long currentId) {
        Iterator iterator = null;
        qb.add("billstatus", "in", (Object)new String[]{AdjustBillStateEnum.SUBMIT.getShortNumber(), AdjustBillStateEnum.AUDITING.getShortNumber(), AdjustBillStateEnum.NOPASS.getShortNumber()});
        Map objs = BusinessDataServiceHelper.loadFromCache((String)"eb_adjustbill", (QFilter[])qb.toArray());
        iterator = objs.values().iterator();
        List customDimKeys = this.dynamicInfoCollection.getAllValOfOneProp("controlkey");
        while (iterator.hasNext()) {
            DynamicObject billObj = (DynamicObject)iterator.next();
            if (currentId != null && currentId.equals(billObj.getLong("id"))) continue;
            this.selectAdjustData(billObj.getDynamicObjectCollection(ADJENTRYENTITY), allAdjustData, customDimKeys, true, entryentityKeys);
        }
    }

    private void selectAdjustData(DynamicObjectCollection entityObjs, Map<String, Pair<Integer, BigDecimal>> allAdjustData, List<Object> customDimKeys, boolean isSelect, List<String> entryentityKeys) {
        DynamicObject F7Val = null;
        BigDecimal adjustData = null;
        String membNum = null;
        int index = -1;
        StringBuilder sb = new StringBuilder();
        block0: for (DynamicObject entityObj : entityObjs) {
            String membNumStr;
            Pair<Integer, BigDecimal> val;
            ++index;
            for (String key : entryentityKeys) {
                if (key.startsWith("customdim")) {
                    if (!customDimKeys.contains("adj" + key)) break;
                    F7Val = entityObj.getDynamicObject(key);
                    key = "adj" + key;
                    membNum = F7Val == null ? (String)this.dynamicInfoCollection.getValOfOnePropByAnotherProp("defMemberNum", "controlkey", (Object)key) : F7Val.getString("number");
                } else {
                    F7Val = entityObj.getDynamicObject(key);
                    if (F7Val == null) continue block0;
                    membNum = F7Val.getString("number");
                }
                sb.append(membNum);
                sb.append("!!");
            }
            if ((val = allAdjustData.get(membNumStr = sb.substring(0, sb.length() - 2))) != null) {
                adjustData = entityObj.getBigDecimal("adjustdata");
                if (adjustData.compareTo(BigDecimal.ZERO) != 0) {
                    val.setValue((Object)((BigDecimal)val.getValue()).add(adjustData));
                }
            } else if (!isSelect) {
                allAdjustData.put(membNumStr, (Pair<Integer, BigDecimal>)new Pair((Object)index, (Object)new BigDecimal(0L)));
            }
            sb.setLength(0);
        }
    }

    private static void dbLock() {
        DBRoute eb = DBRoute.of((String)"epm");
        DB.execute((DBRoute)eb, (String)"insert into t_eb_transaction (fid, fcount)  select a.fid, a.fcount FROM  (select fid, fcount from t_eb_transaction UNION select ?, 0 from t_eb_transaction) as a  where a.fid not in (select fid from t_eb_transaction)", (Object[])new Object[]{8888L});
        DB.execute((DBRoute)eb, (String)"update t_eb_transaction set fcount = fcount + 1 where fid = ?", (Object[])new Object[]{8888L});
    }

    private static String getLockErrorMessage(String lockType) {
        return "audit/control".equals(lockType) ? ResManager.loadKDString((String)"\u9884\u7b97\u8c03\u6574\u5355\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u5c1d\u8bd5", (String)"AuditOp_5", (String)"epm-eb-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u9884\u7b97\u8c03\u6574\u5355\u7533\u8bf7\u9501\u5931\u8d25", (String)"AuditOp_6", (String)"epm-eb-opplugin", (Object[])new Object[0]);
    }
}

