/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.opplugin.ApproveBill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.approveBill.CommitCheck;
import kd.epm.eb.business.approvetype.ApproveUtils;
import kd.epm.eb.common.approveBill.Entity.CentralBillType;

public class ApproveCheckOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        Set notAllDealProcesses;
        DynamicObject[] approveBills;
        super.beforeExecuteOperationTransaction(e);
        String operationKey = e.getOperationKey();
        if (!"approve_check".equals(operationKey) && !"reject_check".equals(operationKey)) {
            return;
        }
        ApproveUtils instance = ApproveUtils.getInstance();
        Set selectApproveIds = instance.getSelectApproveIds(e.getDataEntities());
        for (DynamicObject approveBill : approveBills = BusinessDataServiceHelper.load((Object[])selectApproveIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_approvebill"))) {
            String billNo = approveBill.getString("billno");
            String centralBillType = approveBill.getString("centralbilltype");
            if (!CentralBillType.Main.getNumber().equals(centralBillType)) continue;
            e.setCancel(true);
            if ("approve_check".equals(operationKey)) {
                e.setCancelMessage(ResManager.loadResFormat((String)"\u5ba1\u6279\u5931\u8d25\uff0c\u5f53\u524d\u5355\u636e\u201c%1\u201d\u5b58\u5728\u672a\u5ba1\u6838\u901a\u8fc7\u7684\u5b50\u5ba1\u6279\u5355", (String)"ApproveCheckOp_0", (String)"epm-eb-opplugin", (Object[])new Object[]{billNo}));
            } else {
                e.setCancelMessage(ResManager.loadResFormat((String)"\u9a73\u56de\u5931\u8d25\uff0c\u5f53\u524d\u5355\u636e\u201c%1\u201d\u5b58\u5728\u672a\u5ba1\u6838\u901a\u8fc7\u7684\u5b50\u5ba1\u6279\u5355", (String)"ApproveCheckOp_1", (String)"epm-eb-opplugin", (Object[])new Object[]{billNo}));
            }
            return;
        }
        ArrayList processIds = new ArrayList(16);
        List inRejectApproveBills = instance.getInRejectApproveBills((Collection)selectApproveIds, processIds);
        if ("approve_check".equals(operationKey) && inRejectApproveBills.size() != 0) {
            processIds.addAll(instance.getApproveRefReportProcessIds((Collection)inRejectApproveBills));
        }
        if ((notAllDealProcesses = instance.getNotAllDealProcesses(processIds, (Collection)selectApproveIds)).size() != 0) {
            e.setCancel(true);
            StringBuilder sb = new StringBuilder();
            sb.append(ResManager.loadKDString((String)"\u5ba1\u6279\u5931\u8d25\uff0c\u5f53\u524d\u5355\u636e\u5b58\u5728\u5982\u4e0b\u672a\u5904\u7406\u5b8c\u6210\u7684\u9a73\u56de\u62a5\u8868:", (String)"ApproveCheckOp_2", (String)"epm-eb-opplugin", (Object[])new Object[0])).append("\r\n").append(String.join((CharSequence)"\r\n", notAllDealProcesses));
            e.setCancelMessage(sb.toString());
            return;
        }
        if ("reject_check".equals(operationKey)) {
            for (Long selectApproveId : selectApproveIds) {
                boolean canOperation = new CommitCheck().checkCurrentSchemeOrTaskEntityReportCanOperation(selectApproveId, null, false);
                if (!canOperation) {
                    e.setCancelMessage(ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\u5df2\u63d0\u4ea4\uff0c\u4e0d\u80fd\u9a73\u56de\u3002", (String)"ApproveOperationConfirmPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    continue;
                }
                String billNo = ApproveUtils.getInstance().isParentEntityInApprove(selectApproveId);
                if (billNo == null) continue;
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadResFormat((String)"\u9a73\u56de\u5931\u8d25\uff0c\u5b58\u5728\u4e0a\u7ea7\u7ec4\u7ec7\u63d0\u4ea4\u7684\u5355\u636e\u201c%1\u201d\u3002", (String)"ApproveCheckOp_3", (String)"epm-eb-opplugin", (Object[])new Object[]{billNo}));
            }
        }
    }
}

