/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.opplugin.ApproveBill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.epm.eb.business.approveBill.ApproveBillServiceHelper;
import kd.epm.eb.business.approveBill.ApproveBillWF;
import kd.epm.eb.business.approveBill.RejectOnReportService;
import kd.epm.eb.business.approveBill.helper.ApproveBillSubmitHelper;
import kd.epm.eb.business.approvetype.ApproveUtils;
import kd.epm.eb.business.decompose.service.DataDecomposeService;
import kd.epm.eb.business.task.service.BgTaskDeployListService;
import kd.epm.eb.business.taskflow.TaskFlowPublisher;
import kd.epm.eb.common.approveBill.CentralBillRptSubmitHelper;
import kd.epm.eb.common.approveBill.Entity.ApproveBillInfo;
import kd.epm.eb.common.approveBill.Entity.ApproveBillStatus;
import kd.epm.eb.common.approveBill.Entity.CentralBillType;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.task.ReportOperationEnum;
import kd.epm.eb.common.reportprocess.helper.ApproveBillHelper;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessQuoteService;
import kd.epm.eb.common.reportprocess.utils.ReportProcessUtil;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.opplugin.ApproveBill.ApproveBillValidator;
import org.apache.commons.collections4.CollectionUtils;

public class AuditOp
extends AbstractOperationServicePlugIn {
    private static final String BTN_DELETE = "delete";
    private static final String BTN_UNSUBMIT = "unsubmit01";
    private static final String BTN_UNSUBMIT_WF = "unsubmit";
    private static final String BTN_REJECT = "reject";
    private static final String BTN_SUBMIT = "submit";
    private static final String BTN_AUDITPASS = "auditpass";
    private static final String BTN_AUDIT = "audit";
    private static final String BTN_UNAUDIT = "unaudit";
    private static final String CON_BILLSTATUS = "billstatus";
    private static final String CON_BILLNO = "billno";
    private static final Log log = LogFactory.getLog(AuditOp.class);

    protected String getFormId() {
        return "eb_approvebill";
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("modelid");
        e.getFieldKeys().add("rptprocesstype");
        e.getFieldKeys().add("source");
        e.getFieldKeys().add("eborgid");
        e.getFieldKeys().add("dim_period");
        e.getFieldKeys().add("dim_datatype");
        e.getFieldKeys().add("dim_version");
        e.getFieldKeys().add("entryentity.tempid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ApproveBillValidator(this.getOption().getVariables()));
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        log.info(StringUtils.join((Object[])new String[]{"submitReport_endOperationTransaction!", e.getOperationKey().toLowerCase()}));
        Set<Long> selBillIds = this.getSelBillIds(e);
        switch (e.getOperationKey().toLowerCase()) {
            case "delete": {
                this.doDelete(selBillIds);
                break;
            }
            case "unsubmit01": {
                this.doUnsubmit(selBillIds);
                break;
            }
            case "unsubmit": {
                this.doReject(selBillIds);
                break;
            }
            case "unaudit": {
                this.doUnAudit(selBillIds);
                break;
            }
            case "submit": {
                this.doSubmit(selBillIds);
                break;
            }
            case "auditpass": 
            case "audit": {
                this.doAudit(selBillIds);
                break;
            }
        }
        log.info("submitReport_endOperationTransaction_end");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        Set<Long> selBillIds = this.getSelBillIds(e);
        switch (e.getOperationKey().toLowerCase()) {
            case "auditpass": 
            case "audit": {
                ApproveUtils.getInstance().updateMainApproveStatus(selBillIds);
                break;
            }
        }
    }

    private void doUnAudit(Set<Long> selBillIds) {
        ApproveUtils.getInstance().addHistoryApproveRecord(selBillIds, BTN_UNAUDIT, (ILocaleString)ResManager.getLocaleString((String)"\u53cd\u5ba1\u6838", (String)"AuditOp_23", (String)"epm-eb-opplugin"));
        DataDecomposeService.getInstance().rejectAdjust(selBillIds);
        ApproveBillSubmitHelper.getInstance().updateRptProcess(selBillIds, BgTaskStateEnum.TEMPSAVE, this.getOption(), this.getOperationResult());
        HashSet billIds = new HashSet(selBillIds.size());
        Map billInfoMap = ApproveBillHelper.queryBill(selBillIds);
        for (Map.Entry entry : billInfoMap.entrySet()) {
            ApproveBillInfo billInfo = (ApproveBillInfo)entry.getValue();
            if (billInfo.isCentralBill()) {
                CentralBillRptSubmitHelper.buildSubmitRecord((ApproveBillInfo)billInfo);
                continue;
            }
            billIds.add(entry.getKey());
        }
        this.delRefChildBills(selBillIds);
        ApproveUtils.getInstance().updateApproveSplitBillType(billIds);
        RejectOnReportService.getInstance().discardRefRejectBills(selBillIds);
        TaskFlowPublisher.publishMessageForUnAudit(selBillIds);
    }

    private void doAudit(Set<Long> selBillIds) {
        HashSet<Long> billIds = new HashSet<Long>(16);
        HashSet<Long> rejectBillIds = new HashSet<Long>(16);
        QFilter qFilter = new QFilter("id", "in", selBillIds);
        DynamicObjectCollection approveBills = QueryServiceHelper.query((String)"eb_approvebill", (String)"id,splitbilltype", (QFilter[])qFilter.toArray());
        for (DynamicObject approveBill : approveBills) {
            Long billId = approveBill.getLong("id");
            String billType = approveBill.getString("splitbilltype");
            if (CentralBillType.Reject.getNumber().equals(billType)) {
                rejectBillIds.add(billId);
                continue;
            }
            billIds.add(billId);
        }
        RejectOnReportService.getInstance().auditSelfRejectBill(rejectBillIds);
        ApproveBillSubmitHelper.getInstance().updateRptProcess(billIds, BgTaskStateEnum.COMPLETED, this.getOption(), this.getOperationResult());
        ApproveBillSubmitHelper.getInstance().updateBillStatus(selBillIds, ApproveBillStatus.AUDIT.getNumber());
        TaskFlowPublisher.publishMessageForAudit(selBillIds);
    }

    private void doDelete(Set<Long> selBillIds) {
        Set savedProcessIds = (Set)this.getSavedObj("refAllProcessIds", HashSet.class);
        ReportProcessUtil.deleteApproveBill((Collection)savedProcessIds);
        Set reportProcessIds = (Set)this.getSavedObj("refProcessIds", HashSet.class);
        ApproveUtils.getInstance().deleteRefApproveDesc((Collection)reportProcessIds);
        ApproveUtils.getInstance().updateRejectBillStatus(selBillIds, (Collection)reportProcessIds);
        this.delRefChildBills(selBillIds);
        ApproveUtils.getInstance().deleteRejectOpinions(selBillIds);
        RejectOnReportService.getInstance().deleteRefRejectBills(selBillIds);
    }

    private void doSubmit(Set<Long> approveBillIdSet) {
        Map variables;
        OperateOption option = this.getOption();
        if (option != null && (variables = option.getVariables()) != null) {
            String loopSubmit = (String)variables.get("loopSubmit");
            try {
                if (!StringUtils.equals((CharSequence)loopSubmit, (CharSequence)"true")) {
                    log.info("submit one approveBill.");
                    ApproveBillSubmitHelper.getInstance().updateRptProcess(approveBillIdSet, BgTaskStateEnum.UNDERWAY, this.getOption(), this.getOperationResult());
                    ApproveBillSubmitHelper.getInstance().updateBillStatus(approveBillIdSet, "B");
                    CentralBillRptSubmitHelper.delSubmitRecord(approveBillIdSet);
                    ApproveUtils.getInstance().addHistoryApproveRecord(approveBillIdSet, BTN_SUBMIT, (ILocaleString)ResManager.getLocaleString((String)"\u63d0\u4ea4", (String)"AuditOp_24", (String)"epm-eb-opplugin"));
                    EpmThreadPools.CommPools.execute(() -> ApproveBillServiceHelper.stopWorkFlowForOldBills((Set)approveBillIdSet));
                }
            }
            catch (Exception ex) {
                log.error((Throwable)ex);
                if (ex instanceof KDBizException) {
                    throw ex;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u63d0\u4ea4\u5355\u636e\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AuditOp_01", (String)"epm-eb-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private void doReject(Set<Long> canDoBills) {
        ApproveUtils.getInstance().addHistoryApproveRecord(canDoBills, BTN_UNSUBMIT_WF, (ILocaleString)ResManager.getLocaleString((String)"\u9a73\u56de", (String)"AuditOp_25", (String)"epm-eb-opplugin"));
        DataDecomposeService.getInstance().rejectAdjust(canDoBills);
        ApproveBillSubmitHelper.getInstance().updateBillStatus(canDoBills, ApproveBillStatus.REJECT.getNumber());
        ApproveBillSubmitHelper.getInstance().updateRptProcess(canDoBills, BgTaskStateEnum.INCOMPLETE, this.getOption(), this.getOperationResult());
        for (Long billId : canDoBills) {
            ApproveUtils.getInstance().checkAndRejectMainBill(billId, null);
        }
        log.info("doReject:" + canDoBills);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        switch (e.getOperationKey()) {
            case "checkonrejection": {
                this.checkRejection(e);
                break;
            }
            case "delete": {
                this.b4ExeDelete(e);
                break;
            }
            case "submit": {
                if (!this.getOption().containsVariable("fromApprove")) break;
                this.checkProcessStatus(e);
                this.checkPreTask(e);
                break;
            }
        }
    }

    private void checkPreTask(BeforeOperationArgs e) {
        if (e.isCancel()) {
            return;
        }
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        String selectProperties = "modelid,source,billno,rptprocesstype,eborgid,dim_datatype,dim_period,dim_version,entryentity.tempid";
        Set billIds = Arrays.stream(dataEntities).map(r -> r.getLong("id")).collect(Collectors.toSet());
        QFilter taskBillQFilter = new QFilter("id", "in", billIds).and("rptprocesstype", "=", (Object)"1");
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"eb_approvebill", (String)selectProperties, (QFilter[])taskBillQFilter.toArray());
        if (load == null || load.length == 0) {
            return;
        }
        for (DynamicObject object : load) {
            if (!this.checkPreTaskMonitor(e, object)) continue;
            return;
        }
    }

    private boolean checkPreTaskMonitor(BeforeOperationArgs e, DynamicObject object) {
        Long ebOrgId = object.getLong("eborgid.id");
        Long taskPackageId = object.getLong("source_id");
        Set templateIds = object.getDynamicObjectCollection("entryentity").stream().map(r -> r.getLong("tempid.id")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("org", "=", (Object)ebOrgId);
        qFilter.and("template", "in", templateIds);
        qFilter.and("task.tasklist.year", "in", (Object)object.getLong("dim_period.id"));
        qFilter.and("task.tasklist.version", "in", (Object)object.getLong("dim_version.id"));
        qFilter.and("task.tasklist.datatype", "in", (Object)object.getLong("dim_datatype.id"));
        qFilter.and("task.tasklist", "=", (Object)taskPackageId);
        DynamicObjectCollection taskProcess = QueryServiceHelper.query((String)"eb_taskprocess", (String)"task", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isNotEmpty((Collection)taskProcess)) {
            Long orgViewId = BgTaskDeployListService.getInstance().getTaskListOrgViewId(taskPackageId);
            Set subTaskIds = taskProcess.stream().map(r -> r.getLong("task")).collect(Collectors.toSet());
            String checkInfo = BgTaskDeployListService.getInstance().checkTaskMonitor(Long.valueOf(object.getLong("modelid_id")), subTaskIds, ReportOperationEnum.SUBMIT, ebOrgId, orgViewId);
            if (StringUtils.isNotEmpty((CharSequence)checkInfo)) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadResFormat((String)"\u63d0\u4ea4\u5355\u636e\u201c%1\u201d\u5931\u8d25\uff0c%2", (String)"AuditOp_03", (String)"epm-eb-opplugin", (Object[])new Object[]{object.getString(CON_BILLNO), checkInfo}));
                return true;
            }
        }
        return false;
    }

    private void checkProcessStatus(BeforeOperationArgs e) {
        Set<Long> selBillIds = this.getSelBillIds(e);
        if (CollectionUtils.isEmpty(selBillIds)) {
            return;
        }
        HashMap approveBillWithProcessIdMap = new HashMap(16);
        for (Long selBillId : selBillIds) {
            Map approveRefReportProcessInfo = ApproveUtils.getInstance().getApproveRefReportProcessInfo(Collections.singleton(selBillId));
            if (approveRefReportProcessInfo.isEmpty()) continue;
            approveBillWithProcessIdMap.put(selBillId, approveRefReportProcessInfo.keySet());
        }
        if (approveBillWithProcessIdMap.isEmpty()) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u5f15\u7528\u7684\u62a5\u8868\u5b9e\u4f8b\u5df2\u4e0d\u5b58\u5728\uff0c\u4e0d\u53ef\u63d0\u4ea4", (String)"AuditOp_18", (String)"epm-eb-opplugin", (Object[])new Object[0]));
        }
        QFilter qFilter = new QFilter("id", "in", approveBillWithProcessIdMap.keySet());
        String fields = "id,source.id,modelid.id";
        DynamicObjectCollection approveBillSource = QueryServiceHelper.query((String)"eb_approvebill", (String)fields, (QFilter[])new QFilter[]{qFilter});
        HashMap<Long, Long> approveBySourceMap = new HashMap<Long, Long>(approveBillSource.size());
        for (DynamicObject dynamicObject : approveBillSource) {
            approveBySourceMap.put(dynamicObject.getLong("id"), dynamicObject.getLong("source.id"));
        }
        QFilter sourceFilter = new QFilter("id", "in", approveBySourceMap.values());
        Map scheme = BusinessDataServiceHelper.loadFromCache((String)"eb_rptscheme", (String)"id", (QFilter[])sourceFilter.toArray());
        Map taskList = BusinessDataServiceHelper.loadFromCache((String)"eb_tasklist", (String)"id", (QFilter[])sourceFilter.toArray());
        HashSet hasProcessApproveSet = new HashSet(16);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities.length < 1) {
            return;
        }
        long model = this.getModel(dataEntities[0]);
        for (Map.Entry entity : approveBillWithProcessIdMap.entrySet()) {
            boolean b;
            Long sourceId = (Long)approveBySourceMap.get(entity.getKey());
            ProcessTypeEnum processTypeEnum = null;
            if (!taskList.isEmpty() && taskList.containsKey(sourceId)) {
                processTypeEnum = ProcessTypeEnum.TASK;
            }
            if (!scheme.isEmpty() && scheme.containsKey(sourceId)) {
                processTypeEnum = ProcessTypeEnum.REPORT;
            }
            if (!(b = ReportProcessQuoteService.getInstance().checkSchemeOrTaskHasProcessQuote((Set)entity.getValue(), processTypeEnum, Long.valueOf(model), sourceId))) continue;
            hasProcessApproveSet.add(entity.getKey());
        }
        if (CollectionUtils.isEmpty(hasProcessApproveSet)) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u5f15\u7528\u7684\u62a5\u8868\u5b9e\u4f8b\u5df2\u4e0d\u5b58\u5728\uff0c\u4e0d\u53ef\u63d0\u4ea4", (String)"AuditOp_18", (String)"epm-eb-opplugin", (Object[])new Object[0]));
        }
        List validExtDataEntities = e.getValidExtDataEntities();
        ArrayList<ExtendedDataEntity> passEntity = new ArrayList<ExtendedDataEntity>(validExtDataEntities.size());
        for (ExtendedDataEntity validExtDataEntity : validExtDataEntities) {
            if (hasProcessApproveSet.contains(validExtDataEntity.getBillPkId())) {
                passEntity.add(validExtDataEntity);
                continue;
            }
            String message = ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u5f15\u7528\u7684\u62a5\u8868\u5b9e\u4f8b\u5df2\u4e0d\u5b58\u5728\uff0c\u4e0d\u53ef\u63d0\u4ea4", (String)"AuditOp_18", (String)"epm-eb-opplugin", (Object[])new Object[0]);
            String title = ResManager.loadKDString((String)"\u5f15\u7528\u5b9e\u4f8b\u6821\u9a8c", (String)"AuditOp_19", (String)"epm-eb-opplugin", (Object[])new Object[0]);
            this.addErrMessage(validExtDataEntity, message, title);
        }
        e.getValidExtDataEntities().clear();
        e.getValidExtDataEntities().addAll(passEntity);
    }

    private long getModel(DynamicObject dataEntity) {
        Long modelId = 0L;
        if (dataEntity == null) {
            return modelId;
        }
        DynamicObject dataEntity1 = dataEntity;
        DynamicObject modelid = dataEntity1.getDynamicObject("modelid");
        if (modelid == null) {
            return modelId;
        }
        return modelid.getLong("id");
    }

    private void b4ExeDelete(BeforeOperationArgs e) {
        Set<Long> selBillIds = this.getSelBillIds(e);
        if (CollectionUtils.isEmpty(selBillIds)) {
            return;
        }
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities.length < 1) {
            return;
        }
        long model = this.getModel(dataEntities[0]);
        Long userId = UserUtils.getUserId();
        boolean modelManager = ModelServiceHelper.isModelManager((Long)model);
        Map approveAndCreateMap = ApproveUtils.getInstance().queryApproveBillCreateId(selBillIds);
        List validExtDataEntities = e.getValidExtDataEntities();
        ArrayList<ExtendedDataEntity> passEntity = new ArrayList<ExtendedDataEntity>(16);
        for (ExtendedDataEntity dataEntity : validExtDataEntities) {
            if (!this.delivaryCreateValidate(dataEntity, approveAndCreateMap, userId, modelManager, e)) continue;
            passEntity.add(dataEntity);
        }
        if (CollectionUtils.isEmpty(passEntity)) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u4ec5\u521b\u5efa\u4eba\u548c\u4f53\u7cfb\u7ba1\u7406\u5458\u53ef\u4ee5\u5220\u9664\u5355\u636e\u3002", (String)"AuditOp_16", (String)"epm-eb-opplugin", (Object[])new Object[0]));
        }
        e.getValidExtDataEntities().clear();
        e.getValidExtDataEntities().addAll(passEntity);
        selBillIds = this.getSelBillIds(e);
        Set approveReportProcessIds = ApproveUtils.getInstance().getApproveReportProcessIds(selBillIds);
        this.deleteValidate(e, approveReportProcessIds);
        this.saveRefObject(approveReportProcessIds, "refAllProcessIds");
        Set reportProcessIds = ApproveUtils.getInstance().getApproveRefReportProcessIds(selBillIds);
        this.saveRefObject(reportProcessIds, "refProcessIds");
        QFilter qFilter = new QFilter("id", "in", selBillIds);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_approvebill", (String)"id, billno, eborgid, orgviewid, splitbilltype", (QFilter[])new QFilter[]{qFilter});
        ApproveUtils.getInstance().addHistoryApproveRecordWithoutRefer(selBillIds, query, BTN_DELETE, (ILocaleString)ResManager.getLocaleString((String)"\u5220\u9664", (String)"AuditOp_26", (String)"epm-eb-opplugin"));
    }

    private boolean delivaryCreateValidate(ExtendedDataEntity dataEntity, Map<Long, Long> approveAndCreateMap, Long currentUser, boolean modelManage, BeforeOperationArgs e) {
        if (modelManage) {
            return true;
        }
        Long approveCreate = approveAndCreateMap.get(IDUtils.toLong((Object)dataEntity.getBillPkId()));
        if (approveCreate.equals(currentUser)) {
            return true;
        }
        String message = ResManager.loadKDString((String)"\u4ec5\u521b\u5efa\u4eba\u548c\u4f53\u7cfb\u7ba1\u7406\u5458\u53ef\u4ee5\u5220\u9664\u5355\u636e\u3002", (String)"AuditOp_16", (String)"epm-eb-opplugin", (Object[])new Object[0]);
        String title = ResManager.loadKDString((String)"\u521b\u5efa\u4eba\u68c0\u67e5", (String)"AuditOp_17", (String)"epm-eb-opplugin", (Object[])new Object[0]);
        this.addErrMessage(dataEntity, message, title);
        return false;
    }

    private void addErrMessage(ExtendedDataEntity dataEntity, String errMsg, String title) {
        Object pkId = dataEntity.getDataEntity().getPkValue();
        int dataIndex = dataEntity.getDataEntityIndex();
        int rowIndex = 0;
        ErrorLevel errorLevel = ErrorLevel.Error;
        ValidationErrorInfo errInfo = new ValidationErrorInfo("", pkId, dataIndex, rowIndex, "BeforeExecuteOperationTransactionSample", title, errMsg, errorLevel);
        this.operationResult.addErrorInfo((OperateErrorInfo)errInfo);
    }

    private void saveRefObject(Object object, String variableKey) {
        this.getOption().setVariableValue(variableKey, SerializationUtils.toJsonString((Object)object));
    }

    private <T> T getSavedObj(String variableKey, Class<?> valueType) {
        String refProcessIds = this.getOption().getVariableValue(variableKey, "");
        if (StringUtils.isEmpty((CharSequence)refProcessIds)) {
            return (T)TypesContainer.createInstance(valueType);
        }
        return (T)SerializationUtils.fromJsonString((String)refProcessIds, valueType);
    }

    private void deleteValidate(BeforeOperationArgs e, Set<Long> approveReportProcessIds) {
        List dynamicObjects = e.getValidExtDataEntities();
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
            return;
        }
        HashSet<Long> approvebillIds = new HashSet<Long>(16);
        HashMap<Long, String> approvebillNames = new HashMap<Long, String>(16);
        for (ExtendedDataEntity dynamicObject : dynamicObjects) {
            approvebillIds.add(IDUtils.toLong((Object)dynamicObject.getBillPkId()));
            approvebillNames.put(IDUtils.toLong((Object)dynamicObject.getBillPkId()), dynamicObject.getBillNo());
        }
        if (CollectionUtils.isNotEmpty(approvebillIds)) {
            if (CollectionUtils.isEmpty(approveReportProcessIds)) {
                return;
            }
            QFilter qFilter = new QFilter("id", "in", approveReportProcessIds);
            DynamicObjectCollection reportProcess = QueryServiceHelper.query((String)"eb_reportprocess", (String)"status,approvebill", (QFilter[])qFilter.toArray());
            if (CollectionUtils.isNotEmpty((Collection)reportProcess)) {
                StringBuilder sb = new StringBuilder();
                HashSet<Long> errApprovebillIds = new HashSet<Long>(16);
                for (DynamicObject process : reportProcess) {
                    if (!StringUtils.equals((CharSequence)BgTaskStateEnum.UNDERWAY.getNumber(), (CharSequence)process.getString("status")) && !StringUtils.equals((CharSequence)BgTaskStateEnum.COMPLETED.getNumber(), (CharSequence)process.getString("status"))) continue;
                    e.setCancel(true);
                    if (!errApprovebillIds.add(process.getLong("approvebill"))) continue;
                    sb.append((String)approvebillNames.get(process.getLong("approvebill"))).append("\uff0c");
                }
                if (StringUtils.isNotEmpty((CharSequence)sb.toString())) {
                    e.setCancelMessage(ResManager.loadResFormat((String)"\u5ba1\u6279\u5355\u201c%1\u201d\uff0c\u5b58\u5728\u72b6\u6001\u4e3a\u5df2\u63d0\u4ea4\u6216\u5df2\u5ba1\u6279\u7684\u62a5\u8868\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AuditOp_15", (String)"epm-eb-opplugin", (Object[])new Object[]{sb.toString().subSequence(0, sb.length() - 1)}));
                }
            }
        }
    }

    private void checkRejection(BeforeOperationArgs e) {
        DynamicObject[] dynamicObjects = e.getDataEntities();
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        ExtendedDataEntity[] dataEntities = new ExtendedDataEntity[dynamicObjects.length];
        for (int i = 0; i < dynamicObjects.length; ++i) {
            dataEntities[i] = new ExtendedDataEntity(dynamicObjects[i], i, i);
        }
        String[] errMsg = new String[1];
        boolean illegal = new ApproveBillValidator().checkBillsValid(dataEntities, null, errMsg);
        if (illegal) {
            e.setCancel(true);
            e.setCancelMessage(errMsg[0]);
        }
    }

    private void doUnsubmit(Set<Long> canDoBills) {
        Map variables = this.getOption().getVariables();
        ApproveUtils.getInstance().addHistoryApproveRecord(canDoBills, BTN_UNSUBMIT, (ILocaleString)ResManager.getLocaleString((String)"\u64a4\u9500", (String)"AuditOp_28", (String)"epm-eb-opplugin"));
        DataDecomposeService.getInstance().rejectAdjust(canDoBills);
        ApproveBillSubmitHelper.getInstance().updateRptProcess(canDoBills, BgTaskStateEnum.TEMPSAVE, this.getOption(), this.getOperationResult());
        if (variables == null || variables.size() == 0) {
            return;
        }
        if (this.checkCanDeleteApproveBill(variables, canDoBills)) {
            Set approveReportProcessIds = ApproveUtils.getInstance().getApproveReportProcessIds(canDoBills);
            Set reportProcessIds = ApproveUtils.getInstance().getApproveRefReportProcessIds(canDoBills);
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"eb_approvebill"), (Object[])canDoBills.toArray());
            ReportProcessUtil.deleteApproveBill((Collection)approveReportProcessIds);
            ApproveUtils.getInstance().deleteRefApproveDesc((Collection)reportProcessIds);
            ApproveUtils.getInstance().updateRejectBillStatus(canDoBills, (Collection)reportProcessIds);
        } else {
            ApproveUtils.getInstance().deleteRelBailOrg(canDoBills);
        }
        Map billInfoMap = ApproveBillHelper.queryBill(canDoBills);
        for (Map.Entry entry : billInfoMap.entrySet()) {
            ApproveBillInfo billInfo = (ApproveBillInfo)entry.getValue();
            if (!billInfo.isCentralBill()) continue;
            CentralBillRptSubmitHelper.buildSubmitRecord((ApproveBillInfo)billInfo);
        }
        this.delRefChildBills(canDoBills);
    }

    private boolean checkCanDeleteApproveBill(Map<String, String> variables, Set<Long> canDoBills) {
        boolean containsKey = variables.containsKey("fromreport");
        return containsKey && "fromreport".equals(this.getOption().getVariableValue("fromreport")) && !new ApproveBillWF().hasApproveRecord(IDUtils.toLong((Object)canDoBills.toArray()[0]));
    }

    private Set<Long> getSelBillIds(BeforeOperationArgs e) {
        List dataEntities = e.getValidExtDataEntities();
        HashSet<Long> returns = new HashSet<Long>(dataEntities.size());
        if (CollectionUtils.isNotEmpty((Collection)dataEntities)) {
            for (ExtendedDataEntity dataEntity : dataEntities) {
                Long billId = IDUtils.toLong((Object)dataEntity.getBillPkId());
                returns.add(billId);
            }
        }
        return returns;
    }

    private Set<Long> getSelBillIds(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Long> returns = new HashSet<Long>(dataEntities.length);
        if (dataEntities.length > 0) {
            for (DynamicObject dataEntity : dataEntities) {
                Long billId = dataEntity.getLong("id");
                returns.add(billId);
            }
        }
        return returns;
    }

    private Set<Long> getSelBillIds(AfterOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Long> returns = new HashSet<Long>(dataEntities.length);
        if (dataEntities.length > 0) {
            for (DynamicObject dataEntity : dataEntities) {
                Long billId = dataEntity.getLong("id");
                returns.add(billId);
            }
        }
        return returns;
    }

    protected void updateBillStatus(Set<Long> fids, String status) {
        ApproveBillSubmitHelper.getInstance().updateBillStatus(fids, status);
    }

    private void delRefChildBills(Set<Long> billIds) {
        Set subApproveBillIdLists = ApproveBillHelper.getSubApproveBillIdLists(billIds);
        if (subApproveBillIdLists.size() > 0) {
            Set reportProcessIds = ApproveUtils.getInstance().getApproveRefReportProcessIds(billIds);
            ApproveUtils.getInstance().updateRejectBillStatus(billIds, (Collection)reportProcessIds);
            ApproveUtils.getInstance().stopBillFlowInstance((Collection)subApproveBillIdLists);
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"eb_approvebill"), (Object[])subApproveBillIdLists.toArray());
        }
    }
}

