/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.opplugin;

import java.util.LinkedList;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.opplugin.quote.AbstractSaveQuoteOp;

public class CentralRangeSaveQuoteOp
extends AbstractSaveQuoteOp {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        this.saveMemberQuote(e.getDataEntities());
    }

    @Override
    protected void saveMemberQuote(DynamicObject[] rangeObjects) {
        if (rangeObjects == null || rangeObjects.length == 0) {
            return;
        }
        LinkedList<MemberQuoteDao> quotes = new LinkedList<MemberQuoteDao>();
        IModelCacheHelper modelCache = null;
        for (DynamicObject rangeObject : rangeObjects) {
            long id = rangeObject.getLong("id");
            long modelId = rangeObject.getLong("model.id");
            modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            Dimension dimension = modelCache.getDimension(SysDimensionEnum.Entity.getNumber());
            long dimensionId = dimension.getId();
            long bizModelId = rangeObject.getLong("bizmodel.id");
            DynamicObjectCollection entityRange = rangeObject.getDynamicObjectCollection("entityrange");
            Set memberIds = entityRange.stream().map(dynamicObject -> dynamicObject.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
            quotes.add(new MemberQuoteDao(Long.valueOf(modelId), Long.valueOf(bizModelId), Long.valueOf(dimensionId), memberIds, MemberQuoteResourceEnum.CentralRelRange, Long.valueOf(id)));
        }
        this.saveQuote(quotes);
    }
}

