/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.opplugin.ProjectApply;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.model.BgData;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.impl.metadata.KDCell;
import kd.epm.eb.olap.impl.utils.KDOlapRequestUtils;

public class AuditOp
extends AbstractOperationServicePlugIn {
    private List<Map<String, String>> dimlist;
    private static final String BGM_PROTEMPLATE = "bgm_protemplate";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("id");
        fieldKeys.add("modelid");
        fieldKeys.add("orgid");
        fieldKeys.add("applydate");
        fieldKeys.add("billno");
        fieldKeys.add("entryentity.dim1id");
        fieldKeys.add("entryentity.dim2id");
        fieldKeys.add("entryentity.dim3id");
        fieldKeys.add("entryentity.dim4id");
        fieldKeys.add("entryentity.dim5id");
        fieldKeys.add("entryentity.dim6id");
        fieldKeys.add("entryentity.dim7id");
        fieldKeys.add("entryentity.dim8id");
        fieldKeys.add("entryentity.dim9id");
        fieldKeys.add("entryentity.dim10id");
        fieldKeys.add("entryentity.dim11id");
        fieldKeys.add("entryentity.dim12id");
        fieldKeys.add("entryentity.dim13id");
        fieldKeys.add("entryentity.dim14id");
        fieldKeys.add("entryentity.dim15id");
        fieldKeys.add("entryentity.amountunit");
        fieldKeys.add("entryentity.projectdescribe");
        fieldKeys.add("billstatus");
        fieldKeys.add("curtemplateid");
        fieldKeys.add("templatemodel");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5230\u7684\u52a8\u6001\u5bf9\u8c61\u4e3a\u7a7a\u3002", (String)"AuditOp_0", (String)"epm-eb-opplugin", (Object[])new Object[0]));
        }
        DynamicObject doc = dataEntities[0];
        this.saveData(doc.getLong("id"));
    }

    private void saveData(Long billNo) {
        Long modeldId = null;
        String modelNumber = null;
        DynamicObjectCollection dcs = this.queryDimMember(billNo);
        if (dcs.size() == 0) {
            return;
        }
        modeldId = (Long)((DynamicObject)dcs.get(0)).get("modelid.id");
        modelNumber = ((DynamicObject)dcs.get(0)).get("modelid.number").toString();
        this.dimlist = this.getDimList(dcs, modeldId, modelNumber);
        this.saveDataToOlap(modeldId, this.dimlist);
    }

    private List<Map<String, String>> getDimList(DynamicObjectCollection dcs, Long modeldId, String modelNumber) {
        this.dimlist = new ArrayList<Map<String, String>>();
        DynamicObjectCollection dimMemberNumberCollection = this.queryDimMemberNumber(((DynamicObject)dcs.get(0)).getString("curtemplateid"));
        HashMap<String, String> isvisibleMap = new HashMap<String, String>();
        HashMap<String, String> notvisibleMap = new HashMap<String, String>();
        for (DynamicObject dynamicObject : dimMemberNumberCollection) {
            if (Boolean.parseBoolean(dynamicObject.get("coldimension.isvisible").toString())) {
                isvisibleMap.put(dynamicObject.get("coldimension.dimnumber").toString(), dynamicObject.get("coldimension.dimmembernum").toString());
                continue;
            }
            notvisibleMap.put(dynamicObject.get("coldimension.dimnumber").toString(), dynamicObject.get("coldimension.dimmembernum").toString());
        }
        for (DynamicObject d : dcs) {
            HashMap<String, String> dimMap = new HashMap<String, String>();
            LinkedList<String> member = new LinkedList<String>();
            dimMap.put("Entity", d.getString("orgid.number"));
            for (int i = 4; i <= 19; ++i) {
                if (d.getString(i) == null) continue;
                member.add(d.getString(i));
            }
            for (Map.Entry entry : isvisibleMap.entrySet()) {
                String[] memberArr;
                block4: for (String memberStr : memberArr = ((String)entry.getValue()).split(",")) {
                    for (String s : member) {
                        if (!memberStr.equals(s)) continue;
                        dimMap.put((String)entry.getKey(), s);
                        continue block4;
                    }
                }
            }
            dimMap.putAll(notvisibleMap);
            dimMap.put("Metric", "Money");
            dimMap.put("Process", "IRpt");
            dimMap.put(FacTabFieldDefEnum.FIELD_MONEY.getField(), d.getString("entryentity.amountunit"));
            this.dimlist.add(dimMap);
        }
        return this.dimlist;
    }

    private DynamicObjectCollection queryDimMemberNumber(String templateId) {
        String entityName = BGM_PROTEMPLATE;
        String selectFields = "coldimension.dimensionid,coldimension.dimnumber,coldimension.seldimension,coldimension.memid,coldimension.dimmembernum,coldimension.dimmember,coldimension.isvisible";
        QFilter fmodelid = new QFilter("id", "=", (Object)templateId);
        QFilter fmodelid1 = new QFilter("coldimension.dimnumber", "!=", (Object)"description");
        QFilter[] filters = new QFilter[]{fmodelid, fmodelid1};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])filters);
        return dcs;
    }

    private void saveDataToOlap(Long modelId, List<Map<String, String>> dimlist) {
        LinkedList<IKDCell> cells = new LinkedList<IKDCell>();
        IKDCell kdCell = null;
        try {
            for (Map<String, String> map : dimlist) {
                BgData bgData = new BgData(modelId);
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    if (entry.getKey().equals(FacTabFieldDefEnum.FIELD_MONEY.getField())) continue;
                    bgData.setMember(entry.getKey(), entry.getValue());
                }
                List dimensionList = ModelCacheContext.getOrCreate((Long)modelId).getDimensionList();
                kdCell = KDCell.of((BgData)bgData, (Object)map.get(FacTabFieldDefEnum.FIELD_MONEY.getField()), (List)dimensionList);
                cells.add(kdCell);
            }
            Long modifierId = UserUtils.getUserId();
            DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"OlapService", (String)"save", (Object[])new Object[]{KDOlapRequestUtils.of((Long)modifierId, (Long)modelId, null, null, cells)});
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadResFormat((String)"olap\u4fdd\u5b58\u5931\u8d25\uff0c%s", (String)"AuditOp_1", (String)"epm-eb-opplugin", (Object[])new Object[]{e.getMessage()}));
        }
    }

    private DynamicObjectCollection queryDimMember(Long id) {
        String entityName = "bgm_projectappbill";
        String selectFields = "curtemplateid,modelid.id,modelid.number,entryentity.amountunit,orgid.number,entryentity.dim1id,entryentity.dim2id,entryentity.dim3id,entryentity.dim4id,entryentity.dim5id,entryentity.dim6id,entryentity.dim7id,entryentity.dim8id,entryentity.dim9id,entryentity.dim10id,entryentity.dim11id,entryentity.dim12id,entryentity.dim13id,entryentity.dim14id,entryentity.dim15id";
        QFilter fmodelid = new QFilter("id", "=", (Object)id);
        QFilter[] filters = new QFilter[]{fmodelid};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])filters);
        return dcs;
    }
}

