/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.opplugin.ProjectApply;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.enums.FacTabFieldDefEnum;

public class SubmitValidator
extends AbstractValidator {
    private static final String BGM_PROTEMPLATE = "bgm_protemplate";
    private List<Map<String, String>> dimlist;
    private static final String[] STATUS = new String[]{"B", "E"};

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        ArrayList<ExtendedDataEntity> submitList = new ArrayList<ExtendedDataEntity>(16);
        String templateId = dataEntities[0].getValue("curtemplateid").toString();
        int count = this.queryDimMemberNumber(templateId).size() + 2;
        for (ExtendedDataEntity dataEntity : dataEntities) {
            if (!"A".equals(dataEntity.getValue("billstatus")) || !this.validate1(dataEntity, count)) continue;
            submitList.add(dataEntity);
        }
        this.validate2(submitList);
    }

    protected boolean validate1(ExtendedDataEntity dataEntity, int dimCount) {
        boolean result = true;
        String msg = null;
        String billNumber = dataEntity.getValue("billno").toString();
        DynamicObjectCollection dynamicObject = (DynamicObjectCollection)dataEntity.getValue("entryentity");
        if (dynamicObject.size() == 0) {
            msg = ResManager.loadResFormat((String)"%s\u9879\u76ee\u660e\u7ec6\u4e3a\u7a7a", (String)"SubmitValidator_0", (String)"epm-eb-opplugin", (Object[])new Object[]{billNumber});
            this.addErrorMessage(dataEntity, msg);
            result = false;
        } else {
            result = this.checkOneBillDetail(dataEntity, dimCount);
        }
        return result;
    }

    protected void validate2(List<ExtendedDataEntity> submitList) {
        String entityName = "bgm_projectappbill";
        String selectFields = "id,modelid";
        QFilter filter1 = new QFilter("billstatus", "in", (Object)STATUS);
        QFilter[] filters = new QFilter[]{filter1};
        DynamicObject[] dcs = BusinessDataServiceHelper.load((String)entityName, (String)selectFields, (QFilter[])filters);
        ArrayList<String> all = new ArrayList<String>(16);
        ArrayList<ExtendedDataEntity> notExsitInSubmit = new ArrayList<ExtendedDataEntity>(submitList);
        for (DynamicObject dc : dcs) {
            all.addAll(this.getBillAllDetail((Long)dc.get("id")));
        }
        block1: for (ExtendedDataEntity extendedDataEntity : submitList) {
            List<String> successBillDetail = this.getBillAllDetail((Long)extendedDataEntity.getValue("id"));
            for (String s : successBillDetail) {
                if (!all.contains(s)) continue;
                this.addErrorMessage(extendedDataEntity, ResManager.loadResFormat((String)"%s\u5b58\u5728\u4e0e\u5df2\u63d0\u4ea4\u6216\u5df2\u5ba1\u6838\u5355\u636e\u91cd\u590d\u7684\u9879\u76ee\u660e\u7ec6!", (String)"SubmitValidator_1", (String)"epm-eb-opplugin", (Object[])new Object[]{extendedDataEntity.getValue("billno")}));
                notExsitInSubmit.remove(extendedDataEntity);
                continue block1;
            }
        }
        if (notExsitInSubmit.size() > 1) {
            HashMap<String, ExtendedDataEntity> map = new HashMap<String, ExtendedDataEntity>(16);
            for (ExtendedDataEntity dataEntity : notExsitInSubmit) {
                boolean flag = true;
                List<String> newList = this.getBillAllDetail((Long)dataEntity.getValue("id"));
                for (String s : newList) {
                    if (!map.containsKey(s)) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadResFormat((String)"%s\u5b58\u5728\u4e0e\u5df2\u63d0\u4ea4\u5355\u636e\u91cd\u590d\u7684\u9879\u76ee\u660e\u7ec6!", (String)"SubmitValidator_2", (String)"epm-eb-opplugin", (Object[])new Object[]{dataEntity.getValue("billno")}));
                    flag = false;
                    break;
                }
                if (!flag) continue;
                for (String s : newList) {
                    map.put(s, dataEntity);
                }
            }
        }
    }

    private List<String> getBillAllDetail(Long billNo) {
        DynamicObjectCollection dcs = this.queryDimMember(billNo);
        Long modelId = (Long)((DynamicObject)dcs.get(0)).get("modelid.id");
        List<Map<String, String>> list = this.getDimList(dcs);
        ArrayList detailList = Lists.newArrayListWithCapacity((int)list.size());
        for (int i = 0; i < list.size(); ++i) {
            String[] str;
            StringBuilder stringBuffer = new StringBuilder();
            stringBuffer.append(modelId).append(",");
            list.get(i).put("FMONEY", "");
            for (String s : str = list.get(i).values().toArray(new String[0])) {
                stringBuffer.append(s).append(",");
            }
            detailList.add(stringBuffer.toString());
        }
        return detailList;
    }

    private boolean checkOneBillDetail(ExtendedDataEntity dataEntity, int dimCount) {
        int i;
        Long billNo = (Long)dataEntity.getValue("id");
        DynamicObjectCollection dcs = this.queryDimMember(billNo);
        List<Map<String, String>> list = this.getDimList(dcs);
        HashMap allMemberStr = Maps.newHashMapWithExpectedSize((int)list.size());
        if (dataEntity.getValue("orgid") == null) {
            this.addErrorMessage(dataEntity, ResManager.loadResFormat((String)"%s\u7ec4\u7ec7\u7ef4\u5ea6\u4e3a\u7a7a\u3002", (String)"SubmitValidator_4", (String)"epm-eb-opplugin", (Object[])new Object[]{dataEntity.getValue("billno")}));
            return false;
        }
        for (i = 0; i < list.size(); ++i) {
            if (list.get(i).size() == dimCount && ((DynamicObject)dcs.get(i)).getString("entryentity.projectamount") != null && Double.parseDouble(((DynamicObject)dcs.get(i)).getString("entryentity.projectamount")) != 0.0) continue;
            this.addErrorMessage(dataEntity, ResManager.loadResFormat((String)"%s\u542b\u6709\u9879\u76ee\u660e\u7ec6\u672a\u586b\u5199\u5b8c\u6574!", (String)"SubmitValidator_5", (String)"epm-eb-opplugin", (Object[])new Object[]{dataEntity.getValue("billno")}));
            return false;
        }
        if (list.size() > 1) {
            for (i = 0; i < list.size(); ++i) {
                String[] str;
                StringBuilder stringBuffer = new StringBuilder();
                list.get(i).put("FMONEY", "");
                for (String s : str = list.get(i).values().toArray(new String[0])) {
                    stringBuffer.append(s).append(",");
                }
                if (allMemberStr.containsKey(stringBuffer.toString())) {
                    this.addErrorMessage(dataEntity, ResManager.loadResFormat((String)"%s\u542b\u6709\u91cd\u590d\u9879\u76ee\u660e\u7ec6\u3002", (String)"SubmitValidator_6", (String)"epm-eb-opplugin", (Object[])new Object[]{dataEntity.getValue("billno")}));
                    return false;
                }
                allMemberStr.put(stringBuffer.toString(), billNo);
            }
        }
        return true;
    }

    private List<Map<String, String>> getDimList(DynamicObjectCollection dcs) {
        this.dimlist = new ArrayList<Map<String, String>>(16);
        String temlateId = ((DynamicObject)dcs.get(0)).getString("curtemplateid");
        DynamicObjectCollection dimMemberNumberCollection = this.queryDimMemberNumber(temlateId);
        HashMap<String, String> isvisibleMap = new HashMap<String, String>(16);
        HashMap<String, String> notvisibleMap = new HashMap<String, String>(16);
        for (DynamicObject dynamicObject : dimMemberNumberCollection) {
            if (Boolean.parseBoolean(dynamicObject.get("coldimension.isvisible").toString())) {
                isvisibleMap.put(dynamicObject.get("coldimension.dimnumber").toString(), dynamicObject.get("coldimension.dimmembernum").toString());
                continue;
            }
            notvisibleMap.put(dynamicObject.get("coldimension.dimnumber").toString(), dynamicObject.get("coldimension.dimmembernum").toString());
        }
        for (DynamicObject d : dcs) {
            HashMap<String, String> dimMap = new HashMap<String, String>(16);
            ArrayList<String> member = new ArrayList<String>(16);
            dimMap.put("Entity", d.getString("orgid.number"));
            for (int i = 4; i < 19; ++i) {
                if (d.getString(i) == null || "".equals(d.getString(i))) continue;
                member.add(d.getString(i));
            }
            for (Map.Entry entry : isvisibleMap.entrySet()) {
                String[] memberArr;
                block4: for (String memberStr : memberArr = ((String)entry.getValue()).split(",")) {
                    for (String s : member) {
                        if (!memberStr.equals(s)) continue;
                        dimMap.put((String)entry.getKey(), s);
                        continue block4;
                    }
                }
            }
            for (Map.Entry entry : notvisibleMap.entrySet()) {
                dimMap.put((String)entry.getKey(), (String)entry.getValue());
            }
            dimMap.put("Metric", "Money");
            dimMap.put(FacTabFieldDefEnum.FIELD_MONEY.getField(), d.getString("entryentity.projectamount"));
            this.dimlist.add(dimMap);
        }
        return this.dimlist;
    }

    private DynamicObjectCollection queryDimMember(Long id) {
        String entityName = "bgm_projectappbill";
        String selectFields = "curtemplateid,modelid.id,modelid.number,entryentity.projectamount,orgid.number,entryentity.dim1id,entryentity.dim2id,entryentity.dim3id,entryentity.dim4id,entryentity.dim5id,entryentity.dim6id,entryentity.dim7id,entryentity.dim8id,entryentity.dim9id,entryentity.dim10id,entryentity.dim11id,entryentity.dim12id,entryentity.dim13id,entryentity.dim14id,entryentity.dim15id";
        QFilter fmodelid = new QFilter("id", "=", (Object)id);
        QFilter[] filters = new QFilter[]{fmodelid};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])filters);
        return dcs;
    }

    private DynamicObjectCollection queryDimMemberNumber(String templateId) {
        String entityName = BGM_PROTEMPLATE;
        String selectFields = "coldimension.dimensionid,coldimension.dimnumber,coldimension.seldimension,coldimension.memid,coldimension.dimmembernum,coldimension.dimmember,coldimension.isvisible";
        QFilter fmodelid = new QFilter("id", "=", (Object)templateId);
        QFilter fmodelid1 = new QFilter("coldimension.dimnumber", "!=", (Object)"description");
        QFilter[] filters = new QFilter[]{fmodelid, fmodelid1};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])filters);
        return dcs;
    }
}

