/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.opplugin.applybill;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.olap.transaction.OlapTX;
import kd.epm.eb.olap.transaction.OlapTXHandle;

public class BgApplyBillBaseOp
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        try (OlapTXHandle tx = OlapTX.requiredNew((String)(((Object)((Object)this)).getClass().getName() + ":handleBatchOp"));){
            try {
                this.handleOperation(e);
            }
            catch (Exception exception) {
                tx.markRollback();
                e.setCancelOperation(true);
                if (exception instanceof KDBizException) {
                    throw new KDBizException(ResManager.loadResFormat((String)"%1\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002%2", (String)"BgApplyBillBaseOp_1", (String)"epm-eb-opplugin", (Object[])new Object[]{this.getOpName(), exception.getMessage()}));
                }
                throw new KDBizException(ResManager.loadResFormat((String)"%1\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002%2", (String)"BgApplyBillBaseOp_1", (String)"epm-eb-opplugin", (Object[])new Object[]{this.getOpName(), ThrowableHelper.toString((Exception)exception)}));
            }
        }
        this.addOpLog(e);
    }

    private void addOpLog(BeginOperationTransactionArgs e) {
        if (!e.isCancelOperation()) {
            String appNumber = this.getOption().getVariableValue("appnumber");
            Set failBillIds = this.getOperationResult().getAllErrorInfo().stream().map(OperateInfo::getPkValue).collect(Collectors.toSet());
            StringBuilder sb = new StringBuilder();
            HashSet<String> sussBillNums = new HashSet<String>(16);
            HashSet<String> failBillNums = new HashSet<String>(16);
            for (DynamicObject obj : e.getDataEntities()) {
                String billNumber = obj.getString("billnumber");
                Long billId = obj.getLong("id");
                if (failBillIds.contains(billId)) {
                    failBillNums.add(billNumber);
                    continue;
                }
                sussBillNums.add(billNumber);
            }
            if (sussBillNums.size() > 0) {
                sb.append(ResManager.loadKDString((String)"\u6210\u529f\u5355\u636e\uff1a", (String)"BgApplyBillBaseOp_6", (String)"epm-eb-opplugin", (Object[])new Object[0])).append(sussBillNums);
            }
            if (failBillIds.size() > 0) {
                if (sussBillNums.size() > 0) {
                    sb.append(',');
                }
                sb.append(ResManager.loadKDString((String)"\u5931\u8d25\u5355\u636e\uff1a", (String)"BgApplyBillBaseOp_7", (String)"epm-eb-opplugin", (Object[])new Object[0])).append(failBillNums);
            }
            MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("%1$s", "BgApplyBillBaseOp_8", "epm-eb-opplugin");
            OperationLogUtil.log((String)appNumber, (String)"eb_bgapplybill", (String)"", (String)"", (MultiLangEnumBridge)this.getOpName(), (MultiLangEnumBridge)opDescBridge, (String[])new String[]{sb.toString()});
        }
    }

    protected Long getModelId(DynamicObject[] bills) {
        Long modelId = 0L;
        if (bills.length > 0) {
            modelId = bills[0].getLong("model.id");
        }
        return modelId;
    }

    protected void handleOperation(BeginOperationTransactionArgs e) {
    }

    protected void addErrorInfo(String errorStr, String billNumber, DynamicObject billObj) {
        OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
        operateErrorInfo.setMessage(billNumber + ':' + errorStr);
        operateErrorInfo.setErrorLevel(ErrorLevel.Error.name());
        operateErrorInfo.setPkValue(billObj.getPkValue());
        this.getOperationResult().addErrorInfo(operateErrorInfo);
        this.backStatus4Failed(billObj);
    }

    protected void backStatus4Failed(DynamicObject billObj) {
    }

    protected MultiLangEnumBridge getOpName() {
        return null;
    }
}

