/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.opplugin.applybill;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.common.applybill.ApplyBillStatusEnum;
import kd.epm.eb.common.applybill.ApplyBillType;
import kd.epm.eb.common.applybill.RevokeReportBillTipEnum;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;

public class BgApplyBillBaseValidator
extends AbstractValidator {
    private ApplyBillType applyBillType;

    public ApplyBillType getApplyBillType() {
        return this.applyBillType;
    }

    public void setApplyBillType(ApplyBillType applyBillType) {
        this.applyBillType = applyBillType;
    }

    public void validate() {
        ExtendedDataEntity[] dataEntitiess = this.getDataEntities();
        List<IBillOpValidator> customValidator = this.getCustomValidator();
        if (!customValidator.isEmpty()) {
            block0: for (int i = 0; i < dataEntitiess.length; ++i) {
                ExtendedDataEntity dataEntity = dataEntitiess[i];
                for (IBillOpValidator validator : customValidator) {
                    String result = validator.validate(dataEntity);
                    if (!StringUtils.isNotEmpty((String)result)) continue;
                    this.addErrorMessage(dataEntity, result);
                    continue block0;
                }
            }
        }
    }

    public Long getModelId() {
        Long modelId = 0L;
        ExtendedDataEntity[] dataEntitiess = this.getDataEntities();
        if (dataEntitiess.length > 0) {
            DynamicObject billObj = dataEntitiess[0].getDataEntity();
            modelId = billObj.getLong("model.id");
        }
        return modelId;
    }

    public Long getUserId() {
        return UserUtils.getUserId();
    }

    protected List<IBillOpValidator> getCustomValidator() {
        ArrayList<IBillOpValidator> result = new ArrayList<IBillOpValidator>(16);
        StatusValidator statusValidator = new StatusValidator(ApplyBillStatusEnum.CREATION);
        CreatorValidator creatorValidator = new CreatorValidator(this.getModelId(), this.getUserId());
        creatorValidator.setRejectBill(this.applyBillType == ApplyBillType.APPLYREJECT || this.applyBillType == ApplyBillType.COLLECTREJECT || this.applyBillType == ApplyBillType.REJECT);
        result.add(statusValidator);
        result.add(creatorValidator);
        return result;
    }

    protected String getOpName() {
        return "";
    }

    public Set<String> preparePropertys() {
        Set props = super.preparePropertys();
        props.add("model");
        props.add("billstatus");
        props.add("org");
        props.add("year");
        props.add("creater");
        props.add("applyscheme");
        props.add("billtype");
        props.add("auditpath");
        props.add("version");
        props.add("datatype");
        props.add("collectorg");
        props.add("selappbills");
        return props;
    }

    static class RevokeValidator
    implements IBillOpValidator {
        RevokeValidator() {
        }

        @Override
        public String validate(ExtendedDataEntity dataEntity) {
            DynamicObject applyBill = dataEntity.getDataEntity();
            String billNo = applyBill.getString("billnumber");
            String applyBillType = applyBill.getString("billtype");
            String revokeCheckKey = CentralAppBillService.getInstance().getRevokeCheckInfo(billNo, applyBillType);
            RevokeReportBillTipEnum enumByKey = RevokeReportBillTipEnum.getEnumByKey((String)revokeCheckKey);
            return enumByKey == null ? null : (enumByKey.isErrorTip() ? enumByKey.getShowTipMessage() : null);
        }
    }

    class CreatorValidator
    implements IBillOpValidator {
        private boolean isModelManager;
        private Long currentUser;
        private boolean isRejectBill;

        public boolean isRejectBill() {
            return this.isRejectBill;
        }

        public void setRejectBill(boolean rejectBill) {
            this.isRejectBill = rejectBill;
        }

        @Override
        public String validate(ExtendedDataEntity dataEntity) {
            DynamicObject billObj = dataEntity.getDataEntity();
            Long creator = billObj.getLong("creater.id");
            if (!(this.currentUser.equals(creator) || this.isModelManager || this.isRejectBill())) {
                return ResManager.loadResFormat((String)"\u53ea\u6709\u4f53\u7cfb\u7ba1\u7406\u5458\u6216\u5355\u636e\u521b\u5efa\u8005\u53ef\u4ee5%1\u5355\u636e\u3002", (String)"BgApplyBillDelValidator_2", (String)"epm-eb-opplugin", (Object[])new Object[]{BgApplyBillBaseValidator.this.getOpName()});
            }
            return null;
        }

        public CreatorValidator(Long modelId, Long currentUser) {
            this.isModelManager = ModelServiceHelper.isUserHasRootPermByModel((long)currentUser, (Long)modelId);
            this.currentUser = currentUser;
        }
    }

    class StatusValidator
    implements IBillOpValidator {
        private ApplyBillStatusEnum statusEnum;

        public StatusValidator(ApplyBillStatusEnum statusEnum) {
            this.statusEnum = statusEnum;
        }

        @Override
        public String validate(ExtendedDataEntity dataEntity) {
            DynamicObject billObj = dataEntity.getDataEntity();
            String billStatus = billObj.getString("billstatus");
            if (!this.statusEnum.getNumber().equals(billStatus) && !"E".equals(billStatus)) {
                return ResManager.loadResFormat((String)"\u53ea\u6709%1\u72b6\u6001\u7684\u5355\u636e\u53ef\u4ee5%2\u3002", (String)"BgApplyBillDelValidator_1", (String)"epm-eb-opplugin", (Object[])new Object[]{this.statusEnum.getName(), BgApplyBillBaseValidator.this.getOpName()});
            }
            return null;
        }
    }

    static interface IBillOpValidator {
        public String validate(ExtendedDataEntity var1);
    }
}

