/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.opplugin.applybill;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.epm.eb.business.applybill.util.ApplyBillPluginUitl;
import kd.epm.eb.business.applybill.util.BgApplyBillUtils;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.common.applybill.ApplyBillType;
import kd.epm.eb.common.applybill.SchemeAssignDimGroup;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.centralapproval.CentralAppShowInfo;
import kd.epm.eb.ebSpread.common.util.StringUtil;
import kd.epm.eb.opplugin.applybill.BgApplyBillBaseOp;
import kd.epm.eb.opplugin.applybill.BgApplyBillDelValidator;

public class BgApplyBillDelOp
extends BgApplyBillBaseOp {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new BgApplyBillDelValidator());
    }

    @Override
    protected void handleOperation(BeginOperationTransactionArgs e) {
        DynamicObject[] billObjects = e.getDataEntities();
        Long modelId = this.getModelId(billObjects);
        Map<String, Set<Long>> templateInBill = this.getTemplateByBill(billObjects, modelId);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        HashMap<String, Set<Long>> applyBills = new HashMap<String, Set<Long>>(16);
        HashMap<SchemeAssignDimGroup, Set> schemeAssignRecordIdToMapBills = new HashMap<SchemeAssignDimGroup, Set>(16);
        for (DynamicObject billObj : billObjects) {
            String billType = billObj.getString("billtype");
            String billNumber = billObj.getString("billnumber");
            DynamicObject schemeobj = billObj.getDynamicObject("applyscheme");
            Long bizCtrlRangeId = schemeobj.getLong("bizrange.id");
            Long reportSchemeId = schemeobj.getLong("id");
            SchemeAssignDimGroup schemeAssignDimGroup = new SchemeAssignDimGroup(modelId, reportSchemeId, Long.valueOf(billObj.getLong("year.id")), Long.valueOf(billObj.getLong("version.id")), Long.valueOf(billObj.getLong("datatype.id")));
            if (ApplyBillType.isApplyBill((String)billType)) {
                applyBills.put(billNumber, templateInBill.get(billNumber));
                Set billNums = schemeAssignRecordIdToMapBills.computeIfAbsent(schemeAssignDimGroup, key -> new HashSet(16));
                billNums.add(billNumber);
                continue;
            }
            Long collectOrgId = billObj.getLong("collectorg.id");
            Set<Long> tempIds = templateInBill.get(billNumber);
            String selappbills = billObj.getString("selappbills");
            Set selAppBills = StringUtil.isEmptyString((String)selappbills) ? new HashSet(16) : (Set)SerializationUtils.fromJsonString((String)selappbills, HashSet.class);
            CentralAppShowInfo showInfo = CentralAppBillService.getInstance().getCenAppInfosByEntity(billObj, collectOrgId, new ArrayList<Long>(tempIds), modelId, bizCtrlRangeId, Boolean.valueOf(true), selAppBills, Long.valueOf(schemeobj.getLong("id")), true);
            ApplyBillPluginUitl.rollbackBillData((String)billNumber, (SchemeAssignDimGroup)schemeAssignDimGroup, new HashSet(16), (Long)modelId, (String)billType, (CentralAppShowInfo)showInfo);
            DeleteServiceHelper.delete((String)"eb_centralappadjrecord", (QFilter[])new QFilter[]{new QFilter("approvebillno", "in", Collections.singleton(billNumber))});
        }
        if (!applyBills.isEmpty()) {
            BgApplyBillUtils.getInstance().clearBillOlapData(applyBills, schemeAssignRecordIdToMapBills, modelCacheHelper, null, Boolean.valueOf(false));
            BgApplyBillUtils.getInstance().deleteBillEntryData(applyBills);
        }
        this.deleteMembQuote(billObjects);
    }

    @Override
    protected MultiLangEnumBridge getOpName() {
        return new MultiLangEnumBridge("\u5220\u9664", "BgApplyBillBaseOp_3", "epm-eb-opplugin");
    }

    private void deleteMembQuote(DynamicObject[] billObjects) {
        HashSet<Long> billIds = new HashSet<Long>(billObjects.length);
        for (DynamicObject billObj : billObjects) {
            billIds.add(billObj.getLong("id"));
        }
        BgApplyBillUtils.getInstance().deleteDimQuote(billIds);
    }

    private Map<String, Set<Long>> getTemplateByBill(DynamicObject[] bills, Long modelId) {
        if (bills == null || bills.length == 0) {
            return new HashMap<String, Set<Long>>(16);
        }
        HashMap<String, Set<Long>> result = new HashMap<String, Set<Long>>(16);
        for (DynamicObject bill : bills) {
            String billNumber = bill.getString("billnumber");
            Long orgId = bill.getLong("org.id");
            Long applySchemeId = bill.getLong("applyscheme.id");
            result.put(billNumber, BgApplyBillUtils.getInstance().getTemplateByOrg(orgId, applySchemeId, modelId));
        }
        return result;
    }
}

