/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.opplugin.applybill;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordGroup;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.epm.eb.business.centralapproval.ApproveBillUtil;
import kd.epm.eb.common.applybill.ApplyBillType;
import kd.epm.eb.common.centralapproval.AppBillStatusEnum;
import kd.epm.eb.common.centralapproval.ApproveBill;
import kd.epm.eb.common.utils.StringUtils;

public class BgApplyBillSubBillValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntitiess;
        for (ExtendedDataEntity dataEntity : dataEntitiess = this.getDataEntities()) {
            String applyBillType;
            DynamicObject applyBill = dataEntity.getDataEntity();
            String billNo = applyBill.getString("billnumber");
            boolean canUnSubmit = this.isCanUnSubmit(billNo, applyBillType = applyBill.getString("billtype"));
            if (canUnSubmit) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b50\u5355\u4e2d\u6709\u5ba1\u6838\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u64cd\u4f5c", (String)"BgApplyBillSubBillValidator_1", (String)"epm-eb-opplugin", (Object[])new Object[0]));
        }
    }

    private boolean isCanUnSubmit(String billNo, String billType) {
        QFilter qFilter = new QFilter("billstatus", "!=", (Object)AppBillStatusEnum.CANCEL.getNumber());
        String billNoField = "sumbillno";
        if (billType.equals(ApplyBillType.APPLY.getNumber())) {
            billNoField = "reportbillno";
            qFilter.and(new QFilter("centralapprptentity.sumbillno", "=", (Object)""));
        }
        qFilter.and(new QFilter("centralapprptentity." + billNoField, "=", (Object)billNo));
        List query = ApproveBillUtil.getInstance().getApproveBills(qFilter);
        if (query != null && query.size() == 1) {
            ApproveBill bill = (ApproveBill)query.get(0);
            Long id = bill.getId();
            QFilter filter = new QFilter("parentid", "=", (Object)id);
            filter.and(new QFilter("billstatus", "!=", (Object)AppBillStatusEnum.CANCEL.getNumber()));
            DynamicObjectCollection subbills = QueryServiceHelper.query((String)"eb_centralappbill", (String)"id", (QFilter[])filter.toArray());
            if (subbills != null && !subbills.isEmpty()) {
                for (DynamicObject subbill : subbills) {
                    List<IApprovalRecordItem> recordItems = this.getInApproveRecords(subbill.getString("id"));
                    if (recordItems.isEmpty()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private List<IApprovalRecordItem> getInApproveRecords(String id) {
        ArrayList<IApprovalRecordItem> records = new ArrayList<IApprovalRecordItem>(16);
        List allApprovalRecord = WorkflowServiceHelper.getAllApprovalRecord((String)id);
        for (IApprovalRecordGroup iApprovalRecordGroup : allApprovalRecord) {
            List children = iApprovalRecordGroup.getChildren();
            for (IApprovalRecordItem child : children) {
                String result = child.getResult();
                String name = ResManager.loadKDString((String)"\u540c\u610f", (String)"BgApplyBillSubBillValidator_2", (String)"epm-eb-opplugin", (Object[])new Object[0]);
                if (!StringUtils.isNotEmpty((String)result) || !name.equals(result.trim())) continue;
                records.add(child);
            }
        }
        return records;
    }
}

