/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.opplugin.applybill;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.applybill.util.ApplyTemplateUtils;
import kd.epm.eb.business.applybill.util.BgApplyBillUtils;
import kd.epm.eb.business.applytemplate.config.service.ApplyTemplateColCfgService;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.applyTemplate.constants.FormTypeEnum;
import kd.epm.eb.common.applybill.ApplyBillType;
import kd.epm.eb.common.applybill.SchemeAssignDimGroup;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.EntryTemplateConfig;
import kd.epm.eb.common.applytemplatecolumn.SourceTextEnum;
import kd.epm.eb.common.applytemplatecolumn.TextColumn;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.centralapproval.CentralAppShowInfo;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.ebSpread.common.util.StringUtil;
import kd.epm.eb.opplugin.applybill.BgApplyBillBaseOp;
import kd.epm.eb.opplugin.applybill.BgApplyBillSubmitValidator;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;

public class BgApplyBillSubmitOp
extends BgApplyBillBaseOp {
    public void onAddValidators(AddValidatorsEventArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        ApplyBillType billType = this.getBillType(dataEntities);
        BgApplyBillSubmitValidator bgApplyBillSubmitValidator = new BgApplyBillSubmitValidator();
        bgApplyBillSubmitValidator.setApplyBillType(billType);
        e.addValidator((AbstractValidator)bgApplyBillSubmitValidator);
    }

    private ApplyBillType getBillType(DynamicObject[] dataEntities) {
        if (dataEntities == null || dataEntities.length == 0) {
            return null;
        }
        String billtype = dataEntities[0].getString("billtype");
        return ApplyBillType.getBillTypeByNumber((String)billtype);
    }

    @Override
    protected void handleOperation(BeginOperationTransactionArgs e) {
        DynamicObject[] billObjs = e.getDataEntities();
        ApplyBillType billTypeEnum = this.getBillType(billObjs);
        if (ApplyBillType.REJECT == billTypeEnum || ApplyBillType.APPLYREJECT == billTypeEnum || ApplyBillType.COLLECTREJECT == billTypeEnum) {
            String billtype = billObjs[0].getString("rejectiontype");
            if (billtype.equals("processrejection")) {
                BgApplyBillSubmitOp.extracted(billObjs);
            }
            return;
        }
        Long modelId = this.getModelId(billObjs);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        ApplyTemplateColCfgService templateColCfgService = ApplyTemplateColCfgService.getInstance();
        HashMap<Long, EntryTemplateConfig> allTemplateConfig = new HashMap<Long, EntryTemplateConfig>();
        ArrayList<DynamicObject> sussBillObjs = new ArrayList<DynamicObject>(16);
        block0: for (DynamicObject billDynamicObj : billObjs) {
            DynamicObject org = billDynamicObj.getDynamicObject("org");
            DynamicObject schemeobj = billDynamicObj.getDynamicObject("applyscheme");
            Long orgId = org.getLong("id");
            Long schemeId = schemeobj.getLong("id");
            Long bizCtrlRangeId = schemeobj.getLong("bizrange.id");
            Long billId = billDynamicObj.getLong("id");
            Long collectOrgId = billDynamicObj.getLong("collectorg.id");
            String billNumber = billDynamicObj.getString("billnumber");
            String billType = billDynamicObj.getString("billtype");
            Map CVDMembIds = BgApplyBillUtils.getInstance().selectDVYOnBillObj(billDynamicObj);
            Map allOrgIds = null;
            boolean isApplyBill = ApplyBillType.APPLY.getNumber().equals(billType);
            FormTypeEnum formTypeEnumByBillType = templateColCfgService.getFormTypeEnumByBillType(billType);
            SchemeAssignDimGroup schemeAssignDimGroup = new SchemeAssignDimGroup(modelId, schemeId, (Long)CVDMembIds.get(SysDimensionEnum.Year.getNumber()), (Long)CVDMembIds.get(SysDimensionEnum.Version.getNumber()), (Long)CVDMembIds.get(SysDimensionEnum.DataType.getNumber()));
            Map allDimValSetting = ReportVarUtil.getVarInfo((SchemeAssignDimGroup)schemeAssignDimGroup);
            Set tempIds = BgApplyBillUtils.getInstance().getTemplateByOrg(orgId, schemeId, modelId);
            Set notInitTemp = tempIds.stream().filter(id -> !allTemplateConfig.containsKey(id)).collect(Collectors.toSet());
            if (!notInitTemp.isEmpty()) {
                Map templateObjs = BusinessDataServiceHelper.loadFromCache((String)"eb_applytemplate", (QFilter[])new QFilter[]{new QFilter("id", "in", notInitTemp)});
                for (DynamicObject tempObj : templateObjs.values()) {
                    EntryTemplateConfig templateConfig = ApplyTemplateUtils.convertToBaseConfig((DynamicObject)tempObj, (FormTypeEnum)formTypeEnumByBillType, (IModelCacheHelper)modelCacheHelper, (Map)allDimValSetting);
                    allTemplateConfig.put(tempObj.getLong("id"), templateConfig);
                }
            }
            if (isApplyBill) {
                allOrgIds = new HashMap(16);
                for (Long templateId : tempIds) {
                    EntryTemplateConfig templateConfig = (EntryTemplateConfig)allTemplateConfig.get(templateId);
                    int orgColumnIndex = templateConfig.getOrgColumnKey() == null ? -1 : (Integer)templateConfig.getColumnIndex().get(templateConfig.getOrgColumnKey());
                    List entityData = ApplyTemplateUtils.getEntityData((String)templateConfig.getEntryTable(), (Object)billId, (List)templateConfig.getEntryColumns());
                    HashSet<Long> orgIds = new HashSet<Long>(16);
                    for (Object[] rowData : entityData) {
                        String result = this.checkMustInput(templateConfig.getColumnIndex(), templateConfig.getEntryColumns(), rowData);
                        if (result != null) {
                            this.addErrorInfo(ResManager.loadResFormat((String)"\u201c%1\u201d\u4e2d\u6709\u5fc5\u5f55\u9879\u201c%2\u201d\u672a\u586b\u5199\u3002", (String)"BgApplybillListPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[]{templateConfig.getName(), result}), billNumber, billDynamicObj);
                            continue block0;
                        }
                        if (orgColumnIndex == -1) continue;
                        orgIds.add((Long)rowData[orgColumnIndex]);
                    }
                    HashMap<String, HashSet<Long>> billOrgs = new HashMap<String, HashSet<Long>>(16);
                    billOrgs.put(billNumber, orgIds);
                    allOrgIds.put(templateId, billOrgs);
                }
            } else {
                String selappbills = billDynamicObj.getString("selappbills");
                Set selAppBills = StringUtil.isEmptyString((String)selappbills) ? new HashSet(16) : (Set)SerializationUtils.fromJsonString((String)selappbills, HashSet.class);
                CentralAppShowInfo showInfo = CentralAppBillService.getInstance().getCenAppInfosByEntity(billDynamicObj, collectOrgId, new ArrayList(tempIds), modelId, bizCtrlRangeId, Boolean.valueOf(true), selAppBills, Long.valueOf(schemeobj.getLong("id")), true);
                Map<String, EntryTemplateConfig> templateConfigMap = allTemplateConfig.values().stream().filter(config -> tempIds.contains(config.getTemplateID())).collect(Collectors.toMap(t -> t.getNumber(), t -> t));
                Map allRowData = BgApplyBillUtils.getInstance().getAuditBillData(showInfo, billNumber, templateConfigMap, false);
                billDynamicObj.set("auditpath", (Object)SerializationUtils.toJsonString((Object)showInfo.getCentralAppChain()));
                allOrgIds = BgApplyBillUtils.getInstance().selectEntityDataForCollectBillSubmit(allRowData, templateConfigMap);
            }
            String subResult = CentralAppBillService.getInstance().centralAppBillCreateOrAdd(billNumber, billType, new Pair((Object)schemeobj.getLong("id"), (Object)new Pair((Object)schemeobj.getString("number"), (Object)schemeobj.getString("name"))), allOrgIds, CVDMembIds, collectOrgId, orgId, modelId, tempIds);
            if (StringUtils.isNotEmpty((String)subResult)) {
                this.addErrorInfo(subResult, billNumber, billDynamicObj);
                continue;
            }
            sussBillObjs.add(billDynamicObj);
        }
        e.setDataEntities(sussBillObjs.toArray(new DynamicObject[0]));
    }

    private static void extracted(DynamicObject[] billObjs) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"eb_centralappbill", (String)"id, billstatus", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billObjs[0].getString("srcbillnumber"))});
        OperateOption op = OperateOption.create();
        op.setVariableValue("currbizappid", "bgmd");
        OperationServiceHelper.executeOperate((String)"submit", (String)"eb_centralappbill", (Object[])new Object[]{dynamicObject.getLong("id")}, (OperateOption)op);
        dynamicObject.set("billstatus", (Object)"B");
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    @Override
    protected MultiLangEnumBridge getOpName() {
        return new MultiLangEnumBridge("\u63d0\u4ea4", "BgApplyBillBaseOp_2", "epm-eb-opplugin");
    }

    private String checkMustInput(Map<String, Integer> columnIndex, List<BaseColumn> columnList, Object[] rowData) {
        for (BaseColumn column : columnList) {
            int index;
            Object val;
            if (!column.getIsmustinput().booleanValue() || !column.isEnable() || !column.isBaseVisible() || (val = rowData[index = columnIndex.get(column.getKey()).intValue()]) != null && (!(val instanceof Long) || !val.equals(0L)) && (!(val instanceof String) || !StringUtils.isEmpty((String)((String)val))) || !(column instanceof TextColumn)) continue;
            TextColumn textColumn = (TextColumn)column;
            if (SourceTextEnum.CentralOrg.getValue() == textColumn.getSourceTextEnum()) continue;
            return column.getTitle();
        }
        return null;
    }

    @Override
    protected void backStatus4Failed(DynamicObject billObj) {
        billObj.set("billstatus", (Object)"A");
    }
}

