/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.opplugin.applybill;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.epm.eb.business.applybill.util.ApplyBillAttachmentHelper;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.business.rejectbill.RejectBillService;
import kd.epm.eb.opplugin.applybill.BgApplyBillBaseOp;
import kd.epm.eb.opplugin.applybill.BgApplyBillSubBillValidator;
import kd.epm.eb.opplugin.applybill.BgApplyBillUnSubmitValidator;

public class BgApplyBillUnSubmitOp
extends BgApplyBillBaseOp {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new BgApplyBillUnSubmitValidator());
        e.addValidator((AbstractValidator)new BgApplyBillSubBillValidator());
    }

    @Override
    protected void handleOperation(BeginOperationTransactionArgs e) {
        DynamicObject[] billObjs = e.getDataEntities();
        ArrayList<DynamicObject> sussBillObjs = new ArrayList<DynamicObject>(16);
        for (DynamicObject applyBillDynamicObj : billObjs) {
            String billNumber = applyBillDynamicObj.getString("billnumber");
            String billType = applyBillDynamicObj.getString("billtype");
            long modelId = applyBillDynamicObj.getLong("model.id");
            Set auditBillNumbers = CentralAppBillService.getInstance().revokeReportBill(billNumber, billType);
            if (auditBillNumbers != null && !auditBillNumbers.isEmpty()) {
                HashSet spNumbers = new HashSet(16);
                spNumbers.addAll(auditBillNumbers);
                RejectBillService.getInstance().deleteRejectDataBySpNumbers(spNumbers, Long.valueOf(modelId));
                ApplyBillAttachmentHelper.removeApproveBillAttachments(spNumbers, (Long)modelId);
            }
            sussBillObjs.add(applyBillDynamicObj);
        }
        e.setDataEntities(sussBillObjs.toArray(new DynamicObject[0]));
    }

    @Override
    protected void backStatus4Failed(DynamicObject billObj) {
    }

    @Override
    protected MultiLangEnumBridge getOpName() {
        return new MultiLangEnumBridge("\u64a4\u9500", "BgApplyBillBaseOp_4", "epm-eb-opplugin");
    }
}

