/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.opplugin.applyscheme;

import java.util.Calendar;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.opplugin.task.AbstractBgValidator;

public class ApplySchemeValidator
extends AbstractBgValidator {
    @Override
    public void validate() {
        super.validate();
        this.checkTime();
        this.checkRefTemplate();
    }

    @Override
    protected void setEntityInfo() {
        this.setEntityNumber("eb_bgapplyscheme");
    }

    @Override
    protected String checkNumberRule(DynamicObject obj) {
        if (obj != null && StringUtils.isEmpty((String)obj.getString("number"))) {
            obj.set("number", (Object)("BgApplyscheme-" + System.currentTimeMillis()));
        }
        return super.checkNumberRule(obj);
    }

    @Override
    protected boolean checkNumber(String entityNumber, DynamicObject obj) {
        if (StringUtils.isEmpty((String)entityNumber) || obj == null) {
            return true;
        }
        Long id = obj.getLong("id");
        Long taskPackId = obj.getLong("schemelist.id");
        String number = obj.getString("number");
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("schemelist", "=", (Object)taskPackId));
        builder.add(new QFilter("number", "=", (Object)number));
        return NumberCheckUtils.checkNumberExist((String)this.getEntityNumber(), (QFilter[])builder.toArrays(), (Long)id);
    }

    protected void checkTime() {
        ExtendedDataEntity[] datas;
        DynamicObject task = null;
        String taskId = null;
        Date begin = null;
        Date deadline = null;
        Date currDate = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currDate);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        currDate = calendar.getTime();
        for (ExtendedDataEntity data : datas = this.getDataEntities()) {
            task = data.getDataEntity();
            taskId = task.getString("id");
            begin = task.getDate("begintime");
            deadline = task.getDate("deadline");
            if (taskId != null && !taskId.equals("0")) {
                Date oldBegin = this.getOldBeginTime(taskId);
                if (begin.compareTo(currDate) >= 0 || begin.compareTo(oldBegin) >= 0) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u65b0\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u540c\u65f6\u5c0f\u4e8e\u65e7\u5f00\u59cb\u65e5\u671f\u548c\u5f53\u524d\u65e5\u671f", (String)"TaskValidator_0", (String)"epm-eb-opplugin", (Object[])new Object[0]));
            }
            if (deadline.compareTo(begin) < 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u8d77\u59cb\u65e5\u671f", (String)"TaskValidator_1", (String)"epm-eb-opplugin", (Object[])new Object[0]));
            }
            if (begin.compareTo(currDate) >= 0) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65e5\u671f", (String)"TaskValidator_2", (String)"epm-eb-opplugin", (Object[])new Object[0]));
        }
    }

    protected Date getOldBeginTime(String taskId) {
        DynamicObject oldTask = QueryServiceHelper.queryOne((String)"eb_bgapplyscheme", (String)"id,number,begintime", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taskId)});
        if (oldTask != null) {
            return oldTask.getDate("begintime");
        }
        return null;
    }

    @Override
    protected boolean checkName(DynamicObject obj) {
        if (obj == null) {
            throw new NullPointerException("dynamic Object is null.");
        }
        Long id = obj.getLong("id");
        Long schemeListId = obj.getLong("schemelist.id");
        String name = obj.getString("name");
        if (StringUtils.isEmpty((String)name)) {
            throw new NullPointerException("name is null.");
        }
        boolean check = false;
        QFBuilder builder = new QFBuilder();
        if (id != null && id != 0L) {
            builder.add(new QFilter("id", "=", (Object)id));
            DynamicObjectCollection result = QueryServiceHelper.query((String)"eb_bgapplyscheme", (String)"id", (QFilter[])builder.toArrays());
            check = result == null || result.size() == 0 ? false : (result.size() == 1 ? id.longValue() != ((DynamicObject)result.get(0)).getLong("id") : true);
        } else {
            builder.add(new QFilter("schemelist", "=", (Object)schemeListId));
            builder.add(new QFilter("name", "=", (Object)name));
            check = QueryServiceHelper.exists((String)"eb_bgapplyscheme", (QFilter[])builder.toArrays());
        }
        return check;
    }

    protected void checkRefTemplate() {
        ExtendedDataEntity[] datas;
        DynamicObject task = null;
        for (ExtendedDataEntity data : datas = this.getDataEntities()) {
            task = data.getDataEntity();
            if (task.getDynamicObjectCollection("entryentity") == null || task.getDynamicObjectCollection("entryentity").isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5173\u8054\u7533\u62a5\u6a21\u677f", (String)"ApplySchemeValidator_0", (String)"epm-eb-opplugin", (Object[])new Object[0]));
            }
            if (task.getDynamicObjectCollection("entryentity").size() <= 10) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u6700\u591a\u53ea\u80fd\u5173\u805410\u4e2a\u6a21\u677f\u3002", (String)"ApplySchemeValidator_1", (String)"epm-eb-opplugin", (Object[])new Object[0]));
        }
    }
}

