/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.opplugin.applytemplate;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.epm.eb.business.applybill.util.ApplyTemplateUtils;
import kd.epm.eb.business.template.ApplyTemplateHelper;
import kd.epm.eb.common.applyTemplate.TempDimConfig;
import kd.epm.eb.common.applyTemplate.TempDimConfigType;
import kd.epm.eb.common.applybill.ApplyTempStatusEnum;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.ColumnList;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.utils.IDUtils;

public class ApplyDialogTemplateSaveOp
extends AbstractOperationServicePlugIn {
    private static final String KEY_MAINENTRYENTITY = "mainentryentity";
    private static final String KEY_BIZMAINENTRYENTITY = "bizentryentity";

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        LinkedList quotes = new LinkedList();
        List mainHideDimConfigList = null;
        IModelCacheHelper modelCache = null;
        String settingKey = "eb_applytemplate_dimarea.FormSetting";
        String setting = UserConfigServiceHelper.getSetting((long)RequestContext.get().getCurrUserId(), (String)settingKey);
        HashMap allEntryEntitySettingHashMap = new HashMap(16);
        if (StringUtils.isNotBlank((CharSequence)setting)) {
            Map columWidthMap;
            Map settingMap = (Map)SerializationUtils.fromJsonString((String)setting, HashMap.class);
            Map bizEntryEntitySettingMap = (Map)settingMap.get(KEY_BIZMAINENTRYENTITY);
            Map mainEntryEntitySettingMap = (Map)settingMap.get(KEY_MAINENTRYENTITY);
            if (bizEntryEntitySettingMap != null && (columWidthMap = (Map)bizEntryEntitySettingMap.get("cw")) != null) {
                allEntryEntitySettingHashMap.putAll(columWidthMap);
            }
            if (mainEntryEntitySettingMap != null && (columWidthMap = (Map)mainEntryEntitySettingMap.get("cw")) != null) {
                allEntryEntitySettingHashMap.putAll(columWidthMap);
            }
        }
        for (DynamicObject bill : dataEntities = e.getDataEntities()) {
            Long modelId;
            Long resourceId = bill.getLong("id");
            DynamicObject _object = bill.getDynamicObject("model");
            Long l = modelId = _object != null ? Long.valueOf(_object.getLong("id")) : null;
            if (IDUtils.isNull((Long)modelId)) continue;
            if (modelCache == null || modelCache.getModelobj().getId().compareTo(modelId) != 0) {
                modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            }
            Long datasetId = (_object = bill.getDynamicObject("dataset")) != null ? Long.valueOf(_object.getLong("id")) : null;
            String hideDimData = bill.getString("cachedata_tag");
            if (StringUtils.isNotEmpty((CharSequence)hideDimData)) {
                mainHideDimConfigList = SerializationUtils.fromJsonStringToList((String)hideDimData, TempDimConfig.class);
                mainHideDimConfigList.removeIf(dimConfig -> !TempDimConfigType.HIDEDIM.getValue().equals(dimConfig.getPanel()));
            }
            LargeTextProp entrycfgjson = (LargeTextProp)bill.getDataEntityType().getProperties().get((Object)"entrycfgjson");
            int templateStatus = bill.getInt("templatestatus");
            if (entrycfgjson == null) continue;
            String entrycfgjsonstr = (String)bill.get("entrycfgjson_tag");
            ColumnList columnList = (ColumnList)SerializationUtils.fromJsonString((String)entrycfgjsonstr, ColumnList.class);
            Collection columns = columnList.getColumns();
            for (BaseColumn column : columns) {
                String key = column.getKey();
                Integer width = (Integer)allEntryEntitySettingHashMap.get(key);
                if (width == null) continue;
                column.setWidth(width);
            }
            Map entityinfomap = columnList.getEntityinfomap();
            Set<String> oldColumnKeys = this.getOldColumnKeys();
            for (Map.Entry entry : entityinfomap.entrySet()) {
                String tablename;
                if (StringUtils.isEmpty((CharSequence)entry.getValue().toString())) {
                    tablename = Uuid8.generateShortUuid().toLowerCase();
                    this.createTable(entry, columnList, tablename);
                    continue;
                }
                if (ApplyTempStatusEnum.SAVE.getValue() != templateStatus) {
                    this.addColumnToTable(entry, columnList, oldColumnKeys);
                    continue;
                }
                tablename = entry.getValue().toString().substring(9);
                this.createTable(entry, columnList, tablename);
            }
            bill.set("entrycfgjson_tag", (Object)SerializationUtils.toJsonString((Object)columnList));
            quotes.addAll(ApplyTemplateUtils.getTemplateMemberQuotes((Long)modelId, (Long)datasetId, (Long)resourceId, (ColumnList)columnList, (List)mainHideDimConfigList, (IModelCacheHelper)modelCache));
        }
        e.setDataEntities(dataEntities);
        if (quotes.size() > 0) {
            DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"save", (Object[])new Object[]{quotes});
        }
    }

    private Set<String> getOldColumnKeys() {
        String str = this.getOption().getVariableValue("oldColumnKeys");
        if (str == null) {
            return new HashSet<String>(16);
        }
        return (Set)SerializationUtils.fromJsonString((String)str, HashSet.class);
    }

    private void addColumnToTable(Map.Entry entry, ColumnList columnList, Set<String> oldColumnKeys) {
        Collection columns = columnList.getColumns();
        String tableName = entry.getValue().toString();
        if (KEY_MAINENTRYENTITY.equals(entry.getKey().toString())) {
            List collect = columns.stream().filter(temp -> "h".equals(temp.getCategory()) && !oldColumnKeys.contains(temp.getKey())).collect(Collectors.toList());
            ApplyTemplateHelper.addColumnsToEntryTable(collect, (String)tableName);
        } else if (KEY_BIZMAINENTRYENTITY.equals(entry.getKey().toString())) {
            List collect = columns.stream().filter(temp -> "e".equals(temp.getCategory()) && !oldColumnKeys.contains(temp.getKey())).collect(Collectors.toList());
            ApplyTemplateHelper.addColumnsToEntryTable(collect, (String)tableName);
        }
    }

    private void createTable(Map.Entry entry, ColumnList columnList, String tablename) {
        List collect = null;
        Collection columns = columnList.getColumns();
        if (KEY_MAINENTRYENTITY.equals(entry.getKey().toString())) {
            collect = columns.stream().filter(temp -> "h".equals(temp.getCategory())).collect(Collectors.toList());
            String fulltablename = ApplyTemplateHelper.createBillEntityTable(collect, (String)tablename, (boolean)false);
            entry.setValue(fulltablename);
        } else if (KEY_BIZMAINENTRYENTITY.equals(entry.getKey().toString())) {
            collect = columns.stream().filter(temp -> "e".equals(temp.getCategory())).collect(Collectors.toList());
            String fulltablename = ApplyTemplateHelper.createBillEntityTable(collect, (String)tablename, (boolean)true);
            entry.setValue(fulltablename);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dynamicObject : dataEntities = e.getDataEntities()) {
        }
    }
}

