/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.opplugin.centralapproval;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.EndEvent;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityImpl;
import kd.epm.eb.business.centralapproval.ApproveBillUtil;
import kd.epm.eb.business.centralapproval.ApproveRecordUtil;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.common.centralapproval.AppBillStatusEnum;
import kd.epm.eb.common.centralapproval.ApproveBill;
import kd.epm.eb.common.centralapproval.ApproveRecord;
import kd.epm.eb.common.centralapproval.ApproveRecordEntry;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.opplugin.centralapproval.CentralApprovalValidator;

public class AuditOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(AuditOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("parentid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new CentralApprovalValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String key = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        switch (key) {
            case "auditback": {
                break;
            }
            case "auditpass": {
                this.saveApproveRecord(dataEntities, "0");
                break;
            }
            case "auditend": {
                this.updateAptOrColBillStatus(dataEntities);
            }
        }
    }

    private boolean isWasteBill(ApproveBill approveBill) {
        return AppBillStatusEnum.CANCEL == approveBill.getBillStatus();
    }

    private void saveApproveRecord(DynamicObject[] dataEntities, String status) {
        ApproveBill approveBill;
        if (dataEntities == null || dataEntities.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5ba1\u6279\u5355\u636e\u4fe1\u606f\u5931\u8d25\u3002", (String)"AuditOp_7", (String)"epm-eb-opplugin", (Object[])new Object[0]));
        }
        boolean isBatchApprove = this.isBatchApprove(dataEntities[0]);
        Long userId = CentralAppBillService.getInstance().getUserId();
        Date time = TimeServiceHelper.now();
        Long pkId = dataEntities[0].getLong("id");
        ApproveBillUtil instance = ApproveBillUtil.getInstance();
        ApproveBill approveBill2 = approveBill = isBatchApprove ? instance.getApproveBill(new QFilter("id", "=", (Object)pkId)) : instance.createApproveBill(dataEntities[0]);
        if (this.isWasteBill(approveBill)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u80fd\u5ba1\u6279\u5df2\u4f5c\u5e9f\u7684\u5355\u636e\uff01", (String)"AuditOp_20", (String)"epm-eb-opplugin", (Object[])new Object[0]));
        }
        Map<String, String> nodeInfos = this.getCurrentNodeInfos(pkId);
        if (nodeInfos.size() == 0) {
            return;
        }
        String curNodeNumber = nodeInfos.get("number");
        String plan = "";
        String billNo = approveBill.getBillNo();
        ApproveRecord approveRecord = ApproveRecordUtil.getInstance().getApproveRecord(billNo);
        if (approveRecord == null) {
            approveRecord = new ApproveRecord(billNo, approveBill.getModel());
        }
        List approveRecordEntries = approveRecord.getApproveRecordEntries();
        this.setCentralAppRecEntity(approveRecordEntries, plan, userId, curNodeNumber, nodeInfos.get("name"), status, time);
        try (TXHandle tx = TX.required((String)"updateRecordAndBill");){
            try {
                if (isBatchApprove) {
                    this.updateProcessPlan(approveBill, plan, userId);
                }
                this.saveApproveStatus(approveBill, nodeInfos, userId, time);
                ApproveRecordUtil.getInstance().saveApproveRecord(Collections.singleton(approveRecord));
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private void updateProcessPlan(ApproveBill approveBill, String plan, Long userId) {
        Map centralProcessPlan = approveBill.getCentralProcessPlan();
        HashMap<Long, HashSet<String>> planMap_new = new HashMap<Long, HashSet<String>>(16);
        HashSet<String> curPlans = new HashSet<String>(Arrays.asList(plan.split(",")));
        if (centralProcessPlan != null && centralProcessPlan.size() != 0) {
            Set plans = centralProcessPlan.computeIfAbsent(userId, k -> new HashSet(16));
            if (plans.containsAll(curPlans) && curPlans.containsAll(plans)) {
                return;
            }
            plans.addAll(curPlans);
            planMap_new.putAll(centralProcessPlan);
        } else {
            planMap_new.put(userId, curPlans);
        }
        approveBill.setCentralProcessPlan(planMap_new);
    }

    private Boolean isBatchApprove(DynamicObject approveBill) {
        return approveBill.getDynamicObjectType().getProperty("model") == null;
    }

    private void saveApproveStatus(ApproveBill approveBill, Map<String, String> nodeInfos, Long usrId, Date time) {
        boolean isEnd = this.isNextNodeEnd(nodeInfos);
        approveBill.setAuditDate(time);
        approveBill.setAuditor(usrId);
        if (isEnd) {
            approveBill.setBillStatus(AppBillStatusEnum.AUDITED);
        }
        approveBill.setCurNode("");
        ApproveBillUtil.getInstance().save(Collections.singleton(approveBill));
        this.setAppOrColBillApprovePass(approveBill, usrId, time, isEnd, false);
    }

    private void setCentralAppRecEntity(List<ApproveRecordEntry> approveRecordEntries, String plan, Long userId, String currentNodeNumber, String currentNodeName, String status, Date time) {
        Long org = UserServiceHelper.getUserMainOrgId((long)userId);
        ApproveRecordEntry entry = new ApproveRecordEntry();
        entry.setPlans(plan);
        entry.setApprover(userId);
        entry.setAdminOrg(org);
        entry.setApproveNode(currentNodeName);
        entry.setApproveNodeNumber(currentNodeNumber);
        entry.setApproveStatus(status);
        entry.setApproveDate(time);
        approveRecordEntries.add(entry);
    }

    private boolean isNextNodeEnd(Map<String, String> nodeInfos) {
        String isNextEnd = nodeInfos.get("isNextEnd");
        return StringUtils.isNotEmpty((String)isNextEnd) && "true".equals(isNextEnd);
    }

    private Map<String, String> getCurrentNodeInfos(Long pkId) {
        HashMap<String, String> nodeInfos = new HashMap<String, String>(16);
        Map variables = this.getOption().getVariables();
        Long taskId = ConvertUtils.toLong(variables.get("taskid"));
        if (taskId == 0L) {
            return nodeInfos;
        }
        TaskEntityImpl task = (TaskEntityImpl)WorkflowServiceHelper.findTaskById((Long)taskId);
        if (task == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u67e5\u627e\u5230\u4efb\u52a1\u3002", (String)"AuditOp_29", (String)"epm-eb-opplugin", (Object[])new Object[0]));
        }
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null) {
            boolean isNextEnd;
            String[] arrays;
            DynamicObject taskDyn = task.getDynamicObject();
            String name = taskDyn.getString("name");
            String taskdefinitionkey = taskDyn.getString("taskdefinitionkey");
            if (StringUtils.isNotEmpty((String)taskdefinitionkey) && (arrays = taskdefinitionkey.split("_")) != null && arrays.length > 0) {
                String number = arrays[arrays.length - 1];
                nodeInfos.put("number", number);
            }
            nodeInfos.put("name", name);
            List nextUserTaskNode = WorkflowServiceHelper.getNextUserTaskNodeByBusinessKey((String)String.valueOf(pkId));
            if (nextUserTaskNode != null && nextUserTaskNode.size() > 0 && (isNextEnd = ((Map)nextUserTaskNode.get(0)).get("nextNode") instanceof EndEvent)) {
                nodeInfos.put("isNextEnd", "true");
            }
        } else {
            SequenceFlow sequenceFlow;
            FlowElement targetFlowElement;
            List outgoingFlows;
            ExecutionEntity execution = task.getExecution();
            if (execution == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u4efb\u52a1\u6267\u884c\u5b9e\u4f8b\u3002", (String)"AuditOp_30", (String)"epm-eb-opplugin", (Object[])new Object[0]));
            }
            FlowElement element = execution.getCurrentFlowElement();
            if (element == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u4efb\u52a1\u8282\u70b9\u3002", (String)"AuditOp_31", (String)"epm-eb-opplugin", (Object[])new Object[0]));
            }
            if (element instanceof AuditTask && (outgoingFlows = ((AuditTask)element).getOutgoingFlows()).size() != 0 && (targetFlowElement = (sequenceFlow = (SequenceFlow)outgoingFlows.get(0)).getTargetFlowElement()) instanceof EndEvent) {
                nodeInfos.put("isNextEnd", "true");
            }
            String number = element.getNumber();
            String name = element.getName();
            nodeInfos.put("number", number);
            nodeInfos.put("name", name);
        }
        return nodeInfos;
    }

    private void setAppOrColBillApprovePass(ApproveBill approveBill, Long usrId, Date time, Boolean isEnd, Boolean onlyUpdateStatus) {
        DynamicObject[] billInfos;
        List approveBillEntries = approveBill.getApproveBillEntries();
        if (approveBill.getParentId() != 0L) {
            return;
        }
        if (approveBillEntries == null || approveBillEntries.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5ba1\u6279\u5355\u636e\u5355\u636e\u4f53\u6570\u636e\u5931\u8d25\u3002", (String)"AuditOp_13", (String)"epm-eb-opplugin", (Object[])new Object[0]));
        }
        HashSet bills = new HashSet(16);
        approveBillEntries.forEach(e -> {
            String billNo = e.getSumBillNo();
            if (StringUtils.isEmpty((String)billNo)) {
                billNo = e.getReportBillNo();
            }
            bills.add(billNo);
        });
        for (DynamicObject billInfo : billInfos = BusinessDataServiceHelper.load((String)"eb_bgapplybill", (String)"billstatus, auditor, auditdate", (QFilter[])new QFilter[]{new QFilter("billnumber", "in", bills)})) {
            if (isEnd.booleanValue()) {
                billInfo.set("billstatus", (Object)"D");
            }
            if (onlyUpdateStatus.booleanValue()) continue;
            billInfo.set("auditor", (Object)usrId);
            billInfo.set("auditdate", (Object)time);
        }
        SaveServiceHelper.save((DynamicObject[])billInfos);
    }

    private void updateAptOrColBillStatus(DynamicObject[] dataEntities) {
        Boolean isBatchApprove = this.isBatchApprove(dataEntities[0]);
        Long pkId = dataEntities[0].getLong("id");
        ApproveBillUtil instance = ApproveBillUtil.getInstance();
        ApproveBill approveBill = isBatchApprove != false ? instance.getApproveBill(new QFilter("id", "=", (Object)pkId)) : instance.createApproveBill(dataEntities[0]);
        this.setAppOrColBillApprovePass(approveBill, null, null, true, true);
    }
}

