/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.opplugin.centralapproval;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.centralapproval.AppBillStatusEnum;
import kd.epm.eb.common.centralapproval.AppBillSubStatusEnum;

public class AuditPassOP
extends AbstractOperationServicePlugIn {
    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        if (e.getOperationKey().equals("audit")) {
            this.updateMasterState(e);
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("parentid");
    }

    public void updateMasterState(AfterOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<Long> ids = new ArrayList<Long>(16);
        HashMap<Long, Long> subbillIdMapParentId = new HashMap<Long, Long>(16);
        for (DynamicObject dataEntity : dataEntities) {
            Long parentid = dataEntity.getLong("parentid");
            if (parentid == null || parentid <= 0L) continue;
            Long id = dataEntity.getLong("id");
            ids.add(id);
            subbillIdMapParentId.put(id, parentid);
        }
        if (!ids.isEmpty()) {
            ArrayList parentids = new ArrayList(subbillIdMapParentId.values());
            QFilter qFilter = new QFilter("parentid", "in", parentids);
            qFilter.and(new QFilter("billstatus", "!=", (Object)AppBillStatusEnum.CANCEL.getNumber()));
            DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_centralappbill", (String)"id,parentid,billstatus", (QFilter[])qFilter.toArray());
            HashMap<Long, List> parentIdMapStatus = new HashMap<Long, List>(16);
            for (DynamicObject data : query) {
                List status = parentIdMapStatus.computeIfAbsent(data.getLong("parentid"), x -> new ArrayList(16));
                status.add(data.getString("billstatus"));
            }
            DynamicObject[] ebCentralappbills = BusinessDataServiceHelper.load((Object[])parentids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_centralappbill"));
            if (ebCentralappbills != null && ebCentralappbills.length > 0) {
                for (DynamicObject ebCentralappbill : ebCentralappbills) {
                    Long id = ebCentralappbill.getLong("id");
                    List status = (List)parentIdMapStatus.get(id);
                    if (status.stream().allMatch(s -> s.equals("D"))) {
                        ebCentralappbill.set("itemstatus", (Object)AppBillSubStatusEnum.FULL_APPROVE.getNumber());
                        continue;
                    }
                    if (!status.stream().anyMatch(s -> s.equals("D"))) continue;
                    ebCentralappbill.set("itemstatus", (Object)AppBillSubStatusEnum.PART_APPROVE.getNumber());
                }
                SaveServiceHelper.save((DynamicObject[])ebCentralappbills);
            }
        }
    }
}

