/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.opplugin.dataIntegration;

import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.dataintegration.DataIntegrationGetValType;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.opplugin.quote.AbstractSaveQuoteOp;

public class MbgDataIntegrationOutSaveQuoteOp
extends AbstractSaveQuoteOp {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        this.saveMemberQuote(e.getDataEntities());
    }

    @Override
    protected void saveMemberQuote(DynamicObject[] objects) {
        if (objects == null || objects.length == 0) {
            return;
        }
        LinkedList<MemberQuoteDao> quotes = new LinkedList<MemberQuoteDao>();
        IModelCacheHelper modelCache = null;
        Map dimensionMap = null;
        for (DynamicObject _integrationOut : objects) {
            DynamicObjectCollection entries;
            Long datasetId;
            Long modelId;
            Long id = _integrationOut.getLong("id");
            DynamicObject _object = _integrationOut.getDynamicObject("modelid");
            Long l = modelId = _object != null ? Long.valueOf(_object.getLong("id")) : null;
            if (modelId == null || modelId == 0L) continue;
            if (modelCache == null || modelCache.getModelobj().getId().compareTo(modelId) != 0) {
                modelCache = ModelCacheContext.getOrCreate((Long)modelId);
                dimensionMap = modelCache.getDimensionMap();
            }
            if (dimensionMap == null) continue;
            _object = _integrationOut.getDynamicObject("datasetid");
            Long l2 = datasetId = _object != null ? Long.valueOf(_object.getLong("id")) : null;
            if (IDUtils.isNotNull((Long)datasetId)) {
                quotes.add(new MemberQuoteDao(modelId, datasetId, Long.valueOf(0L), datasetId, MemberTypeEnum.DATASET, MemberQuoteResourceEnum.IntegrationOut, id));
            }
            if ((entries = _integrationOut.getDynamicObjectCollection("dimmapentity")) != null && !entries.isEmpty()) {
                for (DynamicObject entry : entries) {
                    Dimension dimension = (Dimension)dimensionMap.get(entry.getString("dimsource"));
                    if (dimension == null) continue;
                    quotes.add(new MemberQuoteDao(modelId, datasetId, dimension.getId(), dimension.getId(), MemberTypeEnum.DIMENSION, MemberQuoteResourceEnum.IntegrationOut, id));
                }
            }
            this.addInterRangeQuote(quotes, id, modelId, datasetId, dimensionMap, _integrationOut, modelCache);
        }
        this.saveQuote(quotes);
    }

    private void addInterRangeQuote(List<MemberQuoteDao> quotes, Long id, Long modelId, Long datasetId, Map<String, Dimension> dimensionMap, DynamicObject _integration, IModelCacheHelper modelCacheHelper) {
        DynamicObjectCollection interRangeEntry = _integration.getDynamicObjectCollection("interangeentry");
        if (interRangeEntry != null && !interRangeEntry.isEmpty()) {
            for (DynamicObject object : interRangeEntry) {
                Dimension dimension = dimensionMap.get(object.getString("rangedimnum"));
                DataIntegrationGetValType getValType = DataIntegrationGetValType.getTypeByVal((String)object.getString("rangegetvalway"));
                if (getValType != DataIntegrationGetValType.SCHEME || dimension == null) continue;
                String memRangeJson = object.getString("rangememrangejson");
                if (StringUtils.isNotEmpty((String)memRangeJson)) {
                    List rangeEntry = (List)ObjectSerialUtil.parseObject((String)memRangeJson, (TypeReference)new TypeReference<List<MemberCondition>>(){}, (Feature[])new Feature[0]);
                    LinkedHashSet<Long> memberIds = new LinkedHashSet<Long>();
                    Long viewId = 0L;
                    for (MemberCondition condition : rangeEntry) {
                        Member member = modelCacheHelper.getMember(dimension.getNumber(), IDUtils.toLong((Object)condition.getViewId()), condition.getNumber());
                        if (member != null) {
                            memberIds.add(member.getId());
                        }
                        viewId = IDUtils.toLong((Object)condition.getViewId());
                    }
                    if (memberIds.size() > 0) {
                        MemberQuoteDao e = new MemberQuoteDao(modelId, datasetId, dimension.getId(), memberIds, MemberQuoteResourceEnum.IntegrationScheme, id);
                        for (Long memberId : memberIds) {
                            e.getMemberViewMap().put(memberId, viewId);
                        }
                        quotes.add(e);
                    }
                }
                quotes.add(new MemberQuoteDao(modelId, datasetId, dimension.getId(), dimension.getId(), MemberTypeEnum.DIMENSION, MemberQuoteResourceEnum.IntegrationScheme, id));
            }
        }
    }
}

