/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.opplugin.dataIntegration;

import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationDimMap;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.dataintegration.DataIntegrationGetValType;
import kd.epm.eb.common.dataintegration.IntegrationSchemeType;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.opplugin.quote.AbstractSaveQuoteOp;

public class MbgDataIntegrationSaveQuoteOp
extends AbstractSaveQuoteOp {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        this.saveMemberQuote(e.getDataEntities());
    }

    @Override
    protected void saveMemberQuote(DynamicObject[] objects) {
        if (objects == null || objects.length == 0) {
            return;
        }
        LinkedList<MemberQuoteDao> quotes = new LinkedList<MemberQuoteDao>();
        IModelCacheHelper modelCache = null;
        Map dimensionMap = null;
        for (DynamicObject _integration : objects) {
            Long datasetId;
            Long modelId;
            Long id = _integration.getLong("id");
            DynamicObject _object = _integration.getDynamicObject("modelid");
            Long l = modelId = _object != null ? Long.valueOf(_object.getLong("id")) : null;
            if (modelId == null || modelId == 0L) continue;
            _object = _integration.getDynamicObject("datasetid");
            Long l2 = datasetId = _object != null ? Long.valueOf(_object.getLong("id")) : null;
            if (IDUtils.isNull((Long)datasetId)) continue;
            if (modelCache == null || modelId.compareTo(modelCache.getModelobj().getId()) != 0) {
                modelCache = ModelCacheContext.getOrCreate((Long)modelId);
                dimensionMap = modelCache.getDimensionMap(datasetId);
            }
            if (dimensionMap == null) continue;
            quotes.add(new MemberQuoteDao(modelId, datasetId, Long.valueOf(0L), datasetId, MemberTypeEnum.DATASET, MemberQuoteResourceEnum.IntegrationScheme, id));
            this.addDimMapEntryQuote(quotes, id, modelId, datasetId, dimensionMap, _integration, modelCache);
            this.addInterRangeQuote(quotes, id, modelId, datasetId, dimensionMap, _integration, modelCache);
        }
        this.saveQuote(quotes);
    }

    private void addMetricEntryQuote(List<MemberQuoteDao> quotes, Long id, Long modelId, Long datasetId, Map<String, Dimension> dimensionMap, DynamicObject _integration) {
        Dimension dimension;
        DynamicObjectCollection entries = _integration.getDynamicObjectCollection("metricmapentity");
        if (entries != null && !entries.isEmpty() && (dimension = dimensionMap.get(SysDimensionEnum.Metric.getNumber())) != null) {
            LinkedHashSet<Long> memberIds = new LinkedHashSet<Long>();
            for (DynamicObject entry : entries) {
                Member member = dimension.getMember(Long.valueOf(0L), entry.getString("metrictarget"));
                if (member == null) continue;
                memberIds.add(member.getId());
            }
            if (!memberIds.isEmpty()) {
                quotes.add(new MemberQuoteDao(modelId, datasetId, dimension.getId(), memberIds, MemberQuoteResourceEnum.IntegrationScheme, id));
            }
        }
    }

    private void addInterRangeQuote(List<MemberQuoteDao> quotes, Long id, Long modelId, Long datasetId, Map<String, Dimension> dimensionMap, DynamicObject _integration, IModelCacheHelper modelCacheHelper) {
        DynamicObjectCollection interRangeEntry = _integration.getDynamicObjectCollection("interangeentry");
        if (interRangeEntry != null && !interRangeEntry.isEmpty()) {
            for (DynamicObject object : interRangeEntry) {
                Dimension dimension = dimensionMap.get(object.getString("rangedimnum"));
                DataIntegrationGetValType getValType = DataIntegrationGetValType.getTypeByVal((String)object.getString("rangegetvalway"));
                if (getValType != DataIntegrationGetValType.SCHEME || dimension == null) continue;
                String memRangeJson = object.getString("rangememrangejson");
                if (StringUtils.isNotEmpty((String)memRangeJson)) {
                    List rangeEntry = (List)ObjectSerialUtil.parseObject((String)memRangeJson, (TypeReference)new TypeReference<List<MemberCondition>>(){}, (Feature[])new Feature[0]);
                    LinkedHashSet<Long> memberIds = new LinkedHashSet<Long>();
                    Long viewId = 0L;
                    for (MemberCondition condition : rangeEntry) {
                        Member member = modelCacheHelper.getMember(dimension.getNumber(), IDUtils.toLong((Object)condition.getViewId()), condition.getNumber());
                        if (member != null) {
                            memberIds.add(member.getId());
                        }
                        viewId = IDUtils.toLong((Object)condition.getViewId());
                    }
                    if (memberIds.size() > 0) {
                        MemberQuoteDao e = new MemberQuoteDao(modelId, datasetId, dimension.getId(), memberIds, MemberQuoteResourceEnum.IntegrationScheme, id);
                        for (Long memberId : memberIds) {
                            e.getMemberViewMap().put(memberId, viewId);
                        }
                        quotes.add(e);
                    }
                }
                quotes.add(new MemberQuoteDao(modelId, datasetId, dimension.getId(), dimension.getId(), MemberTypeEnum.DIMENSION, MemberQuoteResourceEnum.IntegrationScheme, id));
            }
        }
    }

    private void addDimMapEntryQuote(List<MemberQuoteDao> quotes, Long id, Long modelId, Long datasetId, Map<String, Dimension> dimensionMap, DynamicObject _integration, IModelCacheHelper modelCacheHelper) {
        IntegrationSchemeType schemeType = IntegrationSchemeType.getTypeByVal((String)_integration.getString("schemetype"));
        if (schemeType == IntegrationSchemeType.CUSTOM) {
            this.addCusDimMapEntryQuote(quotes, id, modelId, datasetId, dimensionMap, _integration, modelCacheHelper);
            this.addMetricEntryQuote(quotes, id, modelId, datasetId, dimensionMap, _integration);
        } else if (schemeType == IntegrationSchemeType.GL) {
            this.addGlDimMapEntryQuote(quotes, id, modelId, datasetId, dimensionMap, _integration, modelCacheHelper);
        } else if (schemeType == IntegrationSchemeType.BCM) {
            this.addBcmDimMapEntryQuote(quotes, id, modelId, datasetId, dimensionMap, _integration, modelCacheHelper);
        }
    }

    private void addCusDimMapEntryQuote(List<MemberQuoteDao> quotes, Long id, Long modelId, Long datasetId, Map<String, Dimension> dimensionMap, DynamicObject _integration, IModelCacheHelper modelCacheHelper) {
        DynamicObjectCollection entries = _integration.getDynamicObjectCollection("dimmapentity");
        if (entries != null && !entries.isEmpty()) {
            for (DynamicObject entry : entries) {
                Dimension dimension = dimensionMap.get(entry.getString("dimtarget"));
                Long viewid = 0L;
                DynamicObject dimmemberview = entry.getDynamicObject("dimmemberview");
                if (dimmemberview != null) {
                    viewid = dimmemberview.getLong("id");
                }
                if (dimension == null) continue;
                Member member = modelCacheHelper.getMember(dimension.getNumber(), viewid, entry.getString("dimmembnum"));
                if (member != null) {
                    MemberQuoteDao e = new MemberQuoteDao(modelId, datasetId, dimension.getId(), member.getId(), MemberQuoteResourceEnum.IntegrationScheme, id);
                    e.getMemberViewMap().put(member.getId(), viewid);
                    quotes.add(e);
                    continue;
                }
                quotes.add(new MemberQuoteDao(modelId, datasetId, dimension.getId(), dimension.getId(), MemberTypeEnum.DIMENSION, MemberQuoteResourceEnum.IntegrationScheme, id));
            }
        }
    }

    private void addGlDimMapEntryQuote(List<MemberQuoteDao> quotes, Long id, Long modelId, Long datasetId, Map<String, Dimension> dimensionMap, DynamicObject _integration, IModelCacheHelper modelCacheHelper) {
        DynamicObjectCollection glEntries = _integration.getDynamicObjectCollection("dimmapscheme_entry");
        if (glEntries != null && !glEntries.isEmpty()) {
            for (DynamicObject glEntry : glEntries) {
                String dimMemMapJson = glEntry.getString("dimmemmapjson");
                if (StringUtils.isEmpty((String)dimMemMapJson)) continue;
                List dataIntegrationDimMaps = (List)ObjectSerialUtil.parseObject((String)dimMemMapJson, (TypeReference)new TypeReference<List<DataIntegrationDimMap>>(){}, (Feature[])new Feature[0]);
                for (DataIntegrationDimMap dimMap : dataIntegrationDimMaps) {
                    Dimension dimension = dimensionMap.get(dimMap.getDimtarget());
                    if (dimension == null) continue;
                    Member member = modelCacheHelper.getMember(dimension.getNumber(), dimMap.getDimmembviewid(), dimMap.getDimmembnum());
                    if (member != null) {
                        MemberQuoteDao e = new MemberQuoteDao(modelId, datasetId, dimension.getId(), member.getId(), MemberQuoteResourceEnum.IntegrationScheme, id);
                        e.getMemberViewMap().put(member.getId(), dimMap.getDimmembviewid());
                        quotes.add(e);
                        continue;
                    }
                    quotes.add(new MemberQuoteDao(modelId, datasetId, dimension.getId(), dimension.getId(), MemberTypeEnum.DIMENSION, MemberQuoteResourceEnum.IntegrationScheme, id));
                }
            }
        }
    }

    private void addBcmDimMapEntryQuote(List<MemberQuoteDao> quotes, Long id, Long modelId, Long datasetId, Map<String, Dimension> dimensionMap, DynamicObject _integration, IModelCacheHelper modelCacheHelper) {
        DynamicObjectCollection bcmEntries = _integration.getDynamicObjectCollection("bcmdimmapentity");
        if (bcmEntries != null && !bcmEntries.isEmpty()) {
            for (DynamicObject bcmEntry : bcmEntries) {
                Dimension dimension;
                String dimNum = bcmEntry.getString("bcmdimtarnumber");
                String dimMemNum = bcmEntry.getString("bcmpointtarmem");
                long viewId = 0L;
                DynamicObject bcmpointtarmemview = bcmEntry.getDynamicObject("bcmpointtarmemview");
                if (bcmpointtarmemview != null) {
                    viewId = bcmpointtarmemview.getLong("id");
                }
                if ((dimension = dimensionMap.get(dimNum)) == null) continue;
                Member member = modelCacheHelper.getMember(dimNum, Long.valueOf(viewId), dimMemNum);
                if (member != null) {
                    MemberQuoteDao e = new MemberQuoteDao(modelId, datasetId, dimension.getId(), member.getId(), MemberQuoteResourceEnum.IntegrationScheme, id);
                    e.getMemberViewMap().put(member.getId(), viewId);
                    quotes.add(e);
                    continue;
                }
                quotes.add(new MemberQuoteDao(modelId, datasetId, dimension.getId(), dimension.getId(), MemberTypeEnum.DIMENSION, MemberQuoteResourceEnum.IntegrationScheme, id));
            }
        }
    }
}

