/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.opplugin.mapping;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.epm.eb.common.cache.control.BgLockCacheServiceHelper;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.control.utils.BgMemMappingServiceHelper;

public class BgMappingDeleteOp
extends AbstractOperationServicePlugIn {
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] datas = e.getDataEntities();
        if (datas != null) {
            HashSet<Long> mappingIds = new HashSet<Long>(datas.length);
            for (DynamicObject mapping : datas) {
                mappingIds.add(mapping.getLong("id"));
            }
            BgMemMappingServiceHelper.clearCacheByMapping(mappingIds);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        BgMappingDeleteOp.reloadLockCache(e);
    }

    public static void reloadLockCache(AfterOperationArgs e) {
        DynamicObject[] datas = e.getDataEntities();
        if (datas != null) {
            HashMap<Long, Set> bussModels = new HashMap<Long, Set>(datas.length);
            for (DynamicObject mapping : datas) {
                if (!SysDimensionEnum.Entity.getNumber().equals(mapping.getString("dimnumber"))) continue;
                bussModels.computeIfAbsent(mapping.getLong("model.id"), f -> new HashSet(10)).add(mapping.getLong("bussmodel.id"));
            }
            for (Map.Entry entry : bussModels.entrySet()) {
                for (Long bussModelId : (Set)entry.getValue()) {
                    BgLockCacheServiceHelper.reloadCache((Long)((Long)entry.getKey()), (Long)bussModelId);
                }
            }
        }
    }
}

